
require 'java'
require 'import'

class MenuBox
  def initialize(text_pane)
    @change_font_value_flag = false
    @currentFontName = ""
    @currentFontSize = 0
    @text_pane = text_pane
    @tool_bar = JToolBar.new
    @tool_bar.setLayout(FlowLayout.new(FlowLayout::LEFT));

    @comboFonts = FontComboBox.new(self)
    @tool_bar.add(@comboFonts.box);

    @tool_bar.addSeparator();

    @comboSizes = FontSizeComboBox.new(self)
    @tool_bar.add(@comboSizes.box);

    @toggleB = ToggleButton.new(self, "<html><b>B</b></html>")
    @tool_bar.add(@toggleB.button);
    @toggleI = ToggleButton.new(self, "<html><i>I</i></html>")
    @tool_bar.add(@toggleI.button);
    @toggleU = ToggleButton.new(self, "<html><u>U</u></html>")
    @tool_bar.add(@toggleU.button);
    @toggleS = ToggleButton.new(self, "<html><s>S</s></html>")
    @tool_bar.add(@toggleS.button);

    @color_combo = ColorComboBox.new(self)
    @tool_bar.add(@color_combo.box)
  end
  attr_reader :tool_bar

  def caret_update(s, e)
    a = @text_pane.get_attribute(s)
    change_font_value(a)
  end

  def actionPerformed(ev)
    return if @change_font_value_flag
    source = ev.getSource
    return if source == nil
    attr = SimpleAttributeSet.new
    case source
    when @comboFonts.box
      fontName = @comboFonts.box.getSelectedItem.to_s
      StyleConstants::setFontFamily(attr, fontName)
    when @comboSizes.box
      fontSize = 0;
      begin
        fontSize = @comboSizes.box.getSelectedItem().to_s.to_i
      rescue NumberFormatException => e
        return
      end
      StyleConstants::setFontSize(attr, fontSize);
    when @toggleB.button
      # 強調
      StyleConstants::setBold(attr, @toggleB.button.isSelected());
    when @toggleI.button
      # 斜体
      StyleConstants::setItalic(attr, @toggleI.button.isSelected());
    when @toggleU.button
      # アンダーライン
      StyleConstants::setUnderline(attr, @toggleU.button.isSelected());
    when @toggleS.button
      # 取り消し線
      StyleConstants::setStrikeThrough(attr, @toggleS.button.isSelected());
    when @color_combo.box
      # 前景色
      col = @color_combo.box.getSelectedIndex();
      b = (col % 2) * 255;
      g = ((col / 2) % 2) * 255;
      r = ((col / 4) % 2) * 255;
      StyleConstants::setForeground(attr, Color.new(r, g, b))
    else
      return;
    end
    @text_pane.set_text_pane(attr)
  end

  def change_font_value(a)
    name = StyleConstants::getFontFamily(a);
    size = StyleConstants::getFontSize(a);
    @change_font_value_flag = true
    # 変更前と同じ場合は無視する 
    if @currentFontName != name then
      @currentFontName = name;
      @comboFonts.box.setSelectedItem(name);
    end
    # 変更前と同じ場合は無視する
    if @currentFontSize != size then
      @currentFontSize = size;
      @comboSizes.box.setSelectedItem(size.to_s);
    end
    @toggleB.button.setSelected(StyleConstants::isBold(a))
    @toggleI.button.setSelected(StyleConstants::isItalic(a))
    @toggleU.button.setSelected(StyleConstants::isUnderline(a))
    @toggleS.button.setSelected(StyleConstants::isStrikeThrough(a))
    # 前景色の状態表示
    col = StyleConstants::getForeground(a);
    r = (col.getRed() / 255) * 4;
    g = (col.getGreen() / 255) * 2;
    b = col.getBlue() / 255;
    @color_combo.box.setSelectedIndex(r + g + b);

    @change_font_value_flag = false
  end

end

class ToggleButton
  def initialize(listener, label)
    @button = JToggleButton.new(label)
    @button.setPreferredSize(Dimension.new(26, 26));
    @button.addActionListener(listener);
  end
  attr_reader :button
end

class FontSizeComboBox
  def initialize(listener)
    # フォントサイズを選択するコンボボックス
    @box = JComboBox.new
    [8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72].each{|s|
      @box.addItem(s.to_s)
    }
    @box.setMaximumSize(@box.getPreferredSize());
    @box.addActionListener(listener);
  end
  attr_reader :box
end

class FontComboBox
  def initialize(listener)
    # フォントを選択するコンボボックス
    ge = GraphicsEnvironment::getLocalGraphicsEnvironment();
    familyName = ge.getAvailableFontFamilyNames();
    @box = JComboBox.new(familyName);
    @box.setMaximumSize(@box.getPreferredSize());
    @box.addActionListener(listener);
  end
  attr_reader :box
end

class ColorComboBox
  def initialize(listener)
    # 前景色用コンボボックス
    colorModel = DefaultComboBoxModel.new
    # 色つきのラベルを作成する
    ["#000000", "#0000FF", "#00FF00", "#00FFFF",
     "#FF0000", "#FF00FF", "#FFFF00", "#FFFFFF"].each{|c|
      str = ""
      str += "<html><font color=\"";
      str += c
      str += "\">■</font></html>";
      colorModel.addElement(str)
    }
    @box = JComboBox.new(colorModel);
    @box.setMaximumSize(@box.getPreferredSize());
    @box.addActionListener(listener);
  end
  attr_reader :box

end
