
require 'java'

require 'import'

class CaretInfo

  def initialize(text_pane)
    @text_pane = text_pane
    @disp = JTextField.new()
    @caret_event_target = []
  end
  attr_reader :disp

  def add_caret_event_target(o)
    @caret_event_target << o
  end

  def caretUpdate(ev)
    s = @text_pane.get_selected_start
    e = @text_pane.get_selected_end
    show_caret_info(s, e)
    @caret_event_target.each{|o|
      o.caret_update(s, e)
    }
  end

  def show_caret_info(s, e)
    str = ""
    begin
      if (s == e) then
        select_text = @text_pane.get_text(s, 1)
        str += "Text = "
        str += select_text
      else
        start_text = @text_pane.get_text(s, 1)
        end_text = @text_pane.get_text(e - 1, 1)
        str += "Start = "
        str += start_text
        str += ",End = "
        str += end_text
      end
      @disp.setText(str)
    rescue BadLocationException => ble
      @disp.setText("Error: Bad Caret Location")
    end
  end

end
