
require 'java'

require 'import'

import 'javax.swing.JMenu'
import 'javax.swing.JMenuBar'
import 'javax.swing.JMenuItem'
import 'javax.swing.JFileChooser'
import 'javax.swing.filechooser.FileFilter'

class MenuBar

  def initialize(text_pane)
    @text_pane = text_pane
    @menuBar = JMenuBar.new
    @fileMenu = JMenu.new("File", true);
    @menuBar.add(@fileMenu);

    @newItem = JMenuItem.new("New");
    @fileMenu.add(@newItem);
    @newItem.addActionListener(self);

    @openItem = JMenuItem.new("Open");
    @fileMenu.add(@openItem);
    @openItem.addActionListener(self);

    @saveItem = JMenuItem.new("Save");
    @fileMenu.add(@saveItem);
    @saveItem.addActionListener(self);

    @fileMenu.addSeparator();

    @exitItem = JMenuItem.new("Exit");
    @fileMenu.add(@exitItem);
    @exitItem.addActionListener(self);
  end
  attr_reader :menuBar

  def actionPerformed(ev)
    source = ev.getSource
    case source
    when @exitItem
      java.lang.System.exit(0)
    when @newItem
      newFile
    when @openItem
      openFile
    when @saveItem
      saveFile
    end
  end

  def newFile
    @text_pane.new_document
  end

  # ファイルを開く
  def openFile
    chooser = JFileChooser.new
    filter = RTFFilter.new
    chooser.setFileFilter(filter);

    result = chooser.showOpenDialog(@text_pane.frame)
    return if result != JFileChooser::APPROVE_OPTION
    @text_pane.open_document(chooser.getSelectedFile)
  end

  def saveFile
    chooser = JFileChooser.new
    result = chooser.showSaveDialog(@text_pane.frame)
    return if result != JFileChooser::APPROVE_OPTION
    @text_pane.save_document(chooser.getSelectedFile)
  end

end

class RTFFilter < FileFilter

  def accept(f)
    return true if f.isDirectory()
   
    # 拡張子を取り出す
    ext = File.extname(f.getName())
   
    if (ext == ".rtf") then
      return true;
    else
      return false;
    end
  end 
 
  def getDescription
    return "Rich Text File Format";
  end
 
end
