library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;
 
library unisim ;
use unisim.vcomponents.all ;
 
entity vhdl_upl32_tx_wrapper is
  port (
    clk          : IN  std_logic;
    reset        : IN  std_logic;
    UPL_OUT_Data : OUT std_logic_vector(31 downto 0);
    UPL_OUT_Req  : OUT std_logic;
    UPL_OUT_Ack  : IN  std_logic;
    UPL_OUT_En   : OUT std_logic;
    data_waddr   : IN  std_logic_vector(31 downto 0);
    data_wdata   : IN  std_logic_vector(31 downto 0);
    data_we      : IN  std_logic_vector(0 downto 0);
    request      : IN  std_logic;
    busy         : OUT std_logic;
    send_length  : IN  std_logic_vector(31 downto 0)
    );
end vhdl_upl32_tx_wrapper;

architecture RTL of vhdl_upl32_tx_wrapper is

  component vhdl_upl_tx
    generic (
      DATA_WIDTH : integer := 8;
      DATA_DEPTH : integer := 12
      );
    port (
      pReset_n : in std_logic;
      pClk     : in std_logic;

      -- 出力
      pO0Data    : out std_logic_vector( DATA_WIDTH-1 downto 0 );
      pO0Request : out std_logic;
      pO0Ack     : in  std_logic;
      pO0Enable  : out std_logic;

      -- JavaとのI/F
      pSendRequest : in  std_logic;
      pBusy        : out std_logic;
      pSendLength  : in  std_logic_vector(DATA_DEPTH-1 downto 0);
      pMemWriteEn  : in  std_logic_vector(0 downto 0);
      pMemWriteData: in std_logic_vector(DATA_WIDTH-1 downto 0);
      pMemWriteAddr: in  std_logic_vector(DATA_DEPTH-1 downto 0);

      pDebugA : out std_logic_vector(7 downto 0)

      );
  end component;

  signal reset_n : std_logic;

begin  -- RTL


  reset_n <= not reset;
  
  U: vhdl_upl_tx
    generic map(
      DATA_WIDTH => 32,
      DATA_DEPTH => 3 -- 10
      )
    port map(
      pReset_n => reset_n,
      pClk     => clk,
      
      -- UPLからの入力を受ける
      pO0Data    => UPL_OUT_Data,
      pO0Request => UPL_OUT_Req,
      pO0Ack     => UPL_OUT_Ack,
      pO0Enable  => UPL_OUT_En,
      
      -- JavaとのI/F
      pSendRequest => request,
      pBusy        => busy,
      pSendLength  => send_length(2 downto 0),
      pMemWriteEn  => data_we,
      pMemWriteData=> data_wdata,
      pMemWriteAddr=> data_waddr(2 downto 0),

      pDebugA => open
      );

end RTL;

