library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;

entity upl32test_sim is
end upl32test_sim;

architecture RTL of upl32test_sim is

  component upl32test
    port (
      notify_method_busy : OUT std_logic;
      rom_tx_UPL_OUT_Req : OUT std_logic;
      rom_tx_UPL_OUT_En : OUT std_logic;
      rom_rx_UPL_IN_Ack : OUT std_logic;
      rom_tx_UPL_OUT_Data : OUT std_logic_vector(31 downto 0);
      rom_rx_UPL_IN_Req : IN std_logic;
      notify_method_request : IN std_logic;
      rom_rx_UPL_IN_En : IN std_logic;
      reset : IN std_logic;
      rom_rx_UPL_IN_Data : IN std_logic_vector(31 downto 0);
      rom_tx_UPL_OUT_Ack : IN std_logic;
      clk : IN std_logic
      );
  end component;

  constant STEP  : time := 10 ns;
  signal clk, reset : std_logic;

  signal en, ack, req: std_logic;
  signal data : std_logic_vector(31 downto 0);

begin

  U: upl32test port map(
    notify_method_busy => open,
    notify_method_request => '0',

    rom_tx_UPL_OUT_Req  => req,
    rom_tx_UPL_OUT_En   => en,
    rom_tx_UPL_OUT_Data => data,
    rom_tx_UPL_OUT_Ack  => ack,

    rom_rx_UPL_IN_Ack  => ack,
    rom_rx_UPL_IN_Req  => req,
    rom_rx_UPL_IN_En   => en,
    rom_rx_UPL_IN_Data => data,

    reset => reset,
    clk   => clk
    );
  
  process
  begin
    clk <= '1'; wait for STEP/2;
    clk <= '0'; reset <= '1'; wait for STEP/2;
    clk <= '1'; wait for STEP/2;
    clk <= '0'; wait for STEP/2;
    clk <= '1'; wait for STEP/2;
    clk <= '0'; wait for STEP/2;
    clk <= '1'; reset <= '0'; wait for STEP/2;
    clk <= '0'; wait for STEP/2;
    clk <= '1'; wait for STEP/2;
    clk <= '0'; wait for STEP/2;
    while true loop
      clk <= '1'; wait for STEP/2;
      clk <= '0'; wait for STEP/2;
    end loop;
  end process;

end RTL;
