library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;
 
entity udp_rx_wrapper is
  port (
    clk         : IN  std_logic;
    reset       : IN  std_logic;
    UPL_IN_Data : IN  std_logic_vector(31 downto 0);
    UPL_IN_Req  : IN  std_logic;
    UPL_IN_Ack  : OUT std_logic;
    UPL_IN_En   : IN  std_logic;
    src_ip      : OUT std_logic_vector(31 downto 0);
    src_port    : OUT std_logic_vector(15 downto 0);
    dest_ip     : OUT std_logic_vector(31 downto 0);
    dest_port   : OUT std_logic_vector(15 downto 0);
    data_length : OUT std_logic_vector(31 downto 0);
    data_raddr  : IN  std_logic_vector(31 downto 0);
    data_rdata  : OUT std_logic_vector(31 downto 0);
    valid       : OUT std_logic;
    read_flag   : IN  std_logic
    );
end udp_rx_wrapper;

architecture RTL of udp_rx_wrapper is

  component upl_rx
    generic (
      DATA_WIDTH : integer := 32;
      DATA_DEPTH : integer := 12
      );
    port (
      pReset_n : in std_logic;
      pUPLGlobalClk : in std_logic;
      
      -- UPLからの入力を受ける
      pI0Data    : in std_logic_vector(DATA_WIDTH-1 downto 0 );
      pI0Request : in std_logic;
      pI0Ack     : out std_logic;
      pI0En      : in std_logic;
      
      -- JavaとのI/F
      pDataValid   : out std_logic;
      pDataRead    : in  std_logic;
      pMemReadData : out std_logic_vector(DATA_WIDTH-1 downto 0);
      pMemReadAddr : in  std_logic_vector(DATA_DEPTH-1 downto 0);

      pSrcIPAddr   : out std_logic_vector(31 downto 0);
      pDestIPAddr  : out std_logic_vector(31 downto 0);
      pSrcPort     : out std_logic_vector(15 downto 0);
      pDestPort    : out std_logic_vector(15 downto 0);
      pDataLength  : out std_logic_vector(31 downto 0);

      pDebugA : out std_logic_vector( 7 downto 0 )
      );
  end component;

  signal reset_n : std_logic;

begin  -- RTL


  reset_n <= not reset;
  
  U: upl_rx
    generic map(
      DATA_WIDTH => 32,
      DATA_DEPTH => 12
      )
    port map(
      pReset_n      => reset_n,
      pUPLGlobalClk => clk,
      
      -- UPLからの入力を受ける
      pI0Data    => UPL_IN_Data,
      pI0Request => UPL_IN_Req,
      pI0Ack     => UPL_IN_Ack,
      pI0En      => UPL_IN_En,
      
      -- JavaとのI/F
      pDataValid   => valid,
      pDataRead    => read_flag,
      pMemReadData => data_rdata,
      pMemReadAddr => data_raddr(11 downto 0),

      pSrcIPAddr   => src_ip,
      pDestIPAddr  => dest_ip,
      pSrcPort     => src_port,
      pDestPort    => dest_port,
      pDataLength  => data_length,

      pDebugA => open
      );

end RTL;

