library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;

entity simpledualportram is
  
  generic (
    DEPTH : integer := 10;
    WIDTH : integer := 32);

  port (
    clk   : in  std_logic;
    we    : in  std_logic_vector(0 downto 0);
    raddr : in  std_logic_vector(DEPTH-1 downto 0);
    rdata : out std_logic_vector(WIDTH-1 downto 0);
    waddr : in  std_logic_vector(DEPTH-1 downto 0);
    wdata : in  std_logic_vector(WIDTH-1 downto 0)
    );

end simpledualportram;

architecture RTL of simpledualportram is

  type ram_type is array (2**DEPTH-1 downto 0) of std_logic_vector (WIDTH-1 downto 0);
  signal RAM: ram_type;

  signal q : std_logic_vector(WIDTH-1 downto 0);

begin  -- RTL

  rdata <= q;

  process (clk)
  begin  -- process
    if clk'event and clk = '1' then  -- rising clock edge
      if we(0) = '1' then
        RAM(conv_integer(waddr)) <= wdata;
      end if;
    end if;
  end process;

  process (clk)
  begin  -- process
    if clk'event and clk = '1' then  -- rising clock edge
      q <= RAM(conv_integer(raddr));
    end if;
  end process;

end RTL;
