import net.wasamon.javarock.libraries.VHDLSimpleLibrary;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLGenericParameter;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;

public class UPL32_TX extends VHDLSimpleLibrary implements JavaRockComponentIface{

  public int[] data;

  public boolean busy;
  public boolean request;
  public int send_length;

  public UPL32_TX(String... args){
    super("vhdl_upl32_tx_wrapper", args);

    ports.add(new VHDLPort(this, "clk",     VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "reset",   VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));

    ports.add(new VHDLPort(this, "UPL_OUT_Data", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.OUT,  VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "UPL_OUT_Req",  VHDLTypeBuilder.getStdLogic(),           VHDLPort.Dir.OUT,  VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "UPL_OUT_Ack",  VHDLTypeBuilder.getStdLogic(),           VHDLPort.Dir.IN, VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "UPL_OUT_En",   VHDLTypeBuilder.getStdLogic(),           VHDLPort.Dir.OUT,  VHDLPort.Kind.EXTERNAL));

    ports.add(new VHDLPort(this, "data_waddr", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "data_wdata", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "data_we", VHDLTypeBuilder.getStdLogicVector(0, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "busy", VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.OUT));
    ports.add(new VHDLPort(this, "request", VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "send_length", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    
  }


}
