library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;
 
library unisim ;
use unisim.vcomponents.all ;
 
entity vhdl_upl_rx8_wrapper is
  port (
    clk         : IN  std_logic;
    reset       : IN  std_logic;
    UPL_IN_Data : IN  std_logic_vector(7 downto 0);
    UPL_IN_Req  : IN  std_logic;
    UPL_IN_Ack  : OUT std_logic;
    UPL_IN_En   : IN  std_logic;
    data_raddr  : IN  std_logic_vector(31 downto 0);
    data_rdata  : OUT std_logic_vector(7 downto 0);
    valid       : OUT std_logic;
    read_flag   : IN  std_logic;
    recv_length : OUT std_logic_vector(31 downto 0)
    );
end vhdl_upl_rx8_wrapper;

architecture RTL of vhdl_upl_rx8_wrapper is

  component vhdl_upl_rx8
    generic (
      DATA_WIDTH : integer := 8;
      DATA_DEPTH : integer := 12
      );
    port (
      pReset_n : in std_logic;
      pUPLGlobalClk : in std_logic;
      
      -- UPLからの入力を受ける
      pI0Data    : in std_logic_vector(DATA_WIDTH-1 downto 0 );
      pI0Request : in std_logic;
      pI0Ack     : out std_logic;
      pI0En      : in std_logic;
      
      -- JavaとのI/F
      pDataValid   : out std_logic;
      pDataRead    : in  std_logic;
      pMemReadData : out std_logic_vector(DATA_WIDTH-1 downto 0);
      pMemReadAddr : in  std_logic_vector(DATA_DEPTH-1 downto 0);
      pDataLength  : out std_logic_vector(DATA_DEPTH-1 downto 0);
      
      pDebugA : out std_logic_vector( 7 downto 0 )
      );
  end component;

  signal reset_n : std_logic;

begin  -- RTL


  reset_n <= not reset;
  
  U: vhdl_upl_rx8
    generic map(
      DATA_WIDTH => 8,
      DATA_DEPTH => 12
      )
    port map(
      pReset_n      => reset_n,
      pUPLGlobalClk => clk,
      
      -- UPLからの入力を受ける
      pI0Data    => UPL_IN_Data,
      pI0Request => UPL_IN_Req,
      pI0Ack     => UPL_IN_Ack,
      pI0En      => UPL_IN_En,
      
      -- JavaとのI/F
      pDataValid   => valid,
      pDataRead    => read_flag,
      pMemReadData => data_rdata,
      pMemReadAddr => data_raddr(11 downto 0),
      pDataLength  => recv_length(11 downto 0),
      
      pDebugA => open
      );

  recv_length(31 downto 12) <= (others => '0');

end RTL;

