library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;


entity vhdl_m25p40_buf_wrapper is
  
  port (
    clk   : in std_logic;
    reset : in std_logic;

    M25P40_C   : out std_logic;  -- Serial Clock
    M25P40_DQ0 : out std_logic;  -- Serial Data to M25P40
    M25P40_DQ1 : in  std_logic;  -- Serial Data from M25P40
    M25P40_S   : out std_logic;  -- Chip Select

    -- command
    req     : in  std_logic;  -- do operation
    busy    : out std_logic;  -- module running status
    command : in  std_logic_vector(7 downto 0);  -- command
    addr    : in  std_logic_vector(31 downto 0);  -- read/write address
    length  : in  std_logic_vector(31 downto 0);  -- data length to read/write

    -- Dual-port RAM I/O
    data_waddr : in  std_logic_vector(31 downto 0);
    data_wdata : in  std_logic_vector(7 downto 0);
    data_we    : in  std_logic_vector(0 downto 0);
    data_raddr : in  std_logic_vector(31 downto 0);
    data_rdata : out std_logic_vector(7 downto 0)
    
    );
  
end vhdl_m25p40_buf_wrapper;

architecture RTL of vhdl_m25p40_buf_wrapper is

  component m25p40_buf
    port (
      clk   : in  std_logic;
      reset : in  std_logic;

      M25P40_C   : out std_logic;        -- Serial Clock
      M25P40_DQ0 : out std_logic;        -- Serial Data to M25P40
      M25P40_DQ1 : in std_logic;         -- Serial Data from M25P40
      M25P40_S : out std_logic;          -- Chip Select

      -- command
      pReq     : in  std_logic;                      -- do operation
      pBusy    : out std_logic;                      -- module running status
      pCommand : in  std_logic_vector(7 downto 0);   -- command
      pAddr    : in  std_logic_vector(23 downto 0);  -- read/write address
      pLength  : in  std_logic_vector(8 downto 0);   -- data length to read/write
      
      -- Dual-port RAM I/O
      data_waddr : in  std_logic_vector(7 downto 0);
      data_wdata : in  std_logic_vector(7 downto 0);
      data_we    : in  std_logic_vector(0 downto 0);
      data_raddr : in  std_logic_vector(7 downto 0);
      data_rdata : out std_logic_vector(7 downto 0);

      pDebug : out std_logic_vector(7 downto 0)
      );
    
  end component;
  
begin  -- RTL

  U: m25p40_buf port map(
    clk   => clk,
    reset => reset,

    M25P40_C   => M25P40_C,
    M25P40_DQ0 => M25P40_DQ0,
    M25P40_DQ1 => M25P40_DQ1,
    M25P40_S   => M25P40_S,

    -- command
    pReq     => req,
    pBusy    => busy,
    pCommand => command,
    pAddr    => addr(23 downto 0),
    pLength  => length(8 downto 0),
      
    -- Dual-port RAM I/O
    data_waddr => data_waddr(7 downto 0),
    data_wdata => data_wdata,
    data_we    => data_we,
    data_raddr => data_raddr(7 downto 0),
    data_rdata => data_rdata,

    pDebug => open
    );
  

end RTL;

