library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;
entity fpgamain is
  port (
    udp_tx_UPL_OUT_Req : OUT std_logic;
    notify_method_busy : OUT std_logic;
    udp_tx_UPL_OUT_Data : OUT std_logic_vector(31 downto 0);
    storage_rom_M25P40_C : OUT std_logic;
    udp_tx_UPL_OUT_En : OUT std_logic;
    udp_rx_UPL_IN_Ack : OUT std_logic;
    storage_rom_M25P40_S : OUT std_logic;
    storage_rom_M25P40_DQ0 : OUT std_logic;
    notify_method_request : IN std_logic;
    udp_rx_UPL_IN_Req : IN std_logic;
    udp_rx_UPL_IN_Data : IN std_logic_vector(31 downto 0);
    udp_tx_UPL_OUT_Ack : IN std_logic;
    udp_rx_UPL_IN_En : IN std_logic;
    reset : IN std_logic;
    storage_rom_M25P40_DQ1 : IN std_logic;
    clk : IN std_logic
  );
end fpgamain;

architecture RTL of fpgamain is
  component simpledualportram
    generic (
      DEPTH : integer := 10;
      WIDTH : integer := 32
    );
    port (
      clk : IN std_logic;
      we : IN std_logic_vector(0 downto 0);
      raddr : IN std_logic_vector(DEPTH-1 downto 0);
      rdata : OUT std_logic_vector(WIDTH-1 downto 0);
      waddr : IN std_logic_vector(DEPTH-1 downto 0);
      wdata : IN std_logic_vector(WIDTH-1 downto 0)
    );
  end component;
  component udp_rx_wrapper
    port (
      clk : IN std_logic;
      reset : IN std_logic;
      UPL_IN_Data : IN std_logic_vector(31 downto 0);
      UPL_IN_Req : IN std_logic;
      UPL_IN_Ack : OUT std_logic;
      UPL_IN_En : IN std_logic;
      src_ip : OUT std_logic_vector(31 downto 0);
      src_port : OUT std_logic_vector(15 downto 0);
      dest_ip : OUT std_logic_vector(31 downto 0);
      dest_port : OUT std_logic_vector(15 downto 0);
      data_length : OUT std_logic_vector(31 downto 0);
      data_raddr : IN std_logic_vector(31 downto 0);
      data_rdata : OUT std_logic_vector(31 downto 0);
      valid : OUT std_logic;
      read_flag : IN std_logic
    );
  end component;
  component m25p40if
    port (
      notify_method_busy : OUT std_logic;
      rom_M25P40_C : OUT std_logic;
      buf_read_method_busy : OUT std_logic;
      rom_M25P40_S : OUT std_logic;
      read_bytes_method_busy : OUT std_logic;
      page_program_method_busy : OUT std_logic;
      rom_M25P40_DQ0 : OUT std_logic;
      sector_erase_method_busy : OUT std_logic;
      buf_write_method_busy : OUT std_logic;
      output_port_buf_read : OUT std_logic_vector(7 downto 0);
      input_port_sector_erase_addr : IN std_logic_vector(31 downto 0);
      input_port_page_program_addr : IN std_logic_vector(31 downto 0);
      input_port_buf_read_index : IN std_logic_vector(31 downto 0);
      input_port_read_bytes_addr : IN std_logic_vector(31 downto 0);
      input_port_buf_write_index : IN std_logic_vector(31 downto 0);
      buf_write_method_request : IN std_logic;
      input_port_buf_write_data : IN std_logic_vector(7 downto 0);
      clk : IN std_logic;
      notify_method_request : IN std_logic;
      sector_erase_method_request : IN std_logic;
      read_bytes_method_request : IN std_logic;
      buf_read_method_request : IN std_logic;
      rom_M25P40_DQ1 : IN std_logic;
      reset : IN std_logic;
      page_program_method_request : IN std_logic;
      input_port_read_bytes_length : IN std_logic_vector(31 downto 0);
      input_port_page_program_length : IN std_logic_vector(31 downto 0)
    );
  end component;
  component udp_tx_wrapper
    port (
      clk : IN std_logic;
      reset : IN std_logic;
      UPL_OUT_Data : OUT std_logic_vector(31 downto 0);
      UPL_OUT_Req : OUT std_logic;
      UPL_OUT_Ack : IN std_logic;
      UPL_OUT_En : OUT std_logic;
      data_length : IN std_logic_vector(31 downto 0);
      start : IN std_logic;
      busy : OUT std_logic;
      data_waddr : IN std_logic_vector(31 downto 0);
      data_wdata : IN std_logic_vector(31 downto 0);
      data_we : IN std_logic_vector(0 downto 0);
      dest_ip : IN std_logic_vector(31 downto 0);
      dest_port : IN std_logic_vector(15 downto 0);
      src_ip : IN std_logic_vector(31 downto 0);
      src_port : IN std_logic_vector(15 downto 0)
    );
  end component;
  constant COMMAND_ERASE : integer := 3;
  constant recv_buf_length : integer := 1024;
  constant recv_buf_WIDTH : integer := 31-0+1;
  constant send_buf_length : integer := 1024;
  constant send_buf_WIDTH : integer := 31-0+1;
  constant recv_buf_DEPTH : integer := 10;
  constant send_buf_DEPTH : integer := 10;
  constant COMMAND_READ : integer := 1;
  constant COMMAND_WRITE : integer := 2;
  signal udp_rx_src_ip_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_src_ip_field_wdata_reset_strobe : std_logic := '0';
  signal udp_rx_src_ip_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_src_ip_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal src_port_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal src_port_field_wdata_reset_strobe : std_logic := '0';
  signal src_port_field_wdata_writer_recv_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal src_port_field_wdata_writer_strobe_recv_method_state : std_logic := '0';
  signal src_port_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal src_port_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal dest_ip_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal dest_ip_field_wdata_reset_strobe : std_logic := '0';
  signal dest_ip_field_wdata_writer_recv_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal dest_ip_field_wdata_writer_strobe_recv_method_state : std_logic := '0';
  signal dest_ip_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal dest_ip_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal recv_buf_wdata_field_wdata_reset : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal recv_buf_wdata_field_wdata_reset_strobe : std_logic := '0';
  signal recv_buf_wdata_field_wdata_writer_state_counter_recv_recv_3 : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal recv_buf_wdata_field_wdata_writer_strobe_state_counter_recv_recv_3 : std_logic := '0';
  signal recv_buf_wdata_field_rdata : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal recv_buf_wdata_field_wdata : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal udp_tx_busy_field_wdata_reset : std_logic := '0';
  signal udp_tx_busy_field_wdata_reset_strobe : std_logic := '0';
  signal udp_tx_busy_field_rdata : std_logic := '0';
  signal udp_tx_busy_field_wdata : std_logic := '0';
  signal storage_sector_erase_method_request_field_wdata_reset : std_logic := '0';
  signal storage_sector_erase_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal storage_sector_erase_method_request_field_wdata_writer_state_counter_main_main_6 : std_logic := '0';
  signal storage_sector_erase_method_request_field_wdata_writer_strobe_state_counter_main_main_6 : std_logic := '0';
  signal storage_sector_erase_method_request_field_rdata : std_logic := '0';
  signal storage_sector_erase_method_request_field_wdata : std_logic := '0';
  signal storage_buf_write_method_busy_field_wdata_reset : std_logic := '0';
  signal storage_buf_write_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal storage_buf_write_method_busy_field_rdata : std_logic := '0';
  signal storage_buf_write_method_busy_field_wdata : std_logic := '0';
  signal storage_input_port_buf_write_data_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal storage_input_port_buf_write_data_field_wdata_reset_strobe : std_logic := '0';
  signal storage_input_port_buf_write_data_field_wdata_writer_state_counter_write_data_write_data_6 : std_logic_vector(7 downto 0) := (others => '0');
  signal storage_input_port_buf_write_data_field_wdata_writer_strobe_state_counter_write_data_write_data_6 : std_logic := '0';
  signal storage_input_port_buf_write_data_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal storage_input_port_buf_write_data_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal udp_tx_data_length_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_length_field_wdata_reset_strobe : std_logic := '0';
  signal udp_tx_data_length_field_wdata_writer_send_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_length_field_wdata_writer_strobe_send_method_state : std_logic := '0';
  signal udp_tx_data_length_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_length_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_wait_method_request_field_wdata_reset : std_logic := '0';
  signal this_wait_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_wait_method_request_field_rdata : std_logic := '0';
  signal this_wait_method_request_field_wdata : std_logic := '0';
  signal this_input_port_read_data_len_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_read_data_len_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_read_data_len_field_wdata_writer_state_counter_main_main_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_read_data_len_field_wdata_writer_strobe_state_counter_main_main_6 : std_logic := '0';
  signal this_input_port_read_data_len_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_read_data_len_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_send_method_request_field_wdata_reset : std_logic := '0';
  signal this_send_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_send_method_request_field_wdata_writer_state_counter_main_main_2 : std_logic := '0';
  signal this_send_method_request_field_wdata_writer_strobe_state_counter_main_main_2 : std_logic := '0';
  signal this_send_method_request_field_rdata : std_logic := '0';
  signal this_send_method_request_field_wdata : std_logic := '0';
  signal storage_input_port_buf_write_index_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_buf_write_index_field_wdata_reset_strobe : std_logic := '0';
  signal storage_input_port_buf_write_index_field_wdata_writer_state_counter_write_data_write_data_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_buf_write_index_field_wdata_writer_strobe_state_counter_write_data_write_data_6 : std_logic := '0';
  signal storage_input_port_buf_write_index_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_buf_write_index_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_read_bytes_method_busy_field_wdata_reset : std_logic := '0';
  signal storage_read_bytes_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal storage_read_bytes_method_busy_field_rdata : std_logic := '0';
  signal storage_read_bytes_method_busy_field_wdata : std_logic := '0';
  signal this_recv_method_request_field_wdata_reset : std_logic := '0';
  signal this_recv_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_recv_method_request_field_wdata_writer_state_counter_main_main_2 : std_logic := '0';
  signal this_recv_method_request_field_wdata_writer_strobe_state_counter_main_main_2 : std_logic := '0';
  signal this_recv_method_request_field_rdata : std_logic := '0';
  signal this_recv_method_request_field_wdata : std_logic := '0';
  signal this_write_data_method_request_field_wdata_reset : std_logic := '0';
  signal this_write_data_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_write_data_method_request_field_wdata_writer_state_counter_main_main_6 : std_logic := '0';
  signal this_write_data_method_request_field_wdata_writer_strobe_state_counter_main_main_6 : std_logic := '0';
  signal this_write_data_method_request_field_rdata : std_logic := '0';
  signal this_write_data_method_request_field_wdata : std_logic := '0';
  signal send_buf_rdata_field_wdata_reset : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal send_buf_rdata_field_wdata_reset_strobe : std_logic := '0';
  signal send_buf_rdata_field_rdata : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal send_buf_rdata_field_wdata : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal storage_buf_read_method_request_field_wdata_reset : std_logic := '0';
  signal storage_buf_read_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal storage_buf_read_method_request_field_wdata_writer_state_counter_read_data_read_data_6 : std_logic := '0';
  signal storage_buf_read_method_request_field_wdata_writer_strobe_state_counter_read_data_read_data_6 : std_logic := '0';
  signal storage_buf_read_method_request_field_rdata : std_logic := '0';
  signal storage_buf_read_method_request_field_wdata : std_logic := '0';
  signal udp_tx_src_port_field_wdata_reset : std_logic_vector(15 downto 0) := (others => '0');
  signal udp_tx_src_port_field_wdata_reset_strobe : std_logic := '0';
  signal udp_tx_src_port_field_wdata_writer_send_method_state : std_logic_vector(15 downto 0) := (others => '0');
  signal udp_tx_src_port_field_wdata_writer_strobe_send_method_state : std_logic := '0';
  signal udp_tx_src_port_field_rdata : std_logic_vector(15 downto 0) := (others => '0');
  signal udp_tx_src_port_field_wdata : std_logic_vector(15 downto 0) := (others => '0');
  signal storage_notify_method_busy_field_wdata_reset : std_logic := '0';
  signal storage_notify_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal storage_notify_method_busy_field_rdata : std_logic := '0';
  signal storage_notify_method_busy_field_wdata : std_logic := '0';
  signal udp_tx_start_field_wdata_reset : std_logic := '0';
  signal udp_tx_start_field_wdata_reset_strobe : std_logic := '0';
  signal udp_tx_start_field_wdata_writer_send_method_state : std_logic := '0';
  signal udp_tx_start_field_wdata_writer_strobe_send_method_state : std_logic := '0';
  signal udp_tx_start_field_rdata : std_logic := '0';
  signal udp_tx_start_field_wdata : std_logic := '0';
  signal src_ip_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal src_ip_field_wdata_reset_strobe : std_logic := '0';
  signal src_ip_field_wdata_writer_recv_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal src_ip_field_wdata_writer_strobe_recv_method_state : std_logic := '0';
  signal src_ip_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal src_ip_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_buf_write_method_request_field_wdata_reset : std_logic := '0';
  signal storage_buf_write_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal storage_buf_write_method_request_field_wdata_writer_state_counter_write_data_write_data_6 : std_logic := '0';
  signal storage_buf_write_method_request_field_wdata_writer_strobe_state_counter_write_data_write_data_6 : std_logic := '0';
  signal storage_buf_write_method_request_field_rdata : std_logic := '0';
  signal storage_buf_write_method_request_field_wdata : std_logic := '0';
  signal dest_port_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal dest_port_field_wdata_reset_strobe : std_logic := '0';
  signal dest_port_field_wdata_writer_recv_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal dest_port_field_wdata_writer_strobe_recv_method_state : std_logic := '0';
  signal dest_port_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal dest_port_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_data_rdata_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_data_rdata_field_wdata_reset_strobe : std_logic := '0';
  signal udp_rx_data_rdata_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_data_rdata_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_page_program_length_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_page_program_length_field_wdata_reset_strobe : std_logic := '0';
  signal storage_input_port_page_program_length_field_wdata_writer_write_data_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_page_program_length_field_wdata_writer_strobe_write_data_method_state : std_logic := '0';
  signal storage_input_port_page_program_length_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_page_program_length_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_wdata_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_wdata_field_wdata_reset_strobe : std_logic := '0';
  signal udp_tx_data_wdata_field_wdata_writer_state_counter_send_send_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_wdata_field_wdata_writer_strobe_state_counter_send_send_2 : std_logic := '0';
  signal udp_tx_data_wdata_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_wdata_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal send_buf_waddr_field_wdata_reset : std_logic_vector(10-1 downto 0) := (others => '0');
  signal send_buf_waddr_field_wdata_reset_strobe : std_logic := '0';
  signal send_buf_waddr_field_wdata_writer_state_counter_read_data_read_data_6 : std_logic_vector(10-1 downto 0) := (others => '0');
  signal send_buf_waddr_field_wdata_writer_strobe_state_counter_read_data_read_data_6 : std_logic := '0';
  signal send_buf_waddr_field_wdata_writer_state_counter_main_main_6 : std_logic_vector(10-1 downto 0) := (others => '0');
  signal send_buf_waddr_field_wdata_writer_strobe_state_counter_main_main_6 : std_logic := '0';
  signal send_buf_waddr_field_rdata : std_logic_vector(10-1 downto 0) := (others => '0');
  signal send_buf_waddr_field_wdata : std_logic_vector(10-1 downto 0) := (others => '0');
  signal udp_rx_read_flag_field_wdata_reset : std_logic := '0';
  signal udp_rx_read_flag_field_wdata_reset_strobe : std_logic := '0';
  signal udp_rx_read_flag_field_wdata_writer_recv_method_state : std_logic := '0';
  signal udp_rx_read_flag_field_wdata_writer_strobe_recv_method_state : std_logic := '0';
  signal udp_rx_read_flag_field_rdata : std_logic := '0';
  signal udp_rx_read_flag_field_wdata : std_logic := '0';
  signal udp_rx_valid_field_wdata_reset : std_logic := '0';
  signal udp_rx_valid_field_wdata_reset_strobe : std_logic := '0';
  signal udp_rx_valid_field_rdata : std_logic := '0';
  signal udp_rx_valid_field_wdata : std_logic := '0';
  signal this_input_port_write_data_addr_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_write_data_addr_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_write_data_addr_field_wdata_writer_state_counter_main_main_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_write_data_addr_field_wdata_writer_strobe_state_counter_main_main_6 : std_logic := '0';
  signal this_input_port_write_data_addr_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_write_data_addr_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_we_field_wdata_reset : std_logic_vector(0 downto 0) := (others => '0');
  signal udp_tx_data_we_field_wdata_reset_strobe : std_logic := '0';
  signal udp_tx_data_we_field_wdata_writer_state_counter_send_send_2 : std_logic_vector(0 downto 0) := (others => '0');
  signal udp_tx_data_we_field_wdata_writer_strobe_state_counter_send_send_2 : std_logic := '0';
  signal udp_tx_data_we_field_rdata : std_logic_vector(0 downto 0) := (others => '0');
  signal udp_tx_data_we_field_wdata : std_logic_vector(0 downto 0) := (others => '0');
  signal data_length_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal data_length_field_wdata_reset_strobe : std_logic := '0';
  signal data_length_field_wdata_writer_recv_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal data_length_field_wdata_writer_strobe_recv_method_state : std_logic := '0';
  signal data_length_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal data_length_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_src_port_field_wdata_reset : std_logic_vector(15 downto 0) := (others => '0');
  signal udp_rx_src_port_field_wdata_reset_strobe : std_logic := '0';
  signal udp_rx_src_port_field_rdata : std_logic_vector(15 downto 0) := (others => '0');
  signal udp_rx_src_port_field_wdata : std_logic_vector(15 downto 0) := (others => '0');
  signal recv_buf_rdata_field_wdata_reset : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal recv_buf_rdata_field_wdata_reset_strobe : std_logic := '0';
  signal recv_buf_rdata_field_rdata : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal recv_buf_rdata_field_wdata : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal storage_input_port_buf_read_index_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_buf_read_index_field_wdata_reset_strobe : std_logic := '0';
  signal storage_input_port_buf_read_index_field_wdata_writer_state_counter_read_data_read_data_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_buf_read_index_field_wdata_writer_strobe_state_counter_read_data_read_data_6 : std_logic := '0';
  signal storage_input_port_buf_read_index_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_buf_read_index_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_sector_erase_method_busy_field_wdata_reset : std_logic := '0';
  signal storage_sector_erase_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal storage_sector_erase_method_busy_field_rdata : std_logic := '0';
  signal storage_sector_erase_method_busy_field_wdata : std_logic := '0';
  signal storage_input_port_read_bytes_length_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_read_bytes_length_field_wdata_reset_strobe : std_logic := '0';
  signal storage_input_port_read_bytes_length_field_wdata_writer_read_data_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_read_bytes_length_field_wdata_writer_strobe_read_data_method_state : std_logic := '0';
  signal storage_input_port_read_bytes_length_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_read_bytes_length_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_write_data_len_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_write_data_len_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_write_data_len_field_wdata_writer_state_counter_main_main_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_write_data_len_field_wdata_writer_strobe_state_counter_main_main_6 : std_logic := '0';
  signal this_input_port_write_data_len_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_write_data_len_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal recv_buf_waddr_field_wdata_reset : std_logic_vector(10-1 downto 0) := (others => '0');
  signal recv_buf_waddr_field_wdata_reset_strobe : std_logic := '0';
  signal recv_buf_waddr_field_wdata_writer_state_counter_recv_recv_3 : std_logic_vector(10-1 downto 0) := (others => '0');
  signal recv_buf_waddr_field_wdata_writer_strobe_state_counter_recv_recv_3 : std_logic := '0';
  signal recv_buf_waddr_field_rdata : std_logic_vector(10-1 downto 0) := (others => '0');
  signal recv_buf_waddr_field_wdata : std_logic_vector(10-1 downto 0) := (others => '0');
  signal udp_rx_dest_ip_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_dest_ip_field_wdata_reset_strobe : std_logic := '0';
  signal udp_rx_dest_ip_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_dest_ip_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_buf_read_method_busy_field_wdata_reset : std_logic := '0';
  signal storage_buf_read_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal storage_buf_read_method_busy_field_rdata : std_logic := '0';
  signal storage_buf_read_method_busy_field_wdata : std_logic := '0';
  signal storage_page_program_method_request_field_wdata_reset : std_logic := '0';
  signal storage_page_program_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal storage_page_program_method_request_field_wdata_writer_write_data_method_state : std_logic := '0';
  signal storage_page_program_method_request_field_wdata_writer_strobe_write_data_method_state : std_logic := '0';
  signal storage_page_program_method_request_field_rdata : std_logic := '0';
  signal storage_page_program_method_request_field_wdata : std_logic := '0';
  signal storage_input_port_read_bytes_addr_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_read_bytes_addr_field_wdata_reset_strobe : std_logic := '0';
  signal storage_input_port_read_bytes_addr_field_wdata_writer_read_data_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_read_bytes_addr_field_wdata_writer_strobe_read_data_method_state : std_logic := '0';
  signal storage_input_port_read_bytes_addr_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_read_bytes_addr_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal send_buf_we_field_wdata_reset : std_logic_vector(0 downto 0) := (others => '0');
  signal send_buf_we_field_wdata_reset_strobe : std_logic := '0';
  signal send_buf_we_field_wdata_writer_state_counter_read_data_read_data_6 : std_logic_vector(0 downto 0) := (others => '0');
  signal send_buf_we_field_wdata_writer_strobe_state_counter_read_data_read_data_6 : std_logic := '0';
  signal send_buf_we_field_wdata_writer_state_counter_main_main_6 : std_logic_vector(0 downto 0) := (others => '0');
  signal send_buf_we_field_wdata_writer_strobe_state_counter_main_main_6 : std_logic := '0';
  signal send_buf_we_field_rdata : std_logic_vector(0 downto 0) := (others => '0');
  signal send_buf_we_field_wdata : std_logic_vector(0 downto 0) := (others => '0');
  signal udp_rx_data_length_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_data_length_field_wdata_reset_strobe : std_logic := '0';
  signal udp_rx_data_length_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_data_length_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_send_len_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_send_len_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_send_len_field_wdata_writer_state_counter_main_main_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_send_len_field_wdata_writer_strobe_state_counter_main_main_2 : std_logic := '0';
  signal this_input_port_send_len_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_send_len_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_output_port_buf_read_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal storage_output_port_buf_read_field_wdata_reset_strobe : std_logic := '0';
  signal storage_output_port_buf_read_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal storage_output_port_buf_read_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal send_buf_raddr_field_wdata_reset : std_logic_vector(10-1 downto 0) := (others => '0');
  signal send_buf_raddr_field_wdata_reset_strobe : std_logic := '0';
  signal send_buf_raddr_field_wdata_writer_state_counter_send_send_2 : std_logic_vector(10-1 downto 0) := (others => '0');
  signal send_buf_raddr_field_wdata_writer_strobe_state_counter_send_send_2 : std_logic := '0';
  signal send_buf_raddr_field_rdata : std_logic_vector(10-1 downto 0) := (others => '0');
  signal send_buf_raddr_field_wdata : std_logic_vector(10-1 downto 0) := (others => '0');
  signal this_read_data_method_request_field_wdata_reset : std_logic := '0';
  signal this_read_data_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_read_data_method_request_field_wdata_writer_state_counter_main_main_6 : std_logic := '0';
  signal this_read_data_method_request_field_wdata_writer_strobe_state_counter_main_main_6 : std_logic := '0';
  signal this_read_data_method_request_field_rdata : std_logic := '0';
  signal this_read_data_method_request_field_wdata : std_logic := '0';
  signal udp_rx_dest_port_field_wdata_reset : std_logic_vector(15 downto 0) := (others => '0');
  signal udp_rx_dest_port_field_wdata_reset_strobe : std_logic := '0';
  signal udp_rx_dest_port_field_rdata : std_logic_vector(15 downto 0) := (others => '0');
  signal udp_rx_dest_port_field_wdata : std_logic_vector(15 downto 0) := (others => '0');
  signal udp_rx_data_raddr_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_data_raddr_field_wdata_reset_strobe : std_logic := '0';
  signal udp_rx_data_raddr_field_wdata_writer_state_counter_recv_recv_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_data_raddr_field_wdata_writer_strobe_state_counter_recv_recv_3 : std_logic := '0';
  signal udp_rx_data_raddr_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_rx_data_raddr_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_waddr_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_waddr_field_wdata_reset_strobe : std_logic := '0';
  signal udp_tx_data_waddr_field_wdata_writer_state_counter_send_send_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_waddr_field_wdata_writer_strobe_state_counter_send_send_2 : std_logic := '0';
  signal udp_tx_data_waddr_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_data_waddr_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_page_program_method_busy_field_wdata_reset : std_logic := '0';
  signal storage_page_program_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal storage_page_program_method_busy_field_rdata : std_logic := '0';
  signal storage_page_program_method_busy_field_wdata : std_logic := '0';
  signal udp_tx_dest_port_field_wdata_reset : std_logic_vector(15 downto 0) := (others => '0');
  signal udp_tx_dest_port_field_wdata_reset_strobe : std_logic := '0';
  signal udp_tx_dest_port_field_wdata_writer_send_method_state : std_logic_vector(15 downto 0) := (others => '0');
  signal udp_tx_dest_port_field_wdata_writer_strobe_send_method_state : std_logic := '0';
  signal udp_tx_dest_port_field_rdata : std_logic_vector(15 downto 0) := (others => '0');
  signal udp_tx_dest_port_field_wdata : std_logic_vector(15 downto 0) := (others => '0');
  signal storage_input_port_sector_erase_addr_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_sector_erase_addr_field_wdata_reset_strobe : std_logic := '0';
  signal storage_input_port_sector_erase_addr_field_wdata_writer_state_counter_main_main_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_sector_erase_addr_field_wdata_writer_strobe_state_counter_main_main_6 : std_logic := '0';
  signal storage_input_port_sector_erase_addr_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_sector_erase_addr_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_read_bytes_method_request_field_wdata_reset : std_logic := '0';
  signal storage_read_bytes_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal storage_read_bytes_method_request_field_wdata_writer_read_data_method_state : std_logic := '0';
  signal storage_read_bytes_method_request_field_wdata_writer_strobe_read_data_method_state : std_logic := '0';
  signal storage_read_bytes_method_request_field_rdata : std_logic := '0';
  signal storage_read_bytes_method_request_field_wdata : std_logic := '0';
  signal send_buf_wdata_field_wdata_reset : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal send_buf_wdata_field_wdata_reset_strobe : std_logic := '0';
  signal send_buf_wdata_field_wdata_writer_state_counter_main_main_6 : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal send_buf_wdata_field_wdata_writer_strobe_state_counter_main_main_6 : std_logic := '0';
  signal send_buf_wdata_field_wdata_writer_state_counter_read_data_read_data_6 : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal send_buf_wdata_field_wdata_writer_strobe_state_counter_read_data_read_data_6 : std_logic := '0';
  signal send_buf_wdata_field_rdata : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal send_buf_wdata_field_wdata : std_logic_vector(31-0+1-1 downto 0) := (others => '0');
  signal recv_buf_raddr_field_wdata_reset : std_logic_vector(10-1 downto 0) := (others => '0');
  signal recv_buf_raddr_field_wdata_reset_strobe : std_logic := '0';
  signal recv_buf_raddr_field_wdata_writer_state_counter_write_data_write_data_6 : std_logic_vector(10-1 downto 0) := (others => '0');
  signal recv_buf_raddr_field_wdata_writer_strobe_state_counter_write_data_write_data_6 : std_logic := '0';
  signal recv_buf_raddr_field_wdata_writer_state_counter_main_main_2 : std_logic_vector(10-1 downto 0) := (others => '0');
  signal recv_buf_raddr_field_wdata_writer_strobe_state_counter_main_main_2 : std_logic := '0';
  signal recv_buf_raddr_field_rdata : std_logic_vector(10-1 downto 0) := (others => '0');
  signal recv_buf_raddr_field_wdata : std_logic_vector(10-1 downto 0) := (others => '0');
  signal udp_tx_src_ip_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_src_ip_field_wdata_reset_strobe : std_logic := '0';
  signal udp_tx_src_ip_field_wdata_writer_send_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_src_ip_field_wdata_writer_strobe_send_method_state : std_logic := '0';
  signal udp_tx_src_ip_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_src_ip_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal recv_buf_we_field_wdata_reset : std_logic_vector(0 downto 0) := (others => '0');
  signal recv_buf_we_field_wdata_reset_strobe : std_logic := '0';
  signal recv_buf_we_field_wdata_writer_state_counter_recv_recv_3 : std_logic_vector(0 downto 0) := (others => '0');
  signal recv_buf_we_field_wdata_writer_strobe_state_counter_recv_recv_3 : std_logic := '0';
  signal recv_buf_we_field_rdata : std_logic_vector(0 downto 0) := (others => '0');
  signal recv_buf_we_field_wdata : std_logic_vector(0 downto 0) := (others => '0');
  signal this_input_port_read_data_addr_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_read_data_addr_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_read_data_addr_field_wdata_writer_state_counter_main_main_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_read_data_addr_field_wdata_writer_strobe_state_counter_main_main_6 : std_logic := '0';
  signal this_input_port_read_data_addr_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_read_data_addr_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_page_program_addr_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_page_program_addr_field_wdata_reset_strobe : std_logic := '0';
  signal storage_input_port_page_program_addr_field_wdata_writer_write_data_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_page_program_addr_field_wdata_writer_strobe_write_data_method_state : std_logic := '0';
  signal storage_input_port_page_program_addr_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_input_port_page_program_addr_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_notify_method_request_field_wdata_reset : std_logic := '0';
  signal storage_notify_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal storage_notify_method_request_field_rdata : std_logic := '0';
  signal storage_notify_method_request_field_wdata : std_logic := '0';
  signal udp_tx_dest_ip_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_dest_ip_field_wdata_reset_strobe : std_logic := '0';
  signal udp_tx_dest_ip_field_wdata_writer_send_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_dest_ip_field_wdata_writer_strobe_send_method_state : std_logic := '0';
  signal udp_tx_dest_ip_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal udp_tx_dest_ip_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal read_data_if_flag_read_data_2_read_data_0 : std_logic := '0';
  signal v_recv_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal recv_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_recv_recv_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_recv_recv_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_recv_recv_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_recv_recv_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_write_data_write_data_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal len_main_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_write_data_write_data_5 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_write_data_write_data_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal write_data_if_flag_write_data_4_write_data_0 : std_logic := '0';
  signal state_counter_write_data_write_data_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_write_data_write_data_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_wait_method_busy : std_logic := '0';
  signal this_send_call_state_counter_main_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal read_data_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal notify_flag : std_logic := '0';
  signal b2_read_data_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_send_send_5 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_send_send_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_notify_method_busy : std_logic := '0';
  signal state_counter_send_send_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_send_send_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal d_notify_flag : std_logic := '0';
  signal this_recv_call_state_counter_main_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_buf_write_call_state_counter_write_data_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_buf_read_call_state_counter_read_data_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_output_port_read_data : std_logic_vector(31 downto 0) := (others => '0');
  signal this_send_method_busy : std_logic := '0';
  signal state_counter_read_data_read_data_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal command_main_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal write_data_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_read_data_read_data_5 : std_logic_vector(31 downto 0) := (others => '0');
  signal main_cond_expr_main_7_main_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_read_data_read_data_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal l_write_data_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_read_data_read_data_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_read_data_read_data_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal i_read_data_5 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_read_data_call_state_counter_main_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_page_program_call_state_counter_write_data_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_read_data_method_busy : std_logic := '0';
  signal state_counter_main_main_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal b0_read_data_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_main_main_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_main_main_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal wait_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_main_main_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal array_index_operation_state_counter_write_data_7 : std_logic_vector(2 downto 0) := (others => '0');
  signal this_notify_method_request : std_logic := '0';
  signal v_write_data_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal write_data_if_flag_write_data_2_write_data_0 : std_logic := '0';
  signal state_counter_wait_wait_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal array_index_operation_state_counter_recv_5 : std_logic_vector(2 downto 0) := (others => '0');
  signal array_index_operation_state_counter_recv_4 : std_logic_vector(2 downto 0) := (others => '0');
  signal array_index_operation_state_counter_send_4 : std_logic_vector(2 downto 0) := (others => '0');
  signal array_index_operation_state_counter_send_3 : std_logic_vector(2 downto 0) := (others => '0');
  signal array_index_operation_state_counter_main_10 : std_logic_vector(2 downto 0) := (others => '0');
  signal l_read_data_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal b3_read_data_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal notify_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal addr_main_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal array_index_operation_state_counter_read_data_7 : std_logic_vector(2 downto 0) := (others => '0');
  signal send_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_notify_notify_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_read_bytes_call_state_counter_read_data_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_write_data_method_busy : std_logic := '0';
  signal read_data_if_flag_read_data_4_read_data_0 : std_logic := '0';
  signal b1_read_data_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal i_write_data_5 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_write_data_call_state_counter_main_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_output_port_write_data : std_logic_vector(31 downto 0) := (others => '0');
  signal array_index_operation_state_counter_main_9 : std_logic_vector(2 downto 0) := (others => '0');
  signal array_index_operation_state_counter_main_8 : std_logic_vector(2 downto 0) := (others => '0');
  signal i_recv_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal storage_sector_erase_call_state_counter_main_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal array_index_operation_state_counter_main_5 : std_logic_vector(2 downto 0) := (others => '0');
  signal this_recv_method_busy : std_logic := '0';
  signal i_send_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal array_index_operation_state_counter_main_4 : std_logic_vector(2 downto 0) := (others => '0');
  signal array_index_operation_state_counter_main_3 : std_logic_vector(2 downto 0) := (others => '0');
  signal main_method_state : std_logic_vector(31 downto 0) := (others => '0');
begin
  U_send_buf : simpledualportram
  generic map(
    DEPTH => send_buf_DEPTH,
    WIDTH => send_buf_WIDTH
  )
  port map(
    clk => clk,
    we => send_buf_we_field_rdata,
    raddr => send_buf_raddr_field_rdata,
    rdata => send_buf_rdata_field_wdata,
    waddr => send_buf_waddr_field_rdata,
    wdata => send_buf_wdata_field_rdata
  );
  U_udp_tx : udp_tx_wrapper
  port map(
    clk => clk,
    reset => reset,
    UPL_OUT_Data => udp_tx_UPL_OUT_Data,
    UPL_OUT_Req => udp_tx_UPL_OUT_Req,
    UPL_OUT_Ack => udp_tx_UPL_OUT_Ack,
    UPL_OUT_En => udp_tx_UPL_OUT_En,
    data_length => udp_tx_data_length_field_rdata,
    start => udp_tx_start_field_rdata,
    busy => udp_tx_busy_field_wdata,
    data_waddr => udp_tx_data_waddr_field_rdata,
    data_wdata => udp_tx_data_wdata_field_rdata,
    data_we => udp_tx_data_we_field_rdata,
    dest_ip => udp_tx_dest_ip_field_rdata,
    dest_port => udp_tx_dest_port_field_rdata,
    src_ip => udp_tx_src_ip_field_rdata,
    src_port => udp_tx_src_port_field_rdata
  );
  U_udp_rx : udp_rx_wrapper
  port map(
    clk => clk,
    reset => reset,
    UPL_IN_Data => udp_rx_UPL_IN_Data,
    UPL_IN_Req => udp_rx_UPL_IN_Req,
    UPL_IN_Ack => udp_rx_UPL_IN_Ack,
    UPL_IN_En => udp_rx_UPL_IN_En,
    src_ip => udp_rx_src_ip_field_wdata,
    src_port => udp_rx_src_port_field_wdata,
    dest_ip => udp_rx_dest_ip_field_wdata,
    dest_port => udp_rx_dest_port_field_wdata,
    data_length => udp_rx_data_length_field_wdata,
    data_raddr => udp_rx_data_raddr_field_rdata,
    data_rdata => udp_rx_data_rdata_field_wdata,
    valid => udp_rx_valid_field_wdata,
    read_flag => udp_rx_read_flag_field_rdata
  );
  U_recv_buf : simpledualportram
  generic map(
    DEPTH => recv_buf_DEPTH,
    WIDTH => recv_buf_WIDTH
  )
  port map(
    clk => clk,
    we => recv_buf_we_field_rdata,
    raddr => recv_buf_raddr_field_rdata,
    rdata => recv_buf_rdata_field_wdata,
    waddr => recv_buf_waddr_field_rdata,
    wdata => recv_buf_wdata_field_rdata
  );
  U_storage : m25p40if
  port map(
    notify_method_busy => storage_notify_method_busy_field_wdata,
    rom_M25P40_C => storage_rom_M25P40_C,
    buf_read_method_busy => storage_buf_read_method_busy_field_wdata,
    rom_M25P40_S => storage_rom_M25P40_S,
    read_bytes_method_busy => storage_read_bytes_method_busy_field_wdata,
    page_program_method_busy => storage_page_program_method_busy_field_wdata,
    rom_M25P40_DQ0 => storage_rom_M25P40_DQ0,
    sector_erase_method_busy => storage_sector_erase_method_busy_field_wdata,
    buf_write_method_busy => storage_buf_write_method_busy_field_wdata,
    output_port_buf_read => storage_output_port_buf_read_field_wdata,
    input_port_sector_erase_addr => storage_input_port_sector_erase_addr_field_rdata,
    input_port_page_program_addr => storage_input_port_page_program_addr_field_rdata,
    input_port_buf_read_index => storage_input_port_buf_read_index_field_rdata,
    input_port_read_bytes_addr => storage_input_port_read_bytes_addr_field_rdata,
    input_port_buf_write_index => storage_input_port_buf_write_index_field_rdata,
    buf_write_method_request => storage_buf_write_method_request_field_rdata,
    input_port_buf_write_data => storage_input_port_buf_write_data_field_rdata,
    clk => clk,
    notify_method_request => storage_notify_method_request_field_rdata,
    sector_erase_method_request => storage_sector_erase_method_request_field_rdata,
    read_bytes_method_request => storage_read_bytes_method_request_field_rdata,
    buf_read_method_request => storage_buf_read_method_request_field_rdata,
    rom_M25P40_DQ1 => storage_rom_M25P40_DQ1,
    reset => reset,
    page_program_method_request => storage_page_program_method_request_field_rdata,
    input_port_read_bytes_length => storage_input_port_read_bytes_length_field_rdata,
    input_port_page_program_length => storage_input_port_page_program_length_field_rdata
  );
  this_notify_method_request <= notify_method_request;
  notify_method_busy <= this_notify_method_busy;
  
  udp_rx_src_ip_field_rdata <= udp_rx_src_ip_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        src_port_field_wdata <= src_port_field_wdata_reset;
      elsif (src_port_field_wdata_reset_strobe = '1') then
        src_port_field_wdata <= src_port_field_wdata_reset;
      elsif (src_port_field_wdata_writer_strobe_recv_method_state = '1') then
        src_port_field_wdata <= src_port_field_wdata_writer_recv_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        src_port_field_wdata_reset_strobe <= '1';
      else
        src_port_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(recv_method_state) = 4) then
        src_port_field_wdata_writer_strobe_recv_method_state <= '1';
      else
        src_port_field_wdata_writer_strobe_recv_method_state <= '0';
      end if;
    end if;
  end process;
  src_port_field_rdata <= src_port_field_wdata_reset when (reset = '1') else
        src_port_field_wdata_reset when (src_port_field_wdata_reset_strobe = '1') else
        src_port_field_wdata_writer_recv_method_state when (src_port_field_wdata_writer_strobe_recv_method_state = '1') else
        src_port_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        dest_ip_field_wdata <= dest_ip_field_wdata_reset;
      elsif (dest_ip_field_wdata_reset_strobe = '1') then
        dest_ip_field_wdata <= dest_ip_field_wdata_reset;
      elsif (dest_ip_field_wdata_writer_strobe_recv_method_state = '1') then
        dest_ip_field_wdata <= dest_ip_field_wdata_writer_recv_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        dest_ip_field_wdata_reset_strobe <= '1';
      else
        dest_ip_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(recv_method_state) = 4) then
        dest_ip_field_wdata_writer_strobe_recv_method_state <= '1';
      else
        dest_ip_field_wdata_writer_strobe_recv_method_state <= '0';
      end if;
    end if;
  end process;
  dest_ip_field_rdata <= dest_ip_field_wdata_reset when (reset = '1') else
        dest_ip_field_wdata_reset when (dest_ip_field_wdata_reset_strobe = '1') else
        dest_ip_field_wdata_writer_recv_method_state when (dest_ip_field_wdata_writer_strobe_recv_method_state = '1') else
        dest_ip_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        recv_buf_wdata_field_wdata <= recv_buf_wdata_field_wdata_reset;
      elsif (recv_buf_wdata_field_wdata_reset_strobe = '1') then
        recv_buf_wdata_field_wdata <= recv_buf_wdata_field_wdata_reset;
      elsif (recv_buf_wdata_field_wdata_writer_strobe_state_counter_recv_recv_3 = '1') then
        recv_buf_wdata_field_wdata <= recv_buf_wdata_field_wdata_writer_state_counter_recv_recv_3;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        recv_buf_wdata_field_wdata_reset_strobe <= '1';
      else
        recv_buf_wdata_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_recv_recv_3) = 3) then
        recv_buf_wdata_field_wdata_writer_strobe_state_counter_recv_recv_3 <= '1';
      else
        recv_buf_wdata_field_wdata_writer_strobe_state_counter_recv_recv_3 <= '0';
      end if;
    end if;
  end process;
  recv_buf_wdata_field_rdata <= recv_buf_wdata_field_wdata_reset when (reset = '1') else
        recv_buf_wdata_field_wdata_reset when (recv_buf_wdata_field_wdata_reset_strobe = '1') else
        recv_buf_wdata_field_wdata_writer_state_counter_recv_recv_3 when (recv_buf_wdata_field_wdata_writer_strobe_state_counter_recv_recv_3 = '1') else
        recv_buf_wdata_field_wdata;
  
  udp_tx_busy_field_rdata <= udp_tx_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_sector_erase_method_request_field_wdata <= storage_sector_erase_method_request_field_wdata_reset;
      elsif (storage_sector_erase_method_request_field_wdata_reset_strobe = '1') then
        storage_sector_erase_method_request_field_wdata <= storage_sector_erase_method_request_field_wdata_reset;
      elsif (storage_sector_erase_method_request_field_wdata_writer_strobe_state_counter_main_main_6 = '1') then
        storage_sector_erase_method_request_field_wdata <= storage_sector_erase_method_request_field_wdata_writer_state_counter_main_main_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_sector_erase_method_request_field_wdata_reset_strobe <= '1';
      else
        storage_sector_erase_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_6) = 10 or conv_integer(state_counter_main_main_6) = 10) then
        storage_sector_erase_method_request_field_wdata_writer_strobe_state_counter_main_main_6 <= '1';
      else
        storage_sector_erase_method_request_field_wdata_writer_strobe_state_counter_main_main_6 <= '0';
      end if;
    end if;
  end process;
  storage_sector_erase_method_request_field_rdata <= storage_sector_erase_method_request_field_wdata_reset when (reset = '1') else
        storage_sector_erase_method_request_field_wdata_reset when (storage_sector_erase_method_request_field_wdata_reset_strobe = '1') else
        storage_sector_erase_method_request_field_wdata_writer_state_counter_main_main_6 when (storage_sector_erase_method_request_field_wdata_writer_strobe_state_counter_main_main_6 = '1') else
        storage_sector_erase_method_request_field_wdata;
  
  storage_buf_write_method_busy_field_rdata <= storage_buf_write_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_buf_write_data_field_wdata <= storage_input_port_buf_write_data_field_wdata_reset;
      elsif (storage_input_port_buf_write_data_field_wdata_reset_strobe = '1') then
        storage_input_port_buf_write_data_field_wdata <= storage_input_port_buf_write_data_field_wdata_reset;
      elsif (storage_input_port_buf_write_data_field_wdata_writer_strobe_state_counter_write_data_write_data_6 = '1') then
        storage_input_port_buf_write_data_field_wdata <= storage_input_port_buf_write_data_field_wdata_writer_state_counter_write_data_write_data_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_buf_write_data_field_wdata_reset_strobe <= '1';
      else
        storage_input_port_buf_write_data_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_write_data_write_data_6) = 3 or conv_integer(state_counter_write_data_write_data_6) = 4 or conv_integer(state_counter_write_data_write_data_6) = 5 or conv_integer(state_counter_write_data_write_data_6) = 6) then
        storage_input_port_buf_write_data_field_wdata_writer_strobe_state_counter_write_data_write_data_6 <= '1';
      else
        storage_input_port_buf_write_data_field_wdata_writer_strobe_state_counter_write_data_write_data_6 <= '0';
      end if;
    end if;
  end process;
  storage_input_port_buf_write_data_field_rdata <= storage_input_port_buf_write_data_field_wdata_reset when (reset = '1') else
        storage_input_port_buf_write_data_field_wdata_reset when (storage_input_port_buf_write_data_field_wdata_reset_strobe = '1') else
        storage_input_port_buf_write_data_field_wdata_writer_state_counter_write_data_write_data_6 when (storage_input_port_buf_write_data_field_wdata_writer_strobe_state_counter_write_data_write_data_6 = '1') else
        storage_input_port_buf_write_data_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_data_length_field_wdata <= udp_tx_data_length_field_wdata_reset;
      elsif (udp_tx_data_length_field_wdata_reset_strobe = '1') then
        udp_tx_data_length_field_wdata <= udp_tx_data_length_field_wdata_reset;
      elsif (udp_tx_data_length_field_wdata_writer_strobe_send_method_state = '1') then
        udp_tx_data_length_field_wdata <= udp_tx_data_length_field_wdata_writer_send_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_data_length_field_wdata_reset_strobe <= '1';
      else
        udp_tx_data_length_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(send_method_state) = 6) then
        udp_tx_data_length_field_wdata_writer_strobe_send_method_state <= '1';
      else
        udp_tx_data_length_field_wdata_writer_strobe_send_method_state <= '0';
      end if;
    end if;
  end process;
  udp_tx_data_length_field_rdata <= udp_tx_data_length_field_wdata_reset when (reset = '1') else
        udp_tx_data_length_field_wdata_reset when (udp_tx_data_length_field_wdata_reset_strobe = '1') else
        udp_tx_data_length_field_wdata_writer_send_method_state when (udp_tx_data_length_field_wdata_writer_strobe_send_method_state = '1') else
        udp_tx_data_length_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      elsif (this_wait_method_request_field_wdata_reset_strobe = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata_reset_strobe <= '1';
      else
        this_wait_method_request_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  this_wait_method_request_field_rdata <= this_wait_method_request_field_wdata_reset when (reset = '1') else
        this_wait_method_request_field_wdata_reset when (this_wait_method_request_field_wdata_reset_strobe = '1') else
        this_wait_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_read_data_len_field_wdata <= this_input_port_read_data_len_field_wdata_reset;
      elsif (this_input_port_read_data_len_field_wdata_reset_strobe = '1') then
        this_input_port_read_data_len_field_wdata <= this_input_port_read_data_len_field_wdata_reset;
      elsif (this_input_port_read_data_len_field_wdata_writer_strobe_state_counter_main_main_6 = '1') then
        this_input_port_read_data_len_field_wdata <= this_input_port_read_data_len_field_wdata_writer_state_counter_main_main_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_read_data_len_field_wdata_reset_strobe <= '1';
      else
        this_input_port_read_data_len_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_6) = 1) then
        this_input_port_read_data_len_field_wdata_writer_strobe_state_counter_main_main_6 <= '1';
      else
        this_input_port_read_data_len_field_wdata_writer_strobe_state_counter_main_main_6 <= '0';
      end if;
    end if;
  end process;
  this_input_port_read_data_len_field_rdata <= this_input_port_read_data_len_field_wdata_reset when (reset = '1') else
        this_input_port_read_data_len_field_wdata_reset when (this_input_port_read_data_len_field_wdata_reset_strobe = '1') else
        this_input_port_read_data_len_field_wdata_writer_state_counter_main_main_6 when (this_input_port_read_data_len_field_wdata_writer_strobe_state_counter_main_main_6 = '1') else
        this_input_port_read_data_len_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_send_method_request_field_wdata <= this_send_method_request_field_wdata_reset;
      elsif (this_send_method_request_field_wdata_reset_strobe = '1') then
        this_send_method_request_field_wdata <= this_send_method_request_field_wdata_reset;
      elsif (this_send_method_request_field_wdata_writer_strobe_state_counter_main_main_2 = '1') then
        this_send_method_request_field_wdata <= this_send_method_request_field_wdata_writer_state_counter_main_main_2;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_send_method_request_field_wdata_reset_strobe <= '1';
      else
        this_send_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_2) = 9 or conv_integer(state_counter_main_main_2) = 9) then
        this_send_method_request_field_wdata_writer_strobe_state_counter_main_main_2 <= '1';
      else
        this_send_method_request_field_wdata_writer_strobe_state_counter_main_main_2 <= '0';
      end if;
    end if;
  end process;
  this_send_method_request_field_rdata <= this_send_method_request_field_wdata_reset when (reset = '1') else
        this_send_method_request_field_wdata_reset when (this_send_method_request_field_wdata_reset_strobe = '1') else
        this_send_method_request_field_wdata_writer_state_counter_main_main_2 when (this_send_method_request_field_wdata_writer_strobe_state_counter_main_main_2 = '1') else
        this_send_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_buf_write_index_field_wdata <= storage_input_port_buf_write_index_field_wdata_reset;
      elsif (storage_input_port_buf_write_index_field_wdata_reset_strobe = '1') then
        storage_input_port_buf_write_index_field_wdata <= storage_input_port_buf_write_index_field_wdata_reset;
      elsif (storage_input_port_buf_write_index_field_wdata_writer_strobe_state_counter_write_data_write_data_6 = '1') then
        storage_input_port_buf_write_index_field_wdata <= storage_input_port_buf_write_index_field_wdata_writer_state_counter_write_data_write_data_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_buf_write_index_field_wdata_reset_strobe <= '1';
      else
        storage_input_port_buf_write_index_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_write_data_write_data_6) = 3 or conv_integer(state_counter_write_data_write_data_6) = 4 or conv_integer(state_counter_write_data_write_data_6) = 5 or conv_integer(state_counter_write_data_write_data_6) = 6) then
        storage_input_port_buf_write_index_field_wdata_writer_strobe_state_counter_write_data_write_data_6 <= '1';
      else
        storage_input_port_buf_write_index_field_wdata_writer_strobe_state_counter_write_data_write_data_6 <= '0';
      end if;
    end if;
  end process;
  storage_input_port_buf_write_index_field_rdata <= storage_input_port_buf_write_index_field_wdata_reset when (reset = '1') else
        storage_input_port_buf_write_index_field_wdata_reset when (storage_input_port_buf_write_index_field_wdata_reset_strobe = '1') else
        storage_input_port_buf_write_index_field_wdata_writer_state_counter_write_data_write_data_6 when (storage_input_port_buf_write_index_field_wdata_writer_strobe_state_counter_write_data_write_data_6 = '1') else
        storage_input_port_buf_write_index_field_wdata;
  
  storage_read_bytes_method_busy_field_rdata <= storage_read_bytes_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_recv_method_request_field_wdata <= this_recv_method_request_field_wdata_reset;
      elsif (this_recv_method_request_field_wdata_reset_strobe = '1') then
        this_recv_method_request_field_wdata <= this_recv_method_request_field_wdata_reset;
      elsif (this_recv_method_request_field_wdata_writer_strobe_state_counter_main_main_2 = '1') then
        this_recv_method_request_field_wdata <= this_recv_method_request_field_wdata_writer_state_counter_main_main_2;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_recv_method_request_field_wdata_reset_strobe <= '1';
      else
        this_recv_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_2) = 1 or conv_integer(state_counter_main_main_2) = 1) then
        this_recv_method_request_field_wdata_writer_strobe_state_counter_main_main_2 <= '1';
      else
        this_recv_method_request_field_wdata_writer_strobe_state_counter_main_main_2 <= '0';
      end if;
    end if;
  end process;
  this_recv_method_request_field_rdata <= this_recv_method_request_field_wdata_reset when (reset = '1') else
        this_recv_method_request_field_wdata_reset when (this_recv_method_request_field_wdata_reset_strobe = '1') else
        this_recv_method_request_field_wdata_writer_state_counter_main_main_2 when (this_recv_method_request_field_wdata_writer_strobe_state_counter_main_main_2 = '1') else
        this_recv_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_write_data_method_request_field_wdata <= this_write_data_method_request_field_wdata_reset;
      elsif (this_write_data_method_request_field_wdata_reset_strobe = '1') then
        this_write_data_method_request_field_wdata <= this_write_data_method_request_field_wdata_reset;
      elsif (this_write_data_method_request_field_wdata_writer_strobe_state_counter_main_main_6 = '1') then
        this_write_data_method_request_field_wdata <= this_write_data_method_request_field_wdata_writer_state_counter_main_main_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_write_data_method_request_field_wdata_reset_strobe <= '1';
      else
        this_write_data_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_6) = 4 or conv_integer(state_counter_main_main_6) = 4) then
        this_write_data_method_request_field_wdata_writer_strobe_state_counter_main_main_6 <= '1';
      else
        this_write_data_method_request_field_wdata_writer_strobe_state_counter_main_main_6 <= '0';
      end if;
    end if;
  end process;
  this_write_data_method_request_field_rdata <= this_write_data_method_request_field_wdata_reset when (reset = '1') else
        this_write_data_method_request_field_wdata_reset when (this_write_data_method_request_field_wdata_reset_strobe = '1') else
        this_write_data_method_request_field_wdata_writer_state_counter_main_main_6 when (this_write_data_method_request_field_wdata_writer_strobe_state_counter_main_main_6 = '1') else
        this_write_data_method_request_field_wdata;
  
  send_buf_rdata_field_rdata <= send_buf_rdata_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_buf_read_method_request_field_wdata <= storage_buf_read_method_request_field_wdata_reset;
      elsif (storage_buf_read_method_request_field_wdata_reset_strobe = '1') then
        storage_buf_read_method_request_field_wdata <= storage_buf_read_method_request_field_wdata_reset;
      elsif (storage_buf_read_method_request_field_wdata_writer_strobe_state_counter_read_data_read_data_6 = '1') then
        storage_buf_read_method_request_field_wdata <= storage_buf_read_method_request_field_wdata_writer_state_counter_read_data_read_data_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_buf_read_method_request_field_wdata_reset_strobe <= '1';
      else
        storage_buf_read_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_read_data_read_data_6) = 1 or conv_integer(state_counter_read_data_read_data_6) = 1 or conv_integer(state_counter_read_data_read_data_6) = 3 or conv_integer(state_counter_read_data_read_data_6) = 3 or conv_integer(state_counter_read_data_read_data_6) = 5 or conv_integer(state_counter_read_data_read_data_6) = 5 or conv_integer(state_counter_read_data_read_data_6) = 7 or conv_integer(state_counter_read_data_read_data_6) = 7) then
        storage_buf_read_method_request_field_wdata_writer_strobe_state_counter_read_data_read_data_6 <= '1';
      else
        storage_buf_read_method_request_field_wdata_writer_strobe_state_counter_read_data_read_data_6 <= '0';
      end if;
    end if;
  end process;
  storage_buf_read_method_request_field_rdata <= storage_buf_read_method_request_field_wdata_reset when (reset = '1') else
        storage_buf_read_method_request_field_wdata_reset when (storage_buf_read_method_request_field_wdata_reset_strobe = '1') else
        storage_buf_read_method_request_field_wdata_writer_state_counter_read_data_read_data_6 when (storage_buf_read_method_request_field_wdata_writer_strobe_state_counter_read_data_read_data_6 = '1') else
        storage_buf_read_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_src_port_field_wdata <= udp_tx_src_port_field_wdata_reset;
      elsif (udp_tx_src_port_field_wdata_reset_strobe = '1') then
        udp_tx_src_port_field_wdata <= udp_tx_src_port_field_wdata_reset;
      elsif (udp_tx_src_port_field_wdata_writer_strobe_send_method_state = '1') then
        udp_tx_src_port_field_wdata <= udp_tx_src_port_field_wdata_writer_send_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_src_port_field_wdata_reset_strobe <= '1';
      else
        udp_tx_src_port_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(send_method_state) = 5) then
        udp_tx_src_port_field_wdata_writer_strobe_send_method_state <= '1';
      else
        udp_tx_src_port_field_wdata_writer_strobe_send_method_state <= '0';
      end if;
    end if;
  end process;
  udp_tx_src_port_field_rdata <= udp_tx_src_port_field_wdata_reset when (reset = '1') else
        udp_tx_src_port_field_wdata_reset when (udp_tx_src_port_field_wdata_reset_strobe = '1') else
        udp_tx_src_port_field_wdata_writer_send_method_state when (udp_tx_src_port_field_wdata_writer_strobe_send_method_state = '1') else
        udp_tx_src_port_field_wdata;
  
  storage_notify_method_busy_field_rdata <= storage_notify_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_start_field_wdata <= udp_tx_start_field_wdata_reset;
      elsif (udp_tx_start_field_wdata_reset_strobe = '1') then
        udp_tx_start_field_wdata <= udp_tx_start_field_wdata_reset;
      elsif (udp_tx_start_field_wdata_writer_strobe_send_method_state = '1') then
        udp_tx_start_field_wdata <= udp_tx_start_field_wdata_writer_send_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_start_field_wdata_reset_strobe <= '1';
      else
        udp_tx_start_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(send_method_state) = 9 or conv_integer(send_method_state) = 10) then
        udp_tx_start_field_wdata_writer_strobe_send_method_state <= '1';
      else
        udp_tx_start_field_wdata_writer_strobe_send_method_state <= '0';
      end if;
    end if;
  end process;
  udp_tx_start_field_rdata <= udp_tx_start_field_wdata_reset when (reset = '1') else
        udp_tx_start_field_wdata_reset when (udp_tx_start_field_wdata_reset_strobe = '1') else
        udp_tx_start_field_wdata_writer_send_method_state when (udp_tx_start_field_wdata_writer_strobe_send_method_state = '1') else
        udp_tx_start_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        src_ip_field_wdata <= src_ip_field_wdata_reset;
      elsif (src_ip_field_wdata_reset_strobe = '1') then
        src_ip_field_wdata <= src_ip_field_wdata_reset;
      elsif (src_ip_field_wdata_writer_strobe_recv_method_state = '1') then
        src_ip_field_wdata <= src_ip_field_wdata_writer_recv_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        src_ip_field_wdata_reset_strobe <= '1';
      else
        src_ip_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(recv_method_state) = 4) then
        src_ip_field_wdata_writer_strobe_recv_method_state <= '1';
      else
        src_ip_field_wdata_writer_strobe_recv_method_state <= '0';
      end if;
    end if;
  end process;
  src_ip_field_rdata <= src_ip_field_wdata_reset when (reset = '1') else
        src_ip_field_wdata_reset when (src_ip_field_wdata_reset_strobe = '1') else
        src_ip_field_wdata_writer_recv_method_state when (src_ip_field_wdata_writer_strobe_recv_method_state = '1') else
        src_ip_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_buf_write_method_request_field_wdata <= storage_buf_write_method_request_field_wdata_reset;
      elsif (storage_buf_write_method_request_field_wdata_reset_strobe = '1') then
        storage_buf_write_method_request_field_wdata <= storage_buf_write_method_request_field_wdata_reset;
      elsif (storage_buf_write_method_request_field_wdata_writer_strobe_state_counter_write_data_write_data_6 = '1') then
        storage_buf_write_method_request_field_wdata <= storage_buf_write_method_request_field_wdata_writer_state_counter_write_data_write_data_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_buf_write_method_request_field_wdata_reset_strobe <= '1';
      else
        storage_buf_write_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_write_data_write_data_6) = 3 or conv_integer(state_counter_write_data_write_data_6) = 3 or conv_integer(state_counter_write_data_write_data_6) = 4 or conv_integer(state_counter_write_data_write_data_6) = 4 or conv_integer(state_counter_write_data_write_data_6) = 5 or conv_integer(state_counter_write_data_write_data_6) = 5 or conv_integer(state_counter_write_data_write_data_6) = 6 or conv_integer(state_counter_write_data_write_data_6) = 6) then
        storage_buf_write_method_request_field_wdata_writer_strobe_state_counter_write_data_write_data_6 <= '1';
      else
        storage_buf_write_method_request_field_wdata_writer_strobe_state_counter_write_data_write_data_6 <= '0';
      end if;
    end if;
  end process;
  storage_buf_write_method_request_field_rdata <= storage_buf_write_method_request_field_wdata_reset when (reset = '1') else
        storage_buf_write_method_request_field_wdata_reset when (storage_buf_write_method_request_field_wdata_reset_strobe = '1') else
        storage_buf_write_method_request_field_wdata_writer_state_counter_write_data_write_data_6 when (storage_buf_write_method_request_field_wdata_writer_strobe_state_counter_write_data_write_data_6 = '1') else
        storage_buf_write_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        dest_port_field_wdata <= dest_port_field_wdata_reset;
      elsif (dest_port_field_wdata_reset_strobe = '1') then
        dest_port_field_wdata <= dest_port_field_wdata_reset;
      elsif (dest_port_field_wdata_writer_strobe_recv_method_state = '1') then
        dest_port_field_wdata <= dest_port_field_wdata_writer_recv_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        dest_port_field_wdata_reset_strobe <= '1';
      else
        dest_port_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(recv_method_state) = 4) then
        dest_port_field_wdata_writer_strobe_recv_method_state <= '1';
      else
        dest_port_field_wdata_writer_strobe_recv_method_state <= '0';
      end if;
    end if;
  end process;
  dest_port_field_rdata <= dest_port_field_wdata_reset when (reset = '1') else
        dest_port_field_wdata_reset when (dest_port_field_wdata_reset_strobe = '1') else
        dest_port_field_wdata_writer_recv_method_state when (dest_port_field_wdata_writer_strobe_recv_method_state = '1') else
        dest_port_field_wdata;
  
  udp_rx_data_rdata_field_rdata <= udp_rx_data_rdata_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_page_program_length_field_wdata <= storage_input_port_page_program_length_field_wdata_reset;
      elsif (storage_input_port_page_program_length_field_wdata_reset_strobe = '1') then
        storage_input_port_page_program_length_field_wdata <= storage_input_port_page_program_length_field_wdata_reset;
      elsif (storage_input_port_page_program_length_field_wdata_writer_strobe_write_data_method_state = '1') then
        storage_input_port_page_program_length_field_wdata <= storage_input_port_page_program_length_field_wdata_writer_write_data_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_page_program_length_field_wdata_reset_strobe <= '1';
      else
        storage_input_port_page_program_length_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(write_data_method_state) = 6) then
        storage_input_port_page_program_length_field_wdata_writer_strobe_write_data_method_state <= '1';
      else
        storage_input_port_page_program_length_field_wdata_writer_strobe_write_data_method_state <= '0';
      end if;
    end if;
  end process;
  storage_input_port_page_program_length_field_rdata <= storage_input_port_page_program_length_field_wdata_reset when (reset = '1') else
        storage_input_port_page_program_length_field_wdata_reset when (storage_input_port_page_program_length_field_wdata_reset_strobe = '1') else
        storage_input_port_page_program_length_field_wdata_writer_write_data_method_state when (storage_input_port_page_program_length_field_wdata_writer_strobe_write_data_method_state = '1') else
        storage_input_port_page_program_length_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_data_wdata_field_wdata <= udp_tx_data_wdata_field_wdata_reset;
      elsif (udp_tx_data_wdata_field_wdata_reset_strobe = '1') then
        udp_tx_data_wdata_field_wdata <= udp_tx_data_wdata_field_wdata_reset;
      elsif (udp_tx_data_wdata_field_wdata_writer_strobe_state_counter_send_send_2 = '1') then
        udp_tx_data_wdata_field_wdata <= udp_tx_data_wdata_field_wdata_writer_state_counter_send_send_2;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_data_wdata_field_wdata_reset_strobe <= '1';
      else
        udp_tx_data_wdata_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_send_send_2) = 2) then
        udp_tx_data_wdata_field_wdata_writer_strobe_state_counter_send_send_2 <= '1';
      else
        udp_tx_data_wdata_field_wdata_writer_strobe_state_counter_send_send_2 <= '0';
      end if;
    end if;
  end process;
  udp_tx_data_wdata_field_rdata <= udp_tx_data_wdata_field_wdata_reset when (reset = '1') else
        udp_tx_data_wdata_field_wdata_reset when (udp_tx_data_wdata_field_wdata_reset_strobe = '1') else
        udp_tx_data_wdata_field_wdata_writer_state_counter_send_send_2 when (udp_tx_data_wdata_field_wdata_writer_strobe_state_counter_send_send_2 = '1') else
        udp_tx_data_wdata_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        send_buf_waddr_field_wdata <= send_buf_waddr_field_wdata_reset;
      elsif (send_buf_waddr_field_wdata_reset_strobe = '1') then
        send_buf_waddr_field_wdata <= send_buf_waddr_field_wdata_reset;
      elsif (send_buf_waddr_field_wdata_writer_strobe_state_counter_read_data_read_data_6 = '1') then
        send_buf_waddr_field_wdata <= send_buf_waddr_field_wdata_writer_state_counter_read_data_read_data_6;
      elsif (send_buf_waddr_field_wdata_writer_strobe_state_counter_main_main_6 = '1') then
        send_buf_waddr_field_wdata <= send_buf_waddr_field_wdata_writer_state_counter_main_main_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        send_buf_waddr_field_wdata_reset_strobe <= '1';
      else
        send_buf_waddr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_read_data_read_data_6) = 9) then
        send_buf_waddr_field_wdata_writer_strobe_state_counter_read_data_read_data_6 <= '1';
      else
        send_buf_waddr_field_wdata_writer_strobe_state_counter_read_data_read_data_6 <= '0';
      end if;
      if (conv_integer(state_counter_main_main_6) = 6 or conv_integer(state_counter_main_main_6) = 12 or conv_integer(state_counter_main_main_6) = 16) then
        send_buf_waddr_field_wdata_writer_strobe_state_counter_main_main_6 <= '1';
      else
        send_buf_waddr_field_wdata_writer_strobe_state_counter_main_main_6 <= '0';
      end if;
    end if;
  end process;
  send_buf_waddr_field_rdata <= send_buf_waddr_field_wdata_reset when (reset = '1') else
        send_buf_waddr_field_wdata_reset when (send_buf_waddr_field_wdata_reset_strobe = '1') else
        send_buf_waddr_field_wdata_writer_state_counter_read_data_read_data_6 when (send_buf_waddr_field_wdata_writer_strobe_state_counter_read_data_read_data_6 = '1') else
        send_buf_waddr_field_wdata_writer_state_counter_main_main_6 when (send_buf_waddr_field_wdata_writer_strobe_state_counter_main_main_6 = '1') else
        send_buf_waddr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_rx_read_flag_field_wdata <= udp_rx_read_flag_field_wdata_reset;
      elsif (udp_rx_read_flag_field_wdata_reset_strobe = '1') then
        udp_rx_read_flag_field_wdata <= udp_rx_read_flag_field_wdata_reset;
      elsif (udp_rx_read_flag_field_wdata_writer_strobe_recv_method_state = '1') then
        udp_rx_read_flag_field_wdata <= udp_rx_read_flag_field_wdata_writer_recv_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_rx_read_flag_field_wdata_reset_strobe <= '1';
      else
        udp_rx_read_flag_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(recv_method_state) = 3 or conv_integer(recv_method_state) = 6) then
        udp_rx_read_flag_field_wdata_writer_strobe_recv_method_state <= '1';
      else
        udp_rx_read_flag_field_wdata_writer_strobe_recv_method_state <= '0';
      end if;
    end if;
  end process;
  udp_rx_read_flag_field_rdata <= udp_rx_read_flag_field_wdata_reset when (reset = '1') else
        udp_rx_read_flag_field_wdata_reset when (udp_rx_read_flag_field_wdata_reset_strobe = '1') else
        udp_rx_read_flag_field_wdata_writer_recv_method_state when (udp_rx_read_flag_field_wdata_writer_strobe_recv_method_state = '1') else
        udp_rx_read_flag_field_wdata;
  
  udp_rx_valid_field_rdata <= udp_rx_valid_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_write_data_addr_field_wdata <= this_input_port_write_data_addr_field_wdata_reset;
      elsif (this_input_port_write_data_addr_field_wdata_reset_strobe = '1') then
        this_input_port_write_data_addr_field_wdata <= this_input_port_write_data_addr_field_wdata_reset;
      elsif (this_input_port_write_data_addr_field_wdata_writer_strobe_state_counter_main_main_6 = '1') then
        this_input_port_write_data_addr_field_wdata <= this_input_port_write_data_addr_field_wdata_writer_state_counter_main_main_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_write_data_addr_field_wdata_reset_strobe <= '1';
      else
        this_input_port_write_data_addr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_6) = 4) then
        this_input_port_write_data_addr_field_wdata_writer_strobe_state_counter_main_main_6 <= '1';
      else
        this_input_port_write_data_addr_field_wdata_writer_strobe_state_counter_main_main_6 <= '0';
      end if;
    end if;
  end process;
  this_input_port_write_data_addr_field_rdata <= this_input_port_write_data_addr_field_wdata_reset when (reset = '1') else
        this_input_port_write_data_addr_field_wdata_reset when (this_input_port_write_data_addr_field_wdata_reset_strobe = '1') else
        this_input_port_write_data_addr_field_wdata_writer_state_counter_main_main_6 when (this_input_port_write_data_addr_field_wdata_writer_strobe_state_counter_main_main_6 = '1') else
        this_input_port_write_data_addr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_data_we_field_wdata <= udp_tx_data_we_field_wdata_reset;
      elsif (udp_tx_data_we_field_wdata_reset_strobe = '1') then
        udp_tx_data_we_field_wdata <= udp_tx_data_we_field_wdata_reset;
      elsif (udp_tx_data_we_field_wdata_writer_strobe_state_counter_send_send_2 = '1') then
        udp_tx_data_we_field_wdata <= udp_tx_data_we_field_wdata_writer_state_counter_send_send_2;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_data_we_field_wdata_reset_strobe <= '1';
      else
        udp_tx_data_we_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_send_send_2) = 2) then
        udp_tx_data_we_field_wdata_writer_strobe_state_counter_send_send_2 <= '1';
      else
        udp_tx_data_we_field_wdata_writer_strobe_state_counter_send_send_2 <= '0';
      end if;
    end if;
  end process;
  udp_tx_data_we_field_rdata <= udp_tx_data_we_field_wdata_reset when (reset = '1') else
        udp_tx_data_we_field_wdata_reset when (udp_tx_data_we_field_wdata_reset_strobe = '1') else
        udp_tx_data_we_field_wdata_writer_state_counter_send_send_2 when (udp_tx_data_we_field_wdata_writer_strobe_state_counter_send_send_2 = '1') else
        udp_tx_data_we_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        data_length_field_wdata <= data_length_field_wdata_reset;
      elsif (data_length_field_wdata_reset_strobe = '1') then
        data_length_field_wdata <= data_length_field_wdata_reset;
      elsif (data_length_field_wdata_writer_strobe_recv_method_state = '1') then
        data_length_field_wdata <= data_length_field_wdata_writer_recv_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        data_length_field_wdata_reset_strobe <= '1';
      else
        data_length_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(recv_method_state) = 4) then
        data_length_field_wdata_writer_strobe_recv_method_state <= '1';
      else
        data_length_field_wdata_writer_strobe_recv_method_state <= '0';
      end if;
    end if;
  end process;
  data_length_field_rdata <= data_length_field_wdata_reset when (reset = '1') else
        data_length_field_wdata_reset when (data_length_field_wdata_reset_strobe = '1') else
        data_length_field_wdata_writer_recv_method_state when (data_length_field_wdata_writer_strobe_recv_method_state = '1') else
        data_length_field_wdata;
  
  udp_rx_src_port_field_rdata <= udp_rx_src_port_field_wdata;
  
  recv_buf_rdata_field_rdata <= recv_buf_rdata_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_buf_read_index_field_wdata <= storage_input_port_buf_read_index_field_wdata_reset;
      elsif (storage_input_port_buf_read_index_field_wdata_reset_strobe = '1') then
        storage_input_port_buf_read_index_field_wdata <= storage_input_port_buf_read_index_field_wdata_reset;
      elsif (storage_input_port_buf_read_index_field_wdata_writer_strobe_state_counter_read_data_read_data_6 = '1') then
        storage_input_port_buf_read_index_field_wdata <= storage_input_port_buf_read_index_field_wdata_writer_state_counter_read_data_read_data_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_buf_read_index_field_wdata_reset_strobe <= '1';
      else
        storage_input_port_buf_read_index_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_read_data_read_data_6) = 1 or conv_integer(state_counter_read_data_read_data_6) = 3 or conv_integer(state_counter_read_data_read_data_6) = 5 or conv_integer(state_counter_read_data_read_data_6) = 7) then
        storage_input_port_buf_read_index_field_wdata_writer_strobe_state_counter_read_data_read_data_6 <= '1';
      else
        storage_input_port_buf_read_index_field_wdata_writer_strobe_state_counter_read_data_read_data_6 <= '0';
      end if;
    end if;
  end process;
  storage_input_port_buf_read_index_field_rdata <= storage_input_port_buf_read_index_field_wdata_reset when (reset = '1') else
        storage_input_port_buf_read_index_field_wdata_reset when (storage_input_port_buf_read_index_field_wdata_reset_strobe = '1') else
        storage_input_port_buf_read_index_field_wdata_writer_state_counter_read_data_read_data_6 when (storage_input_port_buf_read_index_field_wdata_writer_strobe_state_counter_read_data_read_data_6 = '1') else
        storage_input_port_buf_read_index_field_wdata;
  
  storage_sector_erase_method_busy_field_rdata <= storage_sector_erase_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_read_bytes_length_field_wdata <= storage_input_port_read_bytes_length_field_wdata_reset;
      elsif (storage_input_port_read_bytes_length_field_wdata_reset_strobe = '1') then
        storage_input_port_read_bytes_length_field_wdata <= storage_input_port_read_bytes_length_field_wdata_reset;
      elsif (storage_input_port_read_bytes_length_field_wdata_writer_strobe_read_data_method_state = '1') then
        storage_input_port_read_bytes_length_field_wdata <= storage_input_port_read_bytes_length_field_wdata_writer_read_data_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_read_bytes_length_field_wdata_reset_strobe <= '1';
      else
        storage_input_port_read_bytes_length_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(read_data_method_state) = 5) then
        storage_input_port_read_bytes_length_field_wdata_writer_strobe_read_data_method_state <= '1';
      else
        storage_input_port_read_bytes_length_field_wdata_writer_strobe_read_data_method_state <= '0';
      end if;
    end if;
  end process;
  storage_input_port_read_bytes_length_field_rdata <= storage_input_port_read_bytes_length_field_wdata_reset when (reset = '1') else
        storage_input_port_read_bytes_length_field_wdata_reset when (storage_input_port_read_bytes_length_field_wdata_reset_strobe = '1') else
        storage_input_port_read_bytes_length_field_wdata_writer_read_data_method_state when (storage_input_port_read_bytes_length_field_wdata_writer_strobe_read_data_method_state = '1') else
        storage_input_port_read_bytes_length_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_write_data_len_field_wdata <= this_input_port_write_data_len_field_wdata_reset;
      elsif (this_input_port_write_data_len_field_wdata_reset_strobe = '1') then
        this_input_port_write_data_len_field_wdata <= this_input_port_write_data_len_field_wdata_reset;
      elsif (this_input_port_write_data_len_field_wdata_writer_strobe_state_counter_main_main_6 = '1') then
        this_input_port_write_data_len_field_wdata <= this_input_port_write_data_len_field_wdata_writer_state_counter_main_main_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_write_data_len_field_wdata_reset_strobe <= '1';
      else
        this_input_port_write_data_len_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_6) = 4) then
        this_input_port_write_data_len_field_wdata_writer_strobe_state_counter_main_main_6 <= '1';
      else
        this_input_port_write_data_len_field_wdata_writer_strobe_state_counter_main_main_6 <= '0';
      end if;
    end if;
  end process;
  this_input_port_write_data_len_field_rdata <= this_input_port_write_data_len_field_wdata_reset when (reset = '1') else
        this_input_port_write_data_len_field_wdata_reset when (this_input_port_write_data_len_field_wdata_reset_strobe = '1') else
        this_input_port_write_data_len_field_wdata_writer_state_counter_main_main_6 when (this_input_port_write_data_len_field_wdata_writer_strobe_state_counter_main_main_6 = '1') else
        this_input_port_write_data_len_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        recv_buf_waddr_field_wdata <= recv_buf_waddr_field_wdata_reset;
      elsif (recv_buf_waddr_field_wdata_reset_strobe = '1') then
        recv_buf_waddr_field_wdata <= recv_buf_waddr_field_wdata_reset;
      elsif (recv_buf_waddr_field_wdata_writer_strobe_state_counter_recv_recv_3 = '1') then
        recv_buf_waddr_field_wdata <= recv_buf_waddr_field_wdata_writer_state_counter_recv_recv_3;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        recv_buf_waddr_field_wdata_reset_strobe <= '1';
      else
        recv_buf_waddr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_recv_recv_3) = 3) then
        recv_buf_waddr_field_wdata_writer_strobe_state_counter_recv_recv_3 <= '1';
      else
        recv_buf_waddr_field_wdata_writer_strobe_state_counter_recv_recv_3 <= '0';
      end if;
    end if;
  end process;
  recv_buf_waddr_field_rdata <= recv_buf_waddr_field_wdata_reset when (reset = '1') else
        recv_buf_waddr_field_wdata_reset when (recv_buf_waddr_field_wdata_reset_strobe = '1') else
        recv_buf_waddr_field_wdata_writer_state_counter_recv_recv_3 when (recv_buf_waddr_field_wdata_writer_strobe_state_counter_recv_recv_3 = '1') else
        recv_buf_waddr_field_wdata;
  
  udp_rx_dest_ip_field_rdata <= udp_rx_dest_ip_field_wdata;
  
  storage_buf_read_method_busy_field_rdata <= storage_buf_read_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_page_program_method_request_field_wdata <= storage_page_program_method_request_field_wdata_reset;
      elsif (storage_page_program_method_request_field_wdata_reset_strobe = '1') then
        storage_page_program_method_request_field_wdata <= storage_page_program_method_request_field_wdata_reset;
      elsif (storage_page_program_method_request_field_wdata_writer_strobe_write_data_method_state = '1') then
        storage_page_program_method_request_field_wdata <= storage_page_program_method_request_field_wdata_writer_write_data_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_page_program_method_request_field_wdata_reset_strobe <= '1';
      else
        storage_page_program_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(write_data_method_state) = 6 or conv_integer(write_data_method_state) = 6) then
        storage_page_program_method_request_field_wdata_writer_strobe_write_data_method_state <= '1';
      else
        storage_page_program_method_request_field_wdata_writer_strobe_write_data_method_state <= '0';
      end if;
    end if;
  end process;
  storage_page_program_method_request_field_rdata <= storage_page_program_method_request_field_wdata_reset when (reset = '1') else
        storage_page_program_method_request_field_wdata_reset when (storage_page_program_method_request_field_wdata_reset_strobe = '1') else
        storage_page_program_method_request_field_wdata_writer_write_data_method_state when (storage_page_program_method_request_field_wdata_writer_strobe_write_data_method_state = '1') else
        storage_page_program_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_read_bytes_addr_field_wdata <= storage_input_port_read_bytes_addr_field_wdata_reset;
      elsif (storage_input_port_read_bytes_addr_field_wdata_reset_strobe = '1') then
        storage_input_port_read_bytes_addr_field_wdata <= storage_input_port_read_bytes_addr_field_wdata_reset;
      elsif (storage_input_port_read_bytes_addr_field_wdata_writer_strobe_read_data_method_state = '1') then
        storage_input_port_read_bytes_addr_field_wdata <= storage_input_port_read_bytes_addr_field_wdata_writer_read_data_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_read_bytes_addr_field_wdata_reset_strobe <= '1';
      else
        storage_input_port_read_bytes_addr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(read_data_method_state) = 5) then
        storage_input_port_read_bytes_addr_field_wdata_writer_strobe_read_data_method_state <= '1';
      else
        storage_input_port_read_bytes_addr_field_wdata_writer_strobe_read_data_method_state <= '0';
      end if;
    end if;
  end process;
  storage_input_port_read_bytes_addr_field_rdata <= storage_input_port_read_bytes_addr_field_wdata_reset when (reset = '1') else
        storage_input_port_read_bytes_addr_field_wdata_reset when (storage_input_port_read_bytes_addr_field_wdata_reset_strobe = '1') else
        storage_input_port_read_bytes_addr_field_wdata_writer_read_data_method_state when (storage_input_port_read_bytes_addr_field_wdata_writer_strobe_read_data_method_state = '1') else
        storage_input_port_read_bytes_addr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        send_buf_we_field_wdata <= send_buf_we_field_wdata_reset;
      elsif (send_buf_we_field_wdata_reset_strobe = '1') then
        send_buf_we_field_wdata <= send_buf_we_field_wdata_reset;
      elsif (send_buf_we_field_wdata_writer_strobe_state_counter_read_data_read_data_6 = '1') then
        send_buf_we_field_wdata <= send_buf_we_field_wdata_writer_state_counter_read_data_read_data_6;
      elsif (send_buf_we_field_wdata_writer_strobe_state_counter_main_main_6 = '1') then
        send_buf_we_field_wdata <= send_buf_we_field_wdata_writer_state_counter_main_main_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        send_buf_we_field_wdata_reset_strobe <= '1';
      else
        send_buf_we_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_read_data_read_data_6) = 9) then
        send_buf_we_field_wdata_writer_strobe_state_counter_read_data_read_data_6 <= '1';
      else
        send_buf_we_field_wdata_writer_strobe_state_counter_read_data_read_data_6 <= '0';
      end if;
      if (conv_integer(state_counter_main_main_6) = 6 or conv_integer(state_counter_main_main_6) = 12 or conv_integer(state_counter_main_main_6) = 16) then
        send_buf_we_field_wdata_writer_strobe_state_counter_main_main_6 <= '1';
      else
        send_buf_we_field_wdata_writer_strobe_state_counter_main_main_6 <= '0';
      end if;
    end if;
  end process;
  send_buf_we_field_rdata <= send_buf_we_field_wdata_reset when (reset = '1') else
        send_buf_we_field_wdata_reset when (send_buf_we_field_wdata_reset_strobe = '1') else
        send_buf_we_field_wdata_writer_state_counter_read_data_read_data_6 when (send_buf_we_field_wdata_writer_strobe_state_counter_read_data_read_data_6 = '1') else
        send_buf_we_field_wdata_writer_state_counter_main_main_6 when (send_buf_we_field_wdata_writer_strobe_state_counter_main_main_6 = '1') else
        send_buf_we_field_wdata;
  
  udp_rx_data_length_field_rdata <= udp_rx_data_length_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_send_len_field_wdata <= this_input_port_send_len_field_wdata_reset;
      elsif (this_input_port_send_len_field_wdata_reset_strobe = '1') then
        this_input_port_send_len_field_wdata <= this_input_port_send_len_field_wdata_reset;
      elsif (this_input_port_send_len_field_wdata_writer_strobe_state_counter_main_main_2 = '1') then
        this_input_port_send_len_field_wdata <= this_input_port_send_len_field_wdata_writer_state_counter_main_main_2;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_send_len_field_wdata_reset_strobe <= '1';
      else
        this_input_port_send_len_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_2) = 9) then
        this_input_port_send_len_field_wdata_writer_strobe_state_counter_main_main_2 <= '1';
      else
        this_input_port_send_len_field_wdata_writer_strobe_state_counter_main_main_2 <= '0';
      end if;
    end if;
  end process;
  this_input_port_send_len_field_rdata <= this_input_port_send_len_field_wdata_reset when (reset = '1') else
        this_input_port_send_len_field_wdata_reset when (this_input_port_send_len_field_wdata_reset_strobe = '1') else
        this_input_port_send_len_field_wdata_writer_state_counter_main_main_2 when (this_input_port_send_len_field_wdata_writer_strobe_state_counter_main_main_2 = '1') else
        this_input_port_send_len_field_wdata;
  
  storage_output_port_buf_read_field_rdata <= storage_output_port_buf_read_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        send_buf_raddr_field_wdata <= send_buf_raddr_field_wdata_reset;
      elsif (send_buf_raddr_field_wdata_reset_strobe = '1') then
        send_buf_raddr_field_wdata <= send_buf_raddr_field_wdata_reset;
      elsif (send_buf_raddr_field_wdata_writer_strobe_state_counter_send_send_2 = '1') then
        send_buf_raddr_field_wdata <= send_buf_raddr_field_wdata_writer_state_counter_send_send_2;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        send_buf_raddr_field_wdata_reset_strobe <= '1';
      else
        send_buf_raddr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_send_send_2) = 1) then
        send_buf_raddr_field_wdata_writer_strobe_state_counter_send_send_2 <= '1';
      else
        send_buf_raddr_field_wdata_writer_strobe_state_counter_send_send_2 <= '0';
      end if;
    end if;
  end process;
  send_buf_raddr_field_rdata <= send_buf_raddr_field_wdata_reset when (reset = '1') else
        send_buf_raddr_field_wdata_reset when (send_buf_raddr_field_wdata_reset_strobe = '1') else
        send_buf_raddr_field_wdata_writer_state_counter_send_send_2 when (send_buf_raddr_field_wdata_writer_strobe_state_counter_send_send_2 = '1') else
        send_buf_raddr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_read_data_method_request_field_wdata <= this_read_data_method_request_field_wdata_reset;
      elsif (this_read_data_method_request_field_wdata_reset_strobe = '1') then
        this_read_data_method_request_field_wdata <= this_read_data_method_request_field_wdata_reset;
      elsif (this_read_data_method_request_field_wdata_writer_strobe_state_counter_main_main_6 = '1') then
        this_read_data_method_request_field_wdata <= this_read_data_method_request_field_wdata_writer_state_counter_main_main_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_read_data_method_request_field_wdata_reset_strobe <= '1';
      else
        this_read_data_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_6) = 1 or conv_integer(state_counter_main_main_6) = 1) then
        this_read_data_method_request_field_wdata_writer_strobe_state_counter_main_main_6 <= '1';
      else
        this_read_data_method_request_field_wdata_writer_strobe_state_counter_main_main_6 <= '0';
      end if;
    end if;
  end process;
  this_read_data_method_request_field_rdata <= this_read_data_method_request_field_wdata_reset when (reset = '1') else
        this_read_data_method_request_field_wdata_reset when (this_read_data_method_request_field_wdata_reset_strobe = '1') else
        this_read_data_method_request_field_wdata_writer_state_counter_main_main_6 when (this_read_data_method_request_field_wdata_writer_strobe_state_counter_main_main_6 = '1') else
        this_read_data_method_request_field_wdata;
  
  udp_rx_dest_port_field_rdata <= udp_rx_dest_port_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_rx_data_raddr_field_wdata <= udp_rx_data_raddr_field_wdata_reset;
      elsif (udp_rx_data_raddr_field_wdata_reset_strobe = '1') then
        udp_rx_data_raddr_field_wdata <= udp_rx_data_raddr_field_wdata_reset;
      elsif (udp_rx_data_raddr_field_wdata_writer_strobe_state_counter_recv_recv_3 = '1') then
        udp_rx_data_raddr_field_wdata <= udp_rx_data_raddr_field_wdata_writer_state_counter_recv_recv_3;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_rx_data_raddr_field_wdata_reset_strobe <= '1';
      else
        udp_rx_data_raddr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_recv_recv_3) = 1) then
        udp_rx_data_raddr_field_wdata_writer_strobe_state_counter_recv_recv_3 <= '1';
      else
        udp_rx_data_raddr_field_wdata_writer_strobe_state_counter_recv_recv_3 <= '0';
      end if;
    end if;
  end process;
  udp_rx_data_raddr_field_rdata <= udp_rx_data_raddr_field_wdata_reset when (reset = '1') else
        udp_rx_data_raddr_field_wdata_reset when (udp_rx_data_raddr_field_wdata_reset_strobe = '1') else
        udp_rx_data_raddr_field_wdata_writer_state_counter_recv_recv_3 when (udp_rx_data_raddr_field_wdata_writer_strobe_state_counter_recv_recv_3 = '1') else
        udp_rx_data_raddr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_data_waddr_field_wdata <= udp_tx_data_waddr_field_wdata_reset;
      elsif (udp_tx_data_waddr_field_wdata_reset_strobe = '1') then
        udp_tx_data_waddr_field_wdata <= udp_tx_data_waddr_field_wdata_reset;
      elsif (udp_tx_data_waddr_field_wdata_writer_strobe_state_counter_send_send_2 = '1') then
        udp_tx_data_waddr_field_wdata <= udp_tx_data_waddr_field_wdata_writer_state_counter_send_send_2;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_data_waddr_field_wdata_reset_strobe <= '1';
      else
        udp_tx_data_waddr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_send_send_2) = 2) then
        udp_tx_data_waddr_field_wdata_writer_strobe_state_counter_send_send_2 <= '1';
      else
        udp_tx_data_waddr_field_wdata_writer_strobe_state_counter_send_send_2 <= '0';
      end if;
    end if;
  end process;
  udp_tx_data_waddr_field_rdata <= udp_tx_data_waddr_field_wdata_reset when (reset = '1') else
        udp_tx_data_waddr_field_wdata_reset when (udp_tx_data_waddr_field_wdata_reset_strobe = '1') else
        udp_tx_data_waddr_field_wdata_writer_state_counter_send_send_2 when (udp_tx_data_waddr_field_wdata_writer_strobe_state_counter_send_send_2 = '1') else
        udp_tx_data_waddr_field_wdata;
  
  storage_page_program_method_busy_field_rdata <= storage_page_program_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_dest_port_field_wdata <= udp_tx_dest_port_field_wdata_reset;
      elsif (udp_tx_dest_port_field_wdata_reset_strobe = '1') then
        udp_tx_dest_port_field_wdata <= udp_tx_dest_port_field_wdata_reset;
      elsif (udp_tx_dest_port_field_wdata_writer_strobe_send_method_state = '1') then
        udp_tx_dest_port_field_wdata <= udp_tx_dest_port_field_wdata_writer_send_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_dest_port_field_wdata_reset_strobe <= '1';
      else
        udp_tx_dest_port_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(send_method_state) = 3) then
        udp_tx_dest_port_field_wdata_writer_strobe_send_method_state <= '1';
      else
        udp_tx_dest_port_field_wdata_writer_strobe_send_method_state <= '0';
      end if;
    end if;
  end process;
  udp_tx_dest_port_field_rdata <= udp_tx_dest_port_field_wdata_reset when (reset = '1') else
        udp_tx_dest_port_field_wdata_reset when (udp_tx_dest_port_field_wdata_reset_strobe = '1') else
        udp_tx_dest_port_field_wdata_writer_send_method_state when (udp_tx_dest_port_field_wdata_writer_strobe_send_method_state = '1') else
        udp_tx_dest_port_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_sector_erase_addr_field_wdata <= storage_input_port_sector_erase_addr_field_wdata_reset;
      elsif (storage_input_port_sector_erase_addr_field_wdata_reset_strobe = '1') then
        storage_input_port_sector_erase_addr_field_wdata <= storage_input_port_sector_erase_addr_field_wdata_reset;
      elsif (storage_input_port_sector_erase_addr_field_wdata_writer_strobe_state_counter_main_main_6 = '1') then
        storage_input_port_sector_erase_addr_field_wdata <= storage_input_port_sector_erase_addr_field_wdata_writer_state_counter_main_main_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_sector_erase_addr_field_wdata_reset_strobe <= '1';
      else
        storage_input_port_sector_erase_addr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_6) = 10) then
        storage_input_port_sector_erase_addr_field_wdata_writer_strobe_state_counter_main_main_6 <= '1';
      else
        storage_input_port_sector_erase_addr_field_wdata_writer_strobe_state_counter_main_main_6 <= '0';
      end if;
    end if;
  end process;
  storage_input_port_sector_erase_addr_field_rdata <= storage_input_port_sector_erase_addr_field_wdata_reset when (reset = '1') else
        storage_input_port_sector_erase_addr_field_wdata_reset when (storage_input_port_sector_erase_addr_field_wdata_reset_strobe = '1') else
        storage_input_port_sector_erase_addr_field_wdata_writer_state_counter_main_main_6 when (storage_input_port_sector_erase_addr_field_wdata_writer_strobe_state_counter_main_main_6 = '1') else
        storage_input_port_sector_erase_addr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_read_bytes_method_request_field_wdata <= storage_read_bytes_method_request_field_wdata_reset;
      elsif (storage_read_bytes_method_request_field_wdata_reset_strobe = '1') then
        storage_read_bytes_method_request_field_wdata <= storage_read_bytes_method_request_field_wdata_reset;
      elsif (storage_read_bytes_method_request_field_wdata_writer_strobe_read_data_method_state = '1') then
        storage_read_bytes_method_request_field_wdata <= storage_read_bytes_method_request_field_wdata_writer_read_data_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_read_bytes_method_request_field_wdata_reset_strobe <= '1';
      else
        storage_read_bytes_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(read_data_method_state) = 5 or conv_integer(read_data_method_state) = 5) then
        storage_read_bytes_method_request_field_wdata_writer_strobe_read_data_method_state <= '1';
      else
        storage_read_bytes_method_request_field_wdata_writer_strobe_read_data_method_state <= '0';
      end if;
    end if;
  end process;
  storage_read_bytes_method_request_field_rdata <= storage_read_bytes_method_request_field_wdata_reset when (reset = '1') else
        storage_read_bytes_method_request_field_wdata_reset when (storage_read_bytes_method_request_field_wdata_reset_strobe = '1') else
        storage_read_bytes_method_request_field_wdata_writer_read_data_method_state when (storage_read_bytes_method_request_field_wdata_writer_strobe_read_data_method_state = '1') else
        storage_read_bytes_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        send_buf_wdata_field_wdata <= send_buf_wdata_field_wdata_reset;
      elsif (send_buf_wdata_field_wdata_reset_strobe = '1') then
        send_buf_wdata_field_wdata <= send_buf_wdata_field_wdata_reset;
      elsif (send_buf_wdata_field_wdata_writer_strobe_state_counter_main_main_6 = '1') then
        send_buf_wdata_field_wdata <= send_buf_wdata_field_wdata_writer_state_counter_main_main_6;
      elsif (send_buf_wdata_field_wdata_writer_strobe_state_counter_read_data_read_data_6 = '1') then
        send_buf_wdata_field_wdata <= send_buf_wdata_field_wdata_writer_state_counter_read_data_read_data_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        send_buf_wdata_field_wdata_reset_strobe <= '1';
      else
        send_buf_wdata_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_6) = 6 or conv_integer(state_counter_main_main_6) = 12 or conv_integer(state_counter_main_main_6) = 16) then
        send_buf_wdata_field_wdata_writer_strobe_state_counter_main_main_6 <= '1';
      else
        send_buf_wdata_field_wdata_writer_strobe_state_counter_main_main_6 <= '0';
      end if;
      if (conv_integer(state_counter_read_data_read_data_6) = 9) then
        send_buf_wdata_field_wdata_writer_strobe_state_counter_read_data_read_data_6 <= '1';
      else
        send_buf_wdata_field_wdata_writer_strobe_state_counter_read_data_read_data_6 <= '0';
      end if;
    end if;
  end process;
  send_buf_wdata_field_rdata <= send_buf_wdata_field_wdata_reset when (reset = '1') else
        send_buf_wdata_field_wdata_reset when (send_buf_wdata_field_wdata_reset_strobe = '1') else
        send_buf_wdata_field_wdata_writer_state_counter_main_main_6 when (send_buf_wdata_field_wdata_writer_strobe_state_counter_main_main_6 = '1') else
        send_buf_wdata_field_wdata_writer_state_counter_read_data_read_data_6 when (send_buf_wdata_field_wdata_writer_strobe_state_counter_read_data_read_data_6 = '1') else
        send_buf_wdata_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        recv_buf_raddr_field_wdata <= recv_buf_raddr_field_wdata_reset;
      elsif (recv_buf_raddr_field_wdata_reset_strobe = '1') then
        recv_buf_raddr_field_wdata <= recv_buf_raddr_field_wdata_reset;
      elsif (recv_buf_raddr_field_wdata_writer_strobe_state_counter_write_data_write_data_6 = '1') then
        recv_buf_raddr_field_wdata <= recv_buf_raddr_field_wdata_writer_state_counter_write_data_write_data_6;
      elsif (recv_buf_raddr_field_wdata_writer_strobe_state_counter_main_main_2 = '1') then
        recv_buf_raddr_field_wdata <= recv_buf_raddr_field_wdata_writer_state_counter_main_main_2;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        recv_buf_raddr_field_wdata_reset_strobe <= '1';
      else
        recv_buf_raddr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_write_data_write_data_6) = 1) then
        recv_buf_raddr_field_wdata_writer_strobe_state_counter_write_data_write_data_6 <= '1';
      else
        recv_buf_raddr_field_wdata_writer_strobe_state_counter_write_data_write_data_6 <= '0';
      end if;
      if (conv_integer(state_counter_main_main_2) = 2 or conv_integer(state_counter_main_main_2) = 4 or conv_integer(state_counter_main_main_2) = 6) then
        recv_buf_raddr_field_wdata_writer_strobe_state_counter_main_main_2 <= '1';
      else
        recv_buf_raddr_field_wdata_writer_strobe_state_counter_main_main_2 <= '0';
      end if;
    end if;
  end process;
  recv_buf_raddr_field_rdata <= recv_buf_raddr_field_wdata_reset when (reset = '1') else
        recv_buf_raddr_field_wdata_reset when (recv_buf_raddr_field_wdata_reset_strobe = '1') else
        recv_buf_raddr_field_wdata_writer_state_counter_write_data_write_data_6 when (recv_buf_raddr_field_wdata_writer_strobe_state_counter_write_data_write_data_6 = '1') else
        recv_buf_raddr_field_wdata_writer_state_counter_main_main_2 when (recv_buf_raddr_field_wdata_writer_strobe_state_counter_main_main_2 = '1') else
        recv_buf_raddr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_src_ip_field_wdata <= udp_tx_src_ip_field_wdata_reset;
      elsif (udp_tx_src_ip_field_wdata_reset_strobe = '1') then
        udp_tx_src_ip_field_wdata <= udp_tx_src_ip_field_wdata_reset;
      elsif (udp_tx_src_ip_field_wdata_writer_strobe_send_method_state = '1') then
        udp_tx_src_ip_field_wdata <= udp_tx_src_ip_field_wdata_writer_send_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_src_ip_field_wdata_reset_strobe <= '1';
      else
        udp_tx_src_ip_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(send_method_state) = 4) then
        udp_tx_src_ip_field_wdata_writer_strobe_send_method_state <= '1';
      else
        udp_tx_src_ip_field_wdata_writer_strobe_send_method_state <= '0';
      end if;
    end if;
  end process;
  udp_tx_src_ip_field_rdata <= udp_tx_src_ip_field_wdata_reset when (reset = '1') else
        udp_tx_src_ip_field_wdata_reset when (udp_tx_src_ip_field_wdata_reset_strobe = '1') else
        udp_tx_src_ip_field_wdata_writer_send_method_state when (udp_tx_src_ip_field_wdata_writer_strobe_send_method_state = '1') else
        udp_tx_src_ip_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        recv_buf_we_field_wdata <= recv_buf_we_field_wdata_reset;
      elsif (recv_buf_we_field_wdata_reset_strobe = '1') then
        recv_buf_we_field_wdata <= recv_buf_we_field_wdata_reset;
      elsif (recv_buf_we_field_wdata_writer_strobe_state_counter_recv_recv_3 = '1') then
        recv_buf_we_field_wdata <= recv_buf_we_field_wdata_writer_state_counter_recv_recv_3;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        recv_buf_we_field_wdata_reset_strobe <= '1';
      else
        recv_buf_we_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_recv_recv_3) = 3) then
        recv_buf_we_field_wdata_writer_strobe_state_counter_recv_recv_3 <= '1';
      else
        recv_buf_we_field_wdata_writer_strobe_state_counter_recv_recv_3 <= '0';
      end if;
    end if;
  end process;
  recv_buf_we_field_rdata <= recv_buf_we_field_wdata_reset when (reset = '1') else
        recv_buf_we_field_wdata_reset when (recv_buf_we_field_wdata_reset_strobe = '1') else
        recv_buf_we_field_wdata_writer_state_counter_recv_recv_3 when (recv_buf_we_field_wdata_writer_strobe_state_counter_recv_recv_3 = '1') else
        recv_buf_we_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_read_data_addr_field_wdata <= this_input_port_read_data_addr_field_wdata_reset;
      elsif (this_input_port_read_data_addr_field_wdata_reset_strobe = '1') then
        this_input_port_read_data_addr_field_wdata <= this_input_port_read_data_addr_field_wdata_reset;
      elsif (this_input_port_read_data_addr_field_wdata_writer_strobe_state_counter_main_main_6 = '1') then
        this_input_port_read_data_addr_field_wdata <= this_input_port_read_data_addr_field_wdata_writer_state_counter_main_main_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_read_data_addr_field_wdata_reset_strobe <= '1';
      else
        this_input_port_read_data_addr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_main_main_6) = 1) then
        this_input_port_read_data_addr_field_wdata_writer_strobe_state_counter_main_main_6 <= '1';
      else
        this_input_port_read_data_addr_field_wdata_writer_strobe_state_counter_main_main_6 <= '0';
      end if;
    end if;
  end process;
  this_input_port_read_data_addr_field_rdata <= this_input_port_read_data_addr_field_wdata_reset when (reset = '1') else
        this_input_port_read_data_addr_field_wdata_reset when (this_input_port_read_data_addr_field_wdata_reset_strobe = '1') else
        this_input_port_read_data_addr_field_wdata_writer_state_counter_main_main_6 when (this_input_port_read_data_addr_field_wdata_writer_strobe_state_counter_main_main_6 = '1') else
        this_input_port_read_data_addr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_page_program_addr_field_wdata <= storage_input_port_page_program_addr_field_wdata_reset;
      elsif (storage_input_port_page_program_addr_field_wdata_reset_strobe = '1') then
        storage_input_port_page_program_addr_field_wdata <= storage_input_port_page_program_addr_field_wdata_reset;
      elsif (storage_input_port_page_program_addr_field_wdata_writer_strobe_write_data_method_state = '1') then
        storage_input_port_page_program_addr_field_wdata <= storage_input_port_page_program_addr_field_wdata_writer_write_data_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_input_port_page_program_addr_field_wdata_reset_strobe <= '1';
      else
        storage_input_port_page_program_addr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(write_data_method_state) = 6) then
        storage_input_port_page_program_addr_field_wdata_writer_strobe_write_data_method_state <= '1';
      else
        storage_input_port_page_program_addr_field_wdata_writer_strobe_write_data_method_state <= '0';
      end if;
    end if;
  end process;
  storage_input_port_page_program_addr_field_rdata <= storage_input_port_page_program_addr_field_wdata_reset when (reset = '1') else
        storage_input_port_page_program_addr_field_wdata_reset when (storage_input_port_page_program_addr_field_wdata_reset_strobe = '1') else
        storage_input_port_page_program_addr_field_wdata_writer_write_data_method_state when (storage_input_port_page_program_addr_field_wdata_writer_strobe_write_data_method_state = '1') else
        storage_input_port_page_program_addr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_notify_method_request_field_wdata <= storage_notify_method_request_field_wdata_reset;
      elsif (storage_notify_method_request_field_wdata_reset_strobe = '1') then
        storage_notify_method_request_field_wdata <= storage_notify_method_request_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        storage_notify_method_request_field_wdata_reset_strobe <= '1';
      else
        storage_notify_method_request_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  storage_notify_method_request_field_rdata <= storage_notify_method_request_field_wdata_reset when (reset = '1') else
        storage_notify_method_request_field_wdata_reset when (storage_notify_method_request_field_wdata_reset_strobe = '1') else
        storage_notify_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_dest_ip_field_wdata <= udp_tx_dest_ip_field_wdata_reset;
      elsif (udp_tx_dest_ip_field_wdata_reset_strobe = '1') then
        udp_tx_dest_ip_field_wdata <= udp_tx_dest_ip_field_wdata_reset;
      elsif (udp_tx_dest_ip_field_wdata_writer_strobe_send_method_state = '1') then
        udp_tx_dest_ip_field_wdata <= udp_tx_dest_ip_field_wdata_writer_send_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        udp_tx_dest_ip_field_wdata_reset_strobe <= '1';
      else
        udp_tx_dest_ip_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(send_method_state) = 2) then
        udp_tx_dest_ip_field_wdata_writer_strobe_send_method_state <= '1';
      else
        udp_tx_dest_ip_field_wdata_writer_strobe_send_method_state <= '0';
      end if;
    end if;
  end process;
  udp_tx_dest_ip_field_rdata <= udp_tx_dest_ip_field_wdata_reset when (reset = '1') else
        udp_tx_dest_ip_field_wdata_reset when (udp_tx_dest_ip_field_wdata_reset_strobe = '1') else
        udp_tx_dest_ip_field_wdata_writer_send_method_state when (udp_tx_dest_ip_field_wdata_writer_strobe_send_method_state = '1') else
        udp_tx_dest_ip_field_wdata;
  process(clk) --main
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_main_main_0 <= (others => '0');
        state_counter_main_main_1 <= (others => '0');
        state_counter_main_main_2 <= (others => '0');
        this_recv_call_state_counter_main_2 <= (others => '0');
        this_recv_call_state_counter_main_2 <= (others => '0');
        command_main_2 <= (others => '0');
        array_index_operation_state_counter_main_3 <= (others => '0');
        addr_main_2 <= (others => '0');
        array_index_operation_state_counter_main_4 <= (others => '0');
        len_main_2 <= (others => '0');
        array_index_operation_state_counter_main_5 <= (others => '0');
        state_counter_main_main_6 <= (others => '0');
        main_cond_expr_main_7_main_2 <= (others => '0');
        this_read_data_call_state_counter_main_6 <= (others => '0');
        this_read_data_call_state_counter_main_6 <= (others => '0');
        this_write_data_call_state_counter_main_6 <= (others => '0');
        this_write_data_call_state_counter_main_6 <= (others => '0');
        array_index_operation_state_counter_main_8 <= (others => '0');
        storage_sector_erase_call_state_counter_main_6 <= (others => '0');
        storage_sector_erase_call_state_counter_main_6 <= (others => '0');
        array_index_operation_state_counter_main_9 <= (others => '0');
        array_index_operation_state_counter_main_10 <= (others => '0');
        this_send_call_state_counter_main_2 <= (others => '0');
        this_send_call_state_counter_main_2 <= (others => '0');
        main_method_state <= (others => '0');
        this_recv_method_request_field_wdata_reset <= '0';
        this_read_data_method_request_field_wdata_reset <= '0';
        this_write_data_method_request_field_wdata_reset <= '0';
        send_buf_wdata_field_wdata_reset <= (others => '0');
        storage_sector_erase_method_request_field_wdata_reset <= '0';
        this_send_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(main_method_state) is
          when 0 => 
            case conv_integer(state_counter_main_main_1) is
              when 0 => state_counter_main_main_1 <= state_counter_main_main_1 + 1;
              when 1 =>
                if (true) then
                  state_counter_main_main_1 <= state_counter_main_main_1 + 1;
                  state_counter_main_main_2 <= conv_std_logic_vector(1, state_counter_main_main_2'length);
                else
                  main_method_state <= main_method_state + 1;
                  state_counter_main_main_1 <= (others => '0');
                end if;
              when 2 =>
                case conv_integer(state_counter_main_main_2) is
                  when 0 => state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                  when 1 =>
                    case conv_integer(this_recv_call_state_counter_main_2) is
                      when 0 =>
                        if (this_recv_method_busy = '0') then
                          this_recv_method_request_field_wdata_writer_state_counter_main_main_2 <= '1';
                          this_recv_call_state_counter_main_2 <= this_recv_call_state_counter_main_2 + 1;
                        end if;
                      when 1 =>
                        this_recv_method_request_field_wdata_writer_state_counter_main_main_2 <= '0';
                        this_recv_call_state_counter_main_2 <= this_recv_call_state_counter_main_2 + 1;
                      when 2 =>
                        if (this_recv_method_request_field_wdata = '0' and this_recv_method_busy = '0') then
                          this_recv_call_state_counter_main_2 <= (others => '0');
                          state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                        end if;
                      when others => this_recv_call_state_counter_main_2 <= (others => '0');
                    end case;
                  when 2 =>
                    case conv_integer(array_index_operation_state_counter_main_3) is
                      when 0 =>
                        recv_buf_raddr_field_wdata_writer_state_counter_main_main_2 <= conv_std_logic_vector(0, recv_buf_raddr_field_wdata'length);
                        array_index_operation_state_counter_main_3 <= array_index_operation_state_counter_main_3 + 1;
                      when 1 =>
                        array_index_operation_state_counter_main_3 <= (others => '0');
                        state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                      when others => array_index_operation_state_counter_main_3 <= (others => '0');
                    end case;
                  when 3 =>
                    command_main_2 <= conv_std_logic_vector(conv_integer(recv_buf_rdata_field_rdata), command_main_2'length);
                    state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                  when 4 =>
                    case conv_integer(array_index_operation_state_counter_main_4) is
                      when 0 =>
                        recv_buf_raddr_field_wdata_writer_state_counter_main_main_2 <= conv_std_logic_vector(1, recv_buf_raddr_field_wdata'length);
                        array_index_operation_state_counter_main_4 <= array_index_operation_state_counter_main_4 + 1;
                      when 1 =>
                        array_index_operation_state_counter_main_4 <= (others => '0');
                        state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                      when others => array_index_operation_state_counter_main_4 <= (others => '0');
                    end case;
                  when 5 =>
                    addr_main_2 <= conv_std_logic_vector(conv_integer(recv_buf_rdata_field_rdata), addr_main_2'length);
                    state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                  when 6 =>
                    case conv_integer(array_index_operation_state_counter_main_5) is
                      when 0 =>
                        recv_buf_raddr_field_wdata_writer_state_counter_main_main_2 <= conv_std_logic_vector(2, recv_buf_raddr_field_wdata'length);
                        array_index_operation_state_counter_main_5 <= array_index_operation_state_counter_main_5 + 1;
                      when 1 =>
                        array_index_operation_state_counter_main_5 <= (others => '0');
                        state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                      when others => array_index_operation_state_counter_main_5 <= (others => '0');
                    end case;
                  when 7 =>
                    len_main_2 <= conv_std_logic_vector(conv_integer(recv_buf_rdata_field_rdata), len_main_2'length);
                    state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                  when 8 =>
                    case conv_integer(state_counter_main_main_6) is
                      when 0 =>
                        if (command_main_2 = COMMAND_READ) then
                          state_counter_main_main_6 <= conv_std_logic_vector(1, state_counter_main_main_6'length);
                        elsif (command_main_2 = COMMAND_WRITE) then
                          state_counter_main_main_6 <= conv_std_logic_vector(4, state_counter_main_main_6'length);
                        elsif (command_main_2 = COMMAND_ERASE) then
                          state_counter_main_main_6 <= conv_std_logic_vector(10, state_counter_main_main_6'length);
                        else
                          state_counter_main_main_6 <= conv_std_logic_vector(16, state_counter_main_main_6'length);
                        end if;
                      when 1 =>
                        case conv_integer(this_read_data_call_state_counter_main_6) is
                          when 0 =>
                            if (this_read_data_method_busy = '0') then
                              this_read_data_method_request_field_wdata_writer_state_counter_main_main_6 <= '1';
                              this_read_data_call_state_counter_main_6 <= this_read_data_call_state_counter_main_6 + 1;
                            end if;
                          when 1 =>
                            this_input_port_read_data_addr_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(conv_integer(addr_main_2), this_input_port_read_data_addr_field_wdata'length);
                            this_input_port_read_data_len_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(conv_integer(len_main_2), this_input_port_read_data_len_field_wdata'length);
                            this_read_data_method_request_field_wdata_writer_state_counter_main_main_6 <= '0';
                            this_read_data_call_state_counter_main_6 <= this_read_data_call_state_counter_main_6 + 1;
                          when 2 =>
                            if (this_read_data_method_request_field_wdata = '0' and this_read_data_method_busy = '0') then
                              this_read_data_call_state_counter_main_6 <= (others => '0');
                              state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                            end if;
                          when others => this_read_data_call_state_counter_main_6 <= (others => '0');
                        end case;
                      when 2 =>
                        len_main_2 <= conv_std_logic_vector(conv_integer(this_output_port_read_data), len_main_2'length);
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                      when 3 =>
                        state_counter_main_main_6 <= (others => '0');
                        state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                      when 4 =>
                        case conv_integer(this_write_data_call_state_counter_main_6) is
                          when 0 =>
                            if (this_write_data_method_busy = '0') then
                              this_write_data_method_request_field_wdata_writer_state_counter_main_main_6 <= '1';
                              this_write_data_call_state_counter_main_6 <= this_write_data_call_state_counter_main_6 + 1;
                            end if;
                          when 1 =>
                            this_input_port_write_data_addr_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(conv_integer(addr_main_2), this_input_port_write_data_addr_field_wdata'length);
                            this_input_port_write_data_len_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(conv_integer(len_main_2), this_input_port_write_data_len_field_wdata'length);
                            this_write_data_method_request_field_wdata_writer_state_counter_main_main_6 <= '0';
                            this_write_data_call_state_counter_main_6 <= this_write_data_call_state_counter_main_6 + 1;
                          when 2 =>
                            if (this_write_data_method_request_field_wdata = '0' and this_write_data_method_busy = '0') then
                              this_write_data_call_state_counter_main_6 <= (others => '0');
                              state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                            end if;
                          when others => this_write_data_call_state_counter_main_6 <= (others => '0');
                        end case;
                      when 5 =>
                        len_main_2 <= conv_std_logic_vector(conv_integer(this_output_port_write_data), len_main_2'length);
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                      when 6 =>
                        send_buf_waddr_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(0, send_buf_waddr_field_wdata'length);
                        send_buf_we_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(1, send_buf_we_field_wdata'length);
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                        send_buf_wdata_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(conv_integer(len_main_2), send_buf_wdata_field_wdata'length);
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                      when 7 =>
                        len_main_2 <= conv_std_logic_vector(1, len_main_2'length);
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                      when 8 =>
                        state_counter_main_main_6 <= (others => '0');
                        state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                      when 10 =>
                        case conv_integer(storage_sector_erase_call_state_counter_main_6) is
                          when 0 =>
                            if (storage_sector_erase_method_busy_field_wdata = '0') then
                              storage_sector_erase_method_request_field_wdata_writer_state_counter_main_main_6 <= '1';
                              storage_sector_erase_call_state_counter_main_6 <= storage_sector_erase_call_state_counter_main_6 + 1;
                            end if;
                          when 1 =>
                            storage_input_port_sector_erase_addr_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(conv_integer(addr_main_2), storage_input_port_sector_erase_addr_field_wdata'length);
                            storage_sector_erase_method_request_field_wdata_writer_state_counter_main_main_6 <= '0';
                            storage_sector_erase_call_state_counter_main_6 <= storage_sector_erase_call_state_counter_main_6 + 1;
                          when 2 =>
                            if (storage_sector_erase_method_request_field_wdata = '0' and storage_sector_erase_method_busy_field_wdata = '0') then
                              storage_sector_erase_call_state_counter_main_6 <= (others => '0');
                              state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                            end if;
                          when others => storage_sector_erase_call_state_counter_main_6 <= (others => '0');
                        end case;
                      when 11 =>
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                      when 12 =>
                        send_buf_waddr_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(0, send_buf_waddr_field_wdata'length);
                        send_buf_we_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(1, send_buf_we_field_wdata'length);
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                        send_buf_wdata_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(1, send_buf_wdata_field_wdata'length);
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                      when 13 =>
                        len_main_2 <= conv_std_logic_vector(1, len_main_2'length);
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                      when 14 =>
                        state_counter_main_main_6 <= (others => '0');
                        state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                      when 16 =>
                        send_buf_waddr_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(0, send_buf_waddr_field_wdata'length);
                        send_buf_we_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(1, send_buf_we_field_wdata'length);
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                        send_buf_wdata_field_wdata_writer_state_counter_main_main_6 <= conv_std_logic_vector(-1, send_buf_wdata_field_wdata'length);
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                      when 17 =>
                        len_main_2 <= conv_std_logic_vector(1, len_main_2'length);
                        state_counter_main_main_6 <= state_counter_main_main_6 + 1;
                      when 18 =>
                        state_counter_main_main_6 <= (others => '0');
                        state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                      when others =>
                        state_counter_main_main_6 <= (others => '0');
                        state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                    end case;
                  when 9 =>
                    case conv_integer(this_send_call_state_counter_main_2) is
                      when 0 =>
                        if (this_send_method_busy = '0') then
                          this_send_method_request_field_wdata_writer_state_counter_main_main_2 <= '1';
                          this_send_call_state_counter_main_2 <= this_send_call_state_counter_main_2 + 1;
                        end if;
                      when 1 =>
                        this_input_port_send_len_field_wdata_writer_state_counter_main_main_2 <= conv_std_logic_vector(conv_integer(len_main_2), this_input_port_send_len_field_wdata'length);
                        this_send_method_request_field_wdata_writer_state_counter_main_main_2 <= '0';
                        this_send_call_state_counter_main_2 <= this_send_call_state_counter_main_2 + 1;
                      when 2 =>
                        if (this_send_method_request_field_wdata = '0' and this_send_method_busy = '0') then
                          this_send_call_state_counter_main_2 <= (others => '0');
                          state_counter_main_main_2 <= state_counter_main_main_2 + 1;
                        end if;
                      when others => this_send_call_state_counter_main_2 <= (others => '0');
                    end case;
                  when 10 =>
                    state_counter_main_main_1 <= state_counter_main_main_1 + 1;
                    state_counter_main_main_2 <= (others => '0');
                  when others => state_counter_main_main_2 <= (others => '0');
                end case;
              when 3 =>
                state_counter_main_main_1 <= (others => '0');
              when others => state_counter_main_main_1 <= (others => '0');
            end case;
          when 1 =>
            null;
          when others => main_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --main
  process(clk) --write_data
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_write_data_write_data_0 <= (others => '0');
        l_write_data_0 <= (others => '0');
        state_counter_write_data_write_data_1 <= (others => '0');
        write_data_if_flag_write_data_2_write_data_0 <= '0';
        state_counter_write_data_write_data_3 <= (others => '0');
        write_data_if_flag_write_data_4_write_data_0 <= '0';
        state_counter_write_data_write_data_5 <= (others => '0');
        i_write_data_5 <= (others => '0');
        state_counter_write_data_write_data_6 <= (others => '0');
        v_write_data_6 <= (others => '0');
        array_index_operation_state_counter_write_data_7 <= (others => '0');
        storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
        storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
        storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
        storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
        storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
        storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
        storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
        storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
        storage_page_program_call_state_counter_write_data_0 <= (others => '0');
        storage_page_program_call_state_counter_write_data_0 <= (others => '0');
        this_write_data_method_busy <= '0';
        write_data_method_state <= (others => '0');
        storage_buf_write_method_request_field_wdata_reset <= '0';
        storage_buf_write_method_request_field_wdata_reset <= '0';
        storage_buf_write_method_request_field_wdata_reset <= '0';
        storage_buf_write_method_request_field_wdata_reset <= '0';
        storage_page_program_method_request_field_wdata_reset <= '0';
        this_output_port_write_data <= (others => '0');
      else
        case conv_integer(write_data_method_state) is
          when 0 =>
            if(this_write_data_method_request_field_rdata = '1') then
              this_write_data_method_busy <= '1';
              write_data_method_state <= write_data_method_state + 1;
            else
              this_write_data_method_busy <= '0';
            end if;
          when 1 =>
            if(this_write_data_method_request_field_rdata = '0') then
              write_data_method_state <= write_data_method_state + 1;
            end if;
          when 2 => 
            l_write_data_0 <= conv_std_logic_vector(conv_integer(this_input_port_write_data_len_field_rdata), l_write_data_0'length);
            write_data_method_state <= write_data_method_state + 1;
          when 3 => 
            case conv_integer(state_counter_write_data_write_data_1) is
              when 0 => state_counter_write_data_write_data_1 <= state_counter_write_data_write_data_1 + 1;
              when 1 =>
                if (conv_integer(l_write_data_0) > 256) then
                  write_data_if_flag_write_data_2_write_data_0 <= '1';
                else
                  write_data_if_flag_write_data_2_write_data_0 <= '0';
                end if;
                state_counter_write_data_write_data_1 <= state_counter_write_data_write_data_1 + 1;
              when 2 =>
                if (write_data_if_flag_write_data_2_write_data_0 = '1') then
                  l_write_data_0 <= conv_std_logic_vector(256, l_write_data_0'length);
                  state_counter_write_data_write_data_1 <= state_counter_write_data_write_data_1 + 1;
                else
                  state_counter_write_data_write_data_1 <= state_counter_write_data_write_data_1 + 1;
                end if;
              when 3 =>
                state_counter_write_data_write_data_1 <= (others => '0');
                write_data_method_state <= write_data_method_state + 1;
              when others =>
                state_counter_write_data_write_data_1 <= (others => '0');
            end case;
          when 4 => 
            case conv_integer(state_counter_write_data_write_data_3) is
              when 0 => state_counter_write_data_write_data_3 <= state_counter_write_data_write_data_3 + 1;
              when 1 =>
                if ((conv_integer(l_write_data_0 and conv_std_logic_vector(3, 32))) /= 0) then
                  write_data_if_flag_write_data_4_write_data_0 <= '1';
                else
                  write_data_if_flag_write_data_4_write_data_0 <= '0';
                end if;
                state_counter_write_data_write_data_3 <= state_counter_write_data_write_data_3 + 1;
              when 2 =>
                if (write_data_if_flag_write_data_4_write_data_0 = '1') then
                  l_write_data_0 <= conv_std_logic_vector((conv_integer(l_write_data_0 and conv_std_logic_vector(508, 32))) + 1, l_write_data_0'length);
                  state_counter_write_data_write_data_3 <= state_counter_write_data_write_data_3 + 1;
                else
                  state_counter_write_data_write_data_3 <= state_counter_write_data_write_data_3 + 1;
                end if;
              when 3 =>
                state_counter_write_data_write_data_3 <= (others => '0');
                write_data_method_state <= write_data_method_state + 1;
              when others =>
                state_counter_write_data_write_data_3 <= (others => '0');
            end case;
          when 5 => 
            case conv_integer(state_counter_write_data_write_data_5) is
              when 0 => state_counter_write_data_write_data_5 <= state_counter_write_data_write_data_5 + 1;
              when 1 =>
                i_write_data_5 <= conv_std_logic_vector(0, i_write_data_5'length);
                state_counter_write_data_write_data_5 <= state_counter_write_data_write_data_5 + 1;
              when 2 =>
                if (conv_integer(i_write_data_5) < (conv_integer((31 downto (31-2+1) => l_write_data_0(31)) & l_write_data_0(31 downto 2)))) then
                  state_counter_write_data_write_data_5 <= state_counter_write_data_write_data_5 + 1;
                  state_counter_write_data_write_data_6 <= conv_std_logic_vector(1, state_counter_write_data_write_data_6'length);
                else
                  write_data_method_state <= write_data_method_state + 1;
                  state_counter_write_data_write_data_5 <= (others => '0');
                end if;
              when 3 =>
                case conv_integer(state_counter_write_data_write_data_6) is
                  when 0 => state_counter_write_data_write_data_6 <= state_counter_write_data_write_data_6 + 1;
                  when 1 =>
                    case conv_integer(array_index_operation_state_counter_write_data_7) is
                      when 0 =>
                        recv_buf_raddr_field_wdata_writer_state_counter_write_data_write_data_6 <= conv_std_logic_vector(conv_integer(i_write_data_5) + 3, recv_buf_raddr_field_wdata'length);
                        array_index_operation_state_counter_write_data_7 <= array_index_operation_state_counter_write_data_7 + 1;
                      when 1 =>
                        array_index_operation_state_counter_write_data_7 <= (others => '0');
                        state_counter_write_data_write_data_6 <= state_counter_write_data_write_data_6 + 1;
                      when others => array_index_operation_state_counter_write_data_7 <= (others => '0');
                    end case;
                  when 2 =>
                    v_write_data_6 <= conv_std_logic_vector(conv_integer(recv_buf_rdata_field_rdata), v_write_data_6'length);
                    state_counter_write_data_write_data_6 <= state_counter_write_data_write_data_6 + 1;
                  when 3 =>
                    case conv_integer(storage_buf_write_call_state_counter_write_data_6) is
                      when 0 =>
                        if (storage_buf_write_method_busy_field_wdata = '0') then
                          storage_buf_write_method_request_field_wdata_writer_state_counter_write_data_write_data_6 <= '1';
                          storage_buf_write_call_state_counter_write_data_6 <= storage_buf_write_call_state_counter_write_data_6 + 1;
                        end if;
                      when 1 =>
                        storage_input_port_buf_write_index_field_wdata_writer_state_counter_write_data_write_data_6 <= conv_std_logic_vector((conv_integer(i_write_data_5(31 - 2 downto 0) & conv_std_logic_vector(0, 2))) + 0, storage_input_port_buf_write_index_field_wdata'length);
                        storage_input_port_buf_write_data_field_wdata_writer_state_counter_write_data_write_data_6 <= conv_std_logic_vector((conv_integer(conv_std_logic_vector((conv_integer((31 downto (31-24+1) => v_write_data_6(31)) & v_write_data_6(31 downto 24))), 32) and conv_std_logic_vector(255, 32))), storage_input_port_buf_write_data_field_wdata'length);
                        storage_buf_write_method_request_field_wdata_writer_state_counter_write_data_write_data_6 <= '0';
                        storage_buf_write_call_state_counter_write_data_6 <= storage_buf_write_call_state_counter_write_data_6 + 1;
                      when 2 =>
                        if (storage_buf_write_method_request_field_wdata = '0' and storage_buf_write_method_busy_field_wdata = '0') then
                          storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
                          state_counter_write_data_write_data_6 <= state_counter_write_data_write_data_6 + 1;
                        end if;
                      when others => storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
                    end case;
                  when 4 =>
                    case conv_integer(storage_buf_write_call_state_counter_write_data_6) is
                      when 0 =>
                        if (storage_buf_write_method_busy_field_wdata = '0') then
                          storage_buf_write_method_request_field_wdata_writer_state_counter_write_data_write_data_6 <= '1';
                          storage_buf_write_call_state_counter_write_data_6 <= storage_buf_write_call_state_counter_write_data_6 + 1;
                        end if;
                      when 1 =>
                        storage_input_port_buf_write_index_field_wdata_writer_state_counter_write_data_write_data_6 <= conv_std_logic_vector((conv_integer(i_write_data_5(31 - 2 downto 0) & conv_std_logic_vector(0, 2))) + 1, storage_input_port_buf_write_index_field_wdata'length);
                        storage_input_port_buf_write_data_field_wdata_writer_state_counter_write_data_write_data_6 <= conv_std_logic_vector((conv_integer(conv_std_logic_vector((conv_integer((31 downto (31-16+1) => v_write_data_6(31)) & v_write_data_6(31 downto 16))), 32) and conv_std_logic_vector(255, 32))), storage_input_port_buf_write_data_field_wdata'length);
                        storage_buf_write_method_request_field_wdata_writer_state_counter_write_data_write_data_6 <= '0';
                        storage_buf_write_call_state_counter_write_data_6 <= storage_buf_write_call_state_counter_write_data_6 + 1;
                      when 2 =>
                        if (storage_buf_write_method_request_field_wdata = '0' and storage_buf_write_method_busy_field_wdata = '0') then
                          storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
                          state_counter_write_data_write_data_6 <= state_counter_write_data_write_data_6 + 1;
                        end if;
                      when others => storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
                    end case;
                  when 5 =>
                    case conv_integer(storage_buf_write_call_state_counter_write_data_6) is
                      when 0 =>
                        if (storage_buf_write_method_busy_field_wdata = '0') then
                          storage_buf_write_method_request_field_wdata_writer_state_counter_write_data_write_data_6 <= '1';
                          storage_buf_write_call_state_counter_write_data_6 <= storage_buf_write_call_state_counter_write_data_6 + 1;
                        end if;
                      when 1 =>
                        storage_input_port_buf_write_index_field_wdata_writer_state_counter_write_data_write_data_6 <= conv_std_logic_vector((conv_integer(i_write_data_5(31 - 2 downto 0) & conv_std_logic_vector(0, 2))) + 2, storage_input_port_buf_write_index_field_wdata'length);
                        storage_input_port_buf_write_data_field_wdata_writer_state_counter_write_data_write_data_6 <= conv_std_logic_vector((conv_integer(conv_std_logic_vector((conv_integer((31 downto (31-8+1) => v_write_data_6(31)) & v_write_data_6(31 downto 8))), 32) and conv_std_logic_vector(255, 32))), storage_input_port_buf_write_data_field_wdata'length);
                        storage_buf_write_method_request_field_wdata_writer_state_counter_write_data_write_data_6 <= '0';
                        storage_buf_write_call_state_counter_write_data_6 <= storage_buf_write_call_state_counter_write_data_6 + 1;
                      when 2 =>
                        if (storage_buf_write_method_request_field_wdata = '0' and storage_buf_write_method_busy_field_wdata = '0') then
                          storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
                          state_counter_write_data_write_data_6 <= state_counter_write_data_write_data_6 + 1;
                        end if;
                      when others => storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
                    end case;
                  when 6 =>
                    case conv_integer(storage_buf_write_call_state_counter_write_data_6) is
                      when 0 =>
                        if (storage_buf_write_method_busy_field_wdata = '0') then
                          storage_buf_write_method_request_field_wdata_writer_state_counter_write_data_write_data_6 <= '1';
                          storage_buf_write_call_state_counter_write_data_6 <= storage_buf_write_call_state_counter_write_data_6 + 1;
                        end if;
                      when 1 =>
                        storage_input_port_buf_write_index_field_wdata_writer_state_counter_write_data_write_data_6 <= conv_std_logic_vector((conv_integer(i_write_data_5(31 - 2 downto 0) & conv_std_logic_vector(0, 2))) + 3, storage_input_port_buf_write_index_field_wdata'length);
                        storage_input_port_buf_write_data_field_wdata_writer_state_counter_write_data_write_data_6 <= conv_std_logic_vector((conv_integer(conv_std_logic_vector((conv_integer((31 downto (31-0+1) => v_write_data_6(31)) & v_write_data_6(31 downto 0))), 32) and conv_std_logic_vector(255, 32))), storage_input_port_buf_write_data_field_wdata'length);
                        storage_buf_write_method_request_field_wdata_writer_state_counter_write_data_write_data_6 <= '0';
                        storage_buf_write_call_state_counter_write_data_6 <= storage_buf_write_call_state_counter_write_data_6 + 1;
                      when 2 =>
                        if (storage_buf_write_method_request_field_wdata = '0' and storage_buf_write_method_busy_field_wdata = '0') then
                          storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
                          state_counter_write_data_write_data_6 <= state_counter_write_data_write_data_6 + 1;
                        end if;
                      when others => storage_buf_write_call_state_counter_write_data_6 <= (others => '0');
                    end case;
                  when 7 =>
                    state_counter_write_data_write_data_5 <= state_counter_write_data_write_data_5 + 1;
                    state_counter_write_data_write_data_6 <= (others => '0');
                  when others => state_counter_write_data_write_data_6 <= (others => '0');
                end case;
              when 4 =>
                  i_write_data_5 <= conv_std_logic_vector(conv_integer(i_write_data_5) + 1, i_write_data_5'length);
                  state_counter_write_data_write_data_5 <= conv_std_logic_vector(2, 32);
              when others => state_counter_write_data_write_data_5 <= (others => '0');
            end case;
          when 6 => 
            case conv_integer(storage_page_program_call_state_counter_write_data_0) is
              when 0 =>
                if (storage_page_program_method_busy_field_wdata = '0') then
                  storage_page_program_method_request_field_wdata_writer_write_data_method_state <= '1';
                  storage_page_program_call_state_counter_write_data_0 <= storage_page_program_call_state_counter_write_data_0 + 1;
                end if;
              when 1 =>
                storage_input_port_page_program_addr_field_wdata_writer_write_data_method_state <= conv_std_logic_vector(conv_integer(this_input_port_write_data_addr_field_rdata), storage_input_port_page_program_addr_field_wdata'length);
                storage_input_port_page_program_length_field_wdata_writer_write_data_method_state <= conv_std_logic_vector(conv_integer(l_write_data_0), storage_input_port_page_program_length_field_wdata'length);
                storage_page_program_method_request_field_wdata_writer_write_data_method_state <= '0';
                storage_page_program_call_state_counter_write_data_0 <= storage_page_program_call_state_counter_write_data_0 + 1;
              when 2 =>
                if (storage_page_program_method_request_field_wdata = '0' and storage_page_program_method_busy_field_wdata = '0') then
                  storage_page_program_call_state_counter_write_data_0 <= (others => '0');
                  write_data_method_state <= write_data_method_state + 1;
                end if;
              when others => storage_page_program_call_state_counter_write_data_0 <= (others => '0');
            end case;
          when 7 => 
            this_output_port_write_data <= conv_std_logic_vector(conv_integer(l_write_data_0), this_output_port_write_data'length);
            write_data_method_state <= (others => '0');
          when 8 =>
            this_write_data_method_busy <= '0';
            write_data_method_state <= (others => '0');
          when others => write_data_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --write_data
  process(clk) --recv
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_recv_recv_0 <= (others => '0');
        state_counter_recv_recv_1 <= (others => '0');
        state_counter_recv_recv_2 <= (others => '0');
        i_recv_2 <= (others => '0');
        state_counter_recv_recv_3 <= (others => '0');
        v_recv_3 <= (others => '0');
        array_index_operation_state_counter_recv_4 <= (others => '0');
        array_index_operation_state_counter_recv_5 <= (others => '0');
        this_recv_method_busy <= '0';
        recv_method_state <= (others => '0');
        udp_rx_read_flag_field_wdata_reset <= '0';
        src_ip_field_wdata_reset <= (others => '0');
        src_port_field_wdata_reset <= (others => '0');
        dest_ip_field_wdata_reset <= (others => '0');
        dest_port_field_wdata_reset <= (others => '0');
        data_length_field_wdata_reset <= (others => '0');
        recv_buf_wdata_field_wdata_reset <= (others => '0');
      else
        case conv_integer(recv_method_state) is
          when 0 =>
            if(this_recv_method_request_field_rdata = '1') then
              this_recv_method_busy <= '1';
              recv_method_state <= recv_method_state + 1;
            else
              this_recv_method_busy <= '0';
            end if;
          when 1 =>
            if(this_recv_method_request_field_rdata = '0') then
              recv_method_state <= recv_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(state_counter_recv_recv_1) is
              when 0 => state_counter_recv_recv_1 <= state_counter_recv_recv_1 + 1;
              when 1 =>
                if (udp_rx_valid_field_rdata = '0') then
                  state_counter_recv_recv_1 <= state_counter_recv_recv_1 + 1;
                else
                  recv_method_state <= recv_method_state + 1;
                  state_counter_recv_recv_1 <= (others => '0');
                end if;
              when 2 =>
                state_counter_recv_recv_1 <= (others => '0');
              when others => state_counter_recv_recv_1 <= (others => '0');
            end case;
          when 3 => 
            udp_rx_read_flag_field_wdata_writer_recv_method_state <= '1';
            recv_method_state <= recv_method_state + 1;
          when 4 => 
            src_ip_field_wdata_writer_recv_method_state <= conv_std_logic_vector(conv_integer(udp_rx_src_ip_field_rdata), src_ip_field_wdata'length);
            src_port_field_wdata_writer_recv_method_state <= conv_std_logic_vector(conv_integer(udp_rx_src_port_field_rdata), src_port_field_wdata'length);
            dest_ip_field_wdata_writer_recv_method_state <= conv_std_logic_vector(conv_integer(udp_rx_dest_ip_field_rdata), dest_ip_field_wdata'length);
            dest_port_field_wdata_writer_recv_method_state <= conv_std_logic_vector(conv_integer(udp_rx_dest_port_field_rdata), dest_port_field_wdata'length);
            data_length_field_wdata_writer_recv_method_state <= conv_std_logic_vector(conv_integer(udp_rx_data_length_field_rdata), data_length_field_wdata'length);
            recv_method_state <= recv_method_state + 1;
          when 5 => 
            case conv_integer(state_counter_recv_recv_2) is
              when 0 => state_counter_recv_recv_2 <= state_counter_recv_recv_2 + 1;
              when 1 =>
                i_recv_2 <= conv_std_logic_vector(0, i_recv_2'length);
                state_counter_recv_recv_2 <= state_counter_recv_recv_2 + 1;
              when 2 =>
                if (conv_integer(i_recv_2) < conv_integer(data_length_field_rdata)) then
                  state_counter_recv_recv_2 <= state_counter_recv_recv_2 + 1;
                  state_counter_recv_recv_3 <= conv_std_logic_vector(1, state_counter_recv_recv_3'length);
                else
                  recv_method_state <= recv_method_state + 1;
                  state_counter_recv_recv_2 <= (others => '0');
                end if;
              when 3 =>
                case conv_integer(state_counter_recv_recv_3) is
                  when 0 => state_counter_recv_recv_3 <= state_counter_recv_recv_3 + 1;
                  when 1 =>
                    case conv_integer(array_index_operation_state_counter_recv_4) is
                      when 0 =>
                        udp_rx_data_raddr_field_wdata_writer_state_counter_recv_recv_3 <= conv_std_logic_vector(conv_integer(i_recv_2), udp_rx_data_raddr_field_wdata'length);
                        array_index_operation_state_counter_recv_4 <= array_index_operation_state_counter_recv_4 + 1;
                      when 1 =>
                        array_index_operation_state_counter_recv_4 <= (others => '0');
                        state_counter_recv_recv_3 <= state_counter_recv_recv_3 + 1;
                      when others => array_index_operation_state_counter_recv_4 <= (others => '0');
                    end case;
                  when 2 =>
                    v_recv_3 <= conv_std_logic_vector(conv_integer(udp_rx_data_rdata_field_rdata), v_recv_3'length);
                    state_counter_recv_recv_3 <= state_counter_recv_recv_3 + 1;
                  when 3 =>
                    recv_buf_waddr_field_wdata_writer_state_counter_recv_recv_3 <= conv_std_logic_vector(conv_integer(i_recv_2), recv_buf_waddr_field_wdata'length);
                    recv_buf_we_field_wdata_writer_state_counter_recv_recv_3 <= conv_std_logic_vector(1, recv_buf_we_field_wdata'length);
                    recv_buf_wdata_field_wdata_writer_state_counter_recv_recv_3 <= conv_std_logic_vector(conv_integer(v_recv_3), recv_buf_wdata_field_wdata'length);
                    state_counter_recv_recv_2 <= state_counter_recv_recv_2 + 1;
                    state_counter_recv_recv_3 <= (others => '0');
                  when others => state_counter_recv_recv_3 <= (others => '0');
                end case;
              when 4 =>
                  i_recv_2 <= conv_std_logic_vector(conv_integer(i_recv_2) + 1, i_recv_2'length);
                  state_counter_recv_recv_2 <= conv_std_logic_vector(2, 32);
              when others => state_counter_recv_recv_2 <= (others => '0');
            end case;
          when 6 => 
            udp_rx_read_flag_field_wdata_writer_recv_method_state <= '0';
            recv_method_state <= recv_method_state + 1;
          when 7 =>
            this_recv_method_busy <= '0';
            recv_method_state <= (others => '0');
          when others => recv_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --recv
  process(clk) --notify
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        notify_flag <= '0';
        this_notify_method_busy <= '0';
        notify_method_state <= (others => '0');
        state_counter_notify_notify_0 <= (others => '0');
      else
        case conv_integer(notify_method_state) is
          when 0 =>
            if(this_notify_method_request = '1') then
              this_notify_method_busy <= '1';
              notify_method_state <= notify_method_state + 1;
            else
              this_notify_method_busy <= '0';
            end if;
          when 1 =>
            if(this_notify_method_request = '0') then
              notify_method_state <= notify_method_state + 1;
            end if;
          when 2 => 
            notify_flag <= '1';
            notify_method_state <= notify_method_state + 1;
          when 3 => 
            notify_flag <= '0';
            notify_method_state <= notify_method_state + 1;
          when 4 =>
            this_notify_method_busy <= '0';
            notify_method_state <= (others => '0');
          when others => notify_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --notify
  process(clk) --send
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_send_send_0 <= (others => '0');
        state_counter_send_send_1 <= (others => '0');
        i_send_1 <= (others => '0');
        state_counter_send_send_2 <= (others => '0');
        array_index_operation_state_counter_send_3 <= (others => '0');
        array_index_operation_state_counter_send_4 <= (others => '0');
        state_counter_send_send_5 <= (others => '0');
        this_send_method_busy <= '0';
        send_method_state <= (others => '0');
        udp_tx_dest_ip_field_wdata_reset <= (others => '0');
        udp_tx_dest_port_field_wdata_reset <= (others => '0');
        udp_tx_src_ip_field_wdata_reset <= (others => '0');
        udp_tx_src_port_field_wdata_reset <= (others => '0');
        udp_tx_data_length_field_wdata_reset <= (others => '0');
        udp_tx_data_wdata_field_wdata_reset <= (others => '0');
        udp_tx_start_field_wdata_reset <= '0';
      else
        case conv_integer(send_method_state) is
          when 0 =>
            if(this_send_method_request_field_rdata = '1') then
              this_send_method_busy <= '1';
              send_method_state <= send_method_state + 1;
            else
              this_send_method_busy <= '0';
            end if;
          when 1 =>
            if(this_send_method_request_field_rdata = '0') then
              send_method_state <= send_method_state + 1;
            end if;
          when 2 => 
            udp_tx_dest_ip_field_wdata_writer_send_method_state <= conv_std_logic_vector(conv_integer(src_ip_field_rdata), udp_tx_dest_ip_field_wdata'length);
            send_method_state <= send_method_state + 1;
          when 3 => 
            udp_tx_dest_port_field_wdata_writer_send_method_state <= conv_std_logic_vector(conv_integer(src_port_field_rdata), udp_tx_dest_port_field_wdata'length);
            send_method_state <= send_method_state + 1;
          when 4 => 
            udp_tx_src_ip_field_wdata_writer_send_method_state <= conv_std_logic_vector(conv_integer(dest_ip_field_rdata), udp_tx_src_ip_field_wdata'length);
            send_method_state <= send_method_state + 1;
          when 5 => 
            udp_tx_src_port_field_wdata_writer_send_method_state <= conv_std_logic_vector(conv_integer(dest_port_field_rdata), udp_tx_src_port_field_wdata'length);
            send_method_state <= send_method_state + 1;
          when 6 => 
            udp_tx_data_length_field_wdata_writer_send_method_state <= conv_std_logic_vector(conv_integer(this_input_port_send_len_field_rdata), udp_tx_data_length_field_wdata'length);
            send_method_state <= send_method_state + 1;
          when 7 => 
            case conv_integer(state_counter_send_send_1) is
              when 0 => state_counter_send_send_1 <= state_counter_send_send_1 + 1;
              when 1 =>
                i_send_1 <= conv_std_logic_vector(0, i_send_1'length);
                state_counter_send_send_1 <= state_counter_send_send_1 + 1;
              when 2 =>
                if (conv_integer(i_send_1) < conv_integer(this_input_port_send_len_field_rdata)) then
                  state_counter_send_send_1 <= state_counter_send_send_1 + 1;
                  state_counter_send_send_2 <= conv_std_logic_vector(1, state_counter_send_send_2'length);
                else
                  send_method_state <= send_method_state + 1;
                  state_counter_send_send_1 <= (others => '0');
                end if;
              when 3 =>
                case conv_integer(state_counter_send_send_2) is
                  when 0 => state_counter_send_send_2 <= state_counter_send_send_2 + 1;
                  when 1 =>
                    case conv_integer(array_index_operation_state_counter_send_3) is
                      when 0 =>
                        send_buf_raddr_field_wdata_writer_state_counter_send_send_2 <= conv_std_logic_vector(conv_integer(i_send_1), send_buf_raddr_field_wdata'length);
                        array_index_operation_state_counter_send_3 <= array_index_operation_state_counter_send_3 + 1;
                      when 1 =>
                        array_index_operation_state_counter_send_3 <= (others => '0');
                        state_counter_send_send_2 <= state_counter_send_send_2 + 1;
                      when others => array_index_operation_state_counter_send_3 <= (others => '0');
                    end case;
                  when 2 =>
                    udp_tx_data_waddr_field_wdata_writer_state_counter_send_send_2 <= conv_std_logic_vector(conv_integer(i_send_1), udp_tx_data_waddr_field_wdata'length);
                    udp_tx_data_we_field_wdata_writer_state_counter_send_send_2 <= conv_std_logic_vector(1, udp_tx_data_we_field_wdata'length);
                    udp_tx_data_wdata_field_wdata_writer_state_counter_send_send_2 <= conv_std_logic_vector(conv_integer(send_buf_rdata_field_rdata), udp_tx_data_wdata_field_wdata'length);
                    state_counter_send_send_1 <= state_counter_send_send_1 + 1;
                    state_counter_send_send_2 <= (others => '0');
                  when others => state_counter_send_send_2 <= (others => '0');
                end case;
              when 4 =>
                  i_send_1 <= conv_std_logic_vector(conv_integer(i_send_1) + 1, i_send_1'length);
                  state_counter_send_send_1 <= conv_std_logic_vector(2, 32);
              when others => state_counter_send_send_1 <= (others => '0');
            end case;
          when 8 => 
            case conv_integer(state_counter_send_send_5) is
              when 0 => state_counter_send_send_5 <= state_counter_send_send_5 + 1;
              when 1 =>
                if (udp_tx_busy_field_rdata = '1') then
                  state_counter_send_send_5 <= state_counter_send_send_5 + 1;
                else
                  send_method_state <= send_method_state + 1;
                  state_counter_send_send_5 <= (others => '0');
                end if;
              when 2 =>
                state_counter_send_send_5 <= (others => '0');
              when others => state_counter_send_send_5 <= (others => '0');
            end case;
          when 9 => 
            udp_tx_start_field_wdata_writer_send_method_state <= '1';
            send_method_state <= send_method_state + 1;
          when 10 => 
            udp_tx_start_field_wdata_writer_send_method_state <= '0';
            send_method_state <= send_method_state + 1;
          when 11 =>
            this_send_method_busy <= '0';
            send_method_state <= (others => '0');
          when others => send_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --send
  process(clk) --wait
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        d_notify_flag <= '0';
        this_wait_method_busy <= '0';
        wait_method_state <= (others => '0');
        state_counter_wait_wait_0 <= (others => '0');
      else
        case conv_integer(wait_method_state) is
          when 0 =>
            if(this_wait_method_request_field_rdata = '1') then
              this_wait_method_busy <= '1';
              wait_method_state <= wait_method_state + 1;
            else
              this_wait_method_busy <= '0';
            end if;
          when 1 =>
            if(this_wait_method_request_field_rdata = '0') then
              wait_method_state <= wait_method_state + 1;
            end if;
          when 2 => 
            if (d_notify_flag = '0' and notify_flag = '1') then
              wait_method_state <= wait_method_state + 1;
            else
              d_notify_flag <= notify_flag;
            end if;
          when 3 =>
            this_wait_method_busy <= '0';
            wait_method_state <= (others => '0');
          when others => wait_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --wait
  process(clk) --read_data
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_read_data_read_data_0 <= (others => '0');
        l_read_data_0 <= (others => '0');
        state_counter_read_data_read_data_1 <= (others => '0');
        read_data_if_flag_read_data_2_read_data_0 <= '0';
        state_counter_read_data_read_data_3 <= (others => '0');
        read_data_if_flag_read_data_4_read_data_0 <= '0';
        storage_read_bytes_call_state_counter_read_data_0 <= (others => '0');
        storage_read_bytes_call_state_counter_read_data_0 <= (others => '0');
        state_counter_read_data_read_data_5 <= (others => '0');
        i_read_data_5 <= (others => '0');
        state_counter_read_data_read_data_6 <= (others => '0');
        b0_read_data_6 <= (others => '0');
        b1_read_data_6 <= (others => '0');
        b2_read_data_6 <= (others => '0');
        b3_read_data_6 <= (others => '0');
        storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
        storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
        storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
        storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
        storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
        storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
        storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
        storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
        array_index_operation_state_counter_read_data_7 <= (others => '0');
        this_read_data_method_busy <= '0';
        read_data_method_state <= (others => '0');
        storage_read_bytes_method_request_field_wdata_reset <= '0';
        storage_buf_read_method_request_field_wdata_reset <= '0';
        storage_buf_read_method_request_field_wdata_reset <= '0';
        storage_buf_read_method_request_field_wdata_reset <= '0';
        storage_buf_read_method_request_field_wdata_reset <= '0';
        this_output_port_read_data <= (others => '0');
      else
        case conv_integer(read_data_method_state) is
          when 0 =>
            if(this_read_data_method_request_field_rdata = '1') then
              this_read_data_method_busy <= '1';
              read_data_method_state <= read_data_method_state + 1;
            else
              this_read_data_method_busy <= '0';
            end if;
          when 1 =>
            if(this_read_data_method_request_field_rdata = '0') then
              read_data_method_state <= read_data_method_state + 1;
            end if;
          when 2 => 
            l_read_data_0 <= conv_std_logic_vector(conv_integer(this_input_port_read_data_len_field_rdata), l_read_data_0'length);
            read_data_method_state <= read_data_method_state + 1;
          when 3 => 
            case conv_integer(state_counter_read_data_read_data_1) is
              when 0 => state_counter_read_data_read_data_1 <= state_counter_read_data_read_data_1 + 1;
              when 1 =>
                if (conv_integer(l_read_data_0) > 256) then
                  read_data_if_flag_read_data_2_read_data_0 <= '1';
                else
                  read_data_if_flag_read_data_2_read_data_0 <= '0';
                end if;
                state_counter_read_data_read_data_1 <= state_counter_read_data_read_data_1 + 1;
              when 2 =>
                if (read_data_if_flag_read_data_2_read_data_0 = '1') then
                  l_read_data_0 <= conv_std_logic_vector(256, l_read_data_0'length);
                  state_counter_read_data_read_data_1 <= state_counter_read_data_read_data_1 + 1;
                else
                  state_counter_read_data_read_data_1 <= state_counter_read_data_read_data_1 + 1;
                end if;
              when 3 =>
                state_counter_read_data_read_data_1 <= (others => '0');
                read_data_method_state <= read_data_method_state + 1;
              when others =>
                state_counter_read_data_read_data_1 <= (others => '0');
            end case;
          when 4 => 
            case conv_integer(state_counter_read_data_read_data_3) is
              when 0 => state_counter_read_data_read_data_3 <= state_counter_read_data_read_data_3 + 1;
              when 1 =>
                if ((conv_integer(l_read_data_0 and conv_std_logic_vector(3, 32))) /= 0) then
                  read_data_if_flag_read_data_4_read_data_0 <= '1';
                else
                  read_data_if_flag_read_data_4_read_data_0 <= '0';
                end if;
                state_counter_read_data_read_data_3 <= state_counter_read_data_read_data_3 + 1;
              when 2 =>
                if (read_data_if_flag_read_data_4_read_data_0 = '1') then
                  l_read_data_0 <= conv_std_logic_vector((conv_integer(l_read_data_0 and conv_std_logic_vector(508, 32))) + 1, l_read_data_0'length);
                  state_counter_read_data_read_data_3 <= state_counter_read_data_read_data_3 + 1;
                else
                  state_counter_read_data_read_data_3 <= state_counter_read_data_read_data_3 + 1;
                end if;
              when 3 =>
                state_counter_read_data_read_data_3 <= (others => '0');
                read_data_method_state <= read_data_method_state + 1;
              when others =>
                state_counter_read_data_read_data_3 <= (others => '0');
            end case;
          when 5 => 
            case conv_integer(storage_read_bytes_call_state_counter_read_data_0) is
              when 0 =>
                if (storage_read_bytes_method_busy_field_wdata = '0') then
                  storage_read_bytes_method_request_field_wdata_writer_read_data_method_state <= '1';
                  storage_read_bytes_call_state_counter_read_data_0 <= storage_read_bytes_call_state_counter_read_data_0 + 1;
                end if;
              when 1 =>
                storage_input_port_read_bytes_addr_field_wdata_writer_read_data_method_state <= conv_std_logic_vector(conv_integer(this_input_port_read_data_addr_field_rdata), storage_input_port_read_bytes_addr_field_wdata'length);
                storage_input_port_read_bytes_length_field_wdata_writer_read_data_method_state <= conv_std_logic_vector(conv_integer(l_read_data_0), storage_input_port_read_bytes_length_field_wdata'length);
                storage_read_bytes_method_request_field_wdata_writer_read_data_method_state <= '0';
                storage_read_bytes_call_state_counter_read_data_0 <= storage_read_bytes_call_state_counter_read_data_0 + 1;
              when 2 =>
                if (storage_read_bytes_method_request_field_wdata = '0' and storage_read_bytes_method_busy_field_wdata = '0') then
                  storage_read_bytes_call_state_counter_read_data_0 <= (others => '0');
                  read_data_method_state <= read_data_method_state + 1;
                end if;
              when others => storage_read_bytes_call_state_counter_read_data_0 <= (others => '0');
            end case;
          when 6 => 
            case conv_integer(state_counter_read_data_read_data_5) is
              when 0 => state_counter_read_data_read_data_5 <= state_counter_read_data_read_data_5 + 1;
              when 1 =>
                i_read_data_5 <= conv_std_logic_vector(0, i_read_data_5'length);
                state_counter_read_data_read_data_5 <= state_counter_read_data_read_data_5 + 1;
              when 2 =>
                if (conv_integer(i_read_data_5) < conv_integer(l_read_data_0)) then
                  state_counter_read_data_read_data_5 <= state_counter_read_data_read_data_5 + 1;
                  state_counter_read_data_read_data_6 <= conv_std_logic_vector(1, state_counter_read_data_read_data_6'length);
                else
                  read_data_method_state <= read_data_method_state + 1;
                  state_counter_read_data_read_data_5 <= (others => '0');
                end if;
              when 3 =>
                case conv_integer(state_counter_read_data_read_data_6) is
                  when 0 => state_counter_read_data_read_data_6 <= state_counter_read_data_read_data_6 + 1;
                  when 1 =>
                    case conv_integer(storage_buf_read_call_state_counter_read_data_6) is
                      when 0 =>
                        if (storage_buf_read_method_busy_field_wdata = '0') then
                          storage_buf_read_method_request_field_wdata_writer_state_counter_read_data_read_data_6 <= '1';
                          storage_buf_read_call_state_counter_read_data_6 <= storage_buf_read_call_state_counter_read_data_6 + 1;
                        end if;
                      when 1 =>
                        storage_input_port_buf_read_index_field_wdata_writer_state_counter_read_data_read_data_6 <= conv_std_logic_vector(conv_integer(i_read_data_5) + 0, storage_input_port_buf_read_index_field_wdata'length);
                        storage_buf_read_method_request_field_wdata_writer_state_counter_read_data_read_data_6 <= '0';
                        storage_buf_read_call_state_counter_read_data_6 <= storage_buf_read_call_state_counter_read_data_6 + 1;
                      when 2 =>
                        if (storage_buf_read_method_request_field_wdata = '0' and storage_buf_read_method_busy_field_wdata = '0') then
                          storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
                          state_counter_read_data_read_data_6 <= state_counter_read_data_read_data_6 + 1;
                        end if;
                      when others => storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
                    end case;
                  when 2 =>
                    b0_read_data_6 <= conv_std_logic_vector(conv_integer(storage_output_port_buf_read_field_rdata), b0_read_data_6'length);
                    state_counter_read_data_read_data_6 <= state_counter_read_data_read_data_6 + 1;
                  when 3 =>
                    case conv_integer(storage_buf_read_call_state_counter_read_data_6) is
                      when 0 =>
                        if (storage_buf_read_method_busy_field_wdata = '0') then
                          storage_buf_read_method_request_field_wdata_writer_state_counter_read_data_read_data_6 <= '1';
                          storage_buf_read_call_state_counter_read_data_6 <= storage_buf_read_call_state_counter_read_data_6 + 1;
                        end if;
                      when 1 =>
                        storage_input_port_buf_read_index_field_wdata_writer_state_counter_read_data_read_data_6 <= conv_std_logic_vector(conv_integer(i_read_data_5) + 1, storage_input_port_buf_read_index_field_wdata'length);
                        storage_buf_read_method_request_field_wdata_writer_state_counter_read_data_read_data_6 <= '0';
                        storage_buf_read_call_state_counter_read_data_6 <= storage_buf_read_call_state_counter_read_data_6 + 1;
                      when 2 =>
                        if (storage_buf_read_method_request_field_wdata = '0' and storage_buf_read_method_busy_field_wdata = '0') then
                          storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
                          state_counter_read_data_read_data_6 <= state_counter_read_data_read_data_6 + 1;
                        end if;
                      when others => storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
                    end case;
                  when 4 =>
                    b1_read_data_6 <= conv_std_logic_vector(conv_integer(storage_output_port_buf_read_field_rdata), b1_read_data_6'length);
                    state_counter_read_data_read_data_6 <= state_counter_read_data_read_data_6 + 1;
                  when 5 =>
                    case conv_integer(storage_buf_read_call_state_counter_read_data_6) is
                      when 0 =>
                        if (storage_buf_read_method_busy_field_wdata = '0') then
                          storage_buf_read_method_request_field_wdata_writer_state_counter_read_data_read_data_6 <= '1';
                          storage_buf_read_call_state_counter_read_data_6 <= storage_buf_read_call_state_counter_read_data_6 + 1;
                        end if;
                      when 1 =>
                        storage_input_port_buf_read_index_field_wdata_writer_state_counter_read_data_read_data_6 <= conv_std_logic_vector(conv_integer(i_read_data_5) + 2, storage_input_port_buf_read_index_field_wdata'length);
                        storage_buf_read_method_request_field_wdata_writer_state_counter_read_data_read_data_6 <= '0';
                        storage_buf_read_call_state_counter_read_data_6 <= storage_buf_read_call_state_counter_read_data_6 + 1;
                      when 2 =>
                        if (storage_buf_read_method_request_field_wdata = '0' and storage_buf_read_method_busy_field_wdata = '0') then
                          storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
                          state_counter_read_data_read_data_6 <= state_counter_read_data_read_data_6 + 1;
                        end if;
                      when others => storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
                    end case;
                  when 6 =>
                    b2_read_data_6 <= conv_std_logic_vector(conv_integer(storage_output_port_buf_read_field_rdata), b2_read_data_6'length);
                    state_counter_read_data_read_data_6 <= state_counter_read_data_read_data_6 + 1;
                  when 7 =>
                    case conv_integer(storage_buf_read_call_state_counter_read_data_6) is
                      when 0 =>
                        if (storage_buf_read_method_busy_field_wdata = '0') then
                          storage_buf_read_method_request_field_wdata_writer_state_counter_read_data_read_data_6 <= '1';
                          storage_buf_read_call_state_counter_read_data_6 <= storage_buf_read_call_state_counter_read_data_6 + 1;
                        end if;
                      when 1 =>
                        storage_input_port_buf_read_index_field_wdata_writer_state_counter_read_data_read_data_6 <= conv_std_logic_vector(conv_integer(i_read_data_5) + 3, storage_input_port_buf_read_index_field_wdata'length);
                        storage_buf_read_method_request_field_wdata_writer_state_counter_read_data_read_data_6 <= '0';
                        storage_buf_read_call_state_counter_read_data_6 <= storage_buf_read_call_state_counter_read_data_6 + 1;
                      when 2 =>
                        if (storage_buf_read_method_request_field_wdata = '0' and storage_buf_read_method_busy_field_wdata = '0') then
                          storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
                          state_counter_read_data_read_data_6 <= state_counter_read_data_read_data_6 + 1;
                        end if;
                      when others => storage_buf_read_call_state_counter_read_data_6 <= (others => '0');
                    end case;
                  when 8 =>
                    b3_read_data_6 <= conv_std_logic_vector(conv_integer(storage_output_port_buf_read_field_rdata), b3_read_data_6'length);
                    state_counter_read_data_read_data_6 <= state_counter_read_data_read_data_6 + 1;
                  when 9 =>
                    send_buf_waddr_field_wdata_writer_state_counter_read_data_read_data_6 <= conv_std_logic_vector((conv_integer((31 downto (31-2+1) => i_read_data_5(31)) & i_read_data_5(31 downto 2))), send_buf_waddr_field_wdata'length);
                    send_buf_we_field_wdata_writer_state_counter_read_data_read_data_6 <= conv_std_logic_vector(1, send_buf_we_field_wdata'length);
                    send_buf_wdata_field_wdata_writer_state_counter_read_data_read_data_6 <= conv_std_logic_vector((conv_integer(conv_std_logic_vector((conv_integer(b0_read_data_6(31 - 24 downto 0) & conv_std_logic_vector(0, 24))), 32) and conv_std_logic_vector(-16777216, 32))) + (conv_integer(conv_std_logic_vector((conv_integer(b1_read_data_6(31 - 16 downto 0) & conv_std_logic_vector(0, 16))), 32) and conv_std_logic_vector(16711680, 32))) + (conv_integer(conv_std_logic_vector((conv_integer(b2_read_data_6(31 - 8 downto 0) & conv_std_logic_vector(0, 8))), 32) and conv_std_logic_vector(65280, 32))) + (conv_integer(conv_std_logic_vector((conv_integer(b3_read_data_6(31 - 0 downto 0) & conv_std_logic_vector(0, 0))), 32) and conv_std_logic_vector(255, 32))), send_buf_wdata_field_wdata'length);
                    state_counter_read_data_read_data_5 <= state_counter_read_data_read_data_5 + 1;
                    state_counter_read_data_read_data_6 <= (others => '0');
                  when others => state_counter_read_data_read_data_6 <= (others => '0');
                end case;
              when 4 =>
                  i_read_data_5 <= conv_std_logic_vector(conv_integer(i_read_data_5) + 4, i_read_data_5'length);
                  state_counter_read_data_read_data_5 <= conv_std_logic_vector(2, 32);
              when others => state_counter_read_data_read_data_5 <= (others => '0');
            end case;
          when 7 => 
            this_output_port_read_data <= conv_std_logic_vector((conv_integer((31 downto (31-2+1) => l_read_data_0(31)) & l_read_data_0(31 downto 2))), this_output_port_read_data'length);
            read_data_method_state <= (others => '0');
          when 8 =>
            this_read_data_method_busy <= '0';
            read_data_method_state <= (others => '0');
          when others => read_data_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --read_data
end RTL;
