
import net.wasamon.javarock.libraries.VHDLSimpleLibrary;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLGenericParameter;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;

public class M25P40_BUF_WRAPPER extends VHDLSimpleLibrary implements JavaRockComponentIface{

  public byte[] data;

  public boolean req;
  public boolean busy;
  public byte command;
  public int addr;
  public int length;

  public M25P40_BUF_WRAPPER(String... args){
    super("vhdl_m25p40_buf_wrapper", args);

    ports.add(new VHDLPort(this, "clk",     VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "reset",   VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));

    ports.add(new VHDLPort(this, "M25P40_C",   VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.OUT,  VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "M25P40_DQ0", VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.OUT, VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "M25P40_DQ1", VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN,  VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "M25P40_S",   VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.OUT,  VHDLPort.Kind.EXTERNAL));

    ports.add(new VHDLPort(this, "req",     VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "busy",    VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.OUT));
    ports.add(new VHDLPort(this, "command", VHDLTypeBuilder.getStdLogicVector( 7, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "addr",    VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "length",  VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));

    ports.add(new VHDLPort(this, "data_waddr", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "data_wdata", VHDLTypeBuilder.getStdLogicVector( 7, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "data_we",    VHDLTypeBuilder.getStdLogicVector(0, 0),  VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "data_raddr", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "data_rdata", VHDLTypeBuilder.getStdLogicVector( 7, 0), VHDLPort.Dir.OUT));

    
  }


}

