
import net.wasamon.javarock.rt.*;

@javarockhdl
public class FPGAMain{

  private final M25P40IF storage = new M25P40IF();
  private final UDP_TX udp_tx = new UDP_TX();
  private final UDP_RX udp_rx = new UDP_RX();

  private int src_ip, src_port, dest_ip, dest_port, data_length;
  private int[] recv_buf = new int[1024];
  private int[] send_buf = new int[1024];

  public static final int COMMAND_READ  = 1;
  public static final int COMMAND_WRITE = 2;
  public static final int COMMAND_ERASE = 3;

  private void recv(){
    while (udp_rx.valid == false) ;
    udp_rx.read_flag = true;
    src_ip      = udp_rx.src_ip;
    src_port    = udp_rx.src_port;
    dest_ip     = udp_rx.dest_ip;
    dest_port   = udp_rx.dest_port;
    data_length = udp_rx.data_length;
    for(int i = 0; i < data_length; i++){
      int v = udp_rx.data[i];
      recv_buf[i] = v;
    }
    udp_rx.read_flag = false;
  }

  private void send(int len){
    udp_tx.dest_ip     = src_ip;
    udp_tx.dest_port   = src_port;
    udp_tx.src_ip      = dest_ip;
    udp_tx.src_port    = dest_port;
    udp_tx.data_length = len;
    for(int i = 0; i < len; i++){
      udp_tx.data[i] = send_buf[i];
    }
    while (udp_tx.busy == true) ;
    udp_tx.start = true;
    udp_tx.start = false;
  }

  private int read_data(int addr, int len){
    int l = len;
    if(l > 256) l = 256;
    if((l & 0x03) != 0) l = (l & 0x000001FC) + 1;
    storage.read_bytes(addr, l);
    for(int i = 0; i < l; i = i + 4){
      int b0, b1, b2, b3;
      b0 = (int)storage.buf_read(i+0);
      b1 = (int)storage.buf_read(i+1);
      b2 = (int)storage.buf_read(i+2);
      b3 = (int)storage.buf_read(i+3);
      send_buf[(i>>2)] = ((b0 << 24) & 0xFF000000)
      	          + ((b1 << 16) & 0x00FF0000)
      	          + ((b2 <<  8) & 0x0000FF00)
	          + ((b3 <<  0) & 0x000000FF);
      //send_buf[i] = 0xDEADBEAF;
    }
    return (l>>2);
  }

  private int write_data(int addr, int len){
    int l = len;
    if(l > 256) l = 256;
    if((l & 0x03) != 0) l = (l & 0x000001FC) + 1;
    for(int i = 0; i < (l>>2); i++){
      int v = recv_buf[i+3];
      storage.buf_write((i<<2)+0, (byte)((v >> 24) & 0x000000FF));
      storage.buf_write((i<<2)+1, (byte)((v >> 16) & 0x000000FF));
      storage.buf_write((i<<2)+2, (byte)((v >>  8) & 0x000000FF));
      storage.buf_write((i<<2)+3, (byte)((v >>  0) & 0x000000FF));
    }
    storage.page_program(addr, l);
    return l;
  }

  @auto
  public void main(){
    while(true){
      recv();
      int command = recv_buf[0];
      int addr    = recv_buf[1];
      int len     = recv_buf[2];
      switch(command){
      case COMMAND_READ:
	len = read_data(addr, len);
	break;
      case COMMAND_WRITE:
	len = write_data(addr, len);
	send_buf[0] = len;
	len = 1;
	break;
      case COMMAND_ERASE:
	storage.sector_erase(addr);
	send_buf[0] = 1;
	len = 1;
	break;
      default:
	send_buf[0] = -1;
	len = 1;
	break;
      }
      send(len);
    }
  }


}