library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;
 
entity udp_tx_wrapper is
    port (
      clk          : IN  std_logic;
      reset        : IN  std_logic;
      UPL_OUT_Data : OUT std_logic_vector(31 downto 0);
      UPL_OUT_Req  : OUT std_logic;
      UPL_OUT_Ack  : IN  std_logic;
      UPL_OUT_En   : OUT std_logic;
      data_length  : IN  std_logic_vector(31 downto 0);
      start        : IN  std_logic;
      busy         : OUT std_logic;
      data_waddr   : IN  std_logic_vector(31 downto 0);
      data_wdata   : IN  std_logic_vector(31 downto 0);
      data_we      : IN  std_logic_vector(0 downto 0);
      dest_ip      : IN  std_logic_vector(31 downto 0);
      dest_port    : IN  std_logic_vector(15 downto 0);
      src_ip       : IN  std_logic_vector(31 downto 0);
      src_port     : IN  std_logic_vector(15 downto 0)
    );
end udp_tx_wrapper;

architecture RTL of udp_tx_wrapper is

  component upl_tx
    generic (
      DATA_WIDTH : integer := 32;
      DATA_DEPTH : integer := 12
      );
    port (
      pReset_n : in std_logic;
      pUPLGlobalClk : in std_logic;
      
      -- UPLに出力する
      pO0Data    : out std_logic_vector(31 downto 0 );
      pO0Request : out std_logic;
      pO0Ack     : in  std_logic;
      pO0En      : out std_logic;
      
      pMemWriteData: in std_logic_vector(DATA_WIDTH-1 downto 0);
      pMemWriteAddr: in std_logic_vector(DATA_DEPTH-1 downto 0);
      pMemWriteEn  : in std_logic_vector(0 downto 0);

      pStart : in  std_logic;
      pBusy  : out std_logic;
      pDataLength : in std_logic_vector(31 downto 0);

      pSrcIPAddr  : in std_logic_vector(31 downto 0);
      pDestIPAddr : in std_logic_vector(31 downto 0);
      pSrcPort    : in std_logic_vector(15 downto 0);
      pDestPort   : in std_logic_vector(15 downto 0);

      pDebugA : out std_logic_vector( 7 downto 0 )
      );
  end component;

  signal reset_n : std_logic;

begin  -- RTL

  reset_n <= not reset;

  U: upl_tx
    generic map(
      DATA_WIDTH => 32,
      DATA_DEPTH => 12
      )
    port map(
      pReset_n      => reset_n,
      pUPLGlobalClk => clk,
      pO0Data    => UPL_OUT_Data,
      pO0Request => UPL_OUT_Req,
      pO0Ack     => UPL_OUT_Ack,
      pO0En      => UPL_OUT_En,
      pMemWriteData => data_wdata,
      pMemWriteAddr => data_waddr(11 downto 0),
      pMemWriteEn   => data_we,
      pStart => start,
      pBusy  => busy,
      pDataLength => data_length,
      pSrcIPAddr  => src_ip,
      pDestIPAddr => dest_ip,
      pSrcPort    => src_port,
      pDestPort   => dest_port,
      pDebugA => open
      );
  
end RTL;
