import net.wasamon.javarock.libraries.VHDLSimpleLibrary;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLGenericParameter;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;

public class UPL32_RX extends VHDLSimpleLibrary implements JavaRockComponentIface{

  public int recv_length;
  public int[] data;

  public boolean valid;
  public boolean read_flag;

  public UPL32_RX(String... args){
    super("vhdl_upl32_rx_wrapper", args);

    ports.add(new VHDLPort(this, "clk",     VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "reset",   VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));

    ports.add(new VHDLPort(this, "UPL_IN_Data", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN,  VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "UPL_IN_Req",  VHDLTypeBuilder.getStdLogic(),           VHDLPort.Dir.IN,  VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "UPL_IN_Ack",  VHDLTypeBuilder.getStdLogic(),           VHDLPort.Dir.OUT, VHDLPort.Kind.EXTERNAL));
    ports.add(new VHDLPort(this, "UPL_IN_En",   VHDLTypeBuilder.getStdLogic(),           VHDLPort.Dir.IN,  VHDLPort.Kind.EXTERNAL));

    ports.add(new VHDLPort(this, "data_raddr", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "data_rdata", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.OUT));
    ports.add(new VHDLPort(this, "valid", VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.OUT));
    ports.add(new VHDLPort(this, "read_flag", VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "recv_length", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.OUT));
    
  }


}
