public class M25P40IF{

  private final M25P40_BUF_WRAPPER rom = new M25P40_BUF_WRAPPER();

  public static final int WRITE_ENABLE                    = 0x06;
  public static final int WRITE_DISABLE                   = 0x04;
  public static final int READ_IDENTIFICATION             = 0x9F;
  public static final int READ_STATUS_REGISTER            = 0x05;
  public static final int WRITE_STATUS_REGISTER           = 0x01;
  public static final int READ_DATA_BYTES                 = 0x03;
  public static final int READ_DATA_BYTES_AT_HIGHER_SPEED = 0x0B;
  public static final int PAGE_PROGRAM                    = 0x02;
  public static final int SECTOR_ERASE                    = 0xD8;
  public static final int BULK_ERASE                      = 0xC7;
  public static final int DEEP_POWER_DOWN                 = 0xB9;
  public static final int RELEASE_FROM_DEEP_POWER_DOWN    = 0xAB;

  public void buf_write(int index, byte data){
    rom.data[index] = data;
  }

  public byte buf_read(int index){
    byte v = rom.data[index];
    return v;
  }

  private void emit_command(int command, int addr, int length){
    rom.command = (byte)command;
    rom.addr = addr;
    rom.length = length;
    while(rom.busy == true){ ; }
    rom.req = true;
    rom.req = false;
    while(rom.busy == true){ ; }
    return;
  }

  private void wait_wip(){
    while(true){
      emit_command(READ_STATUS_REGISTER, 0, 0);
      int v = rom.data[0];
      if((v & 0x00000001) == 0) break;
    }
    return;
  }

  public void sector_erase(int addr){
    emit_command(WRITE_ENABLE, 0, 0);
    emit_command(SECTOR_ERASE, addr, 0);
    wait_wip();
  }

  public void page_program(int addr, int length){
    emit_command(WRITE_ENABLE, 0, 0);
    emit_command(PAGE_PROGRAM, addr, length);
    wait_wip();
  }

  public void read_bytes(int addr, int length){
    emit_command(READ_DATA_BYTES, addr, length);
  }

}
