/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import openjdk.com.sun.tools.javac.util.List;

public class ListBuffer<A>
extends AbstractQueue<A> {
    public List<A> elems;
    public List<A> last;
    public int count;
    public boolean shared;

    public static <T> ListBuffer<T> lb() {
        return new ListBuffer();
    }

    public static <T> ListBuffer<T> of(T x) {
        ListBuffer<T> lb = new ListBuffer<T>();
        lb.add(x);
        return lb;
    }

    public ListBuffer() {
        this.clear();
    }

    @Override
    public final void clear() {
        this.elems = new List<Object>(null, null);
        this.last = this.elems;
        this.count = 0;
        this.shared = false;
    }

    public int length() {
        return this.count;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean nonEmpty() {
        return this.count != 0;
    }

    private void copy() {
        List tail;
        this.elems = new List(this.elems.head, this.elems.tail);
        List p = this.elems;
        while ((tail = p.tail) != null) {
            tail = new List(tail.head, tail.tail);
            p.setTail(tail);
            p = tail;
        }
        this.last = p;
        this.shared = false;
    }

    public ListBuffer<A> prepend(A x) {
        this.elems = this.elems.prepend(x);
        ++this.count;
        return this;
    }

    public ListBuffer<A> append(A x) {
        x.getClass();
        if (this.shared) {
            this.copy();
        }
        this.last.head = x;
        this.last.setTail(new List<Object>(null, null));
        this.last = this.last.tail;
        ++this.count;
        return this;
    }

    public ListBuffer<A> appendList(List<A> xs) {
        while (xs.nonEmpty()) {
            this.append(xs.head);
            xs = xs.tail;
        }
        return this;
    }

    public ListBuffer<A> appendList(ListBuffer<A> xs) {
        return this.appendList(xs.toList());
    }

    public ListBuffer<A> appendArray(A[] xs) {
        int i = 0;
        while (i < xs.length) {
            this.append(xs[i]);
            ++i;
        }
        return this;
    }

    public List<A> toList() {
        this.shared = true;
        return this.elems;
    }

    @Override
    public boolean contains(Object x) {
        return this.elems.contains(x);
    }

    @Override
    public <T> T[] toArray(T[] vec) {
        return this.elems.toArray(vec);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public A first() {
        return this.elems.head;
    }

    public A next() {
        Object x = this.elems.head;
        if (this.elems != this.last) {
            this.elems = this.elems.tail;
            --this.count;
        }
        return x;
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            List<A> elems;
            {
                this.elems = ListBuffer.this.elems;
            }

            @Override
            public boolean hasNext() {
                return this.elems != ListBuffer.this.last;
            }

            @Override
            public A next() {
                if (this.elems == ListBuffer.this.last) {
                    throw new NoSuchElementException();
                }
                Object elem = this.elems.head;
                this.elems = this.elems.tail;
                return elem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(A a) {
        this.append(a);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object x : c) {
            if (this.contains(x)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends A> c) {
        for (A a : c) {
            this.append(a);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(A a) {
        this.append(a);
        return true;
    }

    @Override
    public A poll() {
        return this.next();
    }

    @Override
    public A peek() {
        return this.first();
    }
}

