/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.classfile;

import java.io.IOException;
import openjdk.com.sun.tools.classfile.Attribute;
import openjdk.com.sun.tools.classfile.AttributeException;
import openjdk.com.sun.tools.classfile.ClassReader;

public class BootstrapMethods_attribute
extends Attribute {
    public final BootstrapMethodSpecifier[] bootstrap_method_specifiers;

    BootstrapMethods_attribute(ClassReader cr, int name_index, int length) throws IOException, AttributeException {
        super(name_index, length);
        int bootstrap_method_count = cr.readUnsignedShort();
        this.bootstrap_method_specifiers = new BootstrapMethodSpecifier[bootstrap_method_count];
        int i = 0;
        while (i < this.bootstrap_method_specifiers.length) {
            this.bootstrap_method_specifiers[i] = new BootstrapMethodSpecifier(cr);
            ++i;
        }
    }

    public BootstrapMethods_attribute(int name_index, BootstrapMethodSpecifier[] bootstrap_method_specifiers) {
        super(name_index, BootstrapMethods_attribute.length(bootstrap_method_specifiers));
        this.bootstrap_method_specifiers = bootstrap_method_specifiers;
    }

    public static int length(BootstrapMethodSpecifier[] bootstrap_method_specifiers) {
        int n = 2;
        BootstrapMethodSpecifier[] bootstrapMethodSpecifierArray = bootstrap_method_specifiers;
        int n2 = bootstrap_method_specifiers.length;
        int n3 = 0;
        while (n3 < n2) {
            BootstrapMethodSpecifier b = bootstrapMethodSpecifierArray[n3];
            n += b.length();
            ++n3;
        }
        return n;
    }

    public <R, P> R accept(Attribute.Visitor<R, P> visitor, P p) {
        return visitor.visitBootstrapMethods(this, p);
    }

    public static class BootstrapMethodSpecifier {
        public int bootstrap_method_ref;
        public int[] bootstrap_arguments;

        public BootstrapMethodSpecifier(int bootstrap_method_ref, int[] bootstrap_arguments) {
            this.bootstrap_method_ref = bootstrap_method_ref;
            this.bootstrap_arguments = bootstrap_arguments;
        }

        BootstrapMethodSpecifier(ClassReader cr) throws IOException {
            this.bootstrap_method_ref = cr.readUnsignedShort();
            int method_count = cr.readUnsignedShort();
            this.bootstrap_arguments = new int[method_count];
            int i = 0;
            while (i < this.bootstrap_arguments.length) {
                this.bootstrap_arguments[i] = cr.readUnsignedShort();
                ++i;
            }
        }

        int length() {
            return 4 + this.bootstrap_arguments.length * 2;
        }
    }
}

