/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLLiteral;
import net.wasamon.javarock.model.vhdl.VHDLNewArray;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLVariable;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;

public class VHDLSignal
extends VHDLVariable
implements VHDLItem {
    VHDLProcess process = null;

    public VHDLSignal(JavaRockComponentIface m, String name, JavaRockType type) {
        this(m, name, type, null);
    }

    public VHDLSignal(JavaRockComponentIface m, String name, JavaRockType type, VHDLExpr reset) {
        super(m, name, type, reset);
    }

    protected String getResetExpr() {
        String s = "";
        if (this.reset == null && this.type != null && this.type.getDefaultValue() != null) {
            s = String.valueOf(s) + this.type.getDefaultValue();
        } else if (this.reset != null && this.reset instanceof VHDLLiteral) {
            s = ((VHDLLiteral)this.reset).val.equals("true") ? String.valueOf(s) + "'1'" : (((VHDLLiteral)this.reset).val.equals("false") ? String.valueOf(s) + "'0'" : (this.type instanceof StdLogicVector ? String.valueOf(s) + String.format("conv_std_logic_vector(%s, %s-%s+1)", this.reset, ((StdLogicVector)this.type).begin, ((StdLogicVector)this.type).end) : String.valueOf(s) + this.reset));
        } else if (this.reset != null && this.reset instanceof VHDLNewArray) {
            return "";
        }
        return s;
    }

    public String getResetStmt() {
        String s = "";
        if (this.reset == null && this.type != null && this.type.getDefaultValue() != null) {
            s = String.valueOf(s) + this.name;
            s = String.valueOf(s) + " <= ";
            s = String.valueOf(s) + this.getResetExpr();
        } else if (this.reset != null && this.reset instanceof VHDLLiteral) {
            s = String.valueOf(s) + this.name;
            s = String.valueOf(s) + " <= ";
            s = String.valueOf(s) + this.getResetExpr();
        } else {
            if (this.reset != null && this.reset instanceof VHDLNewArray) {
                return "";
            }
            if (this.reset != null) {
                s = String.valueOf(s) + this.reset;
            } else if (this.reset == null) {
                return "";
            }
        }
        s = String.valueOf(s) + ";";
        return s;
    }

    public String toString() {
        if (this.reset != null && this.reset instanceof VHDLLiteral) {
            if (((VHDLLiteral)this.reset).val.equals("true")) {
                return String.format("signal %s : %s := %s;", this.name, this.type, "'1'");
            }
            if (((VHDLLiteral)this.reset).val.equals("false")) {
                return String.format("signal %s : %s := %s;", this.name, this.type, "'0'");
            }
            if (this.type instanceof StdLogicVector) {
                String r = String.format("conv_std_logic_vector(%s, %s-%s+1)", this.reset, ((StdLogicVector)this.type).begin, ((StdLogicVector)this.type).end);
                return String.format("signal %s : %s := %s;", this.name, this.type, r);
            }
        }
        if (this.type != null && this.type.getDefaultValue() != null && !this.type.getDefaultValue().equals("")) {
            return String.format("signal %s : %s := %s;", this.name, this.type, this.type.getDefaultValue());
        }
        return String.format("signal %s : %s;", this.name, this.type);
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        String[] list;
        String[] stringArray = list = this.toString().split("\n");
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.writeln(out, s, offset);
            ++n2;
        }
    }

    @Override
    public void connect() {
        if (this.reset != null) {
            this.reset.connect();
        }
    }

    @Override
    public void link() {
    }

    public boolean hasResetProcess() {
        return this.process != null;
    }

    public void setResetProcess(VHDLProcess p) {
        if (this.process == null) {
            this.process = p;
        }
    }
}

