/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.wasamon.javarock.model.vhdl.VHDLFor;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.VHDLWhile;

public class VHDLContinue
extends VHDLStatement
implements VHDLItem {
    final VHDLProcess process;
    final VHDLScopeIface scope;

    public VHDLContinue(VHDLProcess process, VHDLScopeIface scope) {
        this.process = process;
        this.scope = scope;
    }

    @Override
    public void connect() {
    }

    @Override
    public void link() {
        super.link();
    }

    @Override
    public int state_count() {
        return 1;
    }

    @Override
    public boolean isStepNext() {
        return true;
    }

    @Override
    public boolean isEndOfState() {
        return true;
    }

    @Override
    public boolean isSkip() {
        return false;
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        VHDLScopeIface s = this.scope;
        while (!(s instanceof VHDLWhile) && !(s instanceof VHDLFor)) {
            this.writeln(out, String.format("%s <= (others => '0');", s.get_state_sig().value()), offset);
            s = s.getParent();
        }
        if (s instanceof VHDLWhile) {
            this.writeln(out, String.format("%s <= (others => '0');", s.get_state_sig().value()), offset);
        } else if (s instanceof VHDLFor) {
            for (VHDLStatement stmt : ((VHDLFor)s).step) {
                stmt.generate(out, offset);
            }
            this.writeln(out, String.format("%s <= conv_std_logic_vector(1, 32);", s.get_state_sig().value()), offset);
        }
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        return null;
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        return null;
    }
}

