/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.processing;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor7;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class PrintingProcessor
extends AbstractProcessor {
    PrintWriter writer = new PrintWriter(System.out);

    public void setWriter(Writer w) {
        this.writer = new PrintWriter(w);
    }

    @Override
    public boolean process(Set<? extends TypeElement> tes, RoundEnvironment renv) {
        for (Element element : renv.getRootElements()) {
            this.print(element);
        }
        return true;
    }

    void print(Element element) {
        ((PrintingElementVisitor)new PrintingElementVisitor(this.writer, this.processingEnv.getElementUtils()).visit(element)).flush();
    }

    public static class PrintingElementVisitor
    extends SimpleElementVisitor7<PrintingElementVisitor, Boolean> {
        int indentation;
        final PrintWriter writer;
        final Elements elementUtils;
        private static final String[] spaces = new String[]{"", "  ", "    ", "      ", "        ", "          ", "            ", "              ", "                ", "                  ", "                    "};

        public PrintingElementVisitor(Writer w, Elements elementUtils) {
            this.writer = new PrintWriter(w);
            this.elementUtils = elementUtils;
            this.indentation = 0;
        }

        @Override
        protected PrintingElementVisitor defaultAction(Element e, Boolean newLine) {
            if (newLine != null && newLine.booleanValue()) {
                this.writer.println();
            }
            this.printDocComment(e);
            this.printModifiers(e);
            return this;
        }

        @Override
        public PrintingElementVisitor visitExecutable(ExecutableElement e, Boolean p) {
            ElementKind kind = e.getKind();
            if (kind != ElementKind.STATIC_INIT && kind != ElementKind.INSTANCE_INIT) {
                Element enclosing = e.getEnclosingElement();
                if (kind == ElementKind.CONSTRUCTOR && enclosing != null && NestingKind.ANONYMOUS == new SimpleElementVisitor7<NestingKind, Void>(){

                    @Override
                    public NestingKind visitType(TypeElement e, Void p) {
                        return e.getNestingKind();
                    }
                }.visit(enclosing)) {
                    return this;
                }
                this.defaultAction((Element)e, true);
                this.printFormalTypeParameters(e, true);
                switch (kind) {
                    case CONSTRUCTOR: {
                        this.writer.print(e.getEnclosingElement().getSimpleName());
                        break;
                    }
                    case METHOD: {
                        this.writer.print(e.getReturnType().toString());
                        this.writer.print(" ");
                        this.writer.print(e.getSimpleName().toString());
                    }
                }
                this.writer.print("(");
                this.printParameters(e);
                this.writer.print(")");
                AnnotationValue defaultValue = e.getDefaultValue();
                if (defaultValue != null) {
                    this.writer.print(" default " + defaultValue);
                }
                this.printThrows(e);
                this.writer.println(";");
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PrintingElementVisitor visitType(TypeElement e, Boolean p) {
            ElementKind kind = e.getKind();
            NestingKind nestingKind = e.getNestingKind();
            if (NestingKind.ANONYMOUS == nestingKind) {
                List<ExecutableElement> constructors;
                this.writer.print("new ");
                List<? extends TypeMirror> list = e.getInterfaces();
                if (!list.isEmpty()) {
                    this.writer.print(list.get(0));
                } else {
                    this.writer.print(e.getSuperclass());
                }
                this.writer.print("(");
                if (list.isEmpty() && !(constructors = ElementFilter.constructorsIn(e.getEnclosedElements())).isEmpty()) {
                    this.printParameters(constructors.get(0));
                }
                this.writer.print(")");
            } else {
                TypeElement e2;
                TypeMirror typeMirror;
                PackageElement packageElement;
                if (nestingKind == NestingKind.TOP_LEVEL && !(packageElement = this.elementUtils.getPackageOf(e)).isUnnamed()) {
                    this.writer.print("package " + packageElement.getQualifiedName() + ";\n");
                }
                this.defaultAction((Element)e, true);
                switch (kind) {
                    case ANNOTATION_TYPE: {
                        this.writer.print("@interface");
                        break;
                    }
                    default: {
                        this.writer.print(kind.toString().toLowerCase());
                    }
                }
                this.writer.print(" ");
                this.writer.print(e.getSimpleName());
                this.printFormalTypeParameters(e, false);
                if (kind == ElementKind.CLASS && (typeMirror = e.getSuperclass()).getKind() != TypeKind.NONE && (e2 = (TypeElement)((DeclaredType)typeMirror).asElement()).getSuperclass().getKind() != TypeKind.NONE) {
                    this.writer.print(" extends " + typeMirror);
                }
                this.printInterfaces(e);
            }
            this.writer.println(" {");
            ++this.indentation;
            if (kind == ElementKind.ENUM) {
                ArrayList<? extends Element> arrayList = new ArrayList<Element>(e.getEnclosedElements());
                ArrayList<Element> enumConstants = new ArrayList<Element>();
                for (Element element : arrayList) {
                    if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
                    enumConstants.add(element);
                }
                if (!enumConstants.isEmpty()) {
                    void var7_17;
                    boolean bl = false;
                    while (var7_17 < enumConstants.size() - 1) {
                        this.visit((Element)enumConstants.get((int)var7_17), true);
                        this.writer.print(",");
                        ++var7_17;
                    }
                    this.visit((Element)enumConstants.get((int)var7_17), true);
                    this.writer.println(";\n");
                    arrayList.removeAll(enumConstants);
                }
                for (Element element : arrayList) {
                    this.visit(element);
                }
            } else {
                for (Element element : e.getEnclosedElements()) {
                    this.visit(element);
                }
            }
            --this.indentation;
            this.indent();
            this.writer.println("}");
            return this;
        }

        @Override
        public PrintingElementVisitor visitVariable(VariableElement e, Boolean newLine) {
            ElementKind kind = e.getKind();
            this.defaultAction((Element)e, newLine);
            if (kind == ElementKind.ENUM_CONSTANT) {
                this.writer.print(e.getSimpleName());
            } else {
                this.writer.print(String.valueOf(e.asType().toString()) + " " + e.getSimpleName());
                Object constantValue = e.getConstantValue();
                if (constantValue != null) {
                    this.writer.print(" = ");
                    this.writer.print(this.elementUtils.getConstantExpression(constantValue));
                }
                this.writer.println(";");
            }
            return this;
        }

        @Override
        public PrintingElementVisitor visitTypeParameter(TypeParameterElement e, Boolean p) {
            this.writer.print(e.getSimpleName());
            return this;
        }

        @Override
        public PrintingElementVisitor visitPackage(PackageElement e, Boolean p) {
            this.defaultAction((Element)e, false);
            if (!e.isUnnamed()) {
                this.writer.println("package " + e.getQualifiedName() + ";");
            } else {
                this.writer.println("// Unnamed package");
            }
            return this;
        }

        public void flush() {
            this.writer.flush();
        }

        private void printDocComment(Element e) {
            String docComment = this.elementUtils.getDocComment(e);
            if (docComment != null) {
                StringTokenizer st = new StringTokenizer(docComment, "\n\r");
                this.indent();
                this.writer.println("/**");
                while (st.hasMoreTokens()) {
                    this.indent();
                    this.writer.print(" *");
                    this.writer.println(st.nextToken());
                }
                this.indent();
                this.writer.println(" */");
            }
        }

        private void printModifiers(Element e) {
            ElementKind kind = e.getKind();
            if (kind == ElementKind.PARAMETER) {
                this.printAnnotationsInline(e);
            } else {
                this.printAnnotations(e);
                this.indent();
            }
            if (kind == ElementKind.ENUM_CONSTANT) {
                return;
            }
            LinkedHashSet<Modifier> modifiers = new LinkedHashSet<Modifier>();
            modifiers.addAll(e.getModifiers());
            switch (kind) {
                case ANNOTATION_TYPE: 
                case INTERFACE: {
                    modifiers.remove((Object)Modifier.ABSTRACT);
                    break;
                }
                case ENUM: {
                    modifiers.remove((Object)Modifier.FINAL);
                    modifiers.remove((Object)Modifier.ABSTRACT);
                    break;
                }
                case FIELD: 
                case METHOD: {
                    Element enclosingElement = e.getEnclosingElement();
                    if (enclosingElement == null || !enclosingElement.getKind().isInterface()) break;
                    modifiers.remove((Object)Modifier.PUBLIC);
                    modifiers.remove((Object)Modifier.ABSTRACT);
                    modifiers.remove((Object)Modifier.STATIC);
                    modifiers.remove((Object)Modifier.FINAL);
                }
            }
            for (Modifier m : modifiers) {
                this.writer.print(String.valueOf(m.toString()) + " ");
            }
        }

        private void printFormalTypeParameters(Parameterizable e, boolean pad) {
            List<? extends TypeParameterElement> typeParams = e.getTypeParameters();
            if (typeParams.size() > 0) {
                this.writer.print("<");
                boolean first = true;
                for (TypeParameterElement typeParameterElement : typeParams) {
                    if (!first) {
                        this.writer.print(", ");
                    }
                    this.printAnnotationsInline(typeParameterElement);
                    this.writer.print(typeParameterElement.toString());
                    first = false;
                }
                this.writer.print(">");
                if (pad) {
                    this.writer.print(" ");
                }
            }
        }

        private void printAnnotationsInline(Element e) {
            List<? extends AnnotationMirror> annots = e.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annots) {
                this.writer.print(annotationMirror);
                this.writer.print(" ");
            }
        }

        private void printAnnotations(Element e) {
            List<? extends AnnotationMirror> annots = e.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annots) {
                this.indent();
                this.writer.println(annotationMirror);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void printParameters(ExecutableElement e) {
            List<? extends VariableElement> parameters = e.getParameters();
            int size = parameters.size();
            switch (size) {
                case 0: {
                    break;
                }
                case 1: {
                    for (VariableElement variableElement : parameters) {
                        this.printModifiers(variableElement);
                        if (e.isVarArgs()) {
                            TypeMirror tm = variableElement.asType();
                            if (tm.getKind() != TypeKind.ARRAY) {
                                throw new AssertionError((Object)("Var-args parameter is not an array type: " + tm));
                            }
                            this.writer.print(((ArrayType)ArrayType.class.cast(tm)).getComponentType());
                            this.writer.print("...");
                        } else {
                            this.writer.print(variableElement.asType());
                        }
                        this.writer.print(" " + variableElement.getSimpleName());
                    }
                    break;
                }
                default: {
                    boolean bl = true;
                    for (VariableElement variableElement : parameters) {
                        void var4_8;
                        if (var4_8 == 2) {
                            ++this.indentation;
                        }
                        if (var4_8 > true) {
                            this.indent();
                        }
                        this.printModifiers(variableElement);
                        if (var4_8 == size && e.isVarArgs()) {
                            TypeMirror tm = variableElement.asType();
                            if (tm.getKind() != TypeKind.ARRAY) {
                                throw new AssertionError((Object)("Var-args parameter is not an array type: " + tm));
                            }
                            this.writer.print(((ArrayType)ArrayType.class.cast(tm)).getComponentType());
                            this.writer.print("...");
                        } else {
                            this.writer.print(variableElement.asType());
                        }
                        this.writer.print(" " + variableElement.getSimpleName());
                        if (var4_8 < size) {
                            this.writer.println(",");
                        }
                        ++var4_8;
                    }
                    if (parameters.size() < 2) break;
                    --this.indentation;
                }
            }
        }

        private void printInterfaces(TypeElement e) {
            List<? extends TypeMirror> interfaces;
            ElementKind kind = e.getKind();
            if (kind != ElementKind.ANNOTATION_TYPE && (interfaces = e.getInterfaces()).size() > 0) {
                this.writer.print(kind.isClass() ? " implements" : " extends");
                boolean first = true;
                for (TypeMirror typeMirror : interfaces) {
                    if (!first) {
                        this.writer.print(",");
                    }
                    this.writer.print(" ");
                    this.writer.print(typeMirror.toString());
                    first = false;
                }
            }
        }

        private void printThrows(ExecutableElement e) {
            List<? extends TypeMirror> thrownTypes = e.getThrownTypes();
            int size = thrownTypes.size();
            if (size != 0) {
                this.writer.print(" throws");
                int i = 1;
                for (TypeMirror typeMirror : thrownTypes) {
                    if (i == 1) {
                        this.writer.print(" ");
                    }
                    if (i == 2) {
                        ++this.indentation;
                    }
                    if (i >= 2) {
                        this.indent();
                    }
                    this.writer.print(typeMirror);
                    if (i != size) {
                        this.writer.println(", ");
                    }
                    ++i;
                }
                if (size >= 2) {
                    --this.indentation;
                }
            }
        }

        private void indent() {
            int indentation = this.indentation;
            if (indentation < 0) {
                return;
            }
            int maxIndex = spaces.length - 1;
            while (indentation > maxIndex) {
                this.writer.print(spaces[maxIndex]);
                indentation -= maxIndex;
            }
            this.writer.print(spaces[indentation]);
        }
    }
}

