/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.parser;

import java.nio.CharBuffer;
import openjdk.com.sun.tools.javac.code.Source;
import openjdk.com.sun.tools.javac.parser.DocCommentScanner;
import openjdk.com.sun.tools.javac.parser.Keywords;
import openjdk.com.sun.tools.javac.parser.Scanner;
import openjdk.com.sun.tools.javac.util.Context;
import openjdk.com.sun.tools.javac.util.Log;
import openjdk.com.sun.tools.javac.util.Names;

public class ScannerFactory {
    public static final Context.Key<ScannerFactory> scannerFactoryKey = new Context.Key();
    final Log log;
    final Names names;
    final Source source;
    final Keywords keywords;

    public static ScannerFactory instance(Context context) {
        ScannerFactory instance = context.get(scannerFactoryKey);
        if (instance == null) {
            instance = new ScannerFactory(context);
        }
        return instance;
    }

    protected ScannerFactory(Context context) {
        context.put(scannerFactoryKey, this);
        this.log = Log.instance(context);
        this.names = Names.instance(context);
        this.source = Source.instance(context);
        this.keywords = Keywords.instance(context);
    }

    public Scanner newScanner(CharSequence input, boolean keepDocComments) {
        if (input instanceof CharBuffer) {
            CharBuffer buf = (CharBuffer)input;
            if (keepDocComments) {
                return new DocCommentScanner(this, buf);
            }
            return new Scanner(this, buf);
        }
        char[] array = input.toString().toCharArray();
        return this.newScanner(array, array.length, keepDocComments);
    }

    public Scanner newScanner(char[] input, int inputLength, boolean keepDocComments) {
        if (keepDocComments) {
            return new DocCommentScanner(this, input, inputLength);
        }
        return new Scanner(this, input, inputLength);
    }
}

