/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.util;

import java.util.BitSet;

public class Position {
    public static final int NOPOS = -1;
    public static final int FIRSTPOS = 0;
    public static final int FIRSTLINE = 1;
    public static final int FIRSTCOLUMN = 1;
    public static final int LINESHIFT = 10;
    public static final int MAXCOLUMN = 1023;
    public static final int MAXLINE = 0x3FFFFF;
    public static final int MAXPOS = Integer.MAX_VALUE;

    private Position() {
    }

    public static LineMap makeLineMap(char[] src, int max, boolean expandTabs) {
        LineMapImpl lineMap = expandTabs ? new LineTabMapImpl(max) : new LineMapImpl();
        lineMap.build(src, max);
        return lineMap;
    }

    public static int encodePosition(int line, int col) {
        if (line < 1) {
            throw new IllegalArgumentException("line must be greater than 0");
        }
        if (col < 1) {
            throw new IllegalArgumentException("column must be greater than 0");
        }
        if (line > 0x3FFFFF || col > 1023) {
            return -1;
        }
        return (line << 10) + col;
    }

    public static interface LineMap
    extends openjdk.com.sun.source.tree.LineMap {
        public int getStartPosition(int var1);

        public int getPosition(int var1, int var2);

        public int getLineNumber(int var1);

        public int getColumnNumber(int var1);
    }

    static class LineMapImpl
    implements LineMap {
        protected int[] startPosition;
        private int lastPosition = 0;
        private int lastLine = 1;

        protected LineMapImpl() {
        }

        protected void build(char[] src, int max) {
            int c = 0;
            int i = 0;
            int[] linebuf = new int[max];
            block0: while (i < max) {
                linebuf[c++] = i;
                do {
                    char ch;
                    if ((ch = src[i]) == '\r' || ch == '\n') {
                        if (ch == '\r' && i + 1 < max && src[i + 1] == '\n') {
                            i += 2;
                            continue block0;
                        }
                        ++i;
                        continue block0;
                    }
                    if (ch != '\t') continue;
                    this.setTabPosition(i);
                } while (++i < max);
            }
            this.startPosition = new int[c];
            System.arraycopy(linebuf, 0, this.startPosition, 0, c);
        }

        @Override
        public int getStartPosition(int line) {
            return this.startPosition[line - 1];
        }

        @Override
        public long getStartPosition(long line) {
            return this.getStartPosition(LineMapImpl.longToInt(line));
        }

        @Override
        public int getPosition(int line, int column) {
            return this.startPosition[line - 1] + column - 1;
        }

        @Override
        public long getPosition(long line, long column) {
            return this.getPosition(LineMapImpl.longToInt(line), LineMapImpl.longToInt(column));
        }

        @Override
        public int getLineNumber(int pos) {
            if (pos == this.lastPosition) {
                return this.lastLine;
            }
            this.lastPosition = pos;
            int low = 0;
            int high = this.startPosition.length - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int midVal = this.startPosition[mid];
                if (midVal < pos) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > pos) {
                    high = mid - 1;
                    continue;
                }
                this.lastLine = mid + 1;
                return this.lastLine;
            }
            this.lastLine = low;
            return this.lastLine;
        }

        @Override
        public long getLineNumber(long pos) {
            return this.getLineNumber(LineMapImpl.longToInt(pos));
        }

        @Override
        public int getColumnNumber(int pos) {
            return pos - this.startPosition[this.getLineNumber(pos) - 1] + 1;
        }

        @Override
        public long getColumnNumber(long pos) {
            return this.getColumnNumber(LineMapImpl.longToInt(pos));
        }

        private static int longToInt(long longValue) {
            int intValue = (int)longValue;
            if ((long)intValue != longValue) {
                throw new IndexOutOfBoundsException();
            }
            return intValue;
        }

        protected void setTabPosition(int offset) {
        }
    }

    public static class LineTabMapImpl
    extends LineMapImpl {
        private BitSet tabMap;

        public LineTabMapImpl(int max) {
            this.tabMap = new BitSet(max);
        }

        @Override
        protected void setTabPosition(int offset) {
            this.tabMap.set(offset);
        }

        @Override
        public int getColumnNumber(int pos) {
            int lineStart = this.startPosition[this.getLineNumber(pos) - 1];
            int column = 0;
            int bp = lineStart;
            while (bp < pos) {
                column = this.tabMap.get(bp) ? column / 8 * 8 + 8 : ++column;
                ++bp;
            }
            return column + 1;
        }

        @Override
        public int getPosition(int line, int column) {
            int pos = this.startPosition[line - 1];
            --column;
            int col = 0;
            while (col < column) {
                if (this.tabMap.get(++pos)) {
                    col = col / 8 * 8 + 8;
                    continue;
                }
                ++col;
            }
            return pos;
        }
    }
}

