/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl.type;

import javax.lang.model.type.TypeKind;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.type.StdLogic;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;
import net.wasamon.javarock.model.vhdl.type.VHDLArrayType;
import net.wasamon.javarock.model.vhdl.type.VHDLInteger;
import net.wasamon.javarock.model.vhdl.type.VHDLMethodType;
import net.wasamon.javarock.tools.types.ComponentType;
import net.wasamon.javarock.tools.types.JavaLiteralType;
import net.wasamon.javarock.tools.types.VoidType;
import openjdk.com.sun.tools.javac.code.Type;
import openjdk.com.sun.tools.javac.tree.JCTree;

public class VHDLTypeBuilder {
    static final VoidType voidType = new VoidType();
    static final JavaLiteralType literalType = new JavaLiteralType();

    public static JavaRockType getType(TypeKind k) {
        boolean flag = true;
        switch (k) {
            case BOOLEAN: {
                return StdLogic.INSTANCE;
            }
            case BYTE: {
                return new StdLogicVector("7", "0");
            }
            case CHAR: {
                return new StdLogicVector("15", "0");
            }
            case INT: {
                return new StdLogicVector("31", "0");
            }
            case LONG: {
                return new StdLogicVector("63", "0");
            }
            case SHORT: {
                return new StdLogicVector("15", "0");
            }
            case VOID: {
                return voidType;
            }
            case OTHER: {
                System.out.println("OTHER");
                flag = false;
                break;
            }
            case DECLARED: {
                System.out.println("DECLARED");
                flag = false;
                break;
            }
            case ARRAY: {
                System.out.println("ARRAY");
                flag = false;
                break;
            }
            case DOUBLE: {
                System.out.println("DOUBLE");
                flag = false;
                break;
            }
            case ERROR: {
                System.out.println("ERROR");
                flag = false;
                break;
            }
            case EXECUTABLE: {
                System.out.println("EXECUTABLE");
                flag = false;
                break;
            }
            case FLOAT: {
                return new StdLogicVector("31", "0");
            }
            case NONE: {
                System.out.println("NONE");
                flag = false;
                break;
            }
            case NULL: {
                System.out.println("NULL");
                flag = false;
                break;
            }
            case PACKAGE: {
                System.out.println("PACKAGE");
                flag = false;
                break;
            }
            case TYPEVAR: {
                System.out.println("TYPEVAR");
                flag = false;
                break;
            }
            case WILDCARD: {
                System.out.println("WILDCARD");
                flag = false;
                break;
            }
            default: {
                flag = false;
            }
        }
        if (!flag) {
            System.err.println("unsupported type: " + (Object)((Object)k));
        }
        return StdLogic.INSTANCE;
    }

    private static JavaRockType getType(JCTree.JCPrimitiveTypeTree that) {
        TypeKind kind = that.getPrimitiveTypeKind();
        return VHDLTypeBuilder.getType(kind);
    }

    public static JavaRockType getType(Type t) {
        return VHDLTypeBuilder.getType(t.getKind());
    }

    public static JavaRockType getType(JCTree that) {
        if (that instanceof JCTree.JCPrimitiveTypeTree) {
            return VHDLTypeBuilder.getType((JCTree.JCPrimitiveTypeTree)that);
        }
        if (that instanceof JCTree.JCIdent) {
            return new ComponentType(((JCTree.JCIdent)that).sym.toString());
        }
        if (that instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCArrayTypeTree at = (JCTree.JCArrayTypeTree)that;
            return new VHDLArrayType(VHDLTypeBuilder.getType(at.elemtype));
        }
        System.err.printf("unsupported type: %s (%s)\n", that, that.getClass());
        return StdLogic.INSTANCE;
    }

    public static VHDLMethodType getMethodInvoke(String name) {
        return new VHDLMethodType(name);
    }

    public static StdLogic getStdLogic() {
        return StdLogic.INSTANCE;
    }

    public static StdLogicVector getStdLogicVector(String beg, String end) {
        return new StdLogicVector(beg, end);
    }

    public static StdLogicVector getStdLogicVector(int beg, int end) {
        return new StdLogicVector(beg, end);
    }

    public static VoidType getVoidType() {
        return voidType;
    }

    public static VHDLInteger getInteger() {
        return new VHDLInteger();
    }

    public static JavaLiteralType getLiteral() {
        return literalType;
    }
}

