/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.JavaRockComponentInstance;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.StateSignal;
import net.wasamon.javarock.model.vhdl.ArrayRef;
import net.wasamon.javarock.model.vhdl.ComponentInstancePointer;
import net.wasamon.javarock.model.vhdl.StaticModuleAccess;
import net.wasamon.javarock.model.vhdl.VHDLArrayPort;
import net.wasamon.javarock.model.vhdl.VHDLConstant;
import net.wasamon.javarock.model.vhdl.VHDLElement;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLFieldArray;
import net.wasamon.javarock.model.vhdl.VHDLFieldPrimitiveSignal;
import net.wasamon.javarock.model.vhdl.VHDLFieldSignal;
import net.wasamon.javarock.model.vhdl.VHDLFixedArray;
import net.wasamon.javarock.model.vhdl.VHDLGenericParameter;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLNewComponentInstance;
import net.wasamon.javarock.model.vhdl.VHDLNotifyProcess;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.VHDLSynchronizedProcess;
import net.wasamon.javarock.model.vhdl.VHDLVariable;
import net.wasamon.javarock.model.vhdl.VHDLWaitProcess;
import net.wasamon.javarock.model.vhdl.type.VHDLArrayType;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
import net.wasamon.javarock.tools.Manager;
import net.wasamon.javarock.tools.types.CompiledComponentType;
import net.wasamon.javarock.tools.types.ComponentType;
import net.wasamon.javarock.tools.types.InstancePointer;

public class VHDLModule
extends VHDLElement
implements JavaRockComponentIface,
VHDLItem,
VHDLScopeIface {
    private final String className;
    final Hashtable<String, VHDLPort> output = new Hashtable();
    final Hashtable<String, VHDLPort> input = new Hashtable();
    final Hashtable<String, VHDLProcess> processes = new Hashtable();
    private final Hashtable<String, VHDLFieldSignal> signals = new Hashtable();
    final Hashtable<String, VHDLSignal> unique_access_signals = new Hashtable();
    final Hashtable<String, ComponentType> components = new Hashtable();
    final Hashtable<String, VHDLNewComponentInstance> instances = new Hashtable();
    final Hashtable<String, String> reqTable = new Hashtable();
    final Hashtable<String, String> busyTable = new Hashtable();
    final Hashtable<String, VHDLGenericParameter> generics = new Hashtable();
    final ArrayList<JavaRockComponentInstance> owners = new ArrayList();
    final Hashtable<String, VHDLConstant> constants = new Hashtable();
    final ArrayList<VHDLStatement> combinations = new ArrayList();
    private final Hashtable<String, InstancePointer> pointers = new Hashtable();
    private final Hashtable<String, String> importList;
    private boolean sequential;
    final boolean runnable;
    private boolean javarockhdl = false;
    private boolean thread = false;
    VHDLSynchronizedProcess syncproc;

    @Override
    public String getName() {
        return this.className.toLowerCase().replace(".", "_");
    }

    public String getOrigName() {
        return this.className;
    }

    public VHDLModule(String name, boolean runnable, Hashtable<String, String> importList) {
        this.className = name;
        this.runnable = runnable;
        this.importList = importList;
        this.sequential = false;
        VHDLProcess p = new VHDLNotifyProcess(this);
        this.processes.put(p.base, p);
        p = new VHDLWaitProcess(this);
        this.processes.put(p.base, p);
    }

    @Override
    public void connect() {
        this.sequential = this.isSequential();
        for (VHDLFieldSignal vHDLFieldSignal : this.signals.values()) {
            vHDLFieldSignal.connect();
        }
        for (VHDLSignal vHDLSignal : this.unique_access_signals.values()) {
            vHDLSignal.connect();
        }
        for (InstancePointer instancePointer : this.pointers.values()) {
            instancePointer.connect();
        }
        for (VHDLNewComponentInstance vHDLNewComponentInstance : this.instances.values()) {
            vHDLNewComponentInstance.connect();
        }
        if (this.syncproc != null) {
            this.syncproc.connect();
        }
        for (VHDLProcess vHDLProcess : this.processes.values()) {
            vHDLProcess.connect();
        }
        for (VHDLPort vHDLPort : this.input.values()) {
            vHDLPort.connect();
        }
    }

    @Override
    public void link() {
        this.sequential = this.isSequential();
        for (InstancePointer instancePointer : this.pointers.values()) {
            instancePointer.link();
        }
        for (VHDLNewComponentInstance vHDLNewComponentInstance : this.instances.values()) {
            vHDLNewComponentInstance.link();
        }
        if (this.syncproc != null) {
            this.syncproc.link();
        }
        for (VHDLProcess vHDLProcess : this.processes.values()) {
            vHDLProcess.link();
        }
        for (VHDLPort vHDLPort : this.input.values()) {
            vHDLPort.link();
        }
        for (VHDLFieldSignal vHDLFieldSignal : this.signals.values()) {
            vHDLFieldSignal.link();
        }
        for (VHDLSignal vHDLSignal : this.unique_access_signals.values()) {
            vHDLSignal.link();
        }
    }

    public void optimize() {
        for (VHDLProcess p : this.processes.values()) {
            p.optimize();
        }
    }

    @Override
    public boolean isSequential() {
        if (this.sequential || this.components.size() == 0) {
            return this.sequential;
        }
        boolean flag = false;
        for (ComponentType t : this.components.values()) {
            JavaRockComponentIface module = Manager.INSTANCE.getComponentIface(t);
            flag |= module.isSequential();
        }
        if (!this.sequential && flag) {
            this.input.put("clk", new VHDLPort((JavaRockComponentIface)this, "clk", (JavaRockType)VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
            this.input.put("reset", new VHDLPort((JavaRockComponentIface)this, "reset", (JavaRockType)VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
            this.sequential |= flag;
        }
        return flag;
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        this.genLibraryImport(out, offset);
        this.writeln(out, String.format("entity %s is", this.getName()), offset);
        this.genPortList(this.getPortArrayList(), out, offset + 2);
        this.writeln(out, String.format("end %s;", this.getName()), offset);
        this.writeln(out, "", 0);
        this.writeln(out, String.format("architecture RTL of %s is", this.getName()), offset);
        this.genComponentList(out, offset + 2);
        this.genSignalList(out, offset + 2);
        this.writeln(out, "begin", offset);
        for (VHDLNewComponentInstance inst : this.instances.values()) {
            inst.generate(out, offset + 2);
        }
        for (VHDLStatement s : this.combinations) {
            s.generate(out, offset + 2);
        }
        for (VHDLProcess p : this.processes.values()) {
            p.generate(out, offset + 2);
        }
        if (this.syncproc != null) {
            this.syncproc.generate(out, offset + 2);
        }
        this.writeln(out, "end RTL;", offset);
    }

    private void genLibraryImport(PrintWriter out, int offset) {
        this.writeln(out, "library IEEE;", offset);
        this.writeln(out, "use IEEE.std_logic_1164.all;", offset);
        this.writeln(out, "use IEEE.std_logic_arith.all;", offset);
        this.writeln(out, "use IEEE.std_logic_signed.all;", offset);
    }

    private void genComponentList(PrintWriter out, int offset) {
        for (ComponentType t : this.components.values()) {
            JavaRockComponentIface c = t instanceof CompiledComponentType ? ((CompiledComponentType)t).component : Manager.INSTANCE.getComponentIface(t);
            t.setComponentIface(c);
            this.writeln(out, "component " + c.getName(), offset);
            this.genGenericList(c.getGenericArrayList(), out, offset + 2);
            this.genPortList(c.getPortArrayList(), out, offset + 2);
            this.writeln(out, "end component;", offset);
        }
    }

    @Override
    public Collection<VHDLPort> getPortArrayList() {
        ArrayList<VHDLPort> list = new ArrayList<VHDLPort>();
        for (VHDLPort port : this.output.values()) {
            if (port instanceof VHDLArrayPort) {
                for (VHDLPort p : ((VHDLArrayPort)port).ports.values()) {
                    list.add(p);
                }
                continue;
            }
            list.add(port);
        }
        for (VHDLPort port : this.input.values()) {
            if (port instanceof VHDLArrayPort) {
                for (VHDLPort p : ((VHDLArrayPort)port).ports.values()) {
                    list.add(p);
                }
                continue;
            }
            list.add(port);
        }
        return list;
    }

    @Override
    public Collection<VHDLFieldSignal> getFieldSignal() {
        return this.signals.values();
    }

    @Override
    public Collection<VHDLGenericParameter> getGenericArrayList() {
        return this.generics.values();
    }

    public void genGenericList(Collection<VHDLGenericParameter> list, PrintWriter out, int offset) {
        if (list.size() == 0) {
            return;
        }
        String sp = "";
        String pad = this.pad(offset + 2);
        this.write(out, "generic (", offset);
        for (VHDLGenericParameter gen : list) {
            this.write(out, String.valueOf(sp) + "\n");
            this.write(out, String.valueOf(pad) + gen);
            sp = ";";
        }
        this.write(out, "\n");
        this.writeln(out, ");", offset);
    }

    public void genPortList(Collection<VHDLPort> list, PrintWriter out, int offset) {
        String sp = "";
        this.write(out, "port (", offset);
        for (VHDLPort port : list) {
            this.write(out, String.valueOf(sp) + "\n");
            port.generate(out, offset + 2);
            sp = ";";
        }
        this.write(out, "\n");
        this.writeln(out, ");", offset);
    }

    private void genSignalList(PrintWriter out, int offset) {
        for (VHDLConstant vHDLConstant : this.constants.values()) {
            vHDLConstant.generate(out, offset);
        }
        for (VHDLFieldSignal vHDLFieldSignal : this.signals.values()) {
            vHDLFieldSignal.generate(out, offset);
        }
        for (VHDLSignal vHDLSignal : this.unique_access_signals.values()) {
            vHDLSignal.generate(out, offset);
        }
    }

    public ComponentType addComponent(ComponentType t) {
        if (!this.components.containsKey(t.ident)) {
            this.components.put(t.ident, t);
        }
        return this.components.get(t.ident);
    }

    public VHDLNewComponentInstance newComponentInstance(String name, ComponentType t, boolean initFlag, boolean fieldFlag) {
        VHDLNewComponentInstance instance = new VHDLNewComponentInstance(this, t, name, fieldFlag);
        this.instances.put(name, instance);
        return instance;
    }

    public InstancePointer addInstancePointer(ComponentType t, String name) {
        if (!this.pointers.containsKey(name)) {
            this.pointers.put(name, new ComponentInstancePointer(this, t, name));
        }
        return this.pointers.get(name);
    }

    public InstancePointer addInstancePointer(VHDLArrayType t, String name) {
        if (!this.pointers.containsKey(name)) {
            this.pointers.put(name, new ArrayRef(this, t, name));
        }
        return this.pointers.get(name);
    }

    public JavaRockComponentInstance getComponentInstance(String name) {
        JavaRockComponentInstance instance = this.instances.get(name);
        if (instance == null) {
            InstancePointer p = this.pointers.get(name);
            instance = p instanceof ComponentInstancePointer ? (JavaRockComponentInstance)((Object)p) : (p instanceof ArrayRef ? new ComponentInstancePointer(this, (ComponentType)((ArrayRef)p).type.base, name) : (this.importList.containsKey(name) ? new StaticModuleAccess(this.importList.get(name)) : new StaticModuleAccess(name)));
        }
        return instance;
    }

    public boolean isComponentInstance(String name) {
        boolean flag = false;
        JavaRockComponentInstance instance = this.instances.get(name);
        if (instance != null) {
            flag = true;
        } else {
            InstancePointer p = this.pointers.get(name);
            if (p != null && p instanceof ComponentInstancePointer) {
                flag = true;
            }
        }
        return flag;
    }

    public VHDLSignal addSignal(String name, VHDLArrayType t, VHDLExpr reset, boolean fUniqueAccess) {
        if (fUniqueAccess) {
            VHDLFixedArray signal = new VHDLFixedArray(this, name, t, reset);
            this.unique_access_signals.put(name, signal);
            return signal;
        }
        VHDLFieldArray signal = new VHDLFieldArray(this, name, t, reset);
        this.signals.put(name, signal);
        return signal;
    }

    public VHDLSignal addSignal(String name, JavaRockType t, VHDLExpr reset, boolean fUniqueAccess, boolean fExport) {
        if (t instanceof VHDLArrayType) {
            return this.addSignal(name, (VHDLArrayType)t, reset, fUniqueAccess);
        }
        if (fUniqueAccess) {
            VHDLSignal signal = new VHDLSignal(this, name, t, reset);
            this.unique_access_signals.put(name, signal);
            return signal;
        }
        VHDLFieldPrimitiveSignal signal = new VHDLFieldPrimitiveSignal(this, name, t, reset, fExport);
        this.signals.put(name, signal);
        return signal;
    }

    public boolean hasSignal(String name) {
        return this.signals.containsKey(name) || this.unique_access_signals.containsKey(name);
    }

    public VHDLSignal getSignal(String name) {
        VHDLSignal sig = (VHDLSignal)((Object)this.signals.get(name));
        if (sig == null) {
            sig = this.unique_access_signals.get(name);
        }
        return sig;
    }

    public VHDLSynchronizedProcess getSynchronizedProcess() {
        return this.syncproc;
    }

    public VHDLSynchronizedProcess setSynchronizedProcess(VHDLSynchronizedProcess p) {
        this.syncproc = p;
        return this.syncproc;
    }

    public VHDLProcess newProcess(JavaRockType type, String base, boolean auto2, boolean privateFlag) {
        VHDLProcess p = new VHDLProcess(this, type, base, auto2, privateFlag);
        this.processes.put(base, p);
        this.busyTable.put(base, p.BUSY_SIGNAL);
        this.reqTable.put(base, p.REQ_SIGNAL);
        return p;
    }

    public VHDLProcess search(String name) {
        if (this.processes.containsKey(name)) {
            return this.processes.get(name);
        }
        if (this.syncproc != null && this.syncproc.processes.containsKey(name)) {
            return this.syncproc.processes.get(name);
        }
        System.out.println("not found: " + name);
        throw new RuntimeException("cannot find such method in " + this.getName() + " : " + name);
    }

    @Override
    public void addOwner(JavaRockComponentInstance owner) {
        this.owners.add(owner);
    }

    @Override
    public Collection<JavaRockComponentInstance> getOwnerList() {
        return this.owners;
    }

    public void dumpSymbolTable() {
        System.out.println("signals");
        Enumeration<String> e = this.signals.keys();
        while (e.hasMoreElements()) {
            System.out.println(" " + e.nextElement());
        }
        System.out.println("unique access signals");
        e = this.unique_access_signals.keys();
        while (e.hasMoreElements()) {
            System.out.println(" " + e.nextElement());
        }
        System.out.println("instances");
        e = this.instances.keys();
        while (e.hasMoreElements()) {
            System.out.println(" " + e.nextElement());
        }
        System.out.println("constants");
        e = this.constants.keys();
        while (e.hasMoreElements()) {
            System.out.println(" " + e.nextElement());
        }
        System.out.println("pointers");
        e = this.pointers.keys();
        while (e.hasMoreElements()) {
            System.out.println(" " + e.nextElement());
        }
        System.out.println("inputs");
        e = this.input.keys();
        while (e.hasMoreElements()) {
            System.out.println(" " + e.nextElement());
        }
    }

    @Override
    public VHDLIdent getIdent(String name, VHDLExpr.TERM t) {
        if (this.signals.containsKey(name)) {
            return new VHDLIdent((VHDLSignal)((Object)this.signals.get(name)), t);
        }
        if (this.unique_access_signals.containsKey(name)) {
            return new VHDLIdent(this.unique_access_signals.get(name), t);
        }
        if (this.input.containsKey(name)) {
            return new VHDLIdent(this.input.get(name), t);
        }
        if (this.instances.containsKey(name)) {
            return new VHDLIdent(new VHDLVariable(this, name, this.instances.get((Object)name).type), t);
        }
        if (this.constants.containsKey(name)) {
            return new VHDLIdent(new VHDLVariable(this, name, this.constants.get((Object)name).type), t);
        }
        if (this.pointers.containsKey(name)) {
            return new VHDLIdent(new VHDLVariable(this, name, this.pointers.get(name)), t);
        }
        System.out.println(String.valueOf(name) + " is unresolved symbol.");
        System.out.println("======================================================");
        this.dumpSymbolTable();
        System.out.println("======================================================");
        throw new RuntimeException("VHDLModule " + this.getName() + ": \"" + name + "\" is not found in identifier table.");
    }

    @Override
    public boolean hasIdent(String name) {
        if (this.signals.containsKey(name)) {
            return true;
        }
        if (this.unique_access_signals.containsKey(name)) {
            return true;
        }
        if (this.instances.containsKey(name)) {
            return true;
        }
        if (this.constants.containsKey(name)) {
            return true;
        }
        if (this.pointers.containsKey(name)) {
            return true;
        }
        return this.input.containsKey(name);
    }

    public void addConstantant(VHDLConstant value) {
        this.constants.put(value.name, value);
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.getName() + ":\n";
        s = String.valueOf(s) + this.getPortArrayList();
        return s;
    }

    @Override
    public String[] getConstructorArgs() {
        return new String[0];
    }

    public void setSequential(boolean flag) {
        if (!this.sequential && flag) {
            this.input.put("clk", new VHDLPort((JavaRockComponentIface)this, "clk", (JavaRockType)VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
            this.input.put("reset", new VHDLPort((JavaRockComponentIface)this, "reset", (JavaRockType)VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
        }
        this.sequential |= flag;
    }

    public boolean isRunnable() {
        return this.runnable;
    }

    public void setJavaRockHDL(boolean flag) {
        this.javarockhdl = flag;
    }

    public boolean isJavaRockHDL() {
        return this.javarockhdl;
    }

    public void setThread(boolean flag) {
        this.thread = flag;
    }

    public boolean isThread() {
        return this.thread;
    }

    @Override
    public String[] getProcessNameList() {
        ArrayList<String> list = new ArrayList<String>();
        for (VHDLProcess process : this.processes.values()) {
            if (!process.sequential) continue;
            list.add(process.base);
        }
        return list.toArray(new String[0]);
    }

    @Override
    public StateSignal get_state_sig() {
        throw new RuntimeException("VHDLModule::get_state_sig is not supporeted.");
    }

    @Override
    public VHDLSignal addSignal(JavaRockType t, String name) {
        throw new RuntimeException("VHDLModule::addVarilable is not supporeted.");
    }

    @Override
    public void addVariable(JavaRockType t, String name) {
        throw new RuntimeException("VHDLModule::addVarilable is not supporeted.");
    }

    @Override
    public void add(VHDLStatement stmt) {
        throw new RuntimeException("VHDLModule::add(VHDLStatement) is not supporeted.");
    }

    @Override
    public VHDLScopeIface getParent() {
        return null;
    }

    @Override
    public void prepare() {
    }
}

