/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.JavaRockComponentInstance;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
import net.wasamon.javarock.tools.Manager;
import net.wasamon.javarock.tools.types.CompiledComponentType;
import net.wasamon.javarock.tools.types.ComponentType;
import net.wasamon.javarock.tools.types.InstancePointer;

public class ComponentInstancePointer
implements InstancePointer,
JavaRockComponentInstance {
    private final ComponentType type;
    final String name;
    final VHDLModule owner;

    public ComponentInstancePointer(VHDLModule owner, ComponentType type, String name) {
        this.owner = owner;
        this.type = type;
        this.name = name;
    }

    @Override
    public VHDLModule owner() {
        return this.owner;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return String.format("ComponentInstancePointer: %s -> %s", this.name, this.type.ident);
    }

    @Override
    public JavaRockComponentIface getComponentIface() {
        if (this.type instanceof CompiledComponentType) {
            return ((CompiledComponentType)this.type).component;
        }
        return Manager.INSTANCE.getComponentIface(this.type);
    }

    @Override
    public void connect() {
        JavaRockComponentIface m = Manager.INSTANCE.getComponentIface(this.type);
        if (!(m instanceof VHDLModule)) {
            throw new RuntimeException(String.format("Instance pointers for not VHDLModule is not supported: %s [%s]", m.getName(), m.getClass()));
        }
        String[] stringArray = m.getProcessNameList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String process = stringArray[n2];
            String base = String.format("%s_%s_method_", this.name, process);
            VHDLPort port = new VHDLPort((JavaRockComponentIface)this.owner, String.valueOf(base) + "request_port", (JavaRockType)VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.OUT);
            VHDLSignal sig = new VHDLSignal(this.owner, String.valueOf(base) + "request", VHDLTypeBuilder.getStdLogic(), null);
            this.owner.output.put(String.valueOf(base) + "request_port", port);
            System.out.println("*** ComponentInstancePointer is not supported completely. ***: " + this.name);
            ((VHDLModule)m).search(process).addAccessor(this);
            ++n2;
        }
    }

    @Override
    public void link() {
    }

    @Override
    public JavaRockType getType() {
        return this.type;
    }

    @Override
    public ComponentType getComponentType() {
        return this.type;
    }

    @Override
    public String getDefaultValue() {
        return null;
    }
}

