package net.wasamon.mailer.driver;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

import com.sun.mail.smtp.SMTPTransport;

public class SMTPClient {
	
	public static SMTPClient getInstance(){
		return instance;
	}
	private static SMTPClient instance = new SMTPClient();
	private SMTPClient(){

	}

	public void sendMessage(ClientData data, MessageData mesgData) throws MessagingException, UnsupportedEncodingException{
		boolean authFlag;
		Properties props = System.getProperties();
		props.put("mail.smtp.host", data.host);
		if("".equals(data.password) == false){
			authFlag = true;
			props.put("mail.smtp.auth", true);
		}else{
			authFlag = false;
			props.put("mail.smtp.auth", false);
		}
		Session session = Session.getInstance(props, null);
		MimeMessage mesg = new MimeMessage(session);
		mesg.setFrom(mesgData.fromAddr);
	    mesg.setRecipients(Message.RecipientType.TO, mesgData.toAddr);
	    if(mesgData.ccAddr != null){
	    	System.out.println(mesgData.ccAddr);
	    	mesg.setRecipients(Message.RecipientType.CC, mesgData.ccAddr);
	    }
	    if(mesgData.bccAddr != null){
	    	System.out.println(mesgData.bccAddr);
	    	mesg.setRecipients(Message.RecipientType.BCC, mesgData.bccAddr);
	    }
	    mesg.setSubject(MimeUtility.encodeText(mesgData.subject, "iso-2022-jp", "B"));
//	    String encodedBody = MimeUtility.encodeText(mesgData.body, "iso-2022-jp", "B");
//	    mesg.setContent(encodedBody, "text/plain; charset=iso-2022-jp"); 
	    mesg.setText(mesgData.body, "iso-2022-jp");
//	    mesg.setText(MimeUtility.encodeText(mesgData.body, "iso-2022-jp", "B"));
	    mesg.setHeader("X-Mailer", "Mailer On Eclipse 0.1.0");
	    mesg.setHeader("Content-Transfer-Encoding", "7bit");
	    mesg.setSentDate(new Date());
//	    SMTPTransport t = (SMTPTransport)session.getTransport(ssl ? "smtps" : "smtp");
	    SMTPTransport t = (SMTPTransport)session.getTransport("smtp");
	    try {
			if (authFlag){
				t.connect(data.host, data.user, data.password);
			}else{
				t.connect();
			}
			t.sendMessage(mesg, mesg.getAllRecipients());
	    } finally {
	    	t.close();
	    }


	    

	}
	

}
