package net.wasamon.mailer.composite;

import java.io.UnsupportedEncodingException;

import javax.mail.MessagingException;

import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.driver.MessageData;
import net.wasamon.mailer.driver.SMTPClient;
import net.wasamon.mailer.views.MailConfigView;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;

public class SendMailComposite extends AbstractMailerComposite implements SelectionListener {

	private Text toField;

	private Text fromField;

	private Text subjectField;

	private Text ccField;

	private Text bccField;

	private Button sendMailButton;
	private Button newMailButton;

	private Text msgText;
	
	public SendMailComposite(Composite parent, IWorkbenchPartSite site, int style){
		super(parent, site, style);
		composite.setLayout(new GridLayout(1, false));
		Composite ctrl = makeCtrlButtonGroup(composite);
		ctrl.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Composite field = makeField(composite);
		field.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		msgText = new Text(composite, SWT.MULTI|SWT.BORDER|SWT.H_SCROLL|SWT.V_SCROLL);
		msgText.setEditable(true);
		msgText.setLayoutData(new GridData(GridData.FILL_BOTH));
	}

	private Composite makeCtrlButtonGroup(Composite parent) {
		Composite c = new Composite(parent, SWT.NONE);
		c.setLayout(new GridLayout(2, true));
		sendMailButton = makeButton(c, this, "Send");
		newMailButton = makeButton(c, this, "New");
		return c;
	}

	private Composite makeField(Composite parent) {
		Composite c = new Composite(parent, SWT.NONE);
		c.setLayout(new GridLayout(2, false));
		toField = makeField(c, "To:");
		fromField = makeField(c, "From:");
		ccField = makeField(c, "Cc:");
		bccField = makeField(c, "Bcc:");
		subjectField = makeField(c, "Subject:");
		return c;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub

	}

	private void sendMessage(String toAddr,
			String fromAddr,
			String subject,
			String ccAddr,
			String bccAddr,
			String mesg) throws MessagingException, UnsupportedEncodingException{
		MessageData data = new MessageData(toAddr, fromAddr, subject);
		if(ccAddr.equals("") == false){
			data.setCcAddr(ccAddr);
		}
		if(bccAddr.equals("") == false){
			data.setBccAddr(bccAddr);
		}
		System.out.println("cc = " + ccAddr);
		System.out.println("bcc = " + bccAddr);
		data.setMessage(mesg);
		SMTPClient.getInstance().sendMessage(getSMTPClientData(), data);
	}
	
	private ClientData getSMTPClientData(){
		MailConfigView view = (MailConfigView)(findViewPart("net.wasamon.mailer.views.mailConfigView"));
		if(view == null){
			return null;
		}else{
			return view.getClientInfo().getSMTPClientData();
		}
	}
	
	public void makeNewDraft(){
		makeNewDraft("", "", "", "");
	}

	public void makeNewDraft(String toAddr, String ccAddr, String subject, String mesg){
		toField.setText(toAddr);
		fromField.setText(getSMTPClientData().myMailAddr);
		subjectField.setText(subject);
		ccField.setText(ccAddr);
		msgText.setText(mesg);
	}

	
	public void widgetSelected(SelectionEvent e) {
		Object obj = e.getSource();
		if(obj == null){
			
		}else if(obj == sendMailButton){
			try{
				sendMessage(toField.getText(),
						fromField.getText(),
						subjectField.getText(),
						ccField.getText(),
						bccField.getText(),
						msgText.getText());
			}catch(MessagingException ex){
				MessageDialog.openError(site.getShell(), "Error", "error sending message: " + ex.getMessage());
			}catch(UnsupportedEncodingException ex){
				MessageDialog.openError(site.getShell(), "Error", "error sending message: " + ex.getMessage());
			}
			toField.setText("");
		}else if(obj == newMailButton){
			makeNewDraft();
		}else{
			
		}

	}

}
