package net.wasamon.mailer.driver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;

public class IMAPClient {

	private final String protocol = "imap";

	private Session session;

	private Store store;

	public static IMAPClient getInstance() {
		return instance;
	}

	private static IMAPClient instance = new IMAPClient();

	private IMAPClient() {
		Properties props = System.getProperties();
		session = Session.getDefaultInstance(props, null);
	}

	private ClientData currentClientData;

	public Store getStore(ClientData data) throws MessagingException {
		if (store == null) {
			store = session.getStore(protocol);
		}
		if (data.equals(currentClientData) == false) {
			store.close();
			currentClientData = data;
		}
		if (store.isConnected() == false) {
			store.connect(currentClientData.host, currentClientData.port,
					currentClientData.user, currentClientData.password);
		}
		return store;
	}

	public Message[] getFolderMessages(Folder folder) throws MessagingException {
		Message[] msgs = folder.getMessages();
		// Use a suitable FetchProfile
		FetchProfile fp = new FetchProfile();
		fp.add(FetchProfile.Item.ENVELOPE);
		fp.add(FetchProfile.Item.FLAGS);
		fp.add("X-Mailer");
		folder.fetch(msgs, fp);
		return msgs;
	}

	public boolean isConnected() {
		return store.isConnected();
	}

	private Folder currentFolder;

	/**
	 * w肵tH_ԂDtH_Ƃnullw肵ꍇC INBOXJ
	 * 
	 * @param mbox
	 * @return
	 * @throws MessagingException
	 */
	public Folder openFolder(ClientData data, String mbox)
			throws MessagingException {
		if (currentFolder == null
				|| currentFolder.getName().equals(mbox) == false) {
			Folder folder = getStore(data).getDefaultFolder();
			if (mbox == null) {
				mbox = "INBOX";
			}
			currentFolder = folder.getFolder(mbox);
		}
		if (currentFolder.isOpen() == false) {
			try {
				currentFolder.open(Folder.READ_WRITE);
			} catch (MessagingException ex) {
				currentFolder.open(Folder.READ_ONLY);
			}
		}
		return currentFolder;
	}

	/**
	 * w肵tH_ԂDtH_Ƃnullw肵ꍇC INBOXJ
	 * 
	 * @param mbox
	 * @return
	 * @throws MessagingException
	 */
	public Folder[] getFolderList(ClientData data) throws MessagingException {
		ArrayList<Folder> list = new ArrayList<Folder>();
		getFolderList(data, getStore(data).getDefaultFolder(), list);
		Folder[] folders = new Folder[list.size()];
		list.toArray(folders);
		return folders;
	}

	/**
	 * w肵tH_ԂDtH_Ƃnullw肵ꍇC INBOXJ
	 * 
	 * @param mbox
	 * @return
	 * @throws MessagingException
	 */
	private void getFolderList(ClientData data, Folder folder, ArrayList<Folder> list) throws MessagingException {
		Folder[] children = folder.list();
		if(children == null || children.length == 0){
		}else{
			for(int i = 0; i < children.length; i++){
				list.add(children[i]);
				getFolderList(data, children[i], list);
			}
		}
	}
	
	public void closeFolder(boolean flag) throws MessagingException {
		if (currentFolder != null && currentFolder.isOpen()) {
			currentFolder.close(flag);
		}
	}

	public void close(boolean flag) throws MessagingException {
		closeFolder(flag);
		if(store != null && store.isConnected()){
			store.close();
		}
	}

	public String getFlagString(Message msg) throws MessagingException{
		StringBuffer sb = new StringBuffer();
		Flags flags = msg.getFlags();
		Flags.Flag[] sf = flags.getSystemFlags(); // get the system flags

		boolean first = true;
		boolean isSeenFlag = false;
		for (int i = 0; i < sf.length; i++) {
			Flags.Flag f = sf[i];
			if (f == Flags.Flag.ANSWERED){
				sb.append("A");
			}else if (f == Flags.Flag.DELETED){
				sb.append("D");
			}else if (f == Flags.Flag.DRAFT){
				sb.append("T");
			}else if (f == Flags.Flag.FLAGGED){
				sb.append("F");
			}else if (f == Flags.Flag.RECENT){
				sb.append("N");
			}else if (f == Flags.Flag.SEEN){
				isSeenFlag = true;
				sb.append(" ");
			}else{
				continue; // skip it
			}
			if (first){
				first = false;
			}else{
				sb.append(' ');
			}
		}
		if(isSeenFlag == false){
			sb.append("U");
		}
		String[] uf = flags.getUserFlags(); // get the user flag strings
		for (int i = 0; i < uf.length; i++) {
			if (first)
				first = false;
			else
				sb.append(' ');
			sb.append(uf[i]);
		}
		return sb.toString();
	}

	MessageData lastData;

	int currentId = -1;

	public MessageData viewMessage(Folder folder, int id)
			throws MessagingException, IOException {
		if (lastData == null || id != currentId
				|| folder.getName().equals(currentFolder.getName()) == false) {
			Message m = folder.getMessage(id);
			if (m != null) {
				lastData = new MessageData(m);
			}
		}
		return lastData;
	}

}
