package net.wasamon.mailer.composite;

import java.io.IOException;

import javax.mail.MessagingException;

import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.driver.IMAPClient;
import net.wasamon.mailer.driver.MessageData;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;

public class MessageComposite extends AbstractMailerComposite{
	
	private StyledText text;
	
	public MessageComposite(Composite parent, IWorkbenchPartSite site, int style){
		super(parent, site, style);
		composite.setLayout(new FillLayout());
		text = new StyledText(composite, SWT.H_SCROLL | SWT.V_SCROLL);
		text.setEditable(false);
	}
	
	public MessageData viewMessage(ClientData data, String folderName, int id){
		MessageData value = null;
		try{
			IMAPClient imap = IMAPClient.getInstance();
			value = imap.viewMessage(imap.openFolder(data, folderName), id);
			text.setText(value.getHeaderString() + value.getMessage());
		}catch(MessagingException e){
			ErrorDialog.openError(
					site.getShell(),
					"Error",
					"Error connecting to server: " + e.getMessage(),
					Status.CANCEL_STATUS);
		}catch(IOException e){
			MessageDialog.openError(
					site.getShell(),
					"Error",
					"I/O Exception: " + e.getMessage());
		}
		return value;
	}
		
}
