package net.wasamon.mailer.views;

import net.wasamon.mailer.composite.SummaryComposite;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class MailSummaryView extends ViewPart {

	private SummaryComposite summary;
	
	private Action doubleClickAction;
	
	public MailSummaryView() {
		// TODO Auto-generated constructor stub
	}

	@Override
	public void createPartControl(Composite parent) {
		summary = new SummaryComposite(parent, getSite(), SWT.NONE);
		makeActions();
		hookDoubleClickAction();
		hookContextMenu();
		contributeToActionBars();
	}

	private void makeActions() {

		doubleClickAction = new Action() {
			public void run() {
				summary.summaryElementSelect();
			}
		};
	}

	private void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		fillLocalPullDown(bars.getMenuManager());
		fillLocalToolBar(bars.getToolBarManager());
	}
	
	private void fillLocalPullDown(IMenuManager manager) {
		manager.add(summary.updateSummaryAction);
		manager.add(summary.deleteMessageAction);
		manager.add(summary.moveMessageAction);
		manager.add(summary.searchMessageAction);
	}

	private void fillContextMenu(IMenuManager manager) {
		manager.add(summary.updateSummaryAction);
		manager.add(summary.deleteMessageAction);
		manager.add(summary.moveMessageAction);
		manager.add(summary.searchMessageAction);
	}

	private void fillLocalToolBar(IToolBarManager manager) {
		manager.add(summary.updateSummaryAction);
		manager.add(summary.deleteMessageAction);
		manager.add(summary.moveMessageAction);
		manager.add(summary.searchMessageAction);
	}

	
	@Override
	public void setFocus() {
		// TODO Auto-generated method stub

	}
	
	public SummaryComposite getSummaryComposite(){
		return summary;
	}
	
	private void hookDoubleClickAction() {
		summary.getSummaryTableViewer().addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				doubleClickAction.run();
			}
		});
	}

	private void hookContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu");
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				MailSummaryView.this.fillContextMenu(manager);
			}
		});
		Menu menu = menuMgr.createContextMenu(summary.getSummaryTableViewer().getControl());
		summary.getSummaryTableViewer().getControl().setMenu(menu);
		getSite().registerContextMenu(menuMgr, summary.getSummaryTableViewer());
	}


}
