package net.wasamon.mailer.driver;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

import net.wasamon.mailer.MailerConstant;

import com.sun.mail.smtp.SMTPTransport;

public class SMTPClient {
	
	public static SMTPClient getInstance(){
		return instance;
	}
	private static SMTPClient instance = new SMTPClient();
	private SMTPClient(){

	}

	public void sendMessage(ClientData data, MessageData mesgData) throws MessagingException, UnsupportedEncodingException{
		boolean authFlag;
		Properties props = System.getProperties();
		props.put("mail.smtp.host", data.host);
		if("".equals(data.password) == false){
			authFlag = true;
			props.put("mail.smtp.auth", true);
		}else{
			authFlag = false;
			props.put("mail.smtp.auth", false);
		}
		Session session = Session.getInstance(props, null);
		MimeMessage mesg = new MimeMessage(session);
		mesg.setFrom(mesgData.fromAddr);
	    mesg.setRecipients(Message.RecipientType.TO, mesgData.toAddr);
	    if(mesgData.ccAddr != null){
	    	//System.out.println(mesgData.ccAddr);
	    	mesg.setRecipients(Message.RecipientType.CC, mesgData.ccAddr);
	    }
	    if(mesgData.bccAddr != null){
	    	//System.out.println(mesgData.bccAddr);
	    	mesg.setRecipients(Message.RecipientType.BCC, mesgData.bccAddr);
	    }
	    mesg.setSubject(MimeUtility.encodeText(mesgData.subject, "iso-2022-jp", "B"));
	    if(mesgData.isMultiPart()){
	    	MimeBodyPart mbp1 = new MimeBodyPart();
	    	mbp1.setText(mesgData.body, "iso-2022-jp");
	    	Multipart mp = new MimeMultipart();
	    	mp.addBodyPart(mbp1);
	    	Iterator<File> i = mesgData.getAttachFileList().iterator();
	    	while(i.hasNext()){
	    		File f = i.next();
	    		MimeBodyPart mbp = new MimeBodyPart();
	    		// Ytt@Cw
	    		FileDataSource fds = new FileDataSource(f);
	    		mbp.setDataHandler(new DataHandler(fds));
	    		mbp.setFileName(MimeUtility.encodeText(fds.getName(), "iso-2022-jp", "B"));
	    		mp.addBodyPart(mbp);
	    	}
	    	mesg.setContent(mp);
	    }else{
	    	mesg.setText(mesgData.body, "iso-2022-jp");
	    }
	    mesg.setHeader("X-Mailer", MailerConstant.name + MailerConstant.version);
	    mesg.setHeader("Content-Transfer-Encoding", "7bit");
	    if(!(mesgData.inReplyTo == null || mesgData.inReplyTo.equals(""))){
	    	mesg.setHeader("In-Reply-To", mesgData.inReplyTo);
	    }
	    if(!(mesgData.references == null || mesgData.references.equals(""))){
	    	mesg.setHeader("References", mesgData.references);
	    }
	    mesg.setSentDate(new Date());
	    SMTPTransport t = (SMTPTransport)session.getTransport("smtp");
	    try {
			if (authFlag){
				t.connect(data.host, data.user, data.password);
			}else{
				t.connect();
			}
			t.sendMessage(mesg, mesg.getAllRecipients());
	    } finally {
	    	t.close();
	    }
	}
	

}
