/**
 * 
 */
package net.wasamon.mailer.composite;

import java.util.Date;

import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMessage;

import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.driver.IMAPClient;
import net.wasamon.mailer.driver.MessageData;

class UpdateSummaryThread extends Thread{
	
	/**
	 * 
	 */
	private final SummaryComposite composite;
	String folderName;
	ClientData client;
	
	public UpdateSummaryThread(SummaryComposite composite, ClientData client, String f) {
		this.composite = composite;
		this.folderName = f;
		this.client = client;
	}
	
	MailDateFormat format = new MailDateFormat();
	
	String[] makeMailSummaryItem(Message mesg) throws MessagingException {
		String data[] = new String[6];
		if(mesg == null) return data; 
		data[0] = String.valueOf(mesg.getMessageNumber());
		if(mesg instanceof MimeMessage && mesg.isMimeType("multipart/*")){
			data[1] = "@";
		}else{
			data[1] = " ";
		}
		Date d = mesg.getSentDate();
		data[2] = IMAPClient.getInstance().getFlagString(mesg);
		data[3] = (d != null ? format.format(d) : "UNKNOWN");
		data[4] = MessageData.getAddrStr(mesg.getFrom()[0]);
		data[5] = MessageData.toDecodedString(mesg.getSubject());
		return data;
	}
	
	public void run() {
		boolean flag = true;
		Runnable pre = composite.newUpdateSummaryPreOpDelegate();
		if(pre != null){
			this.composite.site.getShell().getDisplay().asyncExec(pre);
		}
		try{
			Folder folder = IMAPClient.getInstance().openFolder(client, folderName);
			Message[] msg = IMAPClient.getInstance().getFolderMessageArray(folder);
			FetchProfile fp = new FetchProfile();
			fp.add(FetchProfile.Item.ENVELOPE);
			fp.add(FetchProfile.Item.FLAGS);
			fp.add("X-Mailer");
			folder.fetch(msg, fp);
			for(int i = msg.length - 1; i >= 0; i--){
				String[] data = makeMailSummaryItem(msg[i]);
				this.composite.site.getShell().getDisplay().asyncExec(composite.newUpdateSummaryThreadDelegate(data));
			}
			
		} catch (MessagingException e) {
			this.composite.site.getShell().getDisplay().asyncExec(new ErrorMessageThreadDelegate(this.composite.getShell(), "I/O Error: " + e.getMessage()));
			flag = false;
		}
		Runnable post = composite.newUpdateSummaryEnableDelegate();
		if(post != null){
			this.composite.site.getShell().getDisplay().asyncExec(post);

		}
		if(flag){
			composite.site.getShell().getDisplay().asyncExec(new InfoMessageThreadDelegate(composite.site.getShell(), "summary updated", "mail summary updated completely"));
		}
	}
	
}