package net.wasamon.mailer.composite;

import java.io.File;
import java.io.IOException;

import javax.mail.MessagingException;

import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.driver.IMAPClient;
import net.wasamon.mailer.driver.MessageData;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPartSite;

public class MessageComposite extends AbstractMailerComposite{
	
	private StyledText text;

	private Table mimeTable;
	
	private TableViewer mimeView;
	
	private Action doubleClickAction;
	public Action replyMessageAction;
	
	public MessageComposite(Composite parent, IWorkbenchPartSite site, int style){
		super(parent, site, style);
		composite.setLayout(new FillLayout());
		SashForm sash = new SashForm(composite, SWT.VERTICAL);
		text = new StyledText(sash, SWT.H_SCROLL | SWT.V_SCROLL);
		text.setEditable(false);
		
		mimeTable = new Table(sash, SWT.MULTI | SWT.FULL_SELECTION | SWT.BORDER);
		mimeTable.setHeaderVisible(true);
		mimeTable.setVisible(true);
		TableColumn col = new TableColumn(mimeTable,SWT.LEFT);
		col.setWidth(500);
		col.setText("Mime Object");
		makeAction();
		mimeView = new TableViewer(mimeTable);
		mimeView.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				doubleClickAction.run();
			}
		});

	}
	
	private void makeAction(){
		replyMessageAction = new Action(){
			public void run(){
				replyMessage();
			}
		};
		replyMessageAction.setText("Reply");
		replyMessageAction.setToolTipText("Reply selected message");
		
		doubleClickAction = new Action() {
			public void run() {
				mimeObjectSaveToFile();
			}
		};
	}
	
	public void replyMessage(){
		if (value != null) {
			getSendMailComposite().makeNewDraft(value);
		}
	}

	
	public void mimeObjectSaveToFile() {
		int index = mimeTable.getSelectionIndex();
		if(index >= 0 && value.getMimeObjectSize() > index){
			MessageData.MultiPartData data = value.getMimeObject(index);
			String filename = "";
			if(data.getName() != null){
				filename = data.getName();
			}
			FileDialog saveDialog = new FileDialog(site.getShell(), SWT.SAVE);
			saveDialog.setFileName(filename);
			String saveFile = saveDialog.open();
			if(saveFile != null){
				saveFile = saveFile.trim();
				if(saveFile.equals("") == false){
					try{
						data.saveToFile(new File(saveFile));
					}catch(IOException e){
						MessageDialog.openError(site.getShell(), "Error", "cannot save data: " + e.getMessage());
					}
				}
			}
		}
	}

	private MessageData value;
	
	class ViewMessageThreadDelegate implements Runnable{
		
		public ViewMessageThreadDelegate(){
		}
		public void run(){
			text.setText(value.getHeaderString() + value.getMessage());
			int size = value.getMimeObjectSize();
			if(size > 0){
				for(int i = 0; i < size; i++){
					TableItem item = new TableItem(mimeTable, SWT.NONE);
					item.setText(new String[]{value.getMimeObject(i).toString()});
				}
			}
		}
	}
	
	class ViewMessageThread extends Thread{
		
		String folderName;
		ClientData client;
		int id;
		
		public ViewMessageThread(ClientData client, String f, int id) {
			this.folderName = f;
			this.client = client;
			this.id = id;
		}
		
		public void run() {
			try{
				IMAPClient imap = IMAPClient.getInstance();
				value = imap.viewMessage(imap.openFolder(client, folderName), id);
				site.getShell().getDisplay().asyncExec(new ViewMessageThreadDelegate());
			}catch(MessagingException e){
				site.getShell().getDisplay().asyncExec(new ErrorMessageThreadDelegate(getShell(), "connection error: " + e.getMessage()));
			}catch(IOException e){
				site.getShell().getDisplay().asyncExec(new ErrorMessageThreadDelegate(getShell(), "I/O error: " + e.getMessage()));
			}
		}
	}
	
	public void viewMessage(ClientData data, String folderName, int id){
		value = null;
		mimeTable.removeAll();
		new ViewMessageThread(data, folderName, id).start();
	}
		
}
