package net.wasamon.mailer.views;

import net.wasamon.mailer.composite.SummarySearchComposite;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class MailSummarySearchView extends ViewPart {

	private SummarySearchComposite summary;
	
	private Action doubleClickAction;
	
	public MailSummarySearchView() {
		// TODO Auto-generated constructor stub
	}

	@Override
	public void createPartControl(Composite parent) {
		summary = new SummarySearchComposite(parent, getSite(), SWT.NONE);
		makeActions();
		hookDoubleClickAction();
		hookContextMenu();
		contributeToActionBars();
	}

	private void makeActions() {

		doubleClickAction = new Action() {
			public void run() {
				summary.summaryElementSelect();
			}
		};
	}

	private void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		fillLocalPullDown(bars.getMenuManager());
		fillLocalToolBar(bars.getToolBarManager());
	}
	
	private void fillLocalPullDown(IMenuManager manager) {
		manager.add(summary.deleteMessageAction);
		manager.add(summary.moveMessageAction);
	}

	private void fillContextMenu(IMenuManager manager) {
		manager.add(summary.deleteMessageAction);
		manager.add(summary.moveMessageAction);
	}

	private void fillLocalToolBar(IToolBarManager manager) {
		manager.add(summary.deleteMessageAction);
		manager.add(summary.moveMessageAction);
	}

	
	@Override
	public void setFocus() {
		// TODO Auto-generated method stub

	}
	
	public SummarySearchComposite getSummarySearchComposite(){
		return summary;
	}
	
	private void hookDoubleClickAction() {
		summary.getSummaryTableViewer().addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				doubleClickAction.run();
			}
		});
	}

	private void hookContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu");
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				MailSummarySearchView.this.fillContextMenu(manager);
			}
		});
		Menu menu = menuMgr.createContextMenu(summary.getSummaryTableViewer().getControl());
		summary.getSummaryTableViewer().getControl().setMenu(menu);
		getSite().registerContextMenu(menuMgr, summary.getSummaryTableViewer());
	}


}
