package net.wasamon.mailer.composite;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPartSite;

public class SummarySearchComposite extends SummaryComposite{

	public SummarySearchComposite(Composite parent, IWorkbenchPartSite site, int style) {
		super(parent, site, style);
	}
	
	protected void makeActions(){

		deleteMessageAction = new Action(){
			public void run(){
				deleteSelectedMessages();
			}
		};
		deleteMessageAction.setText("Delete");
		deleteMessageAction.setToolTipText("delete selected messages");

		moveMessageAction = new Action(){
			public void run(){
				moveSelectedMessages();
			}
		};
		moveMessageAction.setText("Move");
		moveMessageAction.setToolTipText("move selected messages");
	}
	
	public void updateSearchSummary(TableItem[] items, String folder){
		this.folder = folder;
		mailSummary.removeAll();
		for(int i = 0; i < items.length; i++){
			TableItem item = new TableItem(mailSummary, SWT.BORDER);
			String[] data = new String[6];
			for(int j = 0; j < data.length; j++){
				data[j] = items[i].getText(j);
			}
			item.setText(data);
		}
		mailSummary.update();
		//mailSummary.setTopIndex(mailSummary.getItemCount());
		mailSummary.setTopIndex(0);
	}
	
	public Runnable newMessageMovePostDelegate(){
		return new MessageMovePostDelegate();
	}
	
	class MessageMovePostDelegate implements Runnable{
		public void run(){
			getSummaryComposite().updateSummary();
		}
	}

}