package net.wasamon.mailer.composite;

import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import javax.mail.internet.MailDateFormat;

import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.views.MailConfigView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPartSite;

public class SummaryComposite extends AbstractMailerComposite implements
		SelectionListener {

	protected Table mailSummary;

	private TableViewer summaryTableViewer;

	public Action updateSummaryAction;
	public Action deleteMessageAction;
	public Action moveMessageAction;
	public Action searchMessageAction;
	public TableColumn dateColumn;
	protected String folder;

	public SummaryComposite(Composite parent, IWorkbenchPartSite site, int style) {
		super(parent, site, style);
		composite.setLayout(new GridLayout(1, false));
		mailSummary = new Table(composite, SWT.MULTI | SWT.FULL_SELECTION | SWT.BORDER);
		mailSummary.setHeaderVisible(true);
		mailSummary.setVisible(true);
		makeTableColumn(mailSummary, "#", 50); // 0
		makeTableColumn(mailSummary, "@", 50); // 1
		makeTableColumn(mailSummary, "F", 50); // 2
		dateColumn = makeTableColumn(mailSummary, "Date", 150); // 3
		dateColumn.addSelectionListener(this);
		makeTableColumn(mailSummary, "From", 150); // 4
		makeTableColumn(mailSummary, "Subject", 250); // 5
		mailSummary.setLayoutData(new GridData(GridData.FILL_BOTH));
		summaryTableViewer = new TableViewer(mailSummary);
		makeActions();
	}

	protected void makeActions(){
		updateSummaryAction = new Action(){
			public void run(){
				updateSummary();
			}
		};
		updateSummaryAction.setText("Update");
		updateSummaryAction.setToolTipText("Update summary");

		deleteMessageAction = new Action(){
			public void run(){
				deleteSelectedMessages();
			}
		};
		deleteMessageAction.setText("Delete");
		deleteMessageAction.setToolTipText("delete selected messages");

		moveMessageAction = new Action(){
			public void run(){
				moveSelectedMessages();
			}
		};
		moveMessageAction.setText("Move");
		moveMessageAction.setToolTipText("move selected messages");
		
		searchMessageAction = new Action(){
			public void run(){
				searchMessage();
			}
		};
		searchMessageAction.setText("Search");
		searchMessageAction.setToolTipText("search");
	}
	
	private void searchMessage(){
		InputDialog d = new InputDialog(site.getShell(), "Search", null, "", null);
		d.open();
		String key = d.getValue().toLowerCase();
		if(key == null) return;
		ArrayList<TableItem> items = new ArrayList<TableItem>();
		for(TableItem item: mailSummary.getItems()){
			String s0 = item.getText(3).toLowerCase();
			String s1 = item.getText(4).toLowerCase();
			String s2 = item.getText(5).toLowerCase();
			if(s0.indexOf(key) >= 0){
				items.add(item);
			}else if(s1.indexOf(key) >= 0){
				items.add(item);
			}else if(s2.indexOf(key) >= 0){
				items.add(item);
			}
		}
		TableItem resultItems[] = new TableItem[items.size()];
		getSummarySearchComposite().updateSearchSummary(items.toArray(resultItems), folder);
	}
	
	private TableColumn makeTableColumn(Table table, String label, int width) {
		TableColumn col = new TableColumn(table, SWT.LEFT);
		col.setText(label);
		col.setWidth(width);
		return col;
	}

	public TableViewer getSummaryTableViewer() {
		return summaryTableViewer;
	}

	private ClientData getIMAPClientData() {
		MailConfigView view = (MailConfigView) (findViewPart("net.wasamon.mailer.views.mailConfigView"));
		if (view == null) {
			return null;
		} else {
			return view.getClientInfo().getIMAPClientData();
		}
	}

	synchronized public void updateSummary(){
		new UpdateSummaryThread(this, getIMAPClientData(), folder).start();
	}
	
	public void setAndUpdate(String folder) {
		this.folder = folder;
		updateSummary();
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
	}

	public void summaryElementSelect() {
		TableItem[] items = mailSummary.getSelection();
		if (items != null) {
			getMessageComposite().viewMessage(getIMAPClientData(), folder, Integer.parseInt(items[0].getText(0)));
		}
	}

	class DateComparator implements Comparator<String[]>{
		
		MailDateFormat format;
		
		public DateComparator() {
			format = new MailDateFormat();
		}

		public int compare(String[] o1, String[] o2) {
			long l1 = 0;
			long l2 = 0;
			if(o1[3].equals("UNKNOWN") == false){
				l1 = format.parse(o1[3], new ParsePosition(0)).getTime();
			}
			if(o2[3].equals("UNKNOWN") == false){
				l2 = format.parse(o2[3], new ParsePosition(0)).getTime();
			}
			if(l1 < l2){
				return -1;
			}else if(l1 > l2){
				return 1;
			}else{
				return 0;
			}
		}
	}
	
	public void widgetSelected(SelectionEvent e) {
		Object obj = e.getSource();
		if (obj == null) {
		}else if(obj == dateColumn){
			ArrayList<String[]> list = new ArrayList<String[]>();
			for(TableItem item : mailSummary.getItems()){
				String[] str = new String[6];
				for(int i = 0; i < str.length; i++){
					str[i] = item.getText(i);
				}
				list.add(str);
			}
			Collections.sort(list, new DateComparator());
			mailSummary.removeAll();
			for(String[] data : list){
				TableItem item = new TableItem(mailSummary, SWT.BORDER);
				item.setText(data);
				mailSummary.setData(item);
			}
			mailSummary.update();
		}else{
			
		}
	}
	
	public int[] getSelectedMessageIDs(){
		TableItem[] items = mailSummary.getSelection();
		int[] mesgs = new int[items.length];
		for(int i = 0; i < items.length; i++){
			mesgs[i] = Integer.parseInt(items[i].getText(0));
		}
		return mesgs;
	}
	
	public void moveSelectedMessages(){
		InputDialog d = new InputDialog(site.getShell(), "toFolder", null, "%INBOX.", new FolderNameValidator());
		d.open();
		String folderName = d.getValue();
		if(folderName != null){
			new MessageMoveThread(this, getIMAPClientData(), folderName, getSelectedMessageIDs()).start();
		}
	}

	public void deleteSelectedMessages(){
		new MessageMoveThread(this, getIMAPClientData(), "%INBOX.trash", getSelectedMessageIDs()).start();
	}
	
	class FolderNameValidator implements IInputValidator{

		public String isValid(String newText) {
			String val = null;
/*
			try{
				if(IMAPClient.getInstance().isFolderExists(getIMAPClientData(), newText)){
					
				}else{table
					val = "no such folder";
				}
			}catch(MessagingException e){
				val = "cannot connect to IMAP server";
			}
*/		
			return val;
		}
		
	}
	
	public UpdateSummaryThreadDelegate newUpdateSummaryThreadDelegate(String[] data){
		return new UpdateSummaryThreadDelegate(data);
	}
	
	class UpdateSummaryThreadDelegate implements Runnable{
		String []data;
		UpdateSummaryThreadDelegate(String[] data){
			this.data = data;
		}
		public void run(){
			TableItem item = new TableItem(mailSummary, SWT.BORDER);
			item.setText(data);
			mailSummary.update();
			mailSummary.setTopIndex(0);
		}
	}
	
	public UpdateSummaryEnableDelegate newUpdateSummaryEnableDelegate(){
		return new UpdateSummaryEnableDelegate();
	}

	class UpdateSummaryEnableDelegate implements Runnable{
		public UpdateSummaryEnableDelegate() {
		}
		public void run(){
			if(updateSummaryAction != null){
				updateSummaryAction.setEnabled(true);
			}
			if(searchMessageAction != null){
				searchMessageAction.setEnabled(true);
			}
			deleteMessageAction.setEnabled(true);
			moveMessageAction.setEnabled(true);
		}
	}

	public UpdateSummaryPreOpDelegate newUpdateSummaryPreOpDelegate(){
		return new UpdateSummaryPreOpDelegate();
	}

	class UpdateSummaryPreOpDelegate implements Runnable{
		public UpdateSummaryPreOpDelegate() {
		}
		public void run(){
			mailSummary.removeAll();
			if(updateSummaryAction != null){
				updateSummaryAction.setEnabled(false);
			}
			if(searchMessageAction != null){
				searchMessageAction.setEnabled(false);
			}
			deleteMessageAction.setEnabled(false);
			moveMessageAction.setEnabled(false);
		}
	}

	public Runnable newMessageMovePostDelegate(){
		return new MessageMovePostDelegate();
	}
	
	class MessageMovePostDelegate implements Runnable{
		public void run(){
			updateSummary();
		}
	}
	
}