package net.wasamon.mailer;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class MailerPerspectiveFactory implements IPerspectiveFactory {

	public void createInitialLayout(IPageLayout layout) {
		String editorArea = layout.getEditorArea();
		layout.setEditorAreaVisible(false);

		IFolderLayout root = layout.createFolder("net.wasamon.mailer.ROOT", IPageLayout.LEFT, 1.0f, editorArea);

		IFolderLayout context = layout.createFolder("net.wasamon.mailer.CONTEXT", IPageLayout.LEFT, 0.25f, "net.wasamon.mailer.ROOT"); 
		context.addView("net.wasamon.mailer.views.mailFolderView");
		IFolderLayout config = layout.createFolder("net.wasamon.mailer.CONFIG", IPageLayout.TOP, 0.25f, "net.wasamon.mailer.CONTEXT"); 
		config.addView("net.wasamon.mailer.views.mailConfigView");
		
		root.addView("net.wasamon.mailer.views.mailSummaryView");
		root.addView("net.wasamon.mailer.views.mailMessageView");
		root.addView("net.wasamon.mailer.views.mailSendView");
		
	}

}
