package net.wasamon.mailer.composite;

import javax.mail.Message;
import javax.mail.MessagingException;

import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.driver.IMAPClient;

public class MessageMoveThread extends Thread{

	ClientData client;
	String folderName;
	SummaryComposite composite;
	int[] mesgIDs;
	
	public MessageMoveThread(SummaryComposite composite, ClientData client, String folderName, int[] mesgIDs){
		this.composite = composite;
		this.client = client;
		this.folderName = folderName;
		this.mesgIDs = mesgIDs;
	}
	
	public void run(){
		boolean flag = false;
		try{
			if(IMAPClient.getInstance().isFolderExists(client, folderName)){
				flag = true;
			}
		}catch(MessagingException e){
			flag = false;
		}
		if(flag == false){
			this.composite.getShell().getDisplay().asyncExec(new ErrorMessageThreadDelegate(composite.getShell(), "no such folder or cannot connect to server"));
		}else{
			try{
				Message[] mesgs = new Message[mesgIDs.length];
				for(int i = 0; i < mesgs.length; i++){
					mesgs[i] = IMAPClient.getInstance().getMessage(mesgIDs[i]);
				}
				IMAPClient.getInstance().moveMessages(client, mesgs, folderName);
			}catch(MessagingException e){
				this.composite.getShell().getDisplay().asyncExec(new ErrorMessageThreadDelegate(this.composite.getShell(), "I/O Error: " + e.getMessage()));
				e.printStackTrace();
			}
			this.composite.getShell().getDisplay().asyncExec(this.composite.newMessageMovePostDelegate());
		}
	}
}