package net.wasamon.mailer.composite;

import net.wasamon.mailer.driver.ClientData;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;

public class ClientInfoComposite extends AbstractMailerComposite{

	private Text hostField;
	private Text portField;
	private Text userField;
	private Text passwdField;
	private Text smtpHostField;
	private Text smtpPortField;
	private Text smtpUserField;
	private Text smtpPasswdField;
	private Text smtpMailAddrField;
	
	public ClientInfoComposite(Composite parent, IWorkbenchPartSite site, int style){
		super(parent, site, style);
		composite.setLayout(new GridLayout(1, false));
		Group imap = makeIMAPConfig(composite);
		imap.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Group smtp = makeSMTPConfig(composite);
		smtp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	}
	
	private Group makeIMAPConfig(Composite parent){
		Group g = new Group(parent, SWT.NONE);
		GridLayout layout = new GridLayout(2, false);
		g.setText("IMAP coinfg");
		g.setLayout(layout);
		hostField = makeField(g, "Host");
		portField = makeField(g, "Port");
		portField.setText("143");
		userField = makeField(g, "User");
		passwdField = makeField(g, "Password");
		passwdField.setEchoChar('*');
		return g;
	}

	private Group makeSMTPConfig(Composite parent){
		Group g = new Group(parent, SWT.NONE);
		GridLayout layout = new GridLayout(2, false);
		g.setText("SMTP coinfg");
		g.setLayout(layout);
		smtpHostField = makeField(g, "Host");
		smtpPortField = makeField(g, "Port");
		smtpPortField.setText("25");
		smtpUserField = makeField(g, "User");
		smtpPasswdField = makeField(g, "Password");
		smtpPasswdField.setEchoChar('*');
		smtpMailAddrField = makeField(g, "Address");
		return g;
	}

	public ClientData getIMAPClientData(){
		String user = userField.getText();
		String passwd = passwdField.getText();
		String host = hostField.getText();
		int port = -1;
		try {
			port = Integer.parseInt(userField.getText());
		} catch (NumberFormatException e) {
			port = -1;
		}
		return new ClientData(host, port, user, passwd);
	}

	public ClientData getSMTPClientData(){
		String user = smtpUserField.getText();
		String passwd = smtpPasswdField.getText();
		String host = smtpHostField.getText();
		String myAddr = smtpMailAddrField.getText();
		int port = -1;
		try {
			port = Integer.parseInt(smtpUserField.getText());
		} catch (NumberFormatException e) {
			port = -1;
		}
		return new ClientData(host, port, user, passwd, myAddr);
	}
	

}
