/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mailer.editors;

import java.io.IOException;
import javax.mail.MessagingException;
import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.driver.IMAPClient;
import net.wasamon.mailer.driver.MessageData;
import net.wasamon.mailer.editors.BaseMailerPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MessageViewer
extends BaseMailerPage {
    private StyledText text;

    public MessageViewer(Composite parent, Shell shell, int style) {
        super(parent, shell, style);
        this.composite.setLayout((Layout)new FillLayout());
        this.text = new StyledText(this.composite, 768);
        this.text.setEditable(false);
    }

    public MessageData viewMessage(ClientData data, String folderName, int id) {
        MessageData value = null;
        try {
            IMAPClient imap = IMAPClient.getInstance();
            value = imap.viewMessage(imap.openFolder(data, "INBOX"), id);
            this.text.setText(String.valueOf(value.getHeaderString()) + value.getMessage());
        }
        catch (MessagingException e) {
            ErrorDialog.openError((Shell)this.shell, (String)"Error", (String)("Error connecting to server: " + e.getMessage()), (IStatus)Status.CANCEL_STATUS);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)("I/O Exception: " + e.getMessage()));
        }
        return value;
    }
}

