/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mailer.editors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import javax.mail.Message;
import javax.mail.MessagingException;
import net.wasamon.mailer.driver.IMAPClient;
import net.wasamon.mailer.driver.MessageData;
import net.wasamon.mailer.editors.BaseMailerPage;
import net.wasamon.mailer.editors.ClientInfoPage;
import net.wasamon.mailer.editors.MessageViewer;
import net.wasamon.mailer.editors.SendMailPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SummaryController
extends BaseMailerPage
implements SelectionListener {
    private Button updateButton;
    private Button replyMesgButton;
    private Table mailSummary;
    private ClientInfoPage infoPage;
    private MessageViewer viewer;
    private SendMailPage sendPage;
    private StyledText text;
    private MessageData selectData;

    public SummaryController(Composite parent, Shell shell, int style, MessageViewer viewer, ClientInfoPage infoPage, SendMailPage sendPage) {
        super(parent, shell, style);
        this.viewer = viewer;
        this.infoPage = infoPage;
        this.sendPage = sendPage;
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.makeButtonGroup(this.composite);
        this.mailSummary = new Table(this.composite, 67586);
        this.mailSummary.setHeaderVisible(true);
        this.mailSummary.addSelectionListener((SelectionListener)this);
        this.mailSummary.setVisible(true);
        this.makeTableColumn(this.mailSummary, "#", 50);
        this.makeTableColumn(this.mailSummary, "F", 50);
        this.makeTableColumn(this.mailSummary, "Date", 150);
        this.makeTableColumn(this.mailSummary, "From", 150);
        this.makeTableColumn(this.mailSummary, "Subject", 250);
        this.mailSummary.setLayoutData((Object)new GridData(1808));
        this.text = new StyledText(this.composite, 768);
        this.text.setLayoutData((Object)new GridData(1808));
    }

    private void makeButtonGroup(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        c.setLayout((Layout)layout);
        this.updateButton = this.makeButton(c, this, "Update");
        this.replyMesgButton = this.makeButton(c, this, "Reply");
    }

    private void makeTableColumn(Table table, String label, int width) {
        TableColumn col = new TableColumn(table, 16384);
        col.setText(label);
        col.setWidth(width);
    }

    private void updateSummary() {
        try {
            IMAPClient imap = IMAPClient.getInstance();
            Message[] msg = imap.getFolderMessages(imap.openFolder(this.infoPage.getIMAPClientData(), "INBOX"));
            this.mailSummary.removeAll();
            int i = 0;
            while (i < msg.length) {
                this.makeMailSummaryItem(msg[i]);
                ++i;
            }
        }
        catch (MessagingException e) {
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)("I/O Exception: " + e.getMessage()));
        }
    }

    private void makeMailSummaryItem(Message msg) throws MessagingException {
        TableItem item = new TableItem(this.mailSummary, 2048);
        String[] data = new String[5];
        data[0] = String.valueOf(msg.getMessageNumber());
        Date d = msg.getSentDate();
        data[1] = IMAPClient.getInstance().getFlagString(msg);
        data[2] = d != null ? d.toString() : "UNKNOWN";
        data[3] = msg.getFrom()[0].toString();
        data[4] = msg.getSubject();
        item.setText(data);
    }

    public void dispose() {
        try {
            IMAPClient.getInstance().close(false);
        }
        catch (MessagingException e) {
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)("I/O Exception: " + e.getMessage()));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj != null) {
            if (obj == this.updateButton) {
                this.updateSummary();
            } else if (obj == this.mailSummary) {
                TableItem[] items = ((Table)obj).getSelection();
                if (items != null) {
                    this.selectData = this.viewer.viewMessage(this.infoPage.getIMAPClientData(), "INBOX", Integer.parseInt(items[0].getText(0)));
                    this.text.setText(String.valueOf(this.selectData.getHeaderString()) + this.selectData.getMessage());
                }
            } else if (obj == this.replyMesgButton && this.selectData != null) {
                String body = "";
                try {
                    body = this.convReplyBody(this.selectData.getFromAddrStr(), this.selectData.getDate(), this.selectData.getPlainMessage());
                }
                catch (IOException iOException) {}
                this.sendPage.makeNewDraft(String.valueOf(this.selectData.getFromAddrStr()) + ", " + this.selectData.getToAddrStr(), this.selectData.getCcAddrStr(), this.convReplySubject(this.selectData.getSubject()), body);
            }
        }
    }

    private String convReplyBody(String from, Date d, String mesg) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(mesg));
        String s = "\n\n\n";
        s = String.valueOf(s) + "at " + d + ",\n";
        s = String.valueOf(s) + from + " wrote:\n";
        String tmp = "";
        while ((tmp = reader.readLine()) != null) {
            s = String.valueOf(s) + "> " + tmp + "\n";
        }
        s = String.valueOf(s) + "\n";
        return s;
    }

    private String convReplySubject(String a) {
        if (a.startsWith("Re:") || a.startsWith("RE:")) {
            return a;
        }
        return "Re: " + a;
    }
}

