/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mailer.editors;

import net.wasamon.mailer.editors.ClientInfoPage;
import net.wasamon.mailer.editors.MessageViewer;
import net.wasamon.mailer.editors.SendMailPage;
import net.wasamon.mailer.editors.SummaryController;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MailScreen
extends MultiPageEditorPart
implements IResourceChangeListener {
    private SummaryController summary;
    private TextEditor editor;
    private MessageViewer mesgViewer;
    private ClientInfoPage infoPage;
    private SendMailPage sendPage;

    public MailScreen() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public MessageViewer getMessageViewer() {
        return this.mesgViewer;
    }

    void createPage2() {
        try {
            this.editor = new TextEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, this.editor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    protected void createPages() {
        this.infoPage = new ClientInfoPage(this.getContainer(), this.getSite().getShell(), 0);
        this.mesgViewer = new MessageViewer(this.getContainer(), this.getSite().getShell(), 0);
        this.sendPage = new SendMailPage(this.getContainer(), this.getSite().getShell(), 0, this.infoPage);
        this.summary = new SummaryController(this.getContainer(), this.getSite().getShell(), 0, this.mesgViewer, this.infoPage, this.sendPage);
        int index = this.addPage((Control)this.infoPage.getComposite());
        this.setPageText(index, "Config");
        index = this.addPage((Control)this.summary.getComposite());
        this.setPageText(index, "Summary");
        index = this.addPage((Control)this.mesgViewer.getComposite());
        this.setPageText(index, "Message");
        index = this.addPage((Control)this.sendPage.getComposite());
        this.setPageText(index, "Draft");
    }

    public void dispose() {
        this.summary.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = MailScreen.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)MailScreen.this.editor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(MailScreen.this.editor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }
}

