/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mailer.driver;

import com.sun.mail.smtp.SMTPTransport;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.driver.MessageData;

public class SMTPClient {
    private static SMTPClient instance = new SMTPClient();

    public static SMTPClient getInstance() {
        return instance;
    }

    private SMTPClient() {
    }

    public void sendMessage(ClientData data, MessageData mesgData) throws MessagingException, UnsupportedEncodingException {
        boolean authFlag;
        Properties props = System.getProperties();
        props.put("mail.smtp.host", data.host);
        if (!"".equals(data.password)) {
            authFlag = true;
            props.put("mail.smtp.auth", (Object)true);
        } else {
            authFlag = false;
            props.put("mail.smtp.auth", (Object)false);
        }
        Session session = Session.getInstance((Properties)props, null);
        MimeMessage mesg = new MimeMessage(session);
        mesg.setFrom(mesgData.fromAddr);
        mesg.setRecipients(Message.RecipientType.TO, mesgData.toAddr);
        if (mesgData.ccAddr != null) {
            System.out.println(mesgData.ccAddr);
            mesg.setRecipients(Message.RecipientType.CC, mesgData.ccAddr);
        }
        if (mesgData.bccAddr != null) {
            System.out.println(mesgData.bccAddr);
            mesg.setRecipients(Message.RecipientType.BCC, mesgData.bccAddr);
        }
        mesg.setSubject(MimeUtility.encodeText((String)mesgData.subject, (String)"iso-2022-jp", (String)"B"));
        mesg.setText(mesgData.body, "iso-2022-jp");
        mesg.setHeader("X-Mailer", "Mailer On Eclipse 0.1.0");
        mesg.setHeader("Content-Transfer-Encoding", "7bit");
        mesg.setSentDate(new Date());
        SMTPTransport t = (SMTPTransport)session.getTransport("smtp");
        try {
            if (authFlag) {
                t.connect(data.host, data.user, data.password);
            } else {
                t.connect();
            }
            t.sendMessage((Message)mesg, mesg.getAllRecipients());
        }
        finally {
            t.close();
        }
    }
}

