library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;
entity net_wasamon_blokus_javarock_io is
  port (
    getchar_method_busy : OUT std_logic;
    notify_method_busy : OUT std_logic;
    output_port_getchar : OUT std_logic_vector(7 downto 0);
    putchar_method_busy : OUT std_logic;
    obj_tx_dout : OUT std_logic;
    obj_rx_din : IN std_logic;
    input_port_putchar_c : IN std_logic_vector(7 downto 0);
    notify_method_request : IN std_logic;
    reset : IN std_logic;
    getchar_method_request : IN std_logic;
    putchar_method_request : IN std_logic;
    clk : IN std_logic
  );
end net_wasamon_blokus_javarock_io;

architecture RTL of net_wasamon_blokus_javarock_io is
  component net_wasamon_blokus_javarock_rs232c
    port (
      notify_method_busy : OUT std_logic;
      write_method_busy : OUT std_logic;
      tx_dout : OUT std_logic;
      read_method_busy : OUT std_logic;
      output_port_read : OUT std_logic_vector(7 downto 0);
      rx_din : IN std_logic;
      notify_method_request : IN std_logic;
      input_port_write_data : IN std_logic_vector(7 downto 0);
      write_method_request : IN std_logic;
      reset : IN std_logic;
      read_method_request : IN std_logic;
      clk : IN std_logic
    );
  end component;
  signal obj_write_method_request_field_wdata_reset : std_logic := '0';
  signal obj_write_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal obj_write_method_request_field_wdata_writer_putchar_method_state : std_logic := '0';
  signal obj_write_method_request_field_wdata_writer_strobe_putchar_method_state : std_logic := '0';
  signal obj_write_method_request_field_rdata : std_logic := '0';
  signal obj_write_method_request_field_wdata : std_logic := '0';
  signal obj_notify_method_request_field_wdata_reset : std_logic := '0';
  signal obj_notify_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal obj_notify_method_request_field_rdata : std_logic := '0';
  signal obj_notify_method_request_field_wdata : std_logic := '0';
  signal this_wait_method_request_field_wdata_reset : std_logic := '0';
  signal this_wait_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_wait_method_request_field_rdata : std_logic := '0';
  signal this_wait_method_request_field_wdata : std_logic := '0';
  signal obj_input_port_write_data_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal obj_input_port_write_data_field_wdata_reset_strobe : std_logic := '0';
  signal obj_input_port_write_data_field_wdata_writer_putchar_method_state : std_logic_vector(7 downto 0) := (others => '0');
  signal obj_input_port_write_data_field_wdata_writer_strobe_putchar_method_state : std_logic := '0';
  signal obj_input_port_write_data_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal obj_input_port_write_data_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal obj_output_port_read_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal obj_output_port_read_field_wdata_reset_strobe : std_logic := '0';
  signal obj_output_port_read_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal obj_output_port_read_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal obj_notify_method_busy_field_wdata_reset : std_logic := '0';
  signal obj_notify_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal obj_notify_method_busy_field_rdata : std_logic := '0';
  signal obj_notify_method_busy_field_wdata : std_logic := '0';
  signal obj_read_method_busy_field_wdata_reset : std_logic := '0';
  signal obj_read_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal obj_read_method_busy_field_rdata : std_logic := '0';
  signal obj_read_method_busy_field_wdata : std_logic := '0';
  signal obj_write_method_busy_field_wdata_reset : std_logic := '0';
  signal obj_write_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal obj_write_method_busy_field_rdata : std_logic := '0';
  signal obj_write_method_busy_field_wdata : std_logic := '0';
  signal obj_read_method_request_field_wdata_reset : std_logic := '0';
  signal obj_read_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal obj_read_method_request_field_wdata_writer_getchar_method_state : std_logic := '0';
  signal obj_read_method_request_field_wdata_writer_strobe_getchar_method_state : std_logic := '0';
  signal obj_read_method_request_field_rdata : std_logic := '0';
  signal obj_read_method_request_field_wdata : std_logic := '0';
  signal this_putchar_method_busy : std_logic := '0';
  signal getchar_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_wait_method_busy : std_logic := '0';
  signal obj_write_call_state_counter_putchar_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_notify_method_request : std_logic := '0';
  signal wait_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal putchar_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_getchar_method_busy : std_logic := '0';
  signal this_notify_method_busy : std_logic := '0';
  signal b_getchar_0 : std_logic_vector(7 downto 0) := (others => '0');
  signal d_notify_flag : std_logic := '0';
  signal notify_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_wait_wait_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_putchar_method_request : std_logic := '0';
  signal this_input_port_putchar_c : std_logic_vector(7 downto 0) := (others => '0');
  signal state_counter_putchar_putchar_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_getchar_method_request : std_logic := '0';
  signal state_counter_getchar_getchar_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal notify_flag : std_logic := '0';
  signal obj_read_call_state_counter_getchar_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_notify_notify_0 : std_logic_vector(31 downto 0) := (others => '0');
begin
  U_obj : net_wasamon_blokus_javarock_rs232c
  port map(
    notify_method_busy => obj_notify_method_busy_field_wdata,
    write_method_busy => obj_write_method_busy_field_wdata,
    tx_dout => obj_tx_dout,
    read_method_busy => obj_read_method_busy_field_wdata,
    output_port_read => obj_output_port_read_field_wdata,
    rx_din => obj_rx_din,
    notify_method_request => obj_notify_method_request_field_rdata,
    input_port_write_data => obj_input_port_write_data_field_rdata,
    write_method_request => obj_write_method_request_field_rdata,
    reset => reset,
    read_method_request => obj_read_method_request_field_rdata,
    clk => clk
  );
  this_notify_method_request <= notify_method_request;
  notify_method_busy <= this_notify_method_busy;
  this_input_port_putchar_c <= conv_std_logic_vector(conv_integer(input_port_putchar_c), this_input_port_putchar_c'length);
  this_putchar_method_request <= putchar_method_request;
  putchar_method_busy <= this_putchar_method_busy;
  this_getchar_method_request <= getchar_method_request;
  getchar_method_busy <= this_getchar_method_busy;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        obj_write_method_request_field_wdata <= obj_write_method_request_field_wdata_reset;
      elsif (obj_write_method_request_field_wdata_reset_strobe = '1') then
        obj_write_method_request_field_wdata <= obj_write_method_request_field_wdata_reset;
      elsif (obj_write_method_request_field_wdata_writer_strobe_putchar_method_state = '1') then
        obj_write_method_request_field_wdata <= obj_write_method_request_field_wdata_writer_putchar_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        obj_write_method_request_field_wdata_reset_strobe <= '1';
      else
        obj_write_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(putchar_method_state) = 2 or conv_integer(putchar_method_state) = 2) then
        obj_write_method_request_field_wdata_writer_strobe_putchar_method_state <= '1';
      else
        obj_write_method_request_field_wdata_writer_strobe_putchar_method_state <= '0';
      end if;
    end if;
  end process;
  obj_write_method_request_field_rdata <= obj_write_method_request_field_wdata_reset when (reset = '1') else
        obj_write_method_request_field_wdata_reset when (obj_write_method_request_field_wdata_reset_strobe = '1') else
        obj_write_method_request_field_wdata_writer_putchar_method_state when (obj_write_method_request_field_wdata_writer_strobe_putchar_method_state = '1') else
        obj_write_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        obj_notify_method_request_field_wdata <= obj_notify_method_request_field_wdata_reset;
      elsif (obj_notify_method_request_field_wdata_reset_strobe = '1') then
        obj_notify_method_request_field_wdata <= obj_notify_method_request_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        obj_notify_method_request_field_wdata_reset_strobe <= '1';
      else
        obj_notify_method_request_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  obj_notify_method_request_field_rdata <= obj_notify_method_request_field_wdata_reset when (reset = '1') else
        obj_notify_method_request_field_wdata_reset when (obj_notify_method_request_field_wdata_reset_strobe = '1') else
        obj_notify_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      elsif (this_wait_method_request_field_wdata_reset_strobe = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata_reset_strobe <= '1';
      else
        this_wait_method_request_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  this_wait_method_request_field_rdata <= this_wait_method_request_field_wdata_reset when (reset = '1') else
        this_wait_method_request_field_wdata_reset when (this_wait_method_request_field_wdata_reset_strobe = '1') else
        this_wait_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        obj_input_port_write_data_field_wdata <= obj_input_port_write_data_field_wdata_reset;
      elsif (obj_input_port_write_data_field_wdata_reset_strobe = '1') then
        obj_input_port_write_data_field_wdata <= obj_input_port_write_data_field_wdata_reset;
      elsif (obj_input_port_write_data_field_wdata_writer_strobe_putchar_method_state = '1') then
        obj_input_port_write_data_field_wdata <= obj_input_port_write_data_field_wdata_writer_putchar_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        obj_input_port_write_data_field_wdata_reset_strobe <= '1';
      else
        obj_input_port_write_data_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(putchar_method_state) = 2) then
        obj_input_port_write_data_field_wdata_writer_strobe_putchar_method_state <= '1';
      else
        obj_input_port_write_data_field_wdata_writer_strobe_putchar_method_state <= '0';
      end if;
    end if;
  end process;
  obj_input_port_write_data_field_rdata <= obj_input_port_write_data_field_wdata_reset when (reset = '1') else
        obj_input_port_write_data_field_wdata_reset when (obj_input_port_write_data_field_wdata_reset_strobe = '1') else
        obj_input_port_write_data_field_wdata_writer_putchar_method_state when (obj_input_port_write_data_field_wdata_writer_strobe_putchar_method_state = '1') else
        obj_input_port_write_data_field_wdata;
  
  obj_output_port_read_field_rdata <= obj_output_port_read_field_wdata;
  
  obj_notify_method_busy_field_rdata <= obj_notify_method_busy_field_wdata;
  
  obj_read_method_busy_field_rdata <= obj_read_method_busy_field_wdata;
  
  obj_write_method_busy_field_rdata <= obj_write_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        obj_read_method_request_field_wdata <= obj_read_method_request_field_wdata_reset;
      elsif (obj_read_method_request_field_wdata_reset_strobe = '1') then
        obj_read_method_request_field_wdata <= obj_read_method_request_field_wdata_reset;
      elsif (obj_read_method_request_field_wdata_writer_strobe_getchar_method_state = '1') then
        obj_read_method_request_field_wdata <= obj_read_method_request_field_wdata_writer_getchar_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        obj_read_method_request_field_wdata_reset_strobe <= '1';
      else
        obj_read_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(getchar_method_state) = 2 or conv_integer(getchar_method_state) = 2) then
        obj_read_method_request_field_wdata_writer_strobe_getchar_method_state <= '1';
      else
        obj_read_method_request_field_wdata_writer_strobe_getchar_method_state <= '0';
      end if;
    end if;
  end process;
  obj_read_method_request_field_rdata <= obj_read_method_request_field_wdata_reset when (reset = '1') else
        obj_read_method_request_field_wdata_reset when (obj_read_method_request_field_wdata_reset_strobe = '1') else
        obj_read_method_request_field_wdata_writer_getchar_method_state when (obj_read_method_request_field_wdata_writer_strobe_getchar_method_state = '1') else
        obj_read_method_request_field_wdata;
  process(clk) --getchar
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_getchar_getchar_0 <= (others => '0');
        b_getchar_0 <= (others => '0');
        obj_read_call_state_counter_getchar_0 <= (others => '0');
        obj_read_call_state_counter_getchar_0 <= (others => '0');
        this_getchar_method_busy <= '0';
        getchar_method_state <= (others => '0');
        obj_read_method_request_field_wdata_reset <= '0';
        output_port_getchar <= (others => '0');
      else
        case conv_integer(getchar_method_state) is
          when 0 =>
            if(this_getchar_method_request = '1') then
              this_getchar_method_busy <= '1';
              getchar_method_state <= getchar_method_state + 1;
            else
              this_getchar_method_busy <= '0';
            end if;
          when 1 =>
            if(this_getchar_method_request = '0') then
              getchar_method_state <= getchar_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(obj_read_call_state_counter_getchar_0) is
              when 0 =>
                if (obj_read_method_busy_field_wdata = '0') then
                  obj_read_method_request_field_wdata_writer_getchar_method_state <= '1';
                  obj_read_call_state_counter_getchar_0 <= conv_std_logic_vector(1, obj_read_call_state_counter_getchar_0'length);
                end if;
              when 1 =>
                obj_read_method_request_field_wdata_writer_getchar_method_state <= '0';
                  obj_read_call_state_counter_getchar_0 <= conv_std_logic_vector(2, obj_read_call_state_counter_getchar_0'length);
              when 2 =>
                if (obj_read_method_request_field_wdata = '0' and obj_read_method_busy_field_wdata = '0') then
                  obj_read_call_state_counter_getchar_0 <= (others => '0');
                  getchar_method_state <= getchar_method_state + 1;
                end if;
              when others => obj_read_call_state_counter_getchar_0 <= (others => '0');
            end case;
          when 3 => 
            b_getchar_0 <= conv_std_logic_vector(conv_integer(obj_output_port_read_field_rdata), b_getchar_0'length);
            getchar_method_state <= getchar_method_state + 1;
          when 4 => 
            output_port_getchar <= conv_std_logic_vector(conv_integer(b_getchar_0), output_port_getchar'length);
            getchar_method_state <= (others => '0');
          when 5 =>
            this_getchar_method_busy <= '0';
            getchar_method_state <= (others => '0');
          when others => getchar_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --getchar
  process(clk) --notify
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        notify_flag <= '0';
        this_notify_method_busy <= '0';
        notify_method_state <= (others => '0');
        state_counter_notify_notify_0 <= (others => '0');
      else
        case conv_integer(notify_method_state) is
          when 0 =>
            if(this_notify_method_request = '1') then
              this_notify_method_busy <= '1';
              notify_method_state <= notify_method_state + 1;
            else
              this_notify_method_busy <= '0';
            end if;
          when 1 =>
            if(this_notify_method_request = '0') then
              notify_method_state <= notify_method_state + 1;
            end if;
          when 2 => 
            notify_flag <= '1';
            notify_method_state <= notify_method_state + 1;
          when 3 => 
            notify_flag <= '0';
            notify_method_state <= notify_method_state + 1;
          when 4 =>
            this_notify_method_busy <= '0';
            notify_method_state <= (others => '0');
          when others => notify_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --notify
  process(clk) --wait
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        d_notify_flag <= '0';
        this_wait_method_busy <= '0';
        wait_method_state <= (others => '0');
        state_counter_wait_wait_0 <= (others => '0');
      else
        case conv_integer(wait_method_state) is
          when 0 =>
            if(this_wait_method_request_field_rdata = '1') then
              this_wait_method_busy <= '1';
              wait_method_state <= wait_method_state + 1;
            else
              this_wait_method_busy <= '0';
            end if;
          when 1 =>
            if(this_wait_method_request_field_rdata = '0') then
              wait_method_state <= wait_method_state + 1;
            end if;
          when 2 => 
            if (d_notify_flag = '0' and notify_flag = '1') then
              wait_method_state <= wait_method_state + 1;
            else
              d_notify_flag <= notify_flag;
            end if;
          when 3 =>
            this_wait_method_busy <= '0';
            wait_method_state <= (others => '0');
          when others => wait_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --wait
  process(clk) --putchar
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_putchar_putchar_0 <= (others => '0');
        obj_write_call_state_counter_putchar_0 <= (others => '0');
        obj_write_call_state_counter_putchar_0 <= (others => '0');
        this_putchar_method_busy <= '0';
        putchar_method_state <= (others => '0');
        obj_write_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(putchar_method_state) is
          when 0 =>
            if(this_putchar_method_request = '1') then
              this_putchar_method_busy <= '1';
              putchar_method_state <= putchar_method_state + 1;
            else
              this_putchar_method_busy <= '0';
            end if;
          when 1 =>
            if(this_putchar_method_request = '0') then
              putchar_method_state <= putchar_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(obj_write_call_state_counter_putchar_0) is
              when 0 =>
                if (obj_write_method_busy_field_wdata = '0') then
                  obj_write_method_request_field_wdata_writer_putchar_method_state <= '1';
                  obj_write_call_state_counter_putchar_0 <= conv_std_logic_vector(1, obj_write_call_state_counter_putchar_0'length);
                end if;
              when 1 =>
                obj_input_port_write_data_field_wdata_writer_putchar_method_state <= conv_std_logic_vector(conv_integer(input_port_putchar_c), obj_input_port_write_data_field_wdata'length);
                obj_write_method_request_field_wdata_writer_putchar_method_state <= '0';
                  obj_write_call_state_counter_putchar_0 <= conv_std_logic_vector(2, obj_write_call_state_counter_putchar_0'length);
              when 2 =>
                if (obj_write_method_request_field_wdata = '0' and obj_write_method_busy_field_wdata = '0') then
                  obj_write_call_state_counter_putchar_0 <= (others => '0');
                  putchar_method_state <= putchar_method_state + 1;
                end if;
              when others => obj_write_call_state_counter_putchar_0 <= (others => '0');
            end case;
          when 3 =>
            this_putchar_method_busy <= '0';
            putchar_method_state <= (others => '0');
          when others => putchar_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --putchar
end RTL;
