package net.wasamon.blokus.javarock.tools;



public class BlokusDuoPatternLengthGen extends RomGenerator{
	
	public static final int MAX_NUM_OF_POINTS = 5;
	public static final int NUM_OF_PATTERNS = 8;
	
	public BlokusDuoPatternLengthGen(int width, int num){
		super("BlokusPatternLengthTable", "vhdl_block_pattern_length_table", width, num);
	}
	
	private static String convBitVector(int v){
		String s = "00000000";
		s += Integer.toBinaryString(v);
		return "\"" + s.substring(s.length()-8, s.length()) + "\"";
	}
	
	public static void main(String... args){
		String contents = "";
		contents += convBitVector(1) + ", "; // 'a'
		contents += convBitVector(2) + ", "; // 'b'
		contents += convBitVector(3) + ", "; // 'c'
		contents += convBitVector(3) + ", "; // 'd'
		contents += convBitVector(4) + ", "; // 'e'
		contents += convBitVector(4) + ", "; // 'f'
		contents += convBitVector(4) + ", "; // 'g'
		contents += convBitVector(4) + ", "; // 'h'
		contents += convBitVector(4) + ", "; // 'i' 
		contents += convBitVector(5) + ", "; // 'j'
		contents += convBitVector(5) + ", "; // 'k'
		contents += convBitVector(5) + ", "; // 'l'
		contents += convBitVector(5) + ", "; // 'm'
		contents += convBitVector(5) + ", "; // 'n'
		contents += convBitVector(5) + ", "; // 'o'
		contents += convBitVector(5) + ", "; // 'p'
		contents += convBitVector(5) + ", "; // 'q'
		contents += convBitVector(5) + ", "; // 'r'
		contents += convBitVector(5) + ", "; // 's'
		contents += convBitVector(5) + ", "; // 't'
		contents += convBitVector(5);        // 'u'
		BlokusDuoPatternLengthGen gen = new BlokusDuoPatternLengthGen(8, ('u'-'a'+1));
		gen.genVHDL(contents);
		gen.genJava("net.wasamon.blokus.javarock", contents);
		
	}
	

}
