package net.wasamon.blokus.javarock.test;

import net.wasamon.blokus.javarock.SimplePlayer;

public class Sim {
	
	public static void main(String... args){
		SimplePlayer p0 = new SimplePlayer();
		SimplePlayer p1 = new SimplePlayer();
		DebugGUI gui = new DebugGUI(p0.getBoard());
		gui.initTestGUI();
		
		p0.setTurnCode(1);
		p1.setTurnCode(2);
		
		int c0, c1;
		
		c0 = p0.getFirstMoveCode(5-1, 5-1); // convert value into 0-origin
		c1 = p1.getFirstMoveCode(10-1, 10-1); // convert value into 0-origin
		
		System.out.printf("p0: %08x @(%d,%d) %c:%d)\n", c0, (c0>>>24)&0x000000FF, (c0>>>16)&0x000000FF, ((c0>>>8)&0x000000FF)+'a', c0&0x000000FF);
		System.out.printf("p1: %08x @(%d,%d) %c:%d)\n", c1, (c1>>>24)&0x000000FF, (c1>>>16)&0x000000FF, ((c1>>>8)&0x000000FF)+'a', c1&0x000000FF);
		
		p0.setOpponentMove((c1>>>24)&0x000000FF, (c1>>>16)&0x000000FF, (c1>>>8)&0x000000FF, c1&0x000000FF);
		p1.setOpponentMove((c0>>>24)&0x000000FF, (c0>>>16)&0x000000FF, (c0>>>8)&0x000000FF, c0&0x000000FF);
		
		while(c0 != -1 || c1 != -1){
			c0 = p0.getNextMove();
			System.out.printf("p0: %08x @(%d,%d) %c:%d)\n", c0, (c0>>>24)&0x000000FF, (c0>>>16)&0x000000FF, ((c0>>>8)&0x000000FF)+'a', c0&0x000000FF);
			if(c0 != -1){
				p1.setOpponentMove((c0>>>24)&0x000000FF, (c0>>>16)&0x000000FF, (c0>>>8)&0x000000FF, c0&0x000000FF);
				gui.update();
			}
			c1 = p1.getNextMove();
			System.out.printf("p1: %08x @(%d,%d) %c:%d)\n", c1, (c1>>>24)&0x000000FF, (c1>>>16)&0x000000FF, ((c1>>>8)&0x000000FF)+'a', c1&0x000000FF);
			if(c1 != -1){
				p0.setOpponentMove((c1>>>24)&0x000000FF, (c1>>>16)&0x000000FF, (c1>>>8)&0x000000FF, c1&0x000000FF);
				gui.update();
			}
		}
		
		
	}


}
