package net.wasamon.blokus.javarock.test;

import javax.swing.JFrame;

import net.wasamon.blokus.javarock.BlokusBoard;
import net.wasamon.blokus.javarock.BoardPanel;

public class DebugGUI {
	
	private JFrame frame;
	private BoardPanel panel;
	
	private final BlokusBoard board;
	
	public DebugGUI(BlokusBoard board){
		this.board = board;
	}
	
	public void initGUI(){
		frame = new JFrame();
		panel = new BoardPanel(board);
		
		frame.getContentPane().add(panel);
		frame.pack();
		frame.setVisible(true);
	}
	
	public void update(){
		frame.repaint();
		panel.repaint();
	}
	
	public void initTestGUI(){
		initGUI();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
	
}


