library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
entity vhdl_block_pattern_length_table is
  generic (
    DEPTH : integer := 5;
    WIDTH : integer := 8 );

  port (
    clk   : in  std_logic;
    reset : in  std_logic;
    data_raddr : in  std_logic_vector(31 downto 0);
    data_rdata : out std_logic_vector(7 downto 0) );

end vhdl_block_pattern_length_table;

architecture RTL of vhdl_block_pattern_length_table is

  type rom_type is array (0 to 20) of std_logic_vector (WIDTH-1 downto 0);
  constant ROM: rom_type := (
  "00000001", "00000010", "00000011", "00000011", "00000100", "00000100", "00000100", "00000100", "00000100", "00000101", "00000101", "00000101", "00000101", "00000101", "00000101", "00000101", "00000101", "00000101", "00000101", "00000101", "00000101"
  );  signal q : std_logic_vector(7 downto 0);
begin  -- RTL

  data_rdata <= q;

  process (clk)
  begin
    if clk'event and clk = '1' then
      q <= ROM(conv_integer(data_raddr(DEPTH-1 downto 0)));
    end if;
  end process;

end RTL;
