library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;
entity net_wasamon_blokus_javarock_gameagent is
  port (
    notify_method_busy : OUT std_logic;
    output_port_led_out : OUT std_logic_vector(31 downto 0);
    io_obj_tx_dout : OUT std_logic;
    notify_method_request : IN std_logic;
    io_obj_rx_din : IN std_logic;
    reset : IN std_logic;
    player_code_input : IN std_logic_vector(31 downto 0);
    clk : IN std_logic
  );
end net_wasamon_blokus_javarock_gameagent;

architecture RTL of net_wasamon_blokus_javarock_gameagent is
  component simpledualportram
    generic (
      DEPTH : integer := 10;
      WIDTH : integer := 32
    );
    port (
      clk : IN std_logic;
      we : IN std_logic_vector(0 downto 0);
      raddr : IN std_logic_vector(DEPTH-1 downto 0);
      rdata : OUT std_logic_vector(WIDTH-1 downto 0);
      waddr : IN std_logic_vector(DEPTH-1 downto 0);
      wdata : IN std_logic_vector(WIDTH-1 downto 0)
    );
  end component;
  component vhdl_input32
    port (
      input : IN std_logic_vector(31 downto 0);
      value : OUT std_logic_vector(31 downto 0)
    );
  end component;
  component net_wasamon_blokus_javarock_io
    port (
      getchar_method_busy : OUT std_logic;
      notify_method_busy : OUT std_logic;
      output_port_getchar : OUT std_logic_vector(7 downto 0);
      putchar_method_busy : OUT std_logic;
      obj_tx_dout : OUT std_logic;
      obj_rx_din : IN std_logic;
      input_port_putchar_c : IN std_logic_vector(7 downto 0);
      notify_method_request : IN std_logic;
      reset : IN std_logic;
      getchar_method_request : IN std_logic;
      putchar_method_request : IN std_logic;
      clk : IN std_logic
    );
  end component;
  component net_wasamon_blokus_javarock_led
    port (
      value_field_rdata_output_port : OUT std_logic_vector(31 downto 0);
      notify_method_busy : OUT std_logic;
      run_method_busy : OUT std_logic;
      value_field_rdata_input_strobe_port : IN std_logic;
      value_field_rdata_input_port : IN std_logic_vector(31 downto 0);
      run_method_request : IN std_logic;
      notify_method_request : IN std_logic;
      reset : IN std_logic;
      clk : IN std_logic
    );
  end component;
  component net_wasamon_blokus_javarock_simpleplayer
    port (
      notify_method_busy : OUT std_logic;
      getNextMove_method_busy : OUT std_logic;
      setOpponentMove_method_busy : OUT std_logic;
      init_method_busy : OUT std_logic;
      output_port_getNextMove : OUT std_logic_vector(31 downto 0);
      setTurnCode_method_busy : OUT std_logic;
      getFirstMoveCode_method_busy : OUT std_logic;
      output_port_getFirstMoveCode : OUT std_logic_vector(31 downto 0);
      setTurnCode_method_request : IN std_logic;
      clk : IN std_logic;
      notify_method_request : IN std_logic;
      input_port_setOpponentMove_rot : IN std_logic_vector(31 downto 0);
      input_port_setOpponentMove_y : IN std_logic_vector(31 downto 0);
      getFirstMoveCode_method_request : IN std_logic;
      input_port_setOpponentMove_x : IN std_logic_vector(31 downto 0);
      getNextMove_method_request : IN std_logic;
      reset : IN std_logic;
      input_port_setTurnCode_v : IN std_logic_vector(31 downto 0);
      input_port_getFirstMoveCode_y : IN std_logic_vector(31 downto 0);
      input_port_setOpponentMove_id : IN std_logic_vector(31 downto 0);
      input_port_getFirstMoveCode_x : IN std_logic_vector(31 downto 0);
      setOpponentMove_method_request : IN std_logic;
      init_method_request : IN std_logic
    );
  end component;
  constant buffer_length : integer := 8;
  constant buffer_WIDTH : integer := 7-0+1;
  constant buffer_DEPTH : integer := 3;
  signal player_init_method_request_field_wdata_reset : std_logic := '0';
  signal player_init_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal player_init_method_request_field_wdata_writer_init_method_state : std_logic := '0';
  signal player_init_method_request_field_wdata_writer_strobe_init_method_state : std_logic := '0';
  signal player_init_method_request_field_rdata : std_logic := '0';
  signal player_init_method_request_field_wdata : std_logic := '0';
  signal this_sendResponse_method_request_field_wdata_reset : std_logic := '0';
  signal this_sendResponse_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_sendResponse_method_request_field_wdata_writer_game_method_state : std_logic := '0';
  signal this_sendResponse_method_request_field_wdata_writer_strobe_game_method_state : std_logic := '0';
  signal this_sendResponse_method_request_field_wdata_writer_state_counter_game_game_6 : std_logic := '0';
  signal this_sendResponse_method_request_field_wdata_writer_strobe_state_counter_game_game_6 : std_logic := '0';
  signal this_sendResponse_method_request_field_rdata : std_logic := '0';
  signal this_sendResponse_method_request_field_wdata : std_logic := '0';
  signal this_input_port_sendResponse_code_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_sendResponse_code_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_sendResponse_code_field_wdata_writer_game_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_sendResponse_code_field_wdata_writer_strobe_game_method_state : std_logic := '0';
  signal this_input_port_sendResponse_code_field_wdata_writer_state_counter_game_game_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_sendResponse_code_field_wdata_writer_strobe_state_counter_game_game_6 : std_logic := '0';
  signal this_input_port_sendResponse_code_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_sendResponse_code_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_setTurnCode_method_busy_field_wdata_reset : std_logic := '0';
  signal player_setTurnCode_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal player_setTurnCode_method_busy_field_rdata : std_logic := '0';
  signal player_setTurnCode_method_busy_field_wdata : std_logic := '0';
  signal player_init_method_busy_field_wdata_reset : std_logic := '0';
  signal player_init_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal player_init_method_busy_field_rdata : std_logic := '0';
  signal player_init_method_busy_field_wdata : std_logic := '0';
  signal player_code_value_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal player_code_value_field_wdata_reset_strobe : std_logic := '0';
  signal player_code_value_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_code_value_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal buffer_we_field_wdata_reset : std_logic_vector(0 downto 0) := (others => '0');
  signal buffer_we_field_wdata_reset_strobe : std_logic := '0';
  signal buffer_we_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 : std_logic_vector(0 downto 0) := (others => '0');
  signal buffer_we_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 : std_logic := '0';
  signal buffer_we_field_rdata : std_logic_vector(0 downto 0) := (others => '0');
  signal buffer_we_field_wdata : std_logic_vector(0 downto 0) := (others => '0');
  signal player_getNextMove_method_request_field_wdata_reset : std_logic := '0';
  signal player_getNextMove_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal player_getNextMove_method_request_field_wdata_writer_state_counter_game_game_6 : std_logic := '0';
  signal player_getNextMove_method_request_field_wdata_writer_strobe_state_counter_game_game_6 : std_logic := '0';
  signal player_getNextMove_method_request_field_rdata : std_logic := '0';
  signal player_getNextMove_method_request_field_wdata : std_logic := '0';
  signal codeL_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal codeL_field_wdata_reset_strobe : std_logic := '0';
  signal codeL_field_wdata_writer_init_method_state : std_logic_vector(7 downto 0) := (others => '0');
  signal codeL_field_wdata_writer_strobe_init_method_state : std_logic := '0';
  signal codeL_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal codeL_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal buffer_wdata_field_wdata_reset : std_logic_vector(7-0+1-1 downto 0) := (others => '0');
  signal buffer_wdata_field_wdata_reset_strobe : std_logic := '0';
  signal buffer_wdata_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 : std_logic_vector(7-0+1-1 downto 0) := (others => '0');
  signal buffer_wdata_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 : std_logic := '0';
  signal buffer_wdata_field_rdata : std_logic_vector(7-0+1-1 downto 0) := (others => '0');
  signal buffer_wdata_field_wdata : std_logic_vector(7-0+1-1 downto 0) := (others => '0');
  signal io_putchar_method_busy_field_wdata_reset : std_logic := '0';
  signal io_putchar_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal io_putchar_method_busy_field_rdata : std_logic := '0';
  signal io_putchar_method_busy_field_wdata : std_logic := '0';
  signal led_value_field_rdata_input_port_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal led_value_field_rdata_input_port_field_wdata_reset_strobe : std_logic := '0';
  signal led_value_field_rdata_input_port_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal led_value_field_rdata_input_port_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_setTurnCode_method_request_field_wdata_reset : std_logic := '0';
  signal player_setTurnCode_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal player_setTurnCode_method_request_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6 : std_logic := '0';
  signal player_setTurnCode_method_request_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 : std_logic := '0';
  signal player_setTurnCode_method_request_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9 : std_logic := '0';
  signal player_setTurnCode_method_request_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 : std_logic := '0';
  signal player_setTurnCode_method_request_field_rdata : std_logic := '0';
  signal player_setTurnCode_method_request_field_wdata : std_logic := '0';
  signal player_output_port_getNextMove_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal player_output_port_getNextMove_field_wdata_reset_strobe : std_logic := '0';
  signal player_output_port_getNextMove_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_output_port_getNextMove_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_waitResponseCode_expected_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal this_input_port_waitResponseCode_expected_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_3 : std_logic_vector(7 downto 0) := (others => '0');
  signal this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_3 : std_logic := '0';
  signal this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_4 : std_logic_vector(7 downto 0) := (others => '0');
  signal this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_4 : std_logic := '0';
  signal this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_6 : std_logic_vector(7 downto 0) := (others => '0');
  signal this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_6 : std_logic := '0';
  signal this_input_port_waitResponseCode_expected_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal this_input_port_waitResponseCode_expected_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal codeH_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal codeH_field_wdata_reset_strobe : std_logic := '0';
  signal codeH_field_wdata_writer_init_method_state : std_logic_vector(7 downto 0) := (others => '0');
  signal codeH_field_wdata_writer_strobe_init_method_state : std_logic := '0';
  signal codeH_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal codeH_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal io_output_port_getchar_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal io_output_port_getchar_field_wdata_reset_strobe : std_logic := '0';
  signal io_output_port_getchar_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal io_output_port_getchar_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal led_value_field_rdata_input_strobe_port_field_wdata_reset : std_logic := '0';
  signal led_value_field_rdata_input_strobe_port_field_wdata_reset_strobe : std_logic := '0';
  signal led_value_field_rdata_input_strobe_port_field_rdata : std_logic := '0';
  signal led_value_field_rdata_input_strobe_port_field_wdata : std_logic := '0';
  signal this_wait_method_request_field_wdata_reset : std_logic := '0';
  signal this_wait_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_wait_method_request_field_rdata : std_logic := '0';
  signal this_wait_method_request_field_wdata : std_logic := '0';
  signal player_notify_method_busy_field_wdata_reset : std_logic := '0';
  signal player_notify_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal player_notify_method_busy_field_rdata : std_logic := '0';
  signal player_notify_method_busy_field_wdata : std_logic := '0';
  signal player_input_port_setOpponentMove_y_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_y_field_wdata_reset_strobe : std_logic := '0';
  signal player_input_port_setOpponentMove_y_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_y_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 : std_logic := '0';
  signal player_input_port_setOpponentMove_y_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_y_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_x_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_x_field_wdata_reset_strobe : std_logic := '0';
  signal player_input_port_setOpponentMove_x_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_x_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 : std_logic := '0';
  signal player_input_port_setOpponentMove_x_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_x_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal io_putchar_method_request_field_wdata_reset : std_logic := '0';
  signal io_putchar_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_3 : std_logic := '0';
  signal io_putchar_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_3 : std_logic := '0';
  signal io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 : std_logic := '0';
  signal io_putchar_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 : std_logic := '0';
  signal io_putchar_method_request_field_wdata_writer_doInitialization_method_state : std_logic := '0';
  signal io_putchar_method_request_field_wdata_writer_strobe_doInitialization_method_state : std_logic := '0';
  signal io_putchar_method_request_field_rdata : std_logic := '0';
  signal io_putchar_method_request_field_wdata : std_logic := '0';
  signal player_input_port_setTurnCode_v_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setTurnCode_v_field_wdata_reset_strobe : std_logic := '0';
  signal player_input_port_setTurnCode_v_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setTurnCode_v_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 : std_logic := '0';
  signal player_input_port_setTurnCode_v_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9 : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setTurnCode_v_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 : std_logic := '0';
  signal player_input_port_setTurnCode_v_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setTurnCode_v_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_setOpponentMove_method_busy_field_wdata_reset : std_logic := '0';
  signal player_setOpponentMove_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal player_setOpponentMove_method_busy_field_rdata : std_logic := '0';
  signal player_setOpponentMove_method_busy_field_wdata : std_logic := '0';
  signal player_setOpponentMove_method_request_field_wdata_reset : std_logic := '0';
  signal player_setOpponentMove_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal player_setOpponentMove_method_request_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 : std_logic := '0';
  signal player_setOpponentMove_method_request_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 : std_logic := '0';
  signal player_setOpponentMove_method_request_field_rdata : std_logic := '0';
  signal player_setOpponentMove_method_request_field_wdata : std_logic := '0';
  signal player_getFirstMoveCode_method_request_field_wdata_reset : std_logic := '0';
  signal player_getFirstMoveCode_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal player_getFirstMoveCode_method_request_field_wdata_writer_doFirstMove_method_state : std_logic := '0';
  signal player_getFirstMoveCode_method_request_field_wdata_writer_strobe_doFirstMove_method_state : std_logic := '0';
  signal player_getFirstMoveCode_method_request_field_rdata : std_logic := '0';
  signal player_getFirstMoveCode_method_request_field_wdata : std_logic := '0';
  signal this_toInt_method_request_field_wdata_reset : std_logic := '0';
  signal this_toInt_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_toInt_method_request_field_wdata_writer_parseAndApply_method_state : std_logic := '0';
  signal this_toInt_method_request_field_wdata_writer_strobe_parseAndApply_method_state : std_logic := '0';
  signal this_toInt_method_request_field_rdata : std_logic := '0';
  signal this_toInt_method_request_field_wdata : std_logic := '0';
  signal player_getNextMove_method_busy_field_wdata_reset : std_logic := '0';
  signal player_getNextMove_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal player_getNextMove_method_busy_field_rdata : std_logic := '0';
  signal player_getNextMove_method_busy_field_wdata : std_logic := '0';
  signal buffer_rdata_field_wdata_reset : std_logic_vector(7-0+1-1 downto 0) := (others => '0');
  signal buffer_rdata_field_wdata_reset_strobe : std_logic := '0';
  signal buffer_rdata_field_rdata : std_logic_vector(7-0+1-1 downto 0) := (others => '0');
  signal buffer_rdata_field_wdata : std_logic_vector(7-0+1-1 downto 0) := (others => '0');
  signal player_output_port_getFirstMoveCode_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal player_output_port_getFirstMoveCode_field_wdata_reset_strobe : std_logic := '0';
  signal player_output_port_getFirstMoveCode_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_output_port_getFirstMoveCode_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_notify_method_request_field_wdata_reset : std_logic := '0';
  signal player_notify_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal player_notify_method_request_field_rdata : std_logic := '0';
  signal player_notify_method_request_field_wdata : std_logic := '0';
  signal player_getFirstMoveCode_method_busy_field_wdata_reset : std_logic := '0';
  signal player_getFirstMoveCode_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal player_getFirstMoveCode_method_busy_field_rdata : std_logic := '0';
  signal player_getFirstMoveCode_method_busy_field_wdata : std_logic := '0';
  signal this_doFirstMove_method_request_field_wdata_reset : std_logic := '0';
  signal this_doFirstMove_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_doFirstMove_method_request_field_wdata_writer_game_method_state : std_logic := '0';
  signal this_doFirstMove_method_request_field_wdata_writer_strobe_game_method_state : std_logic := '0';
  signal this_doFirstMove_method_request_field_rdata : std_logic := '0';
  signal this_doFirstMove_method_request_field_wdata : std_logic := '0';
  signal buffer_waddr_field_wdata_reset : std_logic_vector(3-1 downto 0) := (others => '0');
  signal buffer_waddr_field_wdata_reset_strobe : std_logic := '0';
  signal buffer_waddr_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 : std_logic_vector(3-1 downto 0) := (others => '0');
  signal buffer_waddr_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 : std_logic := '0';
  signal buffer_waddr_field_rdata : std_logic_vector(3-1 downto 0) := (others => '0');
  signal buffer_waddr_field_wdata : std_logic_vector(3-1 downto 0) := (others => '0');
  signal io_notify_method_request_field_wdata_reset : std_logic := '0';
  signal io_notify_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal io_notify_method_request_field_rdata : std_logic := '0';
  signal io_notify_method_request_field_wdata : std_logic := '0';
  signal player_input_port_setOpponentMove_rot_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_rot_field_wdata_reset_strobe : std_logic := '0';
  signal player_input_port_setOpponentMove_rot_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_rot_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 : std_logic := '0';
  signal player_input_port_setOpponentMove_rot_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_rot_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal io_input_port_putchar_c_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal io_input_port_putchar_c_field_wdata_reset_strobe : std_logic := '0';
  signal io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_3 : std_logic_vector(7 downto 0) := (others => '0');
  signal io_input_port_putchar_c_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_3 : std_logic := '0';
  signal io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_4 : std_logic_vector(7 downto 0) := (others => '0');
  signal io_input_port_putchar_c_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 : std_logic := '0';
  signal io_input_port_putchar_c_field_wdata_writer_doInitialization_method_state : std_logic_vector(7 downto 0) := (others => '0');
  signal io_input_port_putchar_c_field_wdata_writer_strobe_doInitialization_method_state : std_logic := '0';
  signal io_input_port_putchar_c_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal io_input_port_putchar_c_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal led_run_method_request_field_wdata_reset : std_logic := '0';
  signal led_run_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal led_run_method_request_field_wdata_writer_fpga_main_method_state : std_logic := '0';
  signal led_run_method_request_field_wdata_writer_strobe_fpga_main_method_state : std_logic := '0';
  signal led_run_method_request_field_rdata : std_logic := '0';
  signal led_run_method_request_field_wdata : std_logic := '0';
  signal this_toStr_method_request_field_wdata_reset : std_logic := '0';
  signal this_toStr_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_toStr_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 : std_logic := '0';
  signal this_toStr_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 : std_logic := '0';
  signal this_toStr_method_request_field_rdata : std_logic := '0';
  signal this_toStr_method_request_field_wdata : std_logic := '0';
  signal this_input_port_waitResponseCode_args_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_waitResponseCode_args_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_3 : std_logic := '0';
  signal this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_4 : std_logic := '0';
  signal this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_6 : std_logic := '0';
  signal this_input_port_waitResponseCode_args_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_waitResponseCode_args_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_game_method_request_field_wdata_reset : std_logic := '0';
  signal this_game_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_game_method_request_field_wdata_writer_state_counter_fpga_main_fpga_main_2 : std_logic := '0';
  signal this_game_method_request_field_wdata_writer_strobe_state_counter_fpga_main_fpga_main_2 : std_logic := '0';
  signal this_game_method_request_field_rdata : std_logic := '0';
  signal this_game_method_request_field_wdata : std_logic := '0';
  signal player_input_port_setOpponentMove_id_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_id_field_wdata_reset_strobe : std_logic := '0';
  signal player_input_port_setOpponentMove_id_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_id_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 : std_logic := '0';
  signal player_input_port_setOpponentMove_id_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_setOpponentMove_id_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal turn_code_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal turn_code_field_wdata_reset_strobe : std_logic := '0';
  signal turn_code_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal turn_code_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 : std_logic := '0';
  signal turn_code_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9 : std_logic_vector(31 downto 0) := (others => '0');
  signal turn_code_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 : std_logic := '0';
  signal turn_code_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal turn_code_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_parseAndApply_offset_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_parseAndApply_offset_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_3 : std_logic := '0';
  signal this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_4 : std_logic := '0';
  signal this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_6 : std_logic := '0';
  signal this_input_port_parseAndApply_offset_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_parseAndApply_offset_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_waitResponseCode_method_request_field_wdata_reset : std_logic := '0';
  signal this_waitResponseCode_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_3 : std_logic := '0';
  signal this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_3 : std_logic := '0';
  signal this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_4 : std_logic := '0';
  signal this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_4 : std_logic := '0';
  signal this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_6 : std_logic := '0';
  signal this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_6 : std_logic := '0';
  signal this_waitResponseCode_method_request_field_rdata : std_logic := '0';
  signal this_waitResponseCode_method_request_field_wdata : std_logic := '0';
  signal this_parseAndApply_method_request_field_wdata_reset : std_logic := '0';
  signal this_parseAndApply_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_3 : std_logic := '0';
  signal this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_3 : std_logic := '0';
  signal this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_4 : std_logic := '0';
  signal this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_4 : std_logic := '0';
  signal this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_6 : std_logic := '0';
  signal this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_6 : std_logic := '0';
  signal this_parseAndApply_method_request_field_rdata : std_logic := '0';
  signal this_parseAndApply_method_request_field_wdata : std_logic := '0';
  signal this_init_method_request_field_wdata_reset : std_logic := '0';
  signal this_init_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_init_method_request_field_wdata_writer_game_method_state : std_logic := '0';
  signal this_init_method_request_field_wdata_writer_strobe_game_method_state : std_logic := '0';
  signal this_init_method_request_field_rdata : std_logic := '0';
  signal this_init_method_request_field_wdata : std_logic := '0';
  signal player_input_port_getFirstMoveCode_y_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_getFirstMoveCode_y_field_wdata_reset_strobe : std_logic := '0';
  signal player_input_port_getFirstMoveCode_y_field_wdata_writer_doFirstMove_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_getFirstMoveCode_y_field_wdata_writer_strobe_doFirstMove_method_state : std_logic := '0';
  signal player_input_port_getFirstMoveCode_y_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_getFirstMoveCode_y_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal led_notify_method_request_field_wdata_reset : std_logic := '0';
  signal led_notify_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal led_notify_method_request_field_rdata : std_logic := '0';
  signal led_notify_method_request_field_wdata : std_logic := '0';
  signal player_input_port_getFirstMoveCode_x_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_getFirstMoveCode_x_field_wdata_reset_strobe : std_logic := '0';
  signal player_input_port_getFirstMoveCode_x_field_wdata_writer_doFirstMove_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_getFirstMoveCode_x_field_wdata_writer_strobe_doFirstMove_method_state : std_logic := '0';
  signal player_input_port_getFirstMoveCode_x_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal player_input_port_getFirstMoveCode_x_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_doInitialization_method_request_field_wdata_reset : std_logic := '0';
  signal this_doInitialization_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_doInitialization_method_request_field_wdata_writer_game_method_state : std_logic := '0';
  signal this_doInitialization_method_request_field_wdata_writer_strobe_game_method_state : std_logic := '0';
  signal this_doInitialization_method_request_field_rdata : std_logic := '0';
  signal this_doInitialization_method_request_field_wdata : std_logic := '0';
  signal io_getchar_method_request_field_wdata_reset : std_logic := '0';
  signal io_getchar_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal io_getchar_method_request_field_wdata_writer_state_counter_doInitialization_doInitialization_2 : std_logic := '0';
  signal io_getchar_method_request_field_wdata_writer_strobe_state_counter_doInitialization_doInitialization_2 : std_logic := '0';
  signal io_getchar_method_request_field_wdata_writer_waitResponseCode_method_state : std_logic := '0';
  signal io_getchar_method_request_field_wdata_writer_strobe_waitResponseCode_method_state : std_logic := '0';
  signal io_getchar_method_request_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 : std_logic := '0';
  signal io_getchar_method_request_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 : std_logic := '0';
  signal io_getchar_method_request_field_wdata_writer_doFirstMove_method_state : std_logic := '0';
  signal io_getchar_method_request_field_wdata_writer_strobe_doFirstMove_method_state : std_logic := '0';
  signal io_getchar_method_request_field_rdata : std_logic := '0';
  signal io_getchar_method_request_field_wdata : std_logic := '0';
  signal led_run_method_busy_field_wdata_reset : std_logic := '0';
  signal led_run_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal led_run_method_busy_field_rdata : std_logic := '0';
  signal led_run_method_busy_field_wdata : std_logic := '0';
  signal this_input_port_toStr_v_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_toStr_v_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_toStr_v_field_wdata_writer_state_counter_sendResponse_sendResponse_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_toStr_v_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 : std_logic := '0';
  signal this_input_port_toStr_v_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_toStr_v_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal io_notify_method_busy_field_wdata_reset : std_logic := '0';
  signal io_notify_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal io_notify_method_busy_field_rdata : std_logic := '0';
  signal io_notify_method_busy_field_wdata : std_logic := '0';
  signal io_getchar_method_busy_field_wdata_reset : std_logic := '0';
  signal io_getchar_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal io_getchar_method_busy_field_rdata : std_logic := '0';
  signal io_getchar_method_busy_field_wdata : std_logic := '0';
  signal led_notify_method_busy_field_wdata_reset : std_logic := '0';
  signal led_notify_method_busy_field_wdata_reset_strobe : std_logic := '0';
  signal led_notify_method_busy_field_rdata : std_logic := '0';
  signal led_notify_method_busy_field_wdata : std_logic := '0';
  signal led_value_field_rdata_output_port_field_wdata_reset : std_logic_vector(31 downto 0) := (others => '0');
  signal led_value_field_rdata_output_port_field_wdata_reset_strobe : std_logic := '0';
  signal led_value_field_rdata_output_port_field_rdata : std_logic_vector(31 downto 0) := (others => '0');
  signal led_value_field_rdata_output_port_field_wdata : std_logic_vector(31 downto 0) := (others => '0');
  signal this_input_port_toInt_x_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal this_input_port_toInt_x_field_wdata_reset_strobe : std_logic := '0';
  signal this_input_port_toInt_x_field_wdata_writer_parseAndApply_method_state : std_logic_vector(7 downto 0) := (others => '0');
  signal this_input_port_toInt_x_field_wdata_writer_strobe_parseAndApply_method_state : std_logic := '0';
  signal this_input_port_toInt_x_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal this_input_port_toInt_x_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal buffer_raddr_field_wdata_reset : std_logic_vector(3-1 downto 0) := (others => '0');
  signal buffer_raddr_field_wdata_reset_strobe : std_logic := '0';
  signal buffer_raddr_field_wdata_writer_parseAndApply_method_state : std_logic_vector(3-1 downto 0) := (others => '0');
  signal buffer_raddr_field_wdata_writer_strobe_parseAndApply_method_state : std_logic := '0';
  signal buffer_raddr_field_rdata : std_logic_vector(3-1 downto 0) := (others => '0');
  signal buffer_raddr_field_wdata : std_logic_vector(3-1 downto 0) := (others => '0');
  signal state_counter_notify_notify_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_toStr_method_busy : std_logic := '0';
  signal code_game_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal doInitialization_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_output_port_toStr : std_logic_vector(7 downto 0) := (others => '0');
  signal d_notify_flag : std_logic := '0';
  signal id_parseAndApply_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal toStr_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_toStr_call_state_counter_sendResponse_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal sendResponse_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal waitResponseCode_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_waitResponseCode_waitResponseCode_8 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_waitResponseCode_waitResponseCode_7 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_waitResponseCode_waitResponseCode_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_waitResponseCode_waitResponseCode_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_waitResponseCode_waitResponseCode_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toStr_toStr_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_waitResponseCode_waitResponseCode_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toStr_toStr_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_waitResponseCode_waitResponseCode_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toStr_toStr_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toStr_toStr_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal array_index_operation_state_counter_parseAndApply_4 : std_logic_vector(2 downto 0) := (others => '0');
  signal this_notify_method_busy : std_logic := '0';
  signal array_index_operation_state_counter_parseAndApply_3 : std_logic_vector(2 downto 0) := (others => '0');
  signal array_index_operation_state_counter_parseAndApply_2 : std_logic_vector(2 downto 0) := (others => '0');
  signal array_index_operation_state_counter_parseAndApply_1 : std_logic_vector(2 downto 0) := (others => '0');
  signal game_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal id_sendResponse_0 : std_logic_vector(7 downto 0) := (others => '0');
  signal io_putchar_call_state_counter_sendResponse_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal io_putchar_call_state_counter_sendResponse_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal io_getchar_call_state_counter_waitResponseCode_8 : std_logic_vector(31 downto 0) := (others => '0');
  signal rot_sendResponse_0 : std_logic_vector(7 downto 0) := (others => '0');
  signal this_doFirstMove_call_state_counter_game_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_output_port_doFirstMove : std_logic_vector(31 downto 0) := (others => '0');
  signal io_getchar_call_state_counter_waitResponseCode_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toInt_toInt_10 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_game_method_busy : std_logic := '0';
  signal c_doInitialization_2 : std_logic_vector(7 downto 0) := (others => '0');
  signal this_toInt_call_state_counter_parseAndApply_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_parseAndApply_call_state_counter_game_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal v_init_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_parseAndApply_call_state_counter_game_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_parseAndApply_call_state_counter_game_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_sendResponse_call_state_counter_game_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal x_sendResponse_0 : std_logic_vector(7 downto 0) := (others => '0');
  signal this_init_call_state_counter_game_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_sendResponse_call_state_counter_game_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal toStr_if_flag_toStr_2_toStr_0 : std_logic := '0';
  signal state_counter_fpga_main_fpga_main_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_fpga_main_fpga_main_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_fpga_main_fpga_main_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal notify_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal array_index_operation_state_counter_waitResponseCode_9 : std_logic_vector(2 downto 0) := (others => '0');
  signal this_init_method_busy : std_logic := '0';
  signal player_getFirstMoveCode_call_state_counter_doFirstMove_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal init_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_sendResponse_sendResponse_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_sendResponse_sendResponse_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_game_call_state_counter_fpga_main_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal player_getNextMove_call_state_counter_game_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_sendResponse_sendResponse_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_sendResponse_sendResponse_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_doInitialization_method_busy : std_logic := '0';
  signal fpga_main_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_waitResponseCode_call_state_counter_game_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_waitResponseCode_call_state_counter_game_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_waitResponseCode_call_state_counter_game_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal doFirstMove_if_flag_doFirstMove_2_doFirstMove_0 : std_logic := '0';
  signal doFirstMove_if_flag_doFirstMove_5_doFirstMove_0 : std_logic := '0';
  signal c_doFirstMove_0 : std_logic_vector(7 downto 0) := (others => '0');
  signal doFirstMove_if_flag_doFirstMove_8_doFirstMove_4 : std_logic := '0';
  signal rot_parseAndApply_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal waitResponseCode_if_flag_waitResponseCode_5_waitResponseCode_0 : std_logic := '0';
  signal led_start_call_state_counter_fpga_main_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal wait_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_doFirstMove_doFirstMove_10 : std_logic_vector(31 downto 0) := (others => '0');
  signal parseAndApply_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_waitResponseCode_method_busy : std_logic := '0';
  signal this_parseAndApply_method_busy : std_logic := '0';
  signal flag_game_0 : std_logic := '0';
  signal this_doInitialization_call_state_counter_game_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal toInt_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_output_port_toInt : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_doFirstMove_doFirstMove_9 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_doFirstMove_doFirstMove_7 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_doFirstMove_doFirstMove_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal io_getchar_call_state_counter_doFirstMove_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_doFirstMove_doFirstMove_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal sendResponse_if_flag_sendResponse_2_sendResponse_0 : std_logic := '0';
  signal state_counter_doFirstMove_doFirstMove_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_doFirstMove_doFirstMove_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal pos_doFirstMove_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_doFirstMove_doFirstMove_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_output_port_waitResponseCode : std_logic := '0';
  signal player_init_call_state_counter_init_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal doInitialization_if_flag_doInitialization_4_doInitialization_2 : std_logic := '0';
  signal y_sendResponse_0 : std_logic_vector(7 downto 0) := (others => '0');
  signal this_toInt_method_busy : std_logic := '0';
  signal doFirstMove_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal c_waitResponseCode_0 : std_logic_vector(7 downto 0) := (others => '0');
  signal parseAndApply_if_flag_parseAndApply_6_parseAndApply_0 : std_logic := '0';
  signal x_parseAndApply_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal io_getchar_call_state_counter_doInitialization_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal io_putchar_call_state_counter_doInitialization_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_doFirstMove_method_busy : std_logic := '0';
  signal this_sendResponse_method_busy : std_logic := '0';
  signal i_waitResponseCode_7 : std_logic_vector(31 downto 0) := (others => '0');
  signal toInt_if_flag_toInt_5_toInt_1 : std_logic := '0';
  signal toInt_if_flag_toInt_8_toInt_4 : std_logic := '0';
  signal this_notify_method_request : std_logic := '0';
  signal state_counter_init_init_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal game_if_flag_game_2_game_0 : std_logic := '0';
  signal state_counter_game_game_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal toInt_if_flag_toInt_2_toInt_0 : std_logic := '0';
  signal state_counter_game_game_5 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_game_game_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_game_game_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_parseAndApply_parseAndApply_7 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_game_game_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_game_game_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_parseAndApply_parseAndApply_5 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_doInitialization_doInitialization_5 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_wait_wait_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_wait_method_busy : std_logic := '0';
  signal state_counter_doInitialization_doInitialization_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_led_out_led_out_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_doInitialization_doInitialization_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_parseAndApply_parseAndApply_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_doInitialization_doInitialization_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toInt_toInt_9 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_doInitialization_doInitialization_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toInt_toInt_7 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toInt_toInt_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal player_setTurnCode_call_state_counter_doFirstMove_9 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toInt_toInt_4 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toInt_toInt_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal notify_flag : std_logic := '0';
  signal code_doFirstMove_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal player_setTurnCode_call_state_counter_doFirstMove_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toInt_toInt_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_toInt_toInt_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal y_parseAndApply_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal waitResponseCode_if_flag_waitResponseCode_2_waitResponseCode_0 : std_logic := '0';
  signal player_setOpponentMove_call_state_counter_parseAndApply_7 : std_logic_vector(31 downto 0) := (others => '0');
begin
  U_buffer : simpledualportram
  generic map(
    DEPTH => buffer_DEPTH,
    WIDTH => buffer_WIDTH
  )
  port map(
    clk => clk,
    we => buffer_we_field_rdata,
    raddr => buffer_raddr_field_rdata,
    rdata => buffer_rdata_field_wdata,
    waddr => buffer_waddr_field_rdata,
    wdata => buffer_wdata_field_rdata
  );
  U_player : net_wasamon_blokus_javarock_simpleplayer
  port map(
    notify_method_busy => player_notify_method_busy_field_wdata,
    getNextMove_method_busy => player_getNextMove_method_busy_field_wdata,
    setOpponentMove_method_busy => player_setOpponentMove_method_busy_field_wdata,
    init_method_busy => player_init_method_busy_field_wdata,
    output_port_getNextMove => player_output_port_getNextMove_field_wdata,
    setTurnCode_method_busy => player_setTurnCode_method_busy_field_wdata,
    getFirstMoveCode_method_busy => player_getFirstMoveCode_method_busy_field_wdata,
    output_port_getFirstMoveCode => player_output_port_getFirstMoveCode_field_wdata,
    setTurnCode_method_request => player_setTurnCode_method_request_field_rdata,
    clk => clk,
    notify_method_request => player_notify_method_request_field_rdata,
    input_port_setOpponentMove_rot => player_input_port_setOpponentMove_rot_field_rdata,
    input_port_setOpponentMove_y => player_input_port_setOpponentMove_y_field_rdata,
    getFirstMoveCode_method_request => player_getFirstMoveCode_method_request_field_rdata,
    input_port_setOpponentMove_x => player_input_port_setOpponentMove_x_field_rdata,
    getNextMove_method_request => player_getNextMove_method_request_field_rdata,
    reset => reset,
    input_port_setTurnCode_v => player_input_port_setTurnCode_v_field_rdata,
    input_port_getFirstMoveCode_y => player_input_port_getFirstMoveCode_y_field_rdata,
    input_port_setOpponentMove_id => player_input_port_setOpponentMove_id_field_rdata,
    input_port_getFirstMoveCode_x => player_input_port_getFirstMoveCode_x_field_rdata,
    setOpponentMove_method_request => player_setOpponentMove_method_request_field_rdata,
    init_method_request => player_init_method_request_field_rdata
  );
  U_led : net_wasamon_blokus_javarock_led
  port map(
    value_field_rdata_output_port => led_value_field_rdata_output_port_field_wdata,
    notify_method_busy => led_notify_method_busy_field_wdata,
    run_method_busy => led_run_method_busy_field_wdata,
    value_field_rdata_input_strobe_port => led_value_field_rdata_input_strobe_port_field_rdata,
    value_field_rdata_input_port => led_value_field_rdata_input_port_field_rdata,
    run_method_request => led_run_method_request_field_rdata,
    notify_method_request => led_notify_method_request_field_rdata,
    reset => reset,
    clk => clk
  );
  U_player_code : vhdl_input32
  port map(
    input => player_code_input,
    value => player_code_value_field_wdata
  );
  U_io : net_wasamon_blokus_javarock_io
  port map(
    getchar_method_busy => io_getchar_method_busy_field_wdata,
    notify_method_busy => io_notify_method_busy_field_wdata,
    output_port_getchar => io_output_port_getchar_field_wdata,
    putchar_method_busy => io_putchar_method_busy_field_wdata,
    obj_tx_dout => io_obj_tx_dout,
    obj_rx_din => io_obj_rx_din,
    input_port_putchar_c => io_input_port_putchar_c_field_rdata,
    notify_method_request => io_notify_method_request_field_rdata,
    reset => reset,
    getchar_method_request => io_getchar_method_request_field_rdata,
    putchar_method_request => io_putchar_method_request_field_rdata,
    clk => clk
  );
  this_notify_method_request <= notify_method_request;
  notify_method_busy <= this_notify_method_busy;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_init_method_request_field_wdata <= player_init_method_request_field_wdata_reset;
      elsif (player_init_method_request_field_wdata_reset_strobe = '1') then
        player_init_method_request_field_wdata <= player_init_method_request_field_wdata_reset;
      elsif (player_init_method_request_field_wdata_writer_strobe_init_method_state = '1') then
        player_init_method_request_field_wdata <= player_init_method_request_field_wdata_writer_init_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_init_method_request_field_wdata_reset_strobe <= '1';
      else
        player_init_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(init_method_state) = 4 or conv_integer(init_method_state) = 4) then
        player_init_method_request_field_wdata_writer_strobe_init_method_state <= '1';
      else
        player_init_method_request_field_wdata_writer_strobe_init_method_state <= '0';
      end if;
    end if;
  end process;
  player_init_method_request_field_rdata <= player_init_method_request_field_wdata_reset when (reset = '1') else
        player_init_method_request_field_wdata_reset when (player_init_method_request_field_wdata_reset_strobe = '1') else
        player_init_method_request_field_wdata_writer_init_method_state when (player_init_method_request_field_wdata_writer_strobe_init_method_state = '1') else
        player_init_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_sendResponse_method_request_field_wdata <= this_sendResponse_method_request_field_wdata_reset;
      elsif (this_sendResponse_method_request_field_wdata_reset_strobe = '1') then
        this_sendResponse_method_request_field_wdata <= this_sendResponse_method_request_field_wdata_reset;
      elsif (this_sendResponse_method_request_field_wdata_writer_strobe_game_method_state = '1') then
        this_sendResponse_method_request_field_wdata <= this_sendResponse_method_request_field_wdata_writer_game_method_state;
      elsif (this_sendResponse_method_request_field_wdata_writer_strobe_state_counter_game_game_6 = '1') then
        this_sendResponse_method_request_field_wdata <= this_sendResponse_method_request_field_wdata_writer_state_counter_game_game_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_sendResponse_method_request_field_wdata_reset_strobe <= '1';
      else
        this_sendResponse_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(game_method_state) = 7 or conv_integer(game_method_state) = 7) then
        this_sendResponse_method_request_field_wdata_writer_strobe_game_method_state <= '1';
      else
        this_sendResponse_method_request_field_wdata_writer_strobe_game_method_state <= '0';
      end if;
      if (conv_integer(state_counter_game_game_6) = 3 or conv_integer(state_counter_game_game_6) = 3) then
        this_sendResponse_method_request_field_wdata_writer_strobe_state_counter_game_game_6 <= '1';
      else
        this_sendResponse_method_request_field_wdata_writer_strobe_state_counter_game_game_6 <= '0';
      end if;
    end if;
  end process;
  this_sendResponse_method_request_field_rdata <= this_sendResponse_method_request_field_wdata_reset when (reset = '1') else
        this_sendResponse_method_request_field_wdata_reset when (this_sendResponse_method_request_field_wdata_reset_strobe = '1') else
        this_sendResponse_method_request_field_wdata_writer_game_method_state when (this_sendResponse_method_request_field_wdata_writer_strobe_game_method_state = '1') else
        this_sendResponse_method_request_field_wdata_writer_state_counter_game_game_6 when (this_sendResponse_method_request_field_wdata_writer_strobe_state_counter_game_game_6 = '1') else
        this_sendResponse_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_sendResponse_code_field_wdata <= this_input_port_sendResponse_code_field_wdata_reset;
      elsif (this_input_port_sendResponse_code_field_wdata_reset_strobe = '1') then
        this_input_port_sendResponse_code_field_wdata <= this_input_port_sendResponse_code_field_wdata_reset;
      elsif (this_input_port_sendResponse_code_field_wdata_writer_strobe_game_method_state = '1') then
        this_input_port_sendResponse_code_field_wdata <= this_input_port_sendResponse_code_field_wdata_writer_game_method_state;
      elsif (this_input_port_sendResponse_code_field_wdata_writer_strobe_state_counter_game_game_6 = '1') then
        this_input_port_sendResponse_code_field_wdata <= this_input_port_sendResponse_code_field_wdata_writer_state_counter_game_game_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_sendResponse_code_field_wdata_reset_strobe <= '1';
      else
        this_input_port_sendResponse_code_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(game_method_state) = 7) then
        this_input_port_sendResponse_code_field_wdata_writer_strobe_game_method_state <= '1';
      else
        this_input_port_sendResponse_code_field_wdata_writer_strobe_game_method_state <= '0';
      end if;
      if (conv_integer(state_counter_game_game_6) = 3) then
        this_input_port_sendResponse_code_field_wdata_writer_strobe_state_counter_game_game_6 <= '1';
      else
        this_input_port_sendResponse_code_field_wdata_writer_strobe_state_counter_game_game_6 <= '0';
      end if;
    end if;
  end process;
  this_input_port_sendResponse_code_field_rdata <= this_input_port_sendResponse_code_field_wdata_reset when (reset = '1') else
        this_input_port_sendResponse_code_field_wdata_reset when (this_input_port_sendResponse_code_field_wdata_reset_strobe = '1') else
        this_input_port_sendResponse_code_field_wdata_writer_game_method_state when (this_input_port_sendResponse_code_field_wdata_writer_strobe_game_method_state = '1') else
        this_input_port_sendResponse_code_field_wdata_writer_state_counter_game_game_6 when (this_input_port_sendResponse_code_field_wdata_writer_strobe_state_counter_game_game_6 = '1') else
        this_input_port_sendResponse_code_field_wdata;
  
  player_setTurnCode_method_busy_field_rdata <= player_setTurnCode_method_busy_field_wdata;
  
  player_init_method_busy_field_rdata <= player_init_method_busy_field_wdata;
  
  player_code_value_field_rdata <= player_code_value_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        buffer_we_field_wdata <= buffer_we_field_wdata_reset;
      elsif (buffer_we_field_wdata_reset_strobe = '1') then
        buffer_we_field_wdata <= buffer_we_field_wdata_reset;
      elsif (buffer_we_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 = '1') then
        buffer_we_field_wdata <= buffer_we_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        buffer_we_field_wdata_reset_strobe <= '1';
      else
        buffer_we_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_waitResponseCode_waitResponseCode_8) = 3) then
        buffer_we_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 <= '1';
      else
        buffer_we_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 <= '0';
      end if;
    end if;
  end process;
  buffer_we_field_rdata <= buffer_we_field_wdata_reset when (reset = '1') else
        buffer_we_field_wdata_reset when (buffer_we_field_wdata_reset_strobe = '1') else
        buffer_we_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 when (buffer_we_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 = '1') else
        buffer_we_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_getNextMove_method_request_field_wdata <= player_getNextMove_method_request_field_wdata_reset;
      elsif (player_getNextMove_method_request_field_wdata_reset_strobe = '1') then
        player_getNextMove_method_request_field_wdata <= player_getNextMove_method_request_field_wdata_reset;
      elsif (player_getNextMove_method_request_field_wdata_writer_strobe_state_counter_game_game_6 = '1') then
        player_getNextMove_method_request_field_wdata <= player_getNextMove_method_request_field_wdata_writer_state_counter_game_game_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_getNextMove_method_request_field_wdata_reset_strobe <= '1';
      else
        player_getNextMove_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_game_game_6) = 1 or conv_integer(state_counter_game_game_6) = 1) then
        player_getNextMove_method_request_field_wdata_writer_strobe_state_counter_game_game_6 <= '1';
      else
        player_getNextMove_method_request_field_wdata_writer_strobe_state_counter_game_game_6 <= '0';
      end if;
    end if;
  end process;
  player_getNextMove_method_request_field_rdata <= player_getNextMove_method_request_field_wdata_reset when (reset = '1') else
        player_getNextMove_method_request_field_wdata_reset when (player_getNextMove_method_request_field_wdata_reset_strobe = '1') else
        player_getNextMove_method_request_field_wdata_writer_state_counter_game_game_6 when (player_getNextMove_method_request_field_wdata_writer_strobe_state_counter_game_game_6 = '1') else
        player_getNextMove_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        codeL_field_wdata <= codeL_field_wdata_reset;
      elsif (codeL_field_wdata_reset_strobe = '1') then
        codeL_field_wdata <= codeL_field_wdata_reset;
      elsif (codeL_field_wdata_writer_strobe_init_method_state = '1') then
        codeL_field_wdata <= codeL_field_wdata_writer_init_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        codeL_field_wdata_reset_strobe <= '1';
      else
        codeL_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(init_method_state) = 3) then
        codeL_field_wdata_writer_strobe_init_method_state <= '1';
      else
        codeL_field_wdata_writer_strobe_init_method_state <= '0';
      end if;
    end if;
  end process;
  codeL_field_rdata <= codeL_field_wdata_reset when (reset = '1') else
        codeL_field_wdata_reset when (codeL_field_wdata_reset_strobe = '1') else
        codeL_field_wdata_writer_init_method_state when (codeL_field_wdata_writer_strobe_init_method_state = '1') else
        codeL_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        buffer_wdata_field_wdata <= buffer_wdata_field_wdata_reset;
      elsif (buffer_wdata_field_wdata_reset_strobe = '1') then
        buffer_wdata_field_wdata <= buffer_wdata_field_wdata_reset;
      elsif (buffer_wdata_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 = '1') then
        buffer_wdata_field_wdata <= buffer_wdata_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        buffer_wdata_field_wdata_reset_strobe <= '1';
      else
        buffer_wdata_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_waitResponseCode_waitResponseCode_8) = 3) then
        buffer_wdata_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 <= '1';
      else
        buffer_wdata_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 <= '0';
      end if;
    end if;
  end process;
  buffer_wdata_field_rdata <= buffer_wdata_field_wdata_reset when (reset = '1') else
        buffer_wdata_field_wdata_reset when (buffer_wdata_field_wdata_reset_strobe = '1') else
        buffer_wdata_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 when (buffer_wdata_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 = '1') else
        buffer_wdata_field_wdata;
  
  io_putchar_method_busy_field_rdata <= io_putchar_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        led_value_field_rdata_input_port_field_wdata <= led_value_field_rdata_input_port_field_wdata_reset;
      elsif (led_value_field_rdata_input_port_field_wdata_reset_strobe = '1') then
        led_value_field_rdata_input_port_field_wdata <= led_value_field_rdata_input_port_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        led_value_field_rdata_input_port_field_wdata_reset_strobe <= '1';
      else
        led_value_field_rdata_input_port_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  led_value_field_rdata_input_port_field_rdata <= led_value_field_rdata_input_port_field_wdata_reset when (reset = '1') else
        led_value_field_rdata_input_port_field_wdata_reset when (led_value_field_rdata_input_port_field_wdata_reset_strobe = '1') else
        led_value_field_rdata_input_port_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_setTurnCode_method_request_field_wdata <= player_setTurnCode_method_request_field_wdata_reset;
      elsif (player_setTurnCode_method_request_field_wdata_reset_strobe = '1') then
        player_setTurnCode_method_request_field_wdata <= player_setTurnCode_method_request_field_wdata_reset;
      elsif (player_setTurnCode_method_request_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 = '1') then
        player_setTurnCode_method_request_field_wdata <= player_setTurnCode_method_request_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6;
      elsif (player_setTurnCode_method_request_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 = '1') then
        player_setTurnCode_method_request_field_wdata <= player_setTurnCode_method_request_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_setTurnCode_method_request_field_wdata_reset_strobe <= '1';
      else
        player_setTurnCode_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_doFirstMove_doFirstMove_6) = 1 or conv_integer(state_counter_doFirstMove_doFirstMove_6) = 1) then
        player_setTurnCode_method_request_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 <= '1';
      else
        player_setTurnCode_method_request_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 <= '0';
      end if;
      if (conv_integer(state_counter_doFirstMove_doFirstMove_9) = 1 or conv_integer(state_counter_doFirstMove_doFirstMove_9) = 1) then
        player_setTurnCode_method_request_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 <= '1';
      else
        player_setTurnCode_method_request_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 <= '0';
      end if;
    end if;
  end process;
  player_setTurnCode_method_request_field_rdata <= player_setTurnCode_method_request_field_wdata_reset when (reset = '1') else
        player_setTurnCode_method_request_field_wdata_reset when (player_setTurnCode_method_request_field_wdata_reset_strobe = '1') else
        player_setTurnCode_method_request_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6 when (player_setTurnCode_method_request_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 = '1') else
        player_setTurnCode_method_request_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9 when (player_setTurnCode_method_request_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 = '1') else
        player_setTurnCode_method_request_field_wdata;
  
  player_output_port_getNextMove_field_rdata <= player_output_port_getNextMove_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_waitResponseCode_expected_field_wdata <= this_input_port_waitResponseCode_expected_field_wdata_reset;
      elsif (this_input_port_waitResponseCode_expected_field_wdata_reset_strobe = '1') then
        this_input_port_waitResponseCode_expected_field_wdata <= this_input_port_waitResponseCode_expected_field_wdata_reset;
      elsif (this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_3 = '1') then
        this_input_port_waitResponseCode_expected_field_wdata <= this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_3;
      elsif (this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_4 = '1') then
        this_input_port_waitResponseCode_expected_field_wdata <= this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_4;
      elsif (this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_6 = '1') then
        this_input_port_waitResponseCode_expected_field_wdata <= this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_waitResponseCode_expected_field_wdata_reset_strobe <= '1';
      else
        this_input_port_waitResponseCode_expected_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_game_game_3) = 1) then
        this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_3 <= '1';
      else
        this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_3 <= '0';
      end if;
      if (conv_integer(state_counter_game_game_4) = 1) then
        this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_4 <= '1';
      else
        this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_4 <= '0';
      end if;
      if (conv_integer(state_counter_game_game_6) = 4) then
        this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_6 <= '1';
      else
        this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_6 <= '0';
      end if;
    end if;
  end process;
  this_input_port_waitResponseCode_expected_field_rdata <= this_input_port_waitResponseCode_expected_field_wdata_reset when (reset = '1') else
        this_input_port_waitResponseCode_expected_field_wdata_reset when (this_input_port_waitResponseCode_expected_field_wdata_reset_strobe = '1') else
        this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_3 when (this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_3 = '1') else
        this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_4 when (this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_4 = '1') else
        this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_6 when (this_input_port_waitResponseCode_expected_field_wdata_writer_strobe_state_counter_game_game_6 = '1') else
        this_input_port_waitResponseCode_expected_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        codeH_field_wdata <= codeH_field_wdata_reset;
      elsif (codeH_field_wdata_reset_strobe = '1') then
        codeH_field_wdata <= codeH_field_wdata_reset;
      elsif (codeH_field_wdata_writer_strobe_init_method_state = '1') then
        codeH_field_wdata <= codeH_field_wdata_writer_init_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        codeH_field_wdata_reset_strobe <= '1';
      else
        codeH_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(init_method_state) = 3) then
        codeH_field_wdata_writer_strobe_init_method_state <= '1';
      else
        codeH_field_wdata_writer_strobe_init_method_state <= '0';
      end if;
    end if;
  end process;
  codeH_field_rdata <= codeH_field_wdata_reset when (reset = '1') else
        codeH_field_wdata_reset when (codeH_field_wdata_reset_strobe = '1') else
        codeH_field_wdata_writer_init_method_state when (codeH_field_wdata_writer_strobe_init_method_state = '1') else
        codeH_field_wdata;
  
  io_output_port_getchar_field_rdata <= io_output_port_getchar_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        led_value_field_rdata_input_strobe_port_field_wdata <= led_value_field_rdata_input_strobe_port_field_wdata_reset;
      elsif (led_value_field_rdata_input_strobe_port_field_wdata_reset_strobe = '1') then
        led_value_field_rdata_input_strobe_port_field_wdata <= led_value_field_rdata_input_strobe_port_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        led_value_field_rdata_input_strobe_port_field_wdata_reset_strobe <= '1';
      else
        led_value_field_rdata_input_strobe_port_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  led_value_field_rdata_input_strobe_port_field_rdata <= led_value_field_rdata_input_strobe_port_field_wdata_reset when (reset = '1') else
        led_value_field_rdata_input_strobe_port_field_wdata_reset when (led_value_field_rdata_input_strobe_port_field_wdata_reset_strobe = '1') else
        led_value_field_rdata_input_strobe_port_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      elsif (this_wait_method_request_field_wdata_reset_strobe = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata_reset_strobe <= '1';
      else
        this_wait_method_request_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  this_wait_method_request_field_rdata <= this_wait_method_request_field_wdata_reset when (reset = '1') else
        this_wait_method_request_field_wdata_reset when (this_wait_method_request_field_wdata_reset_strobe = '1') else
        this_wait_method_request_field_wdata;
  
  player_notify_method_busy_field_rdata <= player_notify_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_setOpponentMove_y_field_wdata <= player_input_port_setOpponentMove_y_field_wdata_reset;
      elsif (player_input_port_setOpponentMove_y_field_wdata_reset_strobe = '1') then
        player_input_port_setOpponentMove_y_field_wdata <= player_input_port_setOpponentMove_y_field_wdata_reset;
      elsif (player_input_port_setOpponentMove_y_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 = '1') then
        player_input_port_setOpponentMove_y_field_wdata <= player_input_port_setOpponentMove_y_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_setOpponentMove_y_field_wdata_reset_strobe <= '1';
      else
        player_input_port_setOpponentMove_y_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_parseAndApply_parseAndApply_7) = 1) then
        player_input_port_setOpponentMove_y_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 <= '1';
      else
        player_input_port_setOpponentMove_y_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 <= '0';
      end if;
    end if;
  end process;
  player_input_port_setOpponentMove_y_field_rdata <= player_input_port_setOpponentMove_y_field_wdata_reset when (reset = '1') else
        player_input_port_setOpponentMove_y_field_wdata_reset when (player_input_port_setOpponentMove_y_field_wdata_reset_strobe = '1') else
        player_input_port_setOpponentMove_y_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 when (player_input_port_setOpponentMove_y_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 = '1') else
        player_input_port_setOpponentMove_y_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_setOpponentMove_x_field_wdata <= player_input_port_setOpponentMove_x_field_wdata_reset;
      elsif (player_input_port_setOpponentMove_x_field_wdata_reset_strobe = '1') then
        player_input_port_setOpponentMove_x_field_wdata <= player_input_port_setOpponentMove_x_field_wdata_reset;
      elsif (player_input_port_setOpponentMove_x_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 = '1') then
        player_input_port_setOpponentMove_x_field_wdata <= player_input_port_setOpponentMove_x_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_setOpponentMove_x_field_wdata_reset_strobe <= '1';
      else
        player_input_port_setOpponentMove_x_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_parseAndApply_parseAndApply_7) = 1) then
        player_input_port_setOpponentMove_x_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 <= '1';
      else
        player_input_port_setOpponentMove_x_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 <= '0';
      end if;
    end if;
  end process;
  player_input_port_setOpponentMove_x_field_rdata <= player_input_port_setOpponentMove_x_field_wdata_reset when (reset = '1') else
        player_input_port_setOpponentMove_x_field_wdata_reset when (player_input_port_setOpponentMove_x_field_wdata_reset_strobe = '1') else
        player_input_port_setOpponentMove_x_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 when (player_input_port_setOpponentMove_x_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 = '1') else
        player_input_port_setOpponentMove_x_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        io_putchar_method_request_field_wdata <= io_putchar_method_request_field_wdata_reset;
      elsif (io_putchar_method_request_field_wdata_reset_strobe = '1') then
        io_putchar_method_request_field_wdata <= io_putchar_method_request_field_wdata_reset;
      elsif (io_putchar_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_3 = '1') then
        io_putchar_method_request_field_wdata <= io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_3;
      elsif (io_putchar_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 = '1') then
        io_putchar_method_request_field_wdata <= io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4;
      elsif (io_putchar_method_request_field_wdata_writer_strobe_doInitialization_method_state = '1') then
        io_putchar_method_request_field_wdata <= io_putchar_method_request_field_wdata_writer_doInitialization_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        io_putchar_method_request_field_wdata_reset_strobe <= '1';
      else
        io_putchar_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_sendResponse_sendResponse_3) = 1 or conv_integer(state_counter_sendResponse_sendResponse_3) = 1 or conv_integer(state_counter_sendResponse_sendResponse_3) = 2 or conv_integer(state_counter_sendResponse_sendResponse_3) = 2 or conv_integer(state_counter_sendResponse_sendResponse_3) = 3 or conv_integer(state_counter_sendResponse_sendResponse_3) = 3 or conv_integer(state_counter_sendResponse_sendResponse_3) = 4 or conv_integer(state_counter_sendResponse_sendResponse_3) = 4) then
        io_putchar_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_3 <= '1';
      else
        io_putchar_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_3 <= '0';
      end if;
      if (conv_integer(state_counter_sendResponse_sendResponse_4) = 7 or conv_integer(state_counter_sendResponse_sendResponse_4) = 7 or conv_integer(state_counter_sendResponse_sendResponse_4) = 8 or conv_integer(state_counter_sendResponse_sendResponse_4) = 8 or conv_integer(state_counter_sendResponse_sendResponse_4) = 9 or conv_integer(state_counter_sendResponse_sendResponse_4) = 9 or conv_integer(state_counter_sendResponse_sendResponse_4) = 10 or conv_integer(state_counter_sendResponse_sendResponse_4) = 10) then
        io_putchar_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 <= '1';
      else
        io_putchar_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 <= '0';
      end if;
      if (conv_integer(doInitialization_method_state) = 3 or conv_integer(doInitialization_method_state) = 3 or conv_integer(doInitialization_method_state) = 4 or conv_integer(doInitialization_method_state) = 4 or conv_integer(doInitialization_method_state) = 5 or conv_integer(doInitialization_method_state) = 5) then
        io_putchar_method_request_field_wdata_writer_strobe_doInitialization_method_state <= '1';
      else
        io_putchar_method_request_field_wdata_writer_strobe_doInitialization_method_state <= '0';
      end if;
    end if;
  end process;
  io_putchar_method_request_field_rdata <= io_putchar_method_request_field_wdata_reset when (reset = '1') else
        io_putchar_method_request_field_wdata_reset when (io_putchar_method_request_field_wdata_reset_strobe = '1') else
        io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_3 when (io_putchar_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_3 = '1') else
        io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 when (io_putchar_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 = '1') else
        io_putchar_method_request_field_wdata_writer_doInitialization_method_state when (io_putchar_method_request_field_wdata_writer_strobe_doInitialization_method_state = '1') else
        io_putchar_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_setTurnCode_v_field_wdata <= player_input_port_setTurnCode_v_field_wdata_reset;
      elsif (player_input_port_setTurnCode_v_field_wdata_reset_strobe = '1') then
        player_input_port_setTurnCode_v_field_wdata <= player_input_port_setTurnCode_v_field_wdata_reset;
      elsif (player_input_port_setTurnCode_v_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 = '1') then
        player_input_port_setTurnCode_v_field_wdata <= player_input_port_setTurnCode_v_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6;
      elsif (player_input_port_setTurnCode_v_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 = '1') then
        player_input_port_setTurnCode_v_field_wdata <= player_input_port_setTurnCode_v_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_setTurnCode_v_field_wdata_reset_strobe <= '1';
      else
        player_input_port_setTurnCode_v_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_doFirstMove_doFirstMove_6) = 1) then
        player_input_port_setTurnCode_v_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 <= '1';
      else
        player_input_port_setTurnCode_v_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 <= '0';
      end if;
      if (conv_integer(state_counter_doFirstMove_doFirstMove_9) = 1) then
        player_input_port_setTurnCode_v_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 <= '1';
      else
        player_input_port_setTurnCode_v_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 <= '0';
      end if;
    end if;
  end process;
  player_input_port_setTurnCode_v_field_rdata <= player_input_port_setTurnCode_v_field_wdata_reset when (reset = '1') else
        player_input_port_setTurnCode_v_field_wdata_reset when (player_input_port_setTurnCode_v_field_wdata_reset_strobe = '1') else
        player_input_port_setTurnCode_v_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6 when (player_input_port_setTurnCode_v_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 = '1') else
        player_input_port_setTurnCode_v_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9 when (player_input_port_setTurnCode_v_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 = '1') else
        player_input_port_setTurnCode_v_field_wdata;
  
  player_setOpponentMove_method_busy_field_rdata <= player_setOpponentMove_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_setOpponentMove_method_request_field_wdata <= player_setOpponentMove_method_request_field_wdata_reset;
      elsif (player_setOpponentMove_method_request_field_wdata_reset_strobe = '1') then
        player_setOpponentMove_method_request_field_wdata <= player_setOpponentMove_method_request_field_wdata_reset;
      elsif (player_setOpponentMove_method_request_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 = '1') then
        player_setOpponentMove_method_request_field_wdata <= player_setOpponentMove_method_request_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_setOpponentMove_method_request_field_wdata_reset_strobe <= '1';
      else
        player_setOpponentMove_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_parseAndApply_parseAndApply_7) = 1 or conv_integer(state_counter_parseAndApply_parseAndApply_7) = 1) then
        player_setOpponentMove_method_request_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 <= '1';
      else
        player_setOpponentMove_method_request_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 <= '0';
      end if;
    end if;
  end process;
  player_setOpponentMove_method_request_field_rdata <= player_setOpponentMove_method_request_field_wdata_reset when (reset = '1') else
        player_setOpponentMove_method_request_field_wdata_reset when (player_setOpponentMove_method_request_field_wdata_reset_strobe = '1') else
        player_setOpponentMove_method_request_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 when (player_setOpponentMove_method_request_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 = '1') else
        player_setOpponentMove_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_getFirstMoveCode_method_request_field_wdata <= player_getFirstMoveCode_method_request_field_wdata_reset;
      elsif (player_getFirstMoveCode_method_request_field_wdata_reset_strobe = '1') then
        player_getFirstMoveCode_method_request_field_wdata <= player_getFirstMoveCode_method_request_field_wdata_reset;
      elsif (player_getFirstMoveCode_method_request_field_wdata_writer_strobe_doFirstMove_method_state = '1') then
        player_getFirstMoveCode_method_request_field_wdata <= player_getFirstMoveCode_method_request_field_wdata_writer_doFirstMove_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_getFirstMoveCode_method_request_field_wdata_reset_strobe <= '1';
      else
        player_getFirstMoveCode_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(doFirstMove_method_state) = 9 or conv_integer(doFirstMove_method_state) = 9) then
        player_getFirstMoveCode_method_request_field_wdata_writer_strobe_doFirstMove_method_state <= '1';
      else
        player_getFirstMoveCode_method_request_field_wdata_writer_strobe_doFirstMove_method_state <= '0';
      end if;
    end if;
  end process;
  player_getFirstMoveCode_method_request_field_rdata <= player_getFirstMoveCode_method_request_field_wdata_reset when (reset = '1') else
        player_getFirstMoveCode_method_request_field_wdata_reset when (player_getFirstMoveCode_method_request_field_wdata_reset_strobe = '1') else
        player_getFirstMoveCode_method_request_field_wdata_writer_doFirstMove_method_state when (player_getFirstMoveCode_method_request_field_wdata_writer_strobe_doFirstMove_method_state = '1') else
        player_getFirstMoveCode_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_toInt_method_request_field_wdata <= this_toInt_method_request_field_wdata_reset;
      elsif (this_toInt_method_request_field_wdata_reset_strobe = '1') then
        this_toInt_method_request_field_wdata <= this_toInt_method_request_field_wdata_reset;
      elsif (this_toInt_method_request_field_wdata_writer_strobe_parseAndApply_method_state = '1') then
        this_toInt_method_request_field_wdata <= this_toInt_method_request_field_wdata_writer_parseAndApply_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_toInt_method_request_field_wdata_reset_strobe <= '1';
      else
        this_toInt_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(parseAndApply_method_state) = 3 or conv_integer(parseAndApply_method_state) = 3 or conv_integer(parseAndApply_method_state) = 6 or conv_integer(parseAndApply_method_state) = 6 or conv_integer(parseAndApply_method_state) = 11 or conv_integer(parseAndApply_method_state) = 11) then
        this_toInt_method_request_field_wdata_writer_strobe_parseAndApply_method_state <= '1';
      else
        this_toInt_method_request_field_wdata_writer_strobe_parseAndApply_method_state <= '0';
      end if;
    end if;
  end process;
  this_toInt_method_request_field_rdata <= this_toInt_method_request_field_wdata_reset when (reset = '1') else
        this_toInt_method_request_field_wdata_reset when (this_toInt_method_request_field_wdata_reset_strobe = '1') else
        this_toInt_method_request_field_wdata_writer_parseAndApply_method_state when (this_toInt_method_request_field_wdata_writer_strobe_parseAndApply_method_state = '1') else
        this_toInt_method_request_field_wdata;
  
  player_getNextMove_method_busy_field_rdata <= player_getNextMove_method_busy_field_wdata;
  
  buffer_rdata_field_rdata <= buffer_rdata_field_wdata;
  
  player_output_port_getFirstMoveCode_field_rdata <= player_output_port_getFirstMoveCode_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_notify_method_request_field_wdata <= player_notify_method_request_field_wdata_reset;
      elsif (player_notify_method_request_field_wdata_reset_strobe = '1') then
        player_notify_method_request_field_wdata <= player_notify_method_request_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_notify_method_request_field_wdata_reset_strobe <= '1';
      else
        player_notify_method_request_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  player_notify_method_request_field_rdata <= player_notify_method_request_field_wdata_reset when (reset = '1') else
        player_notify_method_request_field_wdata_reset when (player_notify_method_request_field_wdata_reset_strobe = '1') else
        player_notify_method_request_field_wdata;
  
  player_getFirstMoveCode_method_busy_field_rdata <= player_getFirstMoveCode_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_doFirstMove_method_request_field_wdata <= this_doFirstMove_method_request_field_wdata_reset;
      elsif (this_doFirstMove_method_request_field_wdata_reset_strobe = '1') then
        this_doFirstMove_method_request_field_wdata <= this_doFirstMove_method_request_field_wdata_reset;
      elsif (this_doFirstMove_method_request_field_wdata_writer_strobe_game_method_state = '1') then
        this_doFirstMove_method_request_field_wdata <= this_doFirstMove_method_request_field_wdata_writer_game_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_doFirstMove_method_request_field_wdata_reset_strobe <= '1';
      else
        this_doFirstMove_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(game_method_state) = 5 or conv_integer(game_method_state) = 5) then
        this_doFirstMove_method_request_field_wdata_writer_strobe_game_method_state <= '1';
      else
        this_doFirstMove_method_request_field_wdata_writer_strobe_game_method_state <= '0';
      end if;
    end if;
  end process;
  this_doFirstMove_method_request_field_rdata <= this_doFirstMove_method_request_field_wdata_reset when (reset = '1') else
        this_doFirstMove_method_request_field_wdata_reset when (this_doFirstMove_method_request_field_wdata_reset_strobe = '1') else
        this_doFirstMove_method_request_field_wdata_writer_game_method_state when (this_doFirstMove_method_request_field_wdata_writer_strobe_game_method_state = '1') else
        this_doFirstMove_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        buffer_waddr_field_wdata <= buffer_waddr_field_wdata_reset;
      elsif (buffer_waddr_field_wdata_reset_strobe = '1') then
        buffer_waddr_field_wdata <= buffer_waddr_field_wdata_reset;
      elsif (buffer_waddr_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 = '1') then
        buffer_waddr_field_wdata <= buffer_waddr_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        buffer_waddr_field_wdata_reset_strobe <= '1';
      else
        buffer_waddr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_waitResponseCode_waitResponseCode_8) = 3) then
        buffer_waddr_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 <= '1';
      else
        buffer_waddr_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 <= '0';
      end if;
    end if;
  end process;
  buffer_waddr_field_rdata <= buffer_waddr_field_wdata_reset when (reset = '1') else
        buffer_waddr_field_wdata_reset when (buffer_waddr_field_wdata_reset_strobe = '1') else
        buffer_waddr_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 when (buffer_waddr_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 = '1') else
        buffer_waddr_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        io_notify_method_request_field_wdata <= io_notify_method_request_field_wdata_reset;
      elsif (io_notify_method_request_field_wdata_reset_strobe = '1') then
        io_notify_method_request_field_wdata <= io_notify_method_request_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        io_notify_method_request_field_wdata_reset_strobe <= '1';
      else
        io_notify_method_request_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  io_notify_method_request_field_rdata <= io_notify_method_request_field_wdata_reset when (reset = '1') else
        io_notify_method_request_field_wdata_reset when (io_notify_method_request_field_wdata_reset_strobe = '1') else
        io_notify_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_setOpponentMove_rot_field_wdata <= player_input_port_setOpponentMove_rot_field_wdata_reset;
      elsif (player_input_port_setOpponentMove_rot_field_wdata_reset_strobe = '1') then
        player_input_port_setOpponentMove_rot_field_wdata <= player_input_port_setOpponentMove_rot_field_wdata_reset;
      elsif (player_input_port_setOpponentMove_rot_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 = '1') then
        player_input_port_setOpponentMove_rot_field_wdata <= player_input_port_setOpponentMove_rot_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_setOpponentMove_rot_field_wdata_reset_strobe <= '1';
      else
        player_input_port_setOpponentMove_rot_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_parseAndApply_parseAndApply_7) = 1) then
        player_input_port_setOpponentMove_rot_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 <= '1';
      else
        player_input_port_setOpponentMove_rot_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 <= '0';
      end if;
    end if;
  end process;
  player_input_port_setOpponentMove_rot_field_rdata <= player_input_port_setOpponentMove_rot_field_wdata_reset when (reset = '1') else
        player_input_port_setOpponentMove_rot_field_wdata_reset when (player_input_port_setOpponentMove_rot_field_wdata_reset_strobe = '1') else
        player_input_port_setOpponentMove_rot_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 when (player_input_port_setOpponentMove_rot_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 = '1') else
        player_input_port_setOpponentMove_rot_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        io_input_port_putchar_c_field_wdata <= io_input_port_putchar_c_field_wdata_reset;
      elsif (io_input_port_putchar_c_field_wdata_reset_strobe = '1') then
        io_input_port_putchar_c_field_wdata <= io_input_port_putchar_c_field_wdata_reset;
      elsif (io_input_port_putchar_c_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_3 = '1') then
        io_input_port_putchar_c_field_wdata <= io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_3;
      elsif (io_input_port_putchar_c_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 = '1') then
        io_input_port_putchar_c_field_wdata <= io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_4;
      elsif (io_input_port_putchar_c_field_wdata_writer_strobe_doInitialization_method_state = '1') then
        io_input_port_putchar_c_field_wdata <= io_input_port_putchar_c_field_wdata_writer_doInitialization_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        io_input_port_putchar_c_field_wdata_reset_strobe <= '1';
      else
        io_input_port_putchar_c_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_sendResponse_sendResponse_3) = 1 or conv_integer(state_counter_sendResponse_sendResponse_3) = 2 or conv_integer(state_counter_sendResponse_sendResponse_3) = 3 or conv_integer(state_counter_sendResponse_sendResponse_3) = 4) then
        io_input_port_putchar_c_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_3 <= '1';
      else
        io_input_port_putchar_c_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_3 <= '0';
      end if;
      if (conv_integer(state_counter_sendResponse_sendResponse_4) = 7 or conv_integer(state_counter_sendResponse_sendResponse_4) = 8 or conv_integer(state_counter_sendResponse_sendResponse_4) = 9 or conv_integer(state_counter_sendResponse_sendResponse_4) = 10) then
        io_input_port_putchar_c_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 <= '1';
      else
        io_input_port_putchar_c_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 <= '0';
      end if;
      if (conv_integer(doInitialization_method_state) = 3 or conv_integer(doInitialization_method_state) = 4 or conv_integer(doInitialization_method_state) = 5) then
        io_input_port_putchar_c_field_wdata_writer_strobe_doInitialization_method_state <= '1';
      else
        io_input_port_putchar_c_field_wdata_writer_strobe_doInitialization_method_state <= '0';
      end if;
    end if;
  end process;
  io_input_port_putchar_c_field_rdata <= io_input_port_putchar_c_field_wdata_reset when (reset = '1') else
        io_input_port_putchar_c_field_wdata_reset when (io_input_port_putchar_c_field_wdata_reset_strobe = '1') else
        io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_3 when (io_input_port_putchar_c_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_3 = '1') else
        io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_4 when (io_input_port_putchar_c_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 = '1') else
        io_input_port_putchar_c_field_wdata_writer_doInitialization_method_state when (io_input_port_putchar_c_field_wdata_writer_strobe_doInitialization_method_state = '1') else
        io_input_port_putchar_c_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        led_run_method_request_field_wdata <= led_run_method_request_field_wdata_reset;
      elsif (led_run_method_request_field_wdata_reset_strobe = '1') then
        led_run_method_request_field_wdata <= led_run_method_request_field_wdata_reset;
      elsif (led_run_method_request_field_wdata_writer_strobe_fpga_main_method_state = '1') then
        led_run_method_request_field_wdata <= led_run_method_request_field_wdata_writer_fpga_main_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        led_run_method_request_field_wdata_reset_strobe <= '1';
      else
        led_run_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(fpga_main_method_state) = 0 or conv_integer(fpga_main_method_state) = 0) then
        led_run_method_request_field_wdata_writer_strobe_fpga_main_method_state <= '1';
      else
        led_run_method_request_field_wdata_writer_strobe_fpga_main_method_state <= '0';
      end if;
    end if;
  end process;
  led_run_method_request_field_rdata <= led_run_method_request_field_wdata_reset when (reset = '1') else
        led_run_method_request_field_wdata_reset when (led_run_method_request_field_wdata_reset_strobe = '1') else
        led_run_method_request_field_wdata_writer_fpga_main_method_state when (led_run_method_request_field_wdata_writer_strobe_fpga_main_method_state = '1') else
        led_run_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_toStr_method_request_field_wdata <= this_toStr_method_request_field_wdata_reset;
      elsif (this_toStr_method_request_field_wdata_reset_strobe = '1') then
        this_toStr_method_request_field_wdata <= this_toStr_method_request_field_wdata_reset;
      elsif (this_toStr_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 = '1') then
        this_toStr_method_request_field_wdata <= this_toStr_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_toStr_method_request_field_wdata_reset_strobe <= '1';
      else
        this_toStr_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_sendResponse_sendResponse_4) = 1 or conv_integer(state_counter_sendResponse_sendResponse_4) = 1 or conv_integer(state_counter_sendResponse_sendResponse_4) = 3 or conv_integer(state_counter_sendResponse_sendResponse_4) = 3 or conv_integer(state_counter_sendResponse_sendResponse_4) = 5 or conv_integer(state_counter_sendResponse_sendResponse_4) = 5) then
        this_toStr_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 <= '1';
      else
        this_toStr_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 <= '0';
      end if;
    end if;
  end process;
  this_toStr_method_request_field_rdata <= this_toStr_method_request_field_wdata_reset when (reset = '1') else
        this_toStr_method_request_field_wdata_reset when (this_toStr_method_request_field_wdata_reset_strobe = '1') else
        this_toStr_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 when (this_toStr_method_request_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 = '1') else
        this_toStr_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_waitResponseCode_args_field_wdata <= this_input_port_waitResponseCode_args_field_wdata_reset;
      elsif (this_input_port_waitResponseCode_args_field_wdata_reset_strobe = '1') then
        this_input_port_waitResponseCode_args_field_wdata <= this_input_port_waitResponseCode_args_field_wdata_reset;
      elsif (this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_3 = '1') then
        this_input_port_waitResponseCode_args_field_wdata <= this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_3;
      elsif (this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_4 = '1') then
        this_input_port_waitResponseCode_args_field_wdata <= this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_4;
      elsif (this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_6 = '1') then
        this_input_port_waitResponseCode_args_field_wdata <= this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_waitResponseCode_args_field_wdata_reset_strobe <= '1';
      else
        this_input_port_waitResponseCode_args_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_game_game_3) = 1) then
        this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_3 <= '1';
      else
        this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_3 <= '0';
      end if;
      if (conv_integer(state_counter_game_game_4) = 1) then
        this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_4 <= '1';
      else
        this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_4 <= '0';
      end if;
      if (conv_integer(state_counter_game_game_6) = 4) then
        this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_6 <= '1';
      else
        this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_6 <= '0';
      end if;
    end if;
  end process;
  this_input_port_waitResponseCode_args_field_rdata <= this_input_port_waitResponseCode_args_field_wdata_reset when (reset = '1') else
        this_input_port_waitResponseCode_args_field_wdata_reset when (this_input_port_waitResponseCode_args_field_wdata_reset_strobe = '1') else
        this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_3 when (this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_3 = '1') else
        this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_4 when (this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_4 = '1') else
        this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_6 when (this_input_port_waitResponseCode_args_field_wdata_writer_strobe_state_counter_game_game_6 = '1') else
        this_input_port_waitResponseCode_args_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_game_method_request_field_wdata <= this_game_method_request_field_wdata_reset;
      elsif (this_game_method_request_field_wdata_reset_strobe = '1') then
        this_game_method_request_field_wdata <= this_game_method_request_field_wdata_reset;
      elsif (this_game_method_request_field_wdata_writer_strobe_state_counter_fpga_main_fpga_main_2 = '1') then
        this_game_method_request_field_wdata <= this_game_method_request_field_wdata_writer_state_counter_fpga_main_fpga_main_2;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_game_method_request_field_wdata_reset_strobe <= '1';
      else
        this_game_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_fpga_main_fpga_main_2) = 1 or conv_integer(state_counter_fpga_main_fpga_main_2) = 1) then
        this_game_method_request_field_wdata_writer_strobe_state_counter_fpga_main_fpga_main_2 <= '1';
      else
        this_game_method_request_field_wdata_writer_strobe_state_counter_fpga_main_fpga_main_2 <= '0';
      end if;
    end if;
  end process;
  this_game_method_request_field_rdata <= this_game_method_request_field_wdata_reset when (reset = '1') else
        this_game_method_request_field_wdata_reset when (this_game_method_request_field_wdata_reset_strobe = '1') else
        this_game_method_request_field_wdata_writer_state_counter_fpga_main_fpga_main_2 when (this_game_method_request_field_wdata_writer_strobe_state_counter_fpga_main_fpga_main_2 = '1') else
        this_game_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_setOpponentMove_id_field_wdata <= player_input_port_setOpponentMove_id_field_wdata_reset;
      elsif (player_input_port_setOpponentMove_id_field_wdata_reset_strobe = '1') then
        player_input_port_setOpponentMove_id_field_wdata <= player_input_port_setOpponentMove_id_field_wdata_reset;
      elsif (player_input_port_setOpponentMove_id_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 = '1') then
        player_input_port_setOpponentMove_id_field_wdata <= player_input_port_setOpponentMove_id_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_setOpponentMove_id_field_wdata_reset_strobe <= '1';
      else
        player_input_port_setOpponentMove_id_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_parseAndApply_parseAndApply_7) = 1) then
        player_input_port_setOpponentMove_id_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 <= '1';
      else
        player_input_port_setOpponentMove_id_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 <= '0';
      end if;
    end if;
  end process;
  player_input_port_setOpponentMove_id_field_rdata <= player_input_port_setOpponentMove_id_field_wdata_reset when (reset = '1') else
        player_input_port_setOpponentMove_id_field_wdata_reset when (player_input_port_setOpponentMove_id_field_wdata_reset_strobe = '1') else
        player_input_port_setOpponentMove_id_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 when (player_input_port_setOpponentMove_id_field_wdata_writer_strobe_state_counter_parseAndApply_parseAndApply_7 = '1') else
        player_input_port_setOpponentMove_id_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        turn_code_field_wdata <= turn_code_field_wdata_reset;
      elsif (turn_code_field_wdata_reset_strobe = '1') then
        turn_code_field_wdata <= turn_code_field_wdata_reset;
      elsif (turn_code_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 = '1') then
        turn_code_field_wdata <= turn_code_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6;
      elsif (turn_code_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 = '1') then
        turn_code_field_wdata <= turn_code_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        turn_code_field_wdata_reset_strobe <= '1';
      else
        turn_code_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_doFirstMove_doFirstMove_6) = 2) then
        turn_code_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 <= '1';
      else
        turn_code_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 <= '0';
      end if;
      if (conv_integer(state_counter_doFirstMove_doFirstMove_9) = 2) then
        turn_code_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 <= '1';
      else
        turn_code_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 <= '0';
      end if;
    end if;
  end process;
  turn_code_field_rdata <= turn_code_field_wdata_reset when (reset = '1') else
        turn_code_field_wdata_reset when (turn_code_field_wdata_reset_strobe = '1') else
        turn_code_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6 when (turn_code_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_6 = '1') else
        turn_code_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9 when (turn_code_field_wdata_writer_strobe_state_counter_doFirstMove_doFirstMove_9 = '1') else
        turn_code_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_parseAndApply_offset_field_wdata <= this_input_port_parseAndApply_offset_field_wdata_reset;
      elsif (this_input_port_parseAndApply_offset_field_wdata_reset_strobe = '1') then
        this_input_port_parseAndApply_offset_field_wdata <= this_input_port_parseAndApply_offset_field_wdata_reset;
      elsif (this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_3 = '1') then
        this_input_port_parseAndApply_offset_field_wdata <= this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_3;
      elsif (this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_4 = '1') then
        this_input_port_parseAndApply_offset_field_wdata <= this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_4;
      elsif (this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_6 = '1') then
        this_input_port_parseAndApply_offset_field_wdata <= this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_parseAndApply_offset_field_wdata_reset_strobe <= '1';
      else
        this_input_port_parseAndApply_offset_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_game_game_3) = 3 or conv_integer(state_counter_game_game_3) = 4) then
        this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_3 <= '1';
      else
        this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_3 <= '0';
      end if;
      if (conv_integer(state_counter_game_game_4) = 3) then
        this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_4 <= '1';
      else
        this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_4 <= '0';
      end if;
      if (conv_integer(state_counter_game_game_6) = 6) then
        this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_6 <= '1';
      else
        this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_6 <= '0';
      end if;
    end if;
  end process;
  this_input_port_parseAndApply_offset_field_rdata <= this_input_port_parseAndApply_offset_field_wdata_reset when (reset = '1') else
        this_input_port_parseAndApply_offset_field_wdata_reset when (this_input_port_parseAndApply_offset_field_wdata_reset_strobe = '1') else
        this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_3 when (this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_3 = '1') else
        this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_4 when (this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_4 = '1') else
        this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_6 when (this_input_port_parseAndApply_offset_field_wdata_writer_strobe_state_counter_game_game_6 = '1') else
        this_input_port_parseAndApply_offset_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_waitResponseCode_method_request_field_wdata <= this_waitResponseCode_method_request_field_wdata_reset;
      elsif (this_waitResponseCode_method_request_field_wdata_reset_strobe = '1') then
        this_waitResponseCode_method_request_field_wdata <= this_waitResponseCode_method_request_field_wdata_reset;
      elsif (this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_3 = '1') then
        this_waitResponseCode_method_request_field_wdata <= this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_3;
      elsif (this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_4 = '1') then
        this_waitResponseCode_method_request_field_wdata <= this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_4;
      elsif (this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_6 = '1') then
        this_waitResponseCode_method_request_field_wdata <= this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_waitResponseCode_method_request_field_wdata_reset_strobe <= '1';
      else
        this_waitResponseCode_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_game_game_3) = 1 or conv_integer(state_counter_game_game_3) = 1) then
        this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_3 <= '1';
      else
        this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_3 <= '0';
      end if;
      if (conv_integer(state_counter_game_game_4) = 1 or conv_integer(state_counter_game_game_4) = 1) then
        this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_4 <= '1';
      else
        this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_4 <= '0';
      end if;
      if (conv_integer(state_counter_game_game_6) = 4 or conv_integer(state_counter_game_game_6) = 4) then
        this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_6 <= '1';
      else
        this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_6 <= '0';
      end if;
    end if;
  end process;
  this_waitResponseCode_method_request_field_rdata <= this_waitResponseCode_method_request_field_wdata_reset when (reset = '1') else
        this_waitResponseCode_method_request_field_wdata_reset when (this_waitResponseCode_method_request_field_wdata_reset_strobe = '1') else
        this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_3 when (this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_3 = '1') else
        this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_4 when (this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_4 = '1') else
        this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_6 when (this_waitResponseCode_method_request_field_wdata_writer_strobe_state_counter_game_game_6 = '1') else
        this_waitResponseCode_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_parseAndApply_method_request_field_wdata <= this_parseAndApply_method_request_field_wdata_reset;
      elsif (this_parseAndApply_method_request_field_wdata_reset_strobe = '1') then
        this_parseAndApply_method_request_field_wdata <= this_parseAndApply_method_request_field_wdata_reset;
      elsif (this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_3 = '1') then
        this_parseAndApply_method_request_field_wdata <= this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_3;
      elsif (this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_4 = '1') then
        this_parseAndApply_method_request_field_wdata <= this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_4;
      elsif (this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_6 = '1') then
        this_parseAndApply_method_request_field_wdata <= this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_6;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_parseAndApply_method_request_field_wdata_reset_strobe <= '1';
      else
        this_parseAndApply_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_game_game_3) = 3 or conv_integer(state_counter_game_game_3) = 3 or conv_integer(state_counter_game_game_3) = 4 or conv_integer(state_counter_game_game_3) = 4) then
        this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_3 <= '1';
      else
        this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_3 <= '0';
      end if;
      if (conv_integer(state_counter_game_game_4) = 3 or conv_integer(state_counter_game_game_4) = 3) then
        this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_4 <= '1';
      else
        this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_4 <= '0';
      end if;
      if (conv_integer(state_counter_game_game_6) = 6 or conv_integer(state_counter_game_game_6) = 6) then
        this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_6 <= '1';
      else
        this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_6 <= '0';
      end if;
    end if;
  end process;
  this_parseAndApply_method_request_field_rdata <= this_parseAndApply_method_request_field_wdata_reset when (reset = '1') else
        this_parseAndApply_method_request_field_wdata_reset when (this_parseAndApply_method_request_field_wdata_reset_strobe = '1') else
        this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_3 when (this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_3 = '1') else
        this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_4 when (this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_4 = '1') else
        this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_6 when (this_parseAndApply_method_request_field_wdata_writer_strobe_state_counter_game_game_6 = '1') else
        this_parseAndApply_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_init_method_request_field_wdata <= this_init_method_request_field_wdata_reset;
      elsif (this_init_method_request_field_wdata_reset_strobe = '1') then
        this_init_method_request_field_wdata <= this_init_method_request_field_wdata_reset;
      elsif (this_init_method_request_field_wdata_writer_strobe_game_method_state = '1') then
        this_init_method_request_field_wdata <= this_init_method_request_field_wdata_writer_game_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_init_method_request_field_wdata_reset_strobe <= '1';
      else
        this_init_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(game_method_state) = 3 or conv_integer(game_method_state) = 3) then
        this_init_method_request_field_wdata_writer_strobe_game_method_state <= '1';
      else
        this_init_method_request_field_wdata_writer_strobe_game_method_state <= '0';
      end if;
    end if;
  end process;
  this_init_method_request_field_rdata <= this_init_method_request_field_wdata_reset when (reset = '1') else
        this_init_method_request_field_wdata_reset when (this_init_method_request_field_wdata_reset_strobe = '1') else
        this_init_method_request_field_wdata_writer_game_method_state when (this_init_method_request_field_wdata_writer_strobe_game_method_state = '1') else
        this_init_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_getFirstMoveCode_y_field_wdata <= player_input_port_getFirstMoveCode_y_field_wdata_reset;
      elsif (player_input_port_getFirstMoveCode_y_field_wdata_reset_strobe = '1') then
        player_input_port_getFirstMoveCode_y_field_wdata <= player_input_port_getFirstMoveCode_y_field_wdata_reset;
      elsif (player_input_port_getFirstMoveCode_y_field_wdata_writer_strobe_doFirstMove_method_state = '1') then
        player_input_port_getFirstMoveCode_y_field_wdata <= player_input_port_getFirstMoveCode_y_field_wdata_writer_doFirstMove_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_getFirstMoveCode_y_field_wdata_reset_strobe <= '1';
      else
        player_input_port_getFirstMoveCode_y_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(doFirstMove_method_state) = 9) then
        player_input_port_getFirstMoveCode_y_field_wdata_writer_strobe_doFirstMove_method_state <= '1';
      else
        player_input_port_getFirstMoveCode_y_field_wdata_writer_strobe_doFirstMove_method_state <= '0';
      end if;
    end if;
  end process;
  player_input_port_getFirstMoveCode_y_field_rdata <= player_input_port_getFirstMoveCode_y_field_wdata_reset when (reset = '1') else
        player_input_port_getFirstMoveCode_y_field_wdata_reset when (player_input_port_getFirstMoveCode_y_field_wdata_reset_strobe = '1') else
        player_input_port_getFirstMoveCode_y_field_wdata_writer_doFirstMove_method_state when (player_input_port_getFirstMoveCode_y_field_wdata_writer_strobe_doFirstMove_method_state = '1') else
        player_input_port_getFirstMoveCode_y_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        led_notify_method_request_field_wdata <= led_notify_method_request_field_wdata_reset;
      elsif (led_notify_method_request_field_wdata_reset_strobe = '1') then
        led_notify_method_request_field_wdata <= led_notify_method_request_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        led_notify_method_request_field_wdata_reset_strobe <= '1';
      else
        led_notify_method_request_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  led_notify_method_request_field_rdata <= led_notify_method_request_field_wdata_reset when (reset = '1') else
        led_notify_method_request_field_wdata_reset when (led_notify_method_request_field_wdata_reset_strobe = '1') else
        led_notify_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_getFirstMoveCode_x_field_wdata <= player_input_port_getFirstMoveCode_x_field_wdata_reset;
      elsif (player_input_port_getFirstMoveCode_x_field_wdata_reset_strobe = '1') then
        player_input_port_getFirstMoveCode_x_field_wdata <= player_input_port_getFirstMoveCode_x_field_wdata_reset;
      elsif (player_input_port_getFirstMoveCode_x_field_wdata_writer_strobe_doFirstMove_method_state = '1') then
        player_input_port_getFirstMoveCode_x_field_wdata <= player_input_port_getFirstMoveCode_x_field_wdata_writer_doFirstMove_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        player_input_port_getFirstMoveCode_x_field_wdata_reset_strobe <= '1';
      else
        player_input_port_getFirstMoveCode_x_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(doFirstMove_method_state) = 9) then
        player_input_port_getFirstMoveCode_x_field_wdata_writer_strobe_doFirstMove_method_state <= '1';
      else
        player_input_port_getFirstMoveCode_x_field_wdata_writer_strobe_doFirstMove_method_state <= '0';
      end if;
    end if;
  end process;
  player_input_port_getFirstMoveCode_x_field_rdata <= player_input_port_getFirstMoveCode_x_field_wdata_reset when (reset = '1') else
        player_input_port_getFirstMoveCode_x_field_wdata_reset when (player_input_port_getFirstMoveCode_x_field_wdata_reset_strobe = '1') else
        player_input_port_getFirstMoveCode_x_field_wdata_writer_doFirstMove_method_state when (player_input_port_getFirstMoveCode_x_field_wdata_writer_strobe_doFirstMove_method_state = '1') else
        player_input_port_getFirstMoveCode_x_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_doInitialization_method_request_field_wdata <= this_doInitialization_method_request_field_wdata_reset;
      elsif (this_doInitialization_method_request_field_wdata_reset_strobe = '1') then
        this_doInitialization_method_request_field_wdata <= this_doInitialization_method_request_field_wdata_reset;
      elsif (this_doInitialization_method_request_field_wdata_writer_strobe_game_method_state = '1') then
        this_doInitialization_method_request_field_wdata <= this_doInitialization_method_request_field_wdata_writer_game_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_doInitialization_method_request_field_wdata_reset_strobe <= '1';
      else
        this_doInitialization_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(game_method_state) = 4 or conv_integer(game_method_state) = 4) then
        this_doInitialization_method_request_field_wdata_writer_strobe_game_method_state <= '1';
      else
        this_doInitialization_method_request_field_wdata_writer_strobe_game_method_state <= '0';
      end if;
    end if;
  end process;
  this_doInitialization_method_request_field_rdata <= this_doInitialization_method_request_field_wdata_reset when (reset = '1') else
        this_doInitialization_method_request_field_wdata_reset when (this_doInitialization_method_request_field_wdata_reset_strobe = '1') else
        this_doInitialization_method_request_field_wdata_writer_game_method_state when (this_doInitialization_method_request_field_wdata_writer_strobe_game_method_state = '1') else
        this_doInitialization_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        io_getchar_method_request_field_wdata <= io_getchar_method_request_field_wdata_reset;
      elsif (io_getchar_method_request_field_wdata_reset_strobe = '1') then
        io_getchar_method_request_field_wdata <= io_getchar_method_request_field_wdata_reset;
      elsif (io_getchar_method_request_field_wdata_writer_strobe_state_counter_doInitialization_doInitialization_2 = '1') then
        io_getchar_method_request_field_wdata <= io_getchar_method_request_field_wdata_writer_state_counter_doInitialization_doInitialization_2;
      elsif (io_getchar_method_request_field_wdata_writer_strobe_waitResponseCode_method_state = '1') then
        io_getchar_method_request_field_wdata <= io_getchar_method_request_field_wdata_writer_waitResponseCode_method_state;
      elsif (io_getchar_method_request_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 = '1') then
        io_getchar_method_request_field_wdata <= io_getchar_method_request_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8;
      elsif (io_getchar_method_request_field_wdata_writer_strobe_doFirstMove_method_state = '1') then
        io_getchar_method_request_field_wdata <= io_getchar_method_request_field_wdata_writer_doFirstMove_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        io_getchar_method_request_field_wdata_reset_strobe <= '1';
      else
        io_getchar_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_doInitialization_doInitialization_2) = 1 or conv_integer(state_counter_doInitialization_doInitialization_2) = 1) then
        io_getchar_method_request_field_wdata_writer_strobe_state_counter_doInitialization_doInitialization_2 <= '1';
      else
        io_getchar_method_request_field_wdata_writer_strobe_state_counter_doInitialization_doInitialization_2 <= '0';
      end if;
      if (conv_integer(waitResponseCode_method_state) = 2 or conv_integer(waitResponseCode_method_state) = 2) then
        io_getchar_method_request_field_wdata_writer_strobe_waitResponseCode_method_state <= '1';
      else
        io_getchar_method_request_field_wdata_writer_strobe_waitResponseCode_method_state <= '0';
      end if;
      if (conv_integer(state_counter_waitResponseCode_waitResponseCode_8) = 1 or conv_integer(state_counter_waitResponseCode_waitResponseCode_8) = 1) then
        io_getchar_method_request_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 <= '1';
      else
        io_getchar_method_request_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 <= '0';
      end if;
      if (conv_integer(doFirstMove_method_state) = 3 or conv_integer(doFirstMove_method_state) = 3 or conv_integer(doFirstMove_method_state) = 6 or conv_integer(doFirstMove_method_state) = 6) then
        io_getchar_method_request_field_wdata_writer_strobe_doFirstMove_method_state <= '1';
      else
        io_getchar_method_request_field_wdata_writer_strobe_doFirstMove_method_state <= '0';
      end if;
    end if;
  end process;
  io_getchar_method_request_field_rdata <= io_getchar_method_request_field_wdata_reset when (reset = '1') else
        io_getchar_method_request_field_wdata_reset when (io_getchar_method_request_field_wdata_reset_strobe = '1') else
        io_getchar_method_request_field_wdata_writer_state_counter_doInitialization_doInitialization_2 when (io_getchar_method_request_field_wdata_writer_strobe_state_counter_doInitialization_doInitialization_2 = '1') else
        io_getchar_method_request_field_wdata_writer_waitResponseCode_method_state when (io_getchar_method_request_field_wdata_writer_strobe_waitResponseCode_method_state = '1') else
        io_getchar_method_request_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 when (io_getchar_method_request_field_wdata_writer_strobe_state_counter_waitResponseCode_waitResponseCode_8 = '1') else
        io_getchar_method_request_field_wdata_writer_doFirstMove_method_state when (io_getchar_method_request_field_wdata_writer_strobe_doFirstMove_method_state = '1') else
        io_getchar_method_request_field_wdata;
  
  led_run_method_busy_field_rdata <= led_run_method_busy_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_toStr_v_field_wdata <= this_input_port_toStr_v_field_wdata_reset;
      elsif (this_input_port_toStr_v_field_wdata_reset_strobe = '1') then
        this_input_port_toStr_v_field_wdata <= this_input_port_toStr_v_field_wdata_reset;
      elsif (this_input_port_toStr_v_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 = '1') then
        this_input_port_toStr_v_field_wdata <= this_input_port_toStr_v_field_wdata_writer_state_counter_sendResponse_sendResponse_4;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_toStr_v_field_wdata_reset_strobe <= '1';
      else
        this_input_port_toStr_v_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_sendResponse_sendResponse_4) = 1 or conv_integer(state_counter_sendResponse_sendResponse_4) = 3 or conv_integer(state_counter_sendResponse_sendResponse_4) = 5) then
        this_input_port_toStr_v_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 <= '1';
      else
        this_input_port_toStr_v_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 <= '0';
      end if;
    end if;
  end process;
  this_input_port_toStr_v_field_rdata <= this_input_port_toStr_v_field_wdata_reset when (reset = '1') else
        this_input_port_toStr_v_field_wdata_reset when (this_input_port_toStr_v_field_wdata_reset_strobe = '1') else
        this_input_port_toStr_v_field_wdata_writer_state_counter_sendResponse_sendResponse_4 when (this_input_port_toStr_v_field_wdata_writer_strobe_state_counter_sendResponse_sendResponse_4 = '1') else
        this_input_port_toStr_v_field_wdata;
  
  io_notify_method_busy_field_rdata <= io_notify_method_busy_field_wdata;
  
  io_getchar_method_busy_field_rdata <= io_getchar_method_busy_field_wdata;
  
  led_notify_method_busy_field_rdata <= led_notify_method_busy_field_wdata;
  
  led_value_field_rdata_output_port_field_rdata <= led_value_field_rdata_output_port_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_toInt_x_field_wdata <= this_input_port_toInt_x_field_wdata_reset;
      elsif (this_input_port_toInt_x_field_wdata_reset_strobe = '1') then
        this_input_port_toInt_x_field_wdata <= this_input_port_toInt_x_field_wdata_reset;
      elsif (this_input_port_toInt_x_field_wdata_writer_strobe_parseAndApply_method_state = '1') then
        this_input_port_toInt_x_field_wdata <= this_input_port_toInt_x_field_wdata_writer_parseAndApply_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_input_port_toInt_x_field_wdata_reset_strobe <= '1';
      else
        this_input_port_toInt_x_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(parseAndApply_method_state) = 3 or conv_integer(parseAndApply_method_state) = 6 or conv_integer(parseAndApply_method_state) = 11) then
        this_input_port_toInt_x_field_wdata_writer_strobe_parseAndApply_method_state <= '1';
      else
        this_input_port_toInt_x_field_wdata_writer_strobe_parseAndApply_method_state <= '0';
      end if;
    end if;
  end process;
  this_input_port_toInt_x_field_rdata <= this_input_port_toInt_x_field_wdata_reset when (reset = '1') else
        this_input_port_toInt_x_field_wdata_reset when (this_input_port_toInt_x_field_wdata_reset_strobe = '1') else
        this_input_port_toInt_x_field_wdata_writer_parseAndApply_method_state when (this_input_port_toInt_x_field_wdata_writer_strobe_parseAndApply_method_state = '1') else
        this_input_port_toInt_x_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        buffer_raddr_field_wdata <= buffer_raddr_field_wdata_reset;
      elsif (buffer_raddr_field_wdata_reset_strobe = '1') then
        buffer_raddr_field_wdata <= buffer_raddr_field_wdata_reset;
      elsif (buffer_raddr_field_wdata_writer_strobe_parseAndApply_method_state = '1') then
        buffer_raddr_field_wdata <= buffer_raddr_field_wdata_writer_parseAndApply_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        buffer_raddr_field_wdata_reset_strobe <= '1';
      else
        buffer_raddr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(parseAndApply_method_state) = 2 or conv_integer(parseAndApply_method_state) = 5 or conv_integer(parseAndApply_method_state) = 8 or conv_integer(parseAndApply_method_state) = 10) then
        buffer_raddr_field_wdata_writer_strobe_parseAndApply_method_state <= '1';
      else
        buffer_raddr_field_wdata_writer_strobe_parseAndApply_method_state <= '0';
      end if;
    end if;
  end process;
  buffer_raddr_field_rdata <= buffer_raddr_field_wdata_reset when (reset = '1') else
        buffer_raddr_field_wdata_reset when (buffer_raddr_field_wdata_reset_strobe = '1') else
        buffer_raddr_field_wdata_writer_parseAndApply_method_state when (buffer_raddr_field_wdata_writer_strobe_parseAndApply_method_state = '1') else
        buffer_raddr_field_wdata;
  process(clk) --sendResponse
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_sendResponse_sendResponse_0 <= (others => '0');
        x_sendResponse_0 <= (others => '0');
        y_sendResponse_0 <= (others => '0');
        id_sendResponse_0 <= (others => '0');
        rot_sendResponse_0 <= (others => '0');
        state_counter_sendResponse_sendResponse_1 <= (others => '0');
        sendResponse_if_flag_sendResponse_2_sendResponse_0 <= '0';
        state_counter_sendResponse_sendResponse_3 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
        state_counter_sendResponse_sendResponse_4 <= (others => '0');
        this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
        this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
        this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
        this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
        this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
        this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
        io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
        this_sendResponse_method_busy <= '0';
        sendResponse_method_state <= (others => '0');
        io_putchar_method_request_field_wdata_reset <= '0';
        io_putchar_method_request_field_wdata_reset <= '0';
        io_putchar_method_request_field_wdata_reset <= '0';
        io_putchar_method_request_field_wdata_reset <= '0';
        this_toStr_method_request_field_wdata_reset <= '0';
        this_toStr_method_request_field_wdata_reset <= '0';
        this_toStr_method_request_field_wdata_reset <= '0';
        io_putchar_method_request_field_wdata_reset <= '0';
        io_putchar_method_request_field_wdata_reset <= '0';
        io_putchar_method_request_field_wdata_reset <= '0';
        io_putchar_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(sendResponse_method_state) is
          when 0 =>
            if(this_sendResponse_method_request_field_rdata = '1') then
              this_sendResponse_method_busy <= '1';
              sendResponse_method_state <= sendResponse_method_state + 1;
            else
              this_sendResponse_method_busy <= '0';
            end if;
          when 1 =>
            if(this_sendResponse_method_request_field_rdata = '0') then
              sendResponse_method_state <= sendResponse_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(state_counter_sendResponse_sendResponse_1) is
              when 0 => state_counter_sendResponse_sendResponse_1 <= state_counter_sendResponse_sendResponse_1 + 1;
              when 1 =>
                if (conv_integer(this_input_port_sendResponse_code_field_rdata) = -1) then
                  sendResponse_if_flag_sendResponse_2_sendResponse_0 <= '1';
                  state_counter_sendResponse_sendResponse_3 <= conv_std_logic_vector(1, state_counter_sendResponse_sendResponse_3'length);
                else
                  sendResponse_if_flag_sendResponse_2_sendResponse_0 <= '0';
                  state_counter_sendResponse_sendResponse_4 <= conv_std_logic_vector(1, state_counter_sendResponse_sendResponse_4'length);
                end if;
                state_counter_sendResponse_sendResponse_1 <= state_counter_sendResponse_sendResponse_1 + 1;
              when 2 =>
                if (sendResponse_if_flag_sendResponse_2_sendResponse_0 = '1') then
                  case conv_integer(state_counter_sendResponse_sendResponse_3) is
                    when 0 => state_counter_sendResponse_sendResponse_3 <= state_counter_sendResponse_sendResponse_3 + 1;
                    when 1 =>
                      case conv_integer(io_putchar_call_state_counter_sendResponse_3) is
                        when 0 =>
                          if (io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= '1';
                            io_putchar_call_state_counter_sendResponse_3 <= conv_std_logic_vector(1, io_putchar_call_state_counter_sendResponse_3'length);
                          end if;
                        when 1 =>
                          io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= conv_std_logic_vector(48, io_input_port_putchar_c_field_wdata'length);
                          io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= '0';
                            io_putchar_call_state_counter_sendResponse_3 <= conv_std_logic_vector(2, io_putchar_call_state_counter_sendResponse_3'length);
                        when 2 =>
                          if (io_putchar_method_request_field_wdata = '0' and io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
                            state_counter_sendResponse_sendResponse_3 <= state_counter_sendResponse_sendResponse_3 + 1;
                          end if;
                        when others => io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
                      end case;
                    when 2 =>
                      case conv_integer(io_putchar_call_state_counter_sendResponse_3) is
                        when 0 =>
                          if (io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= '1';
                            io_putchar_call_state_counter_sendResponse_3 <= conv_std_logic_vector(1, io_putchar_call_state_counter_sendResponse_3'length);
                          end if;
                        when 1 =>
                          io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= conv_std_logic_vector(48, io_input_port_putchar_c_field_wdata'length);
                          io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= '0';
                            io_putchar_call_state_counter_sendResponse_3 <= conv_std_logic_vector(2, io_putchar_call_state_counter_sendResponse_3'length);
                        when 2 =>
                          if (io_putchar_method_request_field_wdata = '0' and io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
                            state_counter_sendResponse_sendResponse_3 <= state_counter_sendResponse_sendResponse_3 + 1;
                          end if;
                        when others => io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
                      end case;
                    when 3 =>
                      case conv_integer(io_putchar_call_state_counter_sendResponse_3) is
                        when 0 =>
                          if (io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= '1';
                            io_putchar_call_state_counter_sendResponse_3 <= conv_std_logic_vector(1, io_putchar_call_state_counter_sendResponse_3'length);
                          end if;
                        when 1 =>
                          io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= conv_std_logic_vector(48, io_input_port_putchar_c_field_wdata'length);
                          io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= '0';
                            io_putchar_call_state_counter_sendResponse_3 <= conv_std_logic_vector(2, io_putchar_call_state_counter_sendResponse_3'length);
                        when 2 =>
                          if (io_putchar_method_request_field_wdata = '0' and io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
                            state_counter_sendResponse_sendResponse_3 <= state_counter_sendResponse_sendResponse_3 + 1;
                          end if;
                        when others => io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
                      end case;
                    when 4 =>
                      case conv_integer(io_putchar_call_state_counter_sendResponse_3) is
                        when 0 =>
                          if (io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= '1';
                            io_putchar_call_state_counter_sendResponse_3 <= conv_std_logic_vector(1, io_putchar_call_state_counter_sendResponse_3'length);
                          end if;
                        when 1 =>
                          io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= conv_std_logic_vector(48, io_input_port_putchar_c_field_wdata'length);
                          io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_3 <= '0';
                            io_putchar_call_state_counter_sendResponse_3 <= conv_std_logic_vector(2, io_putchar_call_state_counter_sendResponse_3'length);
                        when 2 =>
                          if (io_putchar_method_request_field_wdata = '0' and io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
                            state_counter_sendResponse_sendResponse_3 <= state_counter_sendResponse_sendResponse_3 + 1;
                          end if;
                        when others => io_putchar_call_state_counter_sendResponse_3 <= (others => '0');
                      end case;
                    when 5 =>
                      state_counter_sendResponse_sendResponse_1 <= state_counter_sendResponse_sendResponse_1 + 1;
                      state_counter_sendResponse_sendResponse_3 <= (others => '0');
                    when others => state_counter_sendResponse_sendResponse_3 <= (others => '0');
                  end case;
                else
                  case conv_integer(state_counter_sendResponse_sendResponse_4) is
                    when 0 => state_counter_sendResponse_sendResponse_4 <= state_counter_sendResponse_sendResponse_4 + 1;
                    when 1 =>
                      case conv_integer(this_toStr_call_state_counter_sendResponse_4) is
                        when 0 =>
                          if (this_toStr_method_busy = '0') then
                            this_toStr_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '1';
                            this_toStr_call_state_counter_sendResponse_4 <= conv_std_logic_vector(1, this_toStr_call_state_counter_sendResponse_4'length);
                          end if;
                        when 1 =>
                          this_input_port_toStr_v_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= conv_std_logic_vector((conv_integer(conv_std_logic_vector((conv_integer(conv_std_logic_vector(0, 24) & this_input_port_sendResponse_code_field_rdata(31 downto 24))), 32) and conv_std_logic_vector(255, 32))) + 1, this_input_port_toStr_v_field_wdata'length);
                          this_toStr_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '0';
                            this_toStr_call_state_counter_sendResponse_4 <= conv_std_logic_vector(2, this_toStr_call_state_counter_sendResponse_4'length);
                        when 2 =>
                          if (this_toStr_method_request_field_wdata = '0' and this_toStr_method_busy = '0') then
                            this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
                            state_counter_sendResponse_sendResponse_4 <= state_counter_sendResponse_sendResponse_4 + 1;
                          end if;
                        when others => this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
                      end case;
                    when 2 =>
                      x_sendResponse_0 <= conv_std_logic_vector(conv_integer(this_output_port_toStr), x_sendResponse_0'length);
                      state_counter_sendResponse_sendResponse_4 <= state_counter_sendResponse_sendResponse_4 + 1;
                    when 3 =>
                      case conv_integer(this_toStr_call_state_counter_sendResponse_4) is
                        when 0 =>
                          if (this_toStr_method_busy = '0') then
                            this_toStr_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '1';
                            this_toStr_call_state_counter_sendResponse_4 <= conv_std_logic_vector(1, this_toStr_call_state_counter_sendResponse_4'length);
                          end if;
                        when 1 =>
                          this_input_port_toStr_v_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= conv_std_logic_vector((conv_integer(conv_std_logic_vector((conv_integer(conv_std_logic_vector(0, 16) & this_input_port_sendResponse_code_field_rdata(31 downto 16))), 32) and conv_std_logic_vector(255, 32))) + 1, this_input_port_toStr_v_field_wdata'length);
                          this_toStr_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '0';
                            this_toStr_call_state_counter_sendResponse_4 <= conv_std_logic_vector(2, this_toStr_call_state_counter_sendResponse_4'length);
                        when 2 =>
                          if (this_toStr_method_request_field_wdata = '0' and this_toStr_method_busy = '0') then
                            this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
                            state_counter_sendResponse_sendResponse_4 <= state_counter_sendResponse_sendResponse_4 + 1;
                          end if;
                        when others => this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
                      end case;
                    when 4 =>
                      y_sendResponse_0 <= conv_std_logic_vector(conv_integer(this_output_port_toStr), y_sendResponse_0'length);
                      id_sendResponse_0 <= conv_std_logic_vector(((conv_integer(conv_std_logic_vector((conv_integer(conv_std_logic_vector(0, 8) & this_input_port_sendResponse_code_field_rdata(31 downto 8))), 32) and conv_std_logic_vector(255, 32))) + 97), id_sendResponse_0'length);
                      state_counter_sendResponse_sendResponse_4 <= state_counter_sendResponse_sendResponse_4 + 1;
                    when 5 =>
                      case conv_integer(this_toStr_call_state_counter_sendResponse_4) is
                        when 0 =>
                          if (this_toStr_method_busy = '0') then
                            this_toStr_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '1';
                            this_toStr_call_state_counter_sendResponse_4 <= conv_std_logic_vector(1, this_toStr_call_state_counter_sendResponse_4'length);
                          end if;
                        when 1 =>
                          this_input_port_toStr_v_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= conv_std_logic_vector(conv_integer(this_input_port_sendResponse_code_field_rdata and conv_std_logic_vector(255, 32)), this_input_port_toStr_v_field_wdata'length);
                          this_toStr_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '0';
                            this_toStr_call_state_counter_sendResponse_4 <= conv_std_logic_vector(2, this_toStr_call_state_counter_sendResponse_4'length);
                        when 2 =>
                          if (this_toStr_method_request_field_wdata = '0' and this_toStr_method_busy = '0') then
                            this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
                            state_counter_sendResponse_sendResponse_4 <= state_counter_sendResponse_sendResponse_4 + 1;
                          end if;
                        when others => this_toStr_call_state_counter_sendResponse_4 <= (others => '0');
                      end case;
                    when 6 =>
                      rot_sendResponse_0 <= conv_std_logic_vector(conv_integer(this_output_port_toStr), rot_sendResponse_0'length);
                      state_counter_sendResponse_sendResponse_4 <= state_counter_sendResponse_sendResponse_4 + 1;
                    when 7 =>
                      case conv_integer(io_putchar_call_state_counter_sendResponse_4) is
                        when 0 =>
                          if (io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '1';
                            io_putchar_call_state_counter_sendResponse_4 <= conv_std_logic_vector(1, io_putchar_call_state_counter_sendResponse_4'length);
                          end if;
                        when 1 =>
                          io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= conv_std_logic_vector(conv_integer(x_sendResponse_0), io_input_port_putchar_c_field_wdata'length);
                          io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '0';
                            io_putchar_call_state_counter_sendResponse_4 <= conv_std_logic_vector(2, io_putchar_call_state_counter_sendResponse_4'length);
                        when 2 =>
                          if (io_putchar_method_request_field_wdata = '0' and io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
                            state_counter_sendResponse_sendResponse_4 <= state_counter_sendResponse_sendResponse_4 + 1;
                          end if;
                        when others => io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
                      end case;
                    when 8 =>
                      case conv_integer(io_putchar_call_state_counter_sendResponse_4) is
                        when 0 =>
                          if (io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '1';
                            io_putchar_call_state_counter_sendResponse_4 <= conv_std_logic_vector(1, io_putchar_call_state_counter_sendResponse_4'length);
                          end if;
                        when 1 =>
                          io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= conv_std_logic_vector(conv_integer(y_sendResponse_0), io_input_port_putchar_c_field_wdata'length);
                          io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '0';
                            io_putchar_call_state_counter_sendResponse_4 <= conv_std_logic_vector(2, io_putchar_call_state_counter_sendResponse_4'length);
                        when 2 =>
                          if (io_putchar_method_request_field_wdata = '0' and io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
                            state_counter_sendResponse_sendResponse_4 <= state_counter_sendResponse_sendResponse_4 + 1;
                          end if;
                        when others => io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
                      end case;
                    when 9 =>
                      case conv_integer(io_putchar_call_state_counter_sendResponse_4) is
                        when 0 =>
                          if (io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '1';
                            io_putchar_call_state_counter_sendResponse_4 <= conv_std_logic_vector(1, io_putchar_call_state_counter_sendResponse_4'length);
                          end if;
                        when 1 =>
                          io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= conv_std_logic_vector(conv_integer(id_sendResponse_0), io_input_port_putchar_c_field_wdata'length);
                          io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '0';
                            io_putchar_call_state_counter_sendResponse_4 <= conv_std_logic_vector(2, io_putchar_call_state_counter_sendResponse_4'length);
                        when 2 =>
                          if (io_putchar_method_request_field_wdata = '0' and io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
                            state_counter_sendResponse_sendResponse_4 <= state_counter_sendResponse_sendResponse_4 + 1;
                          end if;
                        when others => io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
                      end case;
                    when 10 =>
                      case conv_integer(io_putchar_call_state_counter_sendResponse_4) is
                        when 0 =>
                          if (io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '1';
                            io_putchar_call_state_counter_sendResponse_4 <= conv_std_logic_vector(1, io_putchar_call_state_counter_sendResponse_4'length);
                          end if;
                        when 1 =>
                          io_input_port_putchar_c_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= conv_std_logic_vector(conv_integer(rot_sendResponse_0), io_input_port_putchar_c_field_wdata'length);
                          io_putchar_method_request_field_wdata_writer_state_counter_sendResponse_sendResponse_4 <= '0';
                            io_putchar_call_state_counter_sendResponse_4 <= conv_std_logic_vector(2, io_putchar_call_state_counter_sendResponse_4'length);
                        when 2 =>
                          if (io_putchar_method_request_field_wdata = '0' and io_putchar_method_busy_field_wdata = '0') then
                            io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
                            state_counter_sendResponse_sendResponse_4 <= state_counter_sendResponse_sendResponse_4 + 1;
                          end if;
                        when others => io_putchar_call_state_counter_sendResponse_4 <= (others => '0');
                      end case;
                    when 11 =>
                      state_counter_sendResponse_sendResponse_1 <= state_counter_sendResponse_sendResponse_1 + 1;
                      state_counter_sendResponse_sendResponse_4 <= (others => '0');
                    when others => state_counter_sendResponse_sendResponse_4 <= (others => '0');
                  end case;
                end if;
              when 3 =>
                state_counter_sendResponse_sendResponse_1 <= (others => '0');
                sendResponse_method_state <= sendResponse_method_state + 1;
              when others =>
                state_counter_sendResponse_sendResponse_1 <= (others => '0');
            end case;
          when 3 => 
            sendResponse_method_state <= (others => '0');
          when 4 =>
            this_sendResponse_method_busy <= '0';
            sendResponse_method_state <= (others => '0');
          when others => sendResponse_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --sendResponse
  process(clk) --doInitialization
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_doInitialization_doInitialization_0 <= (others => '0');
        state_counter_doInitialization_doInitialization_1 <= (others => '0');
        state_counter_doInitialization_doInitialization_2 <= (others => '0');
        c_doInitialization_2 <= (others => '0');
        io_getchar_call_state_counter_doInitialization_2 <= (others => '0');
        io_getchar_call_state_counter_doInitialization_2 <= (others => '0');
        state_counter_doInitialization_doInitialization_3 <= (others => '0');
        doInitialization_if_flag_doInitialization_4_doInitialization_2 <= '0';
        state_counter_doInitialization_doInitialization_5 <= (others => '0');
        io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
        io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
        io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
        io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
        io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
        io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
        this_doInitialization_method_busy <= '0';
        doInitialization_method_state <= (others => '0');
        io_getchar_method_request_field_wdata_reset <= '0';
        io_putchar_method_request_field_wdata_reset <= '0';
        io_putchar_method_request_field_wdata_reset <= '0';
        io_putchar_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(doInitialization_method_state) is
          when 0 =>
            if(this_doInitialization_method_request_field_rdata = '1') then
              this_doInitialization_method_busy <= '1';
              doInitialization_method_state <= doInitialization_method_state + 1;
            else
              this_doInitialization_method_busy <= '0';
            end if;
          when 1 =>
            if(this_doInitialization_method_request_field_rdata = '0') then
              doInitialization_method_state <= doInitialization_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(state_counter_doInitialization_doInitialization_1) is
              when 0 => state_counter_doInitialization_doInitialization_1 <= state_counter_doInitialization_doInitialization_1 + 1;
              when 1 =>
                if (true) then
                  state_counter_doInitialization_doInitialization_1 <= state_counter_doInitialization_doInitialization_1 + 1;
                  state_counter_doInitialization_doInitialization_2 <= conv_std_logic_vector(1, state_counter_doInitialization_doInitialization_2'length);
                else
                  doInitialization_method_state <= doInitialization_method_state + 1;
                  state_counter_doInitialization_doInitialization_1 <= (others => '0');
                end if;
              when 2 =>
                case conv_integer(state_counter_doInitialization_doInitialization_2) is
                  when 0 => state_counter_doInitialization_doInitialization_2 <= state_counter_doInitialization_doInitialization_2 + 1;
                  when 1 =>
                    case conv_integer(io_getchar_call_state_counter_doInitialization_2) is
                      when 0 =>
                        if (io_getchar_method_busy_field_wdata = '0') then
                          io_getchar_method_request_field_wdata_writer_state_counter_doInitialization_doInitialization_2 <= '1';
                          io_getchar_call_state_counter_doInitialization_2 <= conv_std_logic_vector(1, io_getchar_call_state_counter_doInitialization_2'length);
                        end if;
                      when 1 =>
                        io_getchar_method_request_field_wdata_writer_state_counter_doInitialization_doInitialization_2 <= '0';
                          io_getchar_call_state_counter_doInitialization_2 <= conv_std_logic_vector(2, io_getchar_call_state_counter_doInitialization_2'length);
                      when 2 =>
                        if (io_getchar_method_request_field_wdata = '0' and io_getchar_method_busy_field_wdata = '0') then
                          io_getchar_call_state_counter_doInitialization_2 <= (others => '0');
                          state_counter_doInitialization_doInitialization_2 <= state_counter_doInitialization_doInitialization_2 + 1;
                        end if;
                      when others => io_getchar_call_state_counter_doInitialization_2 <= (others => '0');
                    end case;
                  when 2 =>
                    c_doInitialization_2 <= conv_std_logic_vector(conv_integer(io_output_port_getchar_field_rdata), c_doInitialization_2'length);
                    state_counter_doInitialization_doInitialization_2 <= state_counter_doInitialization_doInitialization_2 + 1;
                  when 3 =>
                    case conv_integer(state_counter_doInitialization_doInitialization_3) is
                      when 0 => state_counter_doInitialization_doInitialization_3 <= state_counter_doInitialization_doInitialization_3 + 1;
                      when 1 =>
                        if (conv_integer(c_doInitialization_2) = 48) then
                          doInitialization_if_flag_doInitialization_4_doInitialization_2 <= '1';
                          state_counter_doInitialization_doInitialization_5 <= conv_std_logic_vector(1, state_counter_doInitialization_doInitialization_5'length);
                        else
                          doInitialization_if_flag_doInitialization_4_doInitialization_2 <= '0';
                        end if;
                        state_counter_doInitialization_doInitialization_3 <= state_counter_doInitialization_doInitialization_3 + 1;
                      when 2 =>
                        if (doInitialization_if_flag_doInitialization_4_doInitialization_2 = '1') then
                          case conv_integer(state_counter_doInitialization_doInitialization_5) is
                            when 0 => state_counter_doInitialization_doInitialization_5 <= state_counter_doInitialization_doInitialization_5 + 1;
                            when 1 =>
                              state_counter_doInitialization_doInitialization_5 <= (others => '0');
                              state_counter_doInitialization_doInitialization_3 <= (others => '0');
                              state_counter_doInitialization_doInitialization_2 <= (others => '0');
                              state_counter_doInitialization_doInitialization_1 <= (others => '0');
                              doInitialization_method_state <= doInitialization_method_state + 1;
                            when 2 =>
                              state_counter_doInitialization_doInitialization_3 <= state_counter_doInitialization_doInitialization_3 + 1;
                              state_counter_doInitialization_doInitialization_5 <= (others => '0');
                            when others => state_counter_doInitialization_doInitialization_5 <= (others => '0');
                          end case;
                        else
                          state_counter_doInitialization_doInitialization_3 <= state_counter_doInitialization_doInitialization_3 + 1;
                        end if;
                      when 3 =>
                        state_counter_doInitialization_doInitialization_3 <= (others => '0');
                        state_counter_doInitialization_doInitialization_2 <= state_counter_doInitialization_doInitialization_2 + 1;
                      when others =>
                        state_counter_doInitialization_doInitialization_3 <= (others => '0');
                    end case;
                  when 4 =>
                    state_counter_doInitialization_doInitialization_1 <= state_counter_doInitialization_doInitialization_1 + 1;
                    state_counter_doInitialization_doInitialization_2 <= (others => '0');
                  when others => state_counter_doInitialization_doInitialization_2 <= (others => '0');
                end case;
              when 3 =>
                state_counter_doInitialization_doInitialization_1 <= (others => '0');
              when others => state_counter_doInitialization_doInitialization_1 <= (others => '0');
            end case;
          when 3 => 
            case conv_integer(io_putchar_call_state_counter_doInitialization_0) is
              when 0 =>
                if (io_putchar_method_busy_field_wdata = '0') then
                  io_putchar_method_request_field_wdata_writer_doInitialization_method_state <= '1';
                  io_putchar_call_state_counter_doInitialization_0 <= conv_std_logic_vector(1, io_putchar_call_state_counter_doInitialization_0'length);
                end if;
              when 1 =>
                io_input_port_putchar_c_field_wdata_writer_doInitialization_method_state <= conv_std_logic_vector(49, io_input_port_putchar_c_field_wdata'length);
                io_putchar_method_request_field_wdata_writer_doInitialization_method_state <= '0';
                  io_putchar_call_state_counter_doInitialization_0 <= conv_std_logic_vector(2, io_putchar_call_state_counter_doInitialization_0'length);
              when 2 =>
                if (io_putchar_method_request_field_wdata = '0' and io_putchar_method_busy_field_wdata = '0') then
                  io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
                  doInitialization_method_state <= doInitialization_method_state + 1;
                end if;
              when others => io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
            end case;
          when 4 => 
            case conv_integer(io_putchar_call_state_counter_doInitialization_0) is
              when 0 =>
                if (io_putchar_method_busy_field_wdata = '0') then
                  io_putchar_method_request_field_wdata_writer_doInitialization_method_state <= '1';
                  io_putchar_call_state_counter_doInitialization_0 <= conv_std_logic_vector(1, io_putchar_call_state_counter_doInitialization_0'length);
                end if;
              when 1 =>
                io_input_port_putchar_c_field_wdata_writer_doInitialization_method_state <= conv_std_logic_vector(conv_integer(codeH_field_rdata), io_input_port_putchar_c_field_wdata'length);
                io_putchar_method_request_field_wdata_writer_doInitialization_method_state <= '0';
                  io_putchar_call_state_counter_doInitialization_0 <= conv_std_logic_vector(2, io_putchar_call_state_counter_doInitialization_0'length);
              when 2 =>
                if (io_putchar_method_request_field_wdata = '0' and io_putchar_method_busy_field_wdata = '0') then
                  io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
                  doInitialization_method_state <= doInitialization_method_state + 1;
                end if;
              when others => io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
            end case;
          when 5 => 
            case conv_integer(io_putchar_call_state_counter_doInitialization_0) is
              when 0 =>
                if (io_putchar_method_busy_field_wdata = '0') then
                  io_putchar_method_request_field_wdata_writer_doInitialization_method_state <= '1';
                  io_putchar_call_state_counter_doInitialization_0 <= conv_std_logic_vector(1, io_putchar_call_state_counter_doInitialization_0'length);
                end if;
              when 1 =>
                io_input_port_putchar_c_field_wdata_writer_doInitialization_method_state <= conv_std_logic_vector(conv_integer(codeL_field_rdata), io_input_port_putchar_c_field_wdata'length);
                io_putchar_method_request_field_wdata_writer_doInitialization_method_state <= '0';
                  io_putchar_call_state_counter_doInitialization_0 <= conv_std_logic_vector(2, io_putchar_call_state_counter_doInitialization_0'length);
              when 2 =>
                if (io_putchar_method_request_field_wdata = '0' and io_putchar_method_busy_field_wdata = '0') then
                  io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
                  doInitialization_method_state <= doInitialization_method_state + 1;
                end if;
              when others => io_putchar_call_state_counter_doInitialization_0 <= (others => '0');
            end case;
          when 6 =>
            this_doInitialization_method_busy <= '0';
            doInitialization_method_state <= (others => '0');
          when others => doInitialization_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --doInitialization
  process(clk) --waitResponseCode
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_waitResponseCode_waitResponseCode_0 <= (others => '0');
        c_waitResponseCode_0 <= (others => '0');
        io_getchar_call_state_counter_waitResponseCode_0 <= (others => '0');
        io_getchar_call_state_counter_waitResponseCode_0 <= (others => '0');
        state_counter_waitResponseCode_waitResponseCode_1 <= (others => '0');
        waitResponseCode_if_flag_waitResponseCode_2_waitResponseCode_0 <= '0';
        state_counter_waitResponseCode_waitResponseCode_3 <= (others => '0');
        state_counter_waitResponseCode_waitResponseCode_4 <= (others => '0');
        waitResponseCode_if_flag_waitResponseCode_5_waitResponseCode_0 <= '0';
        state_counter_waitResponseCode_waitResponseCode_6 <= (others => '0');
        state_counter_waitResponseCode_waitResponseCode_7 <= (others => '0');
        i_waitResponseCode_7 <= (others => '0');
        state_counter_waitResponseCode_waitResponseCode_8 <= (others => '0');
        io_getchar_call_state_counter_waitResponseCode_8 <= (others => '0');
        io_getchar_call_state_counter_waitResponseCode_8 <= (others => '0');
        array_index_operation_state_counter_waitResponseCode_9 <= (others => '0');
        this_waitResponseCode_method_busy <= '0';
        waitResponseCode_method_state <= (others => '0');
        io_getchar_method_request_field_wdata_reset <= '0';
        this_output_port_waitResponseCode <= '0';
        io_getchar_method_request_field_wdata_reset <= '0';
        buffer_wdata_field_wdata_reset <= (others => '0');
      else
        case conv_integer(waitResponseCode_method_state) is
          when 0 =>
            if(this_waitResponseCode_method_request_field_rdata = '1') then
              this_waitResponseCode_method_busy <= '1';
              waitResponseCode_method_state <= waitResponseCode_method_state + 1;
            else
              this_waitResponseCode_method_busy <= '0';
            end if;
          when 1 =>
            if(this_waitResponseCode_method_request_field_rdata = '0') then
              waitResponseCode_method_state <= waitResponseCode_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(io_getchar_call_state_counter_waitResponseCode_0) is
              when 0 =>
                if (io_getchar_method_busy_field_wdata = '0') then
                  io_getchar_method_request_field_wdata_writer_waitResponseCode_method_state <= '1';
                  io_getchar_call_state_counter_waitResponseCode_0 <= conv_std_logic_vector(1, io_getchar_call_state_counter_waitResponseCode_0'length);
                end if;
              when 1 =>
                io_getchar_method_request_field_wdata_writer_waitResponseCode_method_state <= '0';
                  io_getchar_call_state_counter_waitResponseCode_0 <= conv_std_logic_vector(2, io_getchar_call_state_counter_waitResponseCode_0'length);
              when 2 =>
                if (io_getchar_method_request_field_wdata = '0' and io_getchar_method_busy_field_wdata = '0') then
                  io_getchar_call_state_counter_waitResponseCode_0 <= (others => '0');
                  waitResponseCode_method_state <= waitResponseCode_method_state + 1;
                end if;
              when others => io_getchar_call_state_counter_waitResponseCode_0 <= (others => '0');
            end case;
          when 3 => 
            c_waitResponseCode_0 <= conv_std_logic_vector(conv_integer(io_output_port_getchar_field_rdata), c_waitResponseCode_0'length);
            waitResponseCode_method_state <= waitResponseCode_method_state + 1;
          when 4 => 
            case conv_integer(state_counter_waitResponseCode_waitResponseCode_1) is
              when 0 => state_counter_waitResponseCode_waitResponseCode_1 <= state_counter_waitResponseCode_waitResponseCode_1 + 1;
              when 1 =>
                if (conv_integer(c_waitResponseCode_0) = 57) then
                  waitResponseCode_if_flag_waitResponseCode_2_waitResponseCode_0 <= '1';
                  state_counter_waitResponseCode_waitResponseCode_3 <= conv_std_logic_vector(1, state_counter_waitResponseCode_waitResponseCode_3'length);
                else
                  waitResponseCode_if_flag_waitResponseCode_2_waitResponseCode_0 <= '0';
                end if;
                state_counter_waitResponseCode_waitResponseCode_1 <= state_counter_waitResponseCode_waitResponseCode_1 + 1;
              when 2 =>
                if (waitResponseCode_if_flag_waitResponseCode_2_waitResponseCode_0 = '1') then
                  case conv_integer(state_counter_waitResponseCode_waitResponseCode_3) is
                    when 0 => state_counter_waitResponseCode_waitResponseCode_3 <= state_counter_waitResponseCode_waitResponseCode_3 + 1;
                    when 1 =>
                      this_output_port_waitResponseCode <= '0';
                      state_counter_waitResponseCode_waitResponseCode_3 <= (others => '0');
                      state_counter_waitResponseCode_waitResponseCode_1 <= (others => '0');
                      waitResponseCode_method_state <= (others => '0');
                    when 2 =>
                      state_counter_waitResponseCode_waitResponseCode_1 <= state_counter_waitResponseCode_waitResponseCode_1 + 1;
                      state_counter_waitResponseCode_waitResponseCode_3 <= (others => '0');
                    when others => state_counter_waitResponseCode_waitResponseCode_3 <= (others => '0');
                  end case;
                else
                  state_counter_waitResponseCode_waitResponseCode_1 <= state_counter_waitResponseCode_waitResponseCode_1 + 1;
                end if;
              when 3 =>
                state_counter_waitResponseCode_waitResponseCode_1 <= (others => '0');
                waitResponseCode_method_state <= waitResponseCode_method_state + 1;
              when others =>
                state_counter_waitResponseCode_waitResponseCode_1 <= (others => '0');
            end case;
          when 5 => 
            case conv_integer(state_counter_waitResponseCode_waitResponseCode_4) is
              when 0 => state_counter_waitResponseCode_waitResponseCode_4 <= state_counter_waitResponseCode_waitResponseCode_4 + 1;
              when 1 =>
                if (conv_integer(c_waitResponseCode_0) /= conv_integer(this_input_port_waitResponseCode_expected_field_rdata)) then
                  waitResponseCode_if_flag_waitResponseCode_5_waitResponseCode_0 <= '1';
                  state_counter_waitResponseCode_waitResponseCode_6 <= conv_std_logic_vector(1, state_counter_waitResponseCode_waitResponseCode_6'length);
                else
                  waitResponseCode_if_flag_waitResponseCode_5_waitResponseCode_0 <= '0';
                end if;
                state_counter_waitResponseCode_waitResponseCode_4 <= state_counter_waitResponseCode_waitResponseCode_4 + 1;
              when 2 =>
                if (waitResponseCode_if_flag_waitResponseCode_5_waitResponseCode_0 = '1') then
                  case conv_integer(state_counter_waitResponseCode_waitResponseCode_6) is
                    when 0 => state_counter_waitResponseCode_waitResponseCode_6 <= state_counter_waitResponseCode_waitResponseCode_6 + 1;
                    when 1 =>
                      state_counter_waitResponseCode_waitResponseCode_4 <= state_counter_waitResponseCode_waitResponseCode_4 + 1;
                      state_counter_waitResponseCode_waitResponseCode_6 <= (others => '0');
                    when others => state_counter_waitResponseCode_waitResponseCode_6 <= (others => '0');
                  end case;
                else
                  state_counter_waitResponseCode_waitResponseCode_4 <= state_counter_waitResponseCode_waitResponseCode_4 + 1;
                end if;
              when 3 =>
                state_counter_waitResponseCode_waitResponseCode_4 <= (others => '0');
                waitResponseCode_method_state <= waitResponseCode_method_state + 1;
              when others =>
                state_counter_waitResponseCode_waitResponseCode_4 <= (others => '0');
            end case;
          when 6 => 
            case conv_integer(state_counter_waitResponseCode_waitResponseCode_7) is
              when 0 => state_counter_waitResponseCode_waitResponseCode_7 <= state_counter_waitResponseCode_waitResponseCode_7 + 1;
              when 1 =>
                i_waitResponseCode_7 <= conv_std_logic_vector(0, i_waitResponseCode_7'length);
                state_counter_waitResponseCode_waitResponseCode_7 <= state_counter_waitResponseCode_waitResponseCode_7 + 1;
              when 2 =>
                if (conv_integer(i_waitResponseCode_7) < conv_integer(this_input_port_waitResponseCode_args_field_rdata)) then
                  state_counter_waitResponseCode_waitResponseCode_7 <= state_counter_waitResponseCode_waitResponseCode_7 + 1;
                  state_counter_waitResponseCode_waitResponseCode_8 <= conv_std_logic_vector(1, state_counter_waitResponseCode_waitResponseCode_8'length);
                else
                  waitResponseCode_method_state <= waitResponseCode_method_state + 1;
                  state_counter_waitResponseCode_waitResponseCode_7 <= (others => '0');
                end if;
              when 3 =>
                case conv_integer(state_counter_waitResponseCode_waitResponseCode_8) is
                  when 0 => state_counter_waitResponseCode_waitResponseCode_8 <= state_counter_waitResponseCode_waitResponseCode_8 + 1;
                  when 1 =>
                    case conv_integer(io_getchar_call_state_counter_waitResponseCode_8) is
                      when 0 =>
                        if (io_getchar_method_busy_field_wdata = '0') then
                          io_getchar_method_request_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 <= '1';
                          io_getchar_call_state_counter_waitResponseCode_8 <= conv_std_logic_vector(1, io_getchar_call_state_counter_waitResponseCode_8'length);
                        end if;
                      when 1 =>
                        io_getchar_method_request_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 <= '0';
                          io_getchar_call_state_counter_waitResponseCode_8 <= conv_std_logic_vector(2, io_getchar_call_state_counter_waitResponseCode_8'length);
                      when 2 =>
                        if (io_getchar_method_request_field_wdata = '0' and io_getchar_method_busy_field_wdata = '0') then
                          io_getchar_call_state_counter_waitResponseCode_8 <= (others => '0');
                          state_counter_waitResponseCode_waitResponseCode_8 <= state_counter_waitResponseCode_waitResponseCode_8 + 1;
                        end if;
                      when others => io_getchar_call_state_counter_waitResponseCode_8 <= (others => '0');
                    end case;
                  when 2 =>
                    c_waitResponseCode_0 <= conv_std_logic_vector(conv_integer(io_output_port_getchar_field_rdata), c_waitResponseCode_0'length);
                    state_counter_waitResponseCode_waitResponseCode_8 <= state_counter_waitResponseCode_waitResponseCode_8 + 1;
                  when 3 =>
                    buffer_waddr_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 <= conv_std_logic_vector(conv_integer(i_waitResponseCode_7), buffer_waddr_field_wdata'length);
                    buffer_we_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 <= conv_std_logic_vector(1, buffer_we_field_wdata'length);
                    buffer_wdata_field_wdata_writer_state_counter_waitResponseCode_waitResponseCode_8 <= conv_std_logic_vector(conv_integer(c_waitResponseCode_0), buffer_wdata_field_wdata'length);
                    state_counter_waitResponseCode_waitResponseCode_7 <= state_counter_waitResponseCode_waitResponseCode_7 + 1;
                    state_counter_waitResponseCode_waitResponseCode_8 <= (others => '0');
                  when others => state_counter_waitResponseCode_waitResponseCode_8 <= (others => '0');
                end case;
              when 4 =>
                  i_waitResponseCode_7 <= conv_std_logic_vector(conv_integer(i_waitResponseCode_7) + 1, i_waitResponseCode_7'length);
                  state_counter_waitResponseCode_waitResponseCode_7 <= conv_std_logic_vector(2, 32);
              when others => state_counter_waitResponseCode_waitResponseCode_7 <= (others => '0');
            end case;
          when 7 => 
            this_output_port_waitResponseCode <= '1';
            waitResponseCode_method_state <= (others => '0');
          when 8 =>
            this_waitResponseCode_method_busy <= '0';
            waitResponseCode_method_state <= (others => '0');
          when others => waitResponseCode_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --waitResponseCode
  process(clk) --wait
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        d_notify_flag <= '0';
        this_wait_method_busy <= '0';
        wait_method_state <= (others => '0');
        state_counter_wait_wait_0 <= (others => '0');
      else
        case conv_integer(wait_method_state) is
          when 0 =>
            if(this_wait_method_request_field_rdata = '1') then
              this_wait_method_busy <= '1';
              wait_method_state <= wait_method_state + 1;
            else
              this_wait_method_busy <= '0';
            end if;
          when 1 =>
            if(this_wait_method_request_field_rdata = '0') then
              wait_method_state <= wait_method_state + 1;
            end if;
          when 2 => 
            if (d_notify_flag = '0' and notify_flag = '1') then
              wait_method_state <= wait_method_state + 1;
            else
              d_notify_flag <= notify_flag;
            end if;
          when 3 =>
            this_wait_method_busy <= '0';
            wait_method_state <= (others => '0');
          when others => wait_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --wait
  process(clk) --toInt
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_toInt_toInt_0 <= (others => '0');
        state_counter_toInt_toInt_1 <= (others => '0');
        toInt_if_flag_toInt_2_toInt_0 <= '0';
        state_counter_toInt_toInt_3 <= (others => '0');
        state_counter_toInt_toInt_4 <= (others => '0');
        toInt_if_flag_toInt_5_toInt_1 <= '0';
        state_counter_toInt_toInt_6 <= (others => '0');
        state_counter_toInt_toInt_7 <= (others => '0');
        toInt_if_flag_toInt_8_toInt_4 <= '0';
        state_counter_toInt_toInt_9 <= (others => '0');
        state_counter_toInt_toInt_10 <= (others => '0');
        this_toInt_method_busy <= '0';
        toInt_method_state <= (others => '0');
        this_output_port_toInt <= (others => '0');
      else
        case conv_integer(toInt_method_state) is
          when 0 =>
            if(this_toInt_method_request_field_rdata = '1') then
              this_toInt_method_busy <= '1';
              toInt_method_state <= toInt_method_state + 1;
            else
              this_toInt_method_busy <= '0';
            end if;
          when 1 =>
            if(this_toInt_method_request_field_rdata = '0') then
              toInt_method_state <= toInt_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(state_counter_toInt_toInt_1) is
              when 0 => state_counter_toInt_toInt_1 <= state_counter_toInt_toInt_1 + 1;
              when 1 =>
                if (48 <= conv_integer(this_input_port_toInt_x_field_rdata) and conv_integer(this_input_port_toInt_x_field_rdata) <= 57) then
                  toInt_if_flag_toInt_2_toInt_0 <= '1';
                  state_counter_toInt_toInt_3 <= conv_std_logic_vector(1, state_counter_toInt_toInt_3'length);
                else
                  toInt_if_flag_toInt_2_toInt_0 <= '0';
                end if;
                state_counter_toInt_toInt_1 <= state_counter_toInt_toInt_1 + 1;
              when 2 =>
                if (toInt_if_flag_toInt_2_toInt_0 = '1') then
                  case conv_integer(state_counter_toInt_toInt_3) is
                    when 0 => state_counter_toInt_toInt_3 <= state_counter_toInt_toInt_3 + 1;
                    when 1 =>
                      this_output_port_toInt <= conv_std_logic_vector(conv_integer(this_input_port_toInt_x_field_rdata) - 48, this_output_port_toInt'length);
                      state_counter_toInt_toInt_3 <= (others => '0');
                      state_counter_toInt_toInt_1 <= (others => '0');
                      toInt_method_state <= (others => '0');
                    when 2 =>
                      state_counter_toInt_toInt_1 <= state_counter_toInt_toInt_1 + 1;
                      state_counter_toInt_toInt_3 <= (others => '0');
                    when others => state_counter_toInt_toInt_3 <= (others => '0');
                  end case;
                else
                  case conv_integer(state_counter_toInt_toInt_4) is
                    when 0 => state_counter_toInt_toInt_4 <= state_counter_toInt_toInt_4 + 1;
                    when 1 =>
                      if (97 <= conv_integer(this_input_port_toInt_x_field_rdata) and conv_integer(this_input_port_toInt_x_field_rdata) <= 102) then
                        toInt_if_flag_toInt_5_toInt_1 <= '1';
                        state_counter_toInt_toInt_6 <= conv_std_logic_vector(1, state_counter_toInt_toInt_6'length);
                      else
                        toInt_if_flag_toInt_5_toInt_1 <= '0';
                      end if;
                      state_counter_toInt_toInt_4 <= state_counter_toInt_toInt_4 + 1;
                    when 2 =>
                      if (toInt_if_flag_toInt_5_toInt_1 = '1') then
                        case conv_integer(state_counter_toInt_toInt_6) is
                          when 0 => state_counter_toInt_toInt_6 <= state_counter_toInt_toInt_6 + 1;
                          when 1 =>
                            this_output_port_toInt <= conv_std_logic_vector((conv_integer(this_input_port_toInt_x_field_rdata) - 97) + 10, this_output_port_toInt'length);
                            state_counter_toInt_toInt_6 <= (others => '0');
                            state_counter_toInt_toInt_4 <= (others => '0');
                            state_counter_toInt_toInt_1 <= (others => '0');
                            toInt_method_state <= (others => '0');
                          when 2 =>
                            state_counter_toInt_toInt_4 <= state_counter_toInt_toInt_4 + 1;
                            state_counter_toInt_toInt_6 <= (others => '0');
                          when others => state_counter_toInt_toInt_6 <= (others => '0');
                        end case;
                      else
                        case conv_integer(state_counter_toInt_toInt_7) is
                          when 0 => state_counter_toInt_toInt_7 <= state_counter_toInt_toInt_7 + 1;
                          when 1 =>
                            if (65 <= conv_integer(this_input_port_toInt_x_field_rdata) and conv_integer(this_input_port_toInt_x_field_rdata) <= 70) then
                              toInt_if_flag_toInt_8_toInt_4 <= '1';
                              state_counter_toInt_toInt_9 <= conv_std_logic_vector(1, state_counter_toInt_toInt_9'length);
                            else
                              toInt_if_flag_toInt_8_toInt_4 <= '0';
                              state_counter_toInt_toInt_10 <= conv_std_logic_vector(1, state_counter_toInt_toInt_10'length);
                            end if;
                            state_counter_toInt_toInt_7 <= state_counter_toInt_toInt_7 + 1;
                          when 2 =>
                            if (toInt_if_flag_toInt_8_toInt_4 = '1') then
                              case conv_integer(state_counter_toInt_toInt_9) is
                                when 0 => state_counter_toInt_toInt_9 <= state_counter_toInt_toInt_9 + 1;
                                when 1 =>
                                  this_output_port_toInt <= conv_std_logic_vector((conv_integer(this_input_port_toInt_x_field_rdata) - 65) + 10, this_output_port_toInt'length);
                                  state_counter_toInt_toInt_9 <= (others => '0');
                                  state_counter_toInt_toInt_7 <= (others => '0');
                                  state_counter_toInt_toInt_4 <= (others => '0');
                                  state_counter_toInt_toInt_1 <= (others => '0');
                                  toInt_method_state <= (others => '0');
                                when 2 =>
                                  state_counter_toInt_toInt_7 <= state_counter_toInt_toInt_7 + 1;
                                  state_counter_toInt_toInt_9 <= (others => '0');
                                when others => state_counter_toInt_toInt_9 <= (others => '0');
                              end case;
                            else
                              case conv_integer(state_counter_toInt_toInt_10) is
                                when 0 => state_counter_toInt_toInt_10 <= state_counter_toInt_toInt_10 + 1;
                                when 1 =>
                                  this_output_port_toInt <= conv_std_logic_vector(-1, this_output_port_toInt'length);
                                  state_counter_toInt_toInt_10 <= (others => '0');
                                  state_counter_toInt_toInt_7 <= (others => '0');
                                  state_counter_toInt_toInt_4 <= (others => '0');
                                  state_counter_toInt_toInt_1 <= (others => '0');
                                  toInt_method_state <= (others => '0');
                                when 2 =>
                                  state_counter_toInt_toInt_7 <= state_counter_toInt_toInt_7 + 1;
                                  state_counter_toInt_toInt_10 <= (others => '0');
                                when others => state_counter_toInt_toInt_10 <= (others => '0');
                              end case;
                            end if;
                          when 3 =>
                            state_counter_toInt_toInt_7 <= (others => '0');
                            state_counter_toInt_toInt_4 <= state_counter_toInt_toInt_4 + 1;
                          when others =>
                            state_counter_toInt_toInt_7 <= (others => '0');
                        end case;
                      end if;
                    when 3 =>
                      state_counter_toInt_toInt_4 <= (others => '0');
                      state_counter_toInt_toInt_1 <= state_counter_toInt_toInt_1 + 1;
                    when others =>
                      state_counter_toInt_toInt_4 <= (others => '0');
                  end case;
                end if;
              when 3 =>
                state_counter_toInt_toInt_1 <= (others => '0');
                toInt_method_state <= toInt_method_state + 1;
              when others =>
                state_counter_toInt_toInt_1 <= (others => '0');
            end case;
          when 3 =>
            this_toInt_method_busy <= '0';
            toInt_method_state <= (others => '0');
          when others => toInt_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --toInt
  process(led_value_field_rdata_output_port_field_rdata) --led_out
  begin
    output_port_led_out <= conv_std_logic_vector(conv_integer(led_value_field_rdata_output_port_field_rdata), output_port_led_out'length);
  end process; --led_out
  process(clk) --fpga_main
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_fpga_main_fpga_main_0 <= (others => '0');
        led_start_call_state_counter_fpga_main_0 <= (others => '0');
        led_start_call_state_counter_fpga_main_0 <= (others => '0');
        state_counter_fpga_main_fpga_main_1 <= (others => '0');
        state_counter_fpga_main_fpga_main_2 <= (others => '0');
        this_game_call_state_counter_fpga_main_2 <= (others => '0');
        this_game_call_state_counter_fpga_main_2 <= (others => '0');
        fpga_main_method_state <= (others => '0');
        this_game_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(fpga_main_method_state) is
          when 0 => 
            case conv_integer(led_start_call_state_counter_fpga_main_0) is
              when 0 =>
                if (led_run_method_busy_field_wdata = '0') then
                  led_run_method_request_field_wdata_writer_fpga_main_method_state <= '1';
                  led_start_call_state_counter_fpga_main_0 <= conv_std_logic_vector(1, led_start_call_state_counter_fpga_main_0'length);
                end if;
              when 1 =>
                led_run_method_request_field_wdata_writer_fpga_main_method_state <= '0';
                  led_start_call_state_counter_fpga_main_0 <= conv_std_logic_vector(2, led_start_call_state_counter_fpga_main_0'length);
              when 2 =>
                led_start_call_state_counter_fpga_main_0 <= (others => '0');
                fpga_main_method_state <= fpga_main_method_state + 1;
              when others => led_start_call_state_counter_fpga_main_0 <= (others => '0');
            end case;
          when 1 => 
            case conv_integer(state_counter_fpga_main_fpga_main_1) is
              when 0 => state_counter_fpga_main_fpga_main_1 <= state_counter_fpga_main_fpga_main_1 + 1;
              when 1 =>
                if (true) then
                  state_counter_fpga_main_fpga_main_1 <= state_counter_fpga_main_fpga_main_1 + 1;
                  state_counter_fpga_main_fpga_main_2 <= conv_std_logic_vector(1, state_counter_fpga_main_fpga_main_2'length);
                else
                  fpga_main_method_state <= fpga_main_method_state + 1;
                  state_counter_fpga_main_fpga_main_1 <= (others => '0');
                end if;
              when 2 =>
                case conv_integer(state_counter_fpga_main_fpga_main_2) is
                  when 0 => state_counter_fpga_main_fpga_main_2 <= state_counter_fpga_main_fpga_main_2 + 1;
                  when 1 =>
                    case conv_integer(this_game_call_state_counter_fpga_main_2) is
                      when 0 =>
                        if (this_game_method_busy = '0') then
                          this_game_method_request_field_wdata_writer_state_counter_fpga_main_fpga_main_2 <= '1';
                          this_game_call_state_counter_fpga_main_2 <= conv_std_logic_vector(1, this_game_call_state_counter_fpga_main_2'length);
                        end if;
                      when 1 =>
                        this_game_method_request_field_wdata_writer_state_counter_fpga_main_fpga_main_2 <= '0';
                          this_game_call_state_counter_fpga_main_2 <= conv_std_logic_vector(2, this_game_call_state_counter_fpga_main_2'length);
                      when 2 =>
                        if (this_game_method_request_field_wdata = '0' and this_game_method_busy = '0') then
                          this_game_call_state_counter_fpga_main_2 <= (others => '0');
                          state_counter_fpga_main_fpga_main_2 <= state_counter_fpga_main_fpga_main_2 + 1;
                        end if;
                      when others => this_game_call_state_counter_fpga_main_2 <= (others => '0');
                    end case;
                  when 2 =>
                    state_counter_fpga_main_fpga_main_1 <= state_counter_fpga_main_fpga_main_1 + 1;
                    state_counter_fpga_main_fpga_main_2 <= (others => '0');
                  when others => state_counter_fpga_main_fpga_main_2 <= (others => '0');
                end case;
              when 3 =>
                state_counter_fpga_main_fpga_main_1 <= (others => '0');
              when others => state_counter_fpga_main_fpga_main_1 <= (others => '0');
            end case;
          when 2 =>
            null;
          when others => fpga_main_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --fpga_main
  process(clk) --doFirstMove
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_doFirstMove_doFirstMove_0 <= (others => '0');
        c_doFirstMove_0 <= (others => '0');
        code_doFirstMove_0 <= (others => '0');
        pos_doFirstMove_0 <= (others => '0');
        io_getchar_call_state_counter_doFirstMove_0 <= (others => '0');
        io_getchar_call_state_counter_doFirstMove_0 <= (others => '0');
        state_counter_doFirstMove_doFirstMove_1 <= (others => '0');
        doFirstMove_if_flag_doFirstMove_2_doFirstMove_0 <= '0';
        state_counter_doFirstMove_doFirstMove_3 <= (others => '0');
        io_getchar_call_state_counter_doFirstMove_0 <= (others => '0');
        io_getchar_call_state_counter_doFirstMove_0 <= (others => '0');
        state_counter_doFirstMove_doFirstMove_4 <= (others => '0');
        doFirstMove_if_flag_doFirstMove_5_doFirstMove_0 <= '0';
        state_counter_doFirstMove_doFirstMove_6 <= (others => '0');
        player_setTurnCode_call_state_counter_doFirstMove_6 <= (others => '0');
        player_setTurnCode_call_state_counter_doFirstMove_6 <= (others => '0');
        state_counter_doFirstMove_doFirstMove_7 <= (others => '0');
        doFirstMove_if_flag_doFirstMove_8_doFirstMove_4 <= '0';
        state_counter_doFirstMove_doFirstMove_9 <= (others => '0');
        player_setTurnCode_call_state_counter_doFirstMove_9 <= (others => '0');
        player_setTurnCode_call_state_counter_doFirstMove_9 <= (others => '0');
        state_counter_doFirstMove_doFirstMove_10 <= (others => '0');
        player_getFirstMoveCode_call_state_counter_doFirstMove_0 <= (others => '0');
        player_getFirstMoveCode_call_state_counter_doFirstMove_0 <= (others => '0');
        this_doFirstMove_method_busy <= '0';
        doFirstMove_method_state <= (others => '0');
        io_getchar_method_request_field_wdata_reset <= '0';
        io_getchar_method_request_field_wdata_reset <= '0';
        player_setTurnCode_method_request_field_wdata_reset <= '0';
        turn_code_field_wdata_reset <= (others => '0');
        player_setTurnCode_method_request_field_wdata_reset <= '0';
        player_getFirstMoveCode_method_request_field_wdata_reset <= '0';
        this_output_port_doFirstMove <= (others => '0');
      else
        case conv_integer(doFirstMove_method_state) is
          when 0 =>
            if(this_doFirstMove_method_request_field_rdata = '1') then
              this_doFirstMove_method_busy <= '1';
              doFirstMove_method_state <= doFirstMove_method_state + 1;
            else
              this_doFirstMove_method_busy <= '0';
            end if;
          when 1 =>
            if(this_doFirstMove_method_request_field_rdata = '0') then
              doFirstMove_method_state <= doFirstMove_method_state + 1;
            end if;
          when 2 => 
            pos_doFirstMove_0 <= conv_std_logic_vector(0, pos_doFirstMove_0'length);
            doFirstMove_method_state <= doFirstMove_method_state + 1;
          when 3 => 
            case conv_integer(io_getchar_call_state_counter_doFirstMove_0) is
              when 0 =>
                if (io_getchar_method_busy_field_wdata = '0') then
                  io_getchar_method_request_field_wdata_writer_doFirstMove_method_state <= '1';
                  io_getchar_call_state_counter_doFirstMove_0 <= conv_std_logic_vector(1, io_getchar_call_state_counter_doFirstMove_0'length);
                end if;
              when 1 =>
                io_getchar_method_request_field_wdata_writer_doFirstMove_method_state <= '0';
                  io_getchar_call_state_counter_doFirstMove_0 <= conv_std_logic_vector(2, io_getchar_call_state_counter_doFirstMove_0'length);
              when 2 =>
                if (io_getchar_method_request_field_wdata = '0' and io_getchar_method_busy_field_wdata = '0') then
                  io_getchar_call_state_counter_doFirstMove_0 <= (others => '0');
                  doFirstMove_method_state <= doFirstMove_method_state + 1;
                end if;
              when others => io_getchar_call_state_counter_doFirstMove_0 <= (others => '0');
            end case;
          when 4 => 
            c_doFirstMove_0 <= conv_std_logic_vector(conv_integer(io_output_port_getchar_field_rdata), c_doFirstMove_0'length);
            doFirstMove_method_state <= doFirstMove_method_state + 1;
          when 5 => 
            case conv_integer(state_counter_doFirstMove_doFirstMove_1) is
              when 0 => state_counter_doFirstMove_doFirstMove_1 <= state_counter_doFirstMove_doFirstMove_1 + 1;
              when 1 =>
                if (conv_integer(c_doFirstMove_0) /= 50) then
                  doFirstMove_if_flag_doFirstMove_2_doFirstMove_0 <= '1';
                  state_counter_doFirstMove_doFirstMove_3 <= conv_std_logic_vector(1, state_counter_doFirstMove_doFirstMove_3'length);
                else
                  doFirstMove_if_flag_doFirstMove_2_doFirstMove_0 <= '0';
                end if;
                state_counter_doFirstMove_doFirstMove_1 <= state_counter_doFirstMove_doFirstMove_1 + 1;
              when 2 =>
                if (doFirstMove_if_flag_doFirstMove_2_doFirstMove_0 = '1') then
                  case conv_integer(state_counter_doFirstMove_doFirstMove_3) is
                    when 0 => state_counter_doFirstMove_doFirstMove_3 <= state_counter_doFirstMove_doFirstMove_3 + 1;
                    when 1 =>
                      state_counter_doFirstMove_doFirstMove_1 <= state_counter_doFirstMove_doFirstMove_1 + 1;
                      state_counter_doFirstMove_doFirstMove_3 <= (others => '0');
                    when others => state_counter_doFirstMove_doFirstMove_3 <= (others => '0');
                  end case;
                else
                  state_counter_doFirstMove_doFirstMove_1 <= state_counter_doFirstMove_doFirstMove_1 + 1;
                end if;
              when 3 =>
                state_counter_doFirstMove_doFirstMove_1 <= (others => '0');
                doFirstMove_method_state <= doFirstMove_method_state + 1;
              when others =>
                state_counter_doFirstMove_doFirstMove_1 <= (others => '0');
            end case;
          when 6 => 
            case conv_integer(io_getchar_call_state_counter_doFirstMove_0) is
              when 0 =>
                if (io_getchar_method_busy_field_wdata = '0') then
                  io_getchar_method_request_field_wdata_writer_doFirstMove_method_state <= '1';
                  io_getchar_call_state_counter_doFirstMove_0 <= conv_std_logic_vector(1, io_getchar_call_state_counter_doFirstMove_0'length);
                end if;
              when 1 =>
                io_getchar_method_request_field_wdata_writer_doFirstMove_method_state <= '0';
                  io_getchar_call_state_counter_doFirstMove_0 <= conv_std_logic_vector(2, io_getchar_call_state_counter_doFirstMove_0'length);
              when 2 =>
                if (io_getchar_method_request_field_wdata = '0' and io_getchar_method_busy_field_wdata = '0') then
                  io_getchar_call_state_counter_doFirstMove_0 <= (others => '0');
                  doFirstMove_method_state <= doFirstMove_method_state + 1;
                end if;
              when others => io_getchar_call_state_counter_doFirstMove_0 <= (others => '0');
            end case;
          when 7 => 
            c_doFirstMove_0 <= conv_std_logic_vector(conv_integer(io_output_port_getchar_field_rdata), c_doFirstMove_0'length);
            doFirstMove_method_state <= doFirstMove_method_state + 1;
          when 8 => 
            case conv_integer(state_counter_doFirstMove_doFirstMove_4) is
              when 0 => state_counter_doFirstMove_doFirstMove_4 <= state_counter_doFirstMove_doFirstMove_4 + 1;
              when 1 =>
                if (conv_integer(c_doFirstMove_0) = 53) then
                  doFirstMove_if_flag_doFirstMove_5_doFirstMove_0 <= '1';
                  state_counter_doFirstMove_doFirstMove_6 <= conv_std_logic_vector(1, state_counter_doFirstMove_doFirstMove_6'length);
                else
                  doFirstMove_if_flag_doFirstMove_5_doFirstMove_0 <= '0';
                end if;
                state_counter_doFirstMove_doFirstMove_4 <= state_counter_doFirstMove_doFirstMove_4 + 1;
              when 2 =>
                if (doFirstMove_if_flag_doFirstMove_5_doFirstMove_0 = '1') then
                  case conv_integer(state_counter_doFirstMove_doFirstMove_6) is
                    when 0 => state_counter_doFirstMove_doFirstMove_6 <= state_counter_doFirstMove_doFirstMove_6 + 1;
                    when 1 =>
                      case conv_integer(player_setTurnCode_call_state_counter_doFirstMove_6) is
                        when 0 =>
                          if (player_setTurnCode_method_busy_field_wdata = '0') then
                            player_setTurnCode_method_request_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6 <= '1';
                            player_setTurnCode_call_state_counter_doFirstMove_6 <= conv_std_logic_vector(1, player_setTurnCode_call_state_counter_doFirstMove_6'length);
                          end if;
                        when 1 =>
                          player_input_port_setTurnCode_v_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6 <= conv_std_logic_vector(1, player_input_port_setTurnCode_v_field_wdata'length);
                          player_setTurnCode_method_request_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6 <= '0';
                            player_setTurnCode_call_state_counter_doFirstMove_6 <= conv_std_logic_vector(2, player_setTurnCode_call_state_counter_doFirstMove_6'length);
                        when 2 =>
                          if (player_setTurnCode_method_request_field_wdata = '0' and player_setTurnCode_method_busy_field_wdata = '0') then
                            player_setTurnCode_call_state_counter_doFirstMove_6 <= (others => '0');
                            state_counter_doFirstMove_doFirstMove_6 <= state_counter_doFirstMove_doFirstMove_6 + 1;
                          end if;
                        when others => player_setTurnCode_call_state_counter_doFirstMove_6 <= (others => '0');
                      end case;
                    when 2 =>
                      turn_code_field_wdata_writer_state_counter_doFirstMove_doFirstMove_6 <= conv_std_logic_vector(1, turn_code_field_wdata'length);
                      pos_doFirstMove_0 <= conv_std_logic_vector(5, pos_doFirstMove_0'length);
                      state_counter_doFirstMove_doFirstMove_4 <= state_counter_doFirstMove_doFirstMove_4 + 1;
                      state_counter_doFirstMove_doFirstMove_6 <= (others => '0');
                    when others => state_counter_doFirstMove_doFirstMove_6 <= (others => '0');
                  end case;
                else
                  case conv_integer(state_counter_doFirstMove_doFirstMove_7) is
                    when 0 => state_counter_doFirstMove_doFirstMove_7 <= state_counter_doFirstMove_doFirstMove_7 + 1;
                    when 1 =>
                      if (conv_integer(c_doFirstMove_0) = 65) then
                        doFirstMove_if_flag_doFirstMove_8_doFirstMove_4 <= '1';
                        state_counter_doFirstMove_doFirstMove_9 <= conv_std_logic_vector(1, state_counter_doFirstMove_doFirstMove_9'length);
                      else
                        doFirstMove_if_flag_doFirstMove_8_doFirstMove_4 <= '0';
                        state_counter_doFirstMove_doFirstMove_10 <= conv_std_logic_vector(1, state_counter_doFirstMove_doFirstMove_10'length);
                      end if;
                      state_counter_doFirstMove_doFirstMove_7 <= state_counter_doFirstMove_doFirstMove_7 + 1;
                    when 2 =>
                      if (doFirstMove_if_flag_doFirstMove_8_doFirstMove_4 = '1') then
                        case conv_integer(state_counter_doFirstMove_doFirstMove_9) is
                          when 0 => state_counter_doFirstMove_doFirstMove_9 <= state_counter_doFirstMove_doFirstMove_9 + 1;
                          when 1 =>
                            case conv_integer(player_setTurnCode_call_state_counter_doFirstMove_9) is
                              when 0 =>
                                if (player_setTurnCode_method_busy_field_wdata = '0') then
                                  player_setTurnCode_method_request_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9 <= '1';
                                  player_setTurnCode_call_state_counter_doFirstMove_9 <= conv_std_logic_vector(1, player_setTurnCode_call_state_counter_doFirstMove_9'length);
                                end if;
                              when 1 =>
                                player_input_port_setTurnCode_v_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9 <= conv_std_logic_vector(2, player_input_port_setTurnCode_v_field_wdata'length);
                                player_setTurnCode_method_request_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9 <= '0';
                                  player_setTurnCode_call_state_counter_doFirstMove_9 <= conv_std_logic_vector(2, player_setTurnCode_call_state_counter_doFirstMove_9'length);
                              when 2 =>
                                if (player_setTurnCode_method_request_field_wdata = '0' and player_setTurnCode_method_busy_field_wdata = '0') then
                                  player_setTurnCode_call_state_counter_doFirstMove_9 <= (others => '0');
                                  state_counter_doFirstMove_doFirstMove_9 <= state_counter_doFirstMove_doFirstMove_9 + 1;
                                end if;
                              when others => player_setTurnCode_call_state_counter_doFirstMove_9 <= (others => '0');
                            end case;
                          when 2 =>
                            turn_code_field_wdata_writer_state_counter_doFirstMove_doFirstMove_9 <= conv_std_logic_vector(2, turn_code_field_wdata'length);
                            pos_doFirstMove_0 <= conv_std_logic_vector(10, pos_doFirstMove_0'length);
                            state_counter_doFirstMove_doFirstMove_7 <= state_counter_doFirstMove_doFirstMove_7 + 1;
                            state_counter_doFirstMove_doFirstMove_9 <= (others => '0');
                          when others => state_counter_doFirstMove_doFirstMove_9 <= (others => '0');
                        end case;
                      else
                        case conv_integer(state_counter_doFirstMove_doFirstMove_10) is
                          when 0 => state_counter_doFirstMove_doFirstMove_10 <= state_counter_doFirstMove_doFirstMove_10 + 1;
                          when 1 =>
                            state_counter_doFirstMove_doFirstMove_7 <= state_counter_doFirstMove_doFirstMove_7 + 1;
                            state_counter_doFirstMove_doFirstMove_10 <= (others => '0');
                          when others => state_counter_doFirstMove_doFirstMove_10 <= (others => '0');
                        end case;
                      end if;
                    when 3 =>
                      state_counter_doFirstMove_doFirstMove_7 <= (others => '0');
                      state_counter_doFirstMove_doFirstMove_4 <= state_counter_doFirstMove_doFirstMove_4 + 1;
                    when others =>
                      state_counter_doFirstMove_doFirstMove_7 <= (others => '0');
                  end case;
                end if;
              when 3 =>
                state_counter_doFirstMove_doFirstMove_4 <= (others => '0');
                doFirstMove_method_state <= doFirstMove_method_state + 1;
              when others =>
                state_counter_doFirstMove_doFirstMove_4 <= (others => '0');
            end case;
          when 9 => 
            case conv_integer(player_getFirstMoveCode_call_state_counter_doFirstMove_0) is
              when 0 =>
                if (player_getFirstMoveCode_method_busy_field_wdata = '0') then
                  player_getFirstMoveCode_method_request_field_wdata_writer_doFirstMove_method_state <= '1';
                  player_getFirstMoveCode_call_state_counter_doFirstMove_0 <= conv_std_logic_vector(1, player_getFirstMoveCode_call_state_counter_doFirstMove_0'length);
                end if;
              when 1 =>
                player_input_port_getFirstMoveCode_x_field_wdata_writer_doFirstMove_method_state <= conv_std_logic_vector(conv_integer(pos_doFirstMove_0) - 1, player_input_port_getFirstMoveCode_x_field_wdata'length);
                player_input_port_getFirstMoveCode_y_field_wdata_writer_doFirstMove_method_state <= conv_std_logic_vector(conv_integer(pos_doFirstMove_0) - 1, player_input_port_getFirstMoveCode_y_field_wdata'length);
                player_getFirstMoveCode_method_request_field_wdata_writer_doFirstMove_method_state <= '0';
                  player_getFirstMoveCode_call_state_counter_doFirstMove_0 <= conv_std_logic_vector(2, player_getFirstMoveCode_call_state_counter_doFirstMove_0'length);
              when 2 =>
                if (player_getFirstMoveCode_method_request_field_wdata = '0' and player_getFirstMoveCode_method_busy_field_wdata = '0') then
                  player_getFirstMoveCode_call_state_counter_doFirstMove_0 <= (others => '0');
                  doFirstMove_method_state <= doFirstMove_method_state + 1;
                end if;
              when others => player_getFirstMoveCode_call_state_counter_doFirstMove_0 <= (others => '0');
            end case;
          when 10 => 
            code_doFirstMove_0 <= conv_std_logic_vector(conv_integer(player_output_port_getFirstMoveCode_field_rdata), code_doFirstMove_0'length);
            doFirstMove_method_state <= doFirstMove_method_state + 1;
          when 11 => 
            this_output_port_doFirstMove <= conv_std_logic_vector(conv_integer(code_doFirstMove_0), this_output_port_doFirstMove'length);
            doFirstMove_method_state <= (others => '0');
          when 12 =>
            this_doFirstMove_method_busy <= '0';
            doFirstMove_method_state <= (others => '0');
          when others => doFirstMove_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --doFirstMove
  process(clk) --toStr
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_toStr_toStr_0 <= (others => '0');
        state_counter_toStr_toStr_1 <= (others => '0');
        toStr_if_flag_toStr_2_toStr_0 <= '0';
        state_counter_toStr_toStr_3 <= (others => '0');
        state_counter_toStr_toStr_4 <= (others => '0');
        this_toStr_method_busy <= '0';
        toStr_method_state <= (others => '0');
        this_output_port_toStr <= (others => '0');
      else
        case conv_integer(toStr_method_state) is
          when 0 =>
            if(this_toStr_method_request_field_rdata = '1') then
              this_toStr_method_busy <= '1';
              toStr_method_state <= toStr_method_state + 1;
            else
              this_toStr_method_busy <= '0';
            end if;
          when 1 =>
            if(this_toStr_method_request_field_rdata = '0') then
              toStr_method_state <= toStr_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(state_counter_toStr_toStr_1) is
              when 0 => state_counter_toStr_toStr_1 <= state_counter_toStr_toStr_1 + 1;
              when 1 =>
                if (conv_integer(this_input_port_toStr_v_field_rdata) < 10) then
                  toStr_if_flag_toStr_2_toStr_0 <= '1';
                  state_counter_toStr_toStr_3 <= conv_std_logic_vector(1, state_counter_toStr_toStr_3'length);
                else
                  toStr_if_flag_toStr_2_toStr_0 <= '0';
                  state_counter_toStr_toStr_4 <= conv_std_logic_vector(1, state_counter_toStr_toStr_4'length);
                end if;
                state_counter_toStr_toStr_1 <= state_counter_toStr_toStr_1 + 1;
              when 2 =>
                if (toStr_if_flag_toStr_2_toStr_0 = '1') then
                  case conv_integer(state_counter_toStr_toStr_3) is
                    when 0 => state_counter_toStr_toStr_3 <= state_counter_toStr_toStr_3 + 1;
                    when 1 =>
                      this_output_port_toStr <= conv_std_logic_vector((conv_integer(this_input_port_toStr_v_field_rdata) + 48), this_output_port_toStr'length);
                      state_counter_toStr_toStr_3 <= (others => '0');
                      state_counter_toStr_toStr_1 <= (others => '0');
                      toStr_method_state <= (others => '0');
                    when 2 =>
                      state_counter_toStr_toStr_1 <= state_counter_toStr_toStr_1 + 1;
                      state_counter_toStr_toStr_3 <= (others => '0');
                    when others => state_counter_toStr_toStr_3 <= (others => '0');
                  end case;
                else
                  case conv_integer(state_counter_toStr_toStr_4) is
                    when 0 => state_counter_toStr_toStr_4 <= state_counter_toStr_toStr_4 + 1;
                    when 1 =>
                      this_output_port_toStr <= conv_std_logic_vector(((conv_integer(this_input_port_toStr_v_field_rdata) - 10) + 97), this_output_port_toStr'length);
                      state_counter_toStr_toStr_4 <= (others => '0');
                      state_counter_toStr_toStr_1 <= (others => '0');
                      toStr_method_state <= (others => '0');
                    when 2 =>
                      state_counter_toStr_toStr_1 <= state_counter_toStr_toStr_1 + 1;
                      state_counter_toStr_toStr_4 <= (others => '0');
                    when others => state_counter_toStr_toStr_4 <= (others => '0');
                  end case;
                end if;
              when 3 =>
                state_counter_toStr_toStr_1 <= (others => '0');
                toStr_method_state <= toStr_method_state + 1;
              when others =>
                state_counter_toStr_toStr_1 <= (others => '0');
            end case;
          when 3 =>
            this_toStr_method_busy <= '0';
            toStr_method_state <= (others => '0');
          when others => toStr_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --toStr
  process(clk) --game
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_game_game_0 <= (others => '0');
        code_game_0 <= (others => '0');
        flag_game_0 <= '0';
        this_init_call_state_counter_game_0 <= (others => '0');
        this_init_call_state_counter_game_0 <= (others => '0');
        this_doInitialization_call_state_counter_game_0 <= (others => '0');
        this_doInitialization_call_state_counter_game_0 <= (others => '0');
        this_doFirstMove_call_state_counter_game_0 <= (others => '0');
        this_doFirstMove_call_state_counter_game_0 <= (others => '0');
        this_sendResponse_call_state_counter_game_0 <= (others => '0');
        this_sendResponse_call_state_counter_game_0 <= (others => '0');
        state_counter_game_game_1 <= (others => '0');
        game_if_flag_game_2_game_0 <= '0';
        state_counter_game_game_3 <= (others => '0');
        this_waitResponseCode_call_state_counter_game_3 <= (others => '0');
        this_waitResponseCode_call_state_counter_game_3 <= (others => '0');
        this_parseAndApply_call_state_counter_game_3 <= (others => '0');
        this_parseAndApply_call_state_counter_game_3 <= (others => '0');
        this_parseAndApply_call_state_counter_game_3 <= (others => '0');
        this_parseAndApply_call_state_counter_game_3 <= (others => '0');
        state_counter_game_game_4 <= (others => '0');
        this_waitResponseCode_call_state_counter_game_4 <= (others => '0');
        this_waitResponseCode_call_state_counter_game_4 <= (others => '0');
        this_parseAndApply_call_state_counter_game_4 <= (others => '0');
        this_parseAndApply_call_state_counter_game_4 <= (others => '0');
        state_counter_game_game_5 <= (others => '0');
        state_counter_game_game_6 <= (others => '0');
        player_getNextMove_call_state_counter_game_6 <= (others => '0');
        player_getNextMove_call_state_counter_game_6 <= (others => '0');
        this_sendResponse_call_state_counter_game_6 <= (others => '0');
        this_sendResponse_call_state_counter_game_6 <= (others => '0');
        this_waitResponseCode_call_state_counter_game_6 <= (others => '0');
        this_waitResponseCode_call_state_counter_game_6 <= (others => '0');
        this_parseAndApply_call_state_counter_game_6 <= (others => '0');
        this_parseAndApply_call_state_counter_game_6 <= (others => '0');
        this_game_method_busy <= '0';
        game_method_state <= (others => '0');
        this_init_method_request_field_wdata_reset <= '0';
        this_doInitialization_method_request_field_wdata_reset <= '0';
        this_doFirstMove_method_request_field_wdata_reset <= '0';
        this_sendResponse_method_request_field_wdata_reset <= '0';
        this_waitResponseCode_method_request_field_wdata_reset <= '0';
        this_parseAndApply_method_request_field_wdata_reset <= '0';
        this_parseAndApply_method_request_field_wdata_reset <= '0';
        this_waitResponseCode_method_request_field_wdata_reset <= '0';
        this_parseAndApply_method_request_field_wdata_reset <= '0';
        player_getNextMove_method_request_field_wdata_reset <= '0';
        this_sendResponse_method_request_field_wdata_reset <= '0';
        this_waitResponseCode_method_request_field_wdata_reset <= '0';
        this_parseAndApply_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(game_method_state) is
          when 0 =>
            if(this_game_method_request_field_rdata = '1') then
              this_game_method_busy <= '1';
              game_method_state <= game_method_state + 1;
            else
              this_game_method_busy <= '0';
            end if;
          when 1 =>
            if(this_game_method_request_field_rdata = '0') then
              game_method_state <= game_method_state + 1;
            end if;
          when 2 => 
            flag_game_0 <= '1';
            game_method_state <= game_method_state + 1;
          when 3 => 
            case conv_integer(this_init_call_state_counter_game_0) is
              when 0 =>
                if (this_init_method_busy = '0') then
                  this_init_method_request_field_wdata_writer_game_method_state <= '1';
                  this_init_call_state_counter_game_0 <= conv_std_logic_vector(1, this_init_call_state_counter_game_0'length);
                end if;
              when 1 =>
                this_init_method_request_field_wdata_writer_game_method_state <= '0';
                  this_init_call_state_counter_game_0 <= conv_std_logic_vector(2, this_init_call_state_counter_game_0'length);
              when 2 =>
                if (this_init_method_request_field_wdata = '0' and this_init_method_busy = '0') then
                  this_init_call_state_counter_game_0 <= (others => '0');
                  game_method_state <= game_method_state + 1;
                end if;
              when others => this_init_call_state_counter_game_0 <= (others => '0');
            end case;
          when 4 => 
            case conv_integer(this_doInitialization_call_state_counter_game_0) is
              when 0 =>
                if (this_doInitialization_method_busy = '0') then
                  this_doInitialization_method_request_field_wdata_writer_game_method_state <= '1';
                  this_doInitialization_call_state_counter_game_0 <= conv_std_logic_vector(1, this_doInitialization_call_state_counter_game_0'length);
                end if;
              when 1 =>
                this_doInitialization_method_request_field_wdata_writer_game_method_state <= '0';
                  this_doInitialization_call_state_counter_game_0 <= conv_std_logic_vector(2, this_doInitialization_call_state_counter_game_0'length);
              when 2 =>
                if (this_doInitialization_method_request_field_wdata = '0' and this_doInitialization_method_busy = '0') then
                  this_doInitialization_call_state_counter_game_0 <= (others => '0');
                  game_method_state <= game_method_state + 1;
                end if;
              when others => this_doInitialization_call_state_counter_game_0 <= (others => '0');
            end case;
          when 5 => 
            case conv_integer(this_doFirstMove_call_state_counter_game_0) is
              when 0 =>
                if (this_doFirstMove_method_busy = '0') then
                  this_doFirstMove_method_request_field_wdata_writer_game_method_state <= '1';
                  this_doFirstMove_call_state_counter_game_0 <= conv_std_logic_vector(1, this_doFirstMove_call_state_counter_game_0'length);
                end if;
              when 1 =>
                this_doFirstMove_method_request_field_wdata_writer_game_method_state <= '0';
                  this_doFirstMove_call_state_counter_game_0 <= conv_std_logic_vector(2, this_doFirstMove_call_state_counter_game_0'length);
              when 2 =>
                if (this_doFirstMove_method_request_field_wdata = '0' and this_doFirstMove_method_busy = '0') then
                  this_doFirstMove_call_state_counter_game_0 <= (others => '0');
                  game_method_state <= game_method_state + 1;
                end if;
              when others => this_doFirstMove_call_state_counter_game_0 <= (others => '0');
            end case;
          when 6 => 
            code_game_0 <= conv_std_logic_vector(conv_integer(this_output_port_doFirstMove), code_game_0'length);
            game_method_state <= game_method_state + 1;
          when 7 => 
            case conv_integer(this_sendResponse_call_state_counter_game_0) is
              when 0 =>
                if (this_sendResponse_method_busy = '0') then
                  this_sendResponse_method_request_field_wdata_writer_game_method_state <= '1';
                  this_sendResponse_call_state_counter_game_0 <= conv_std_logic_vector(1, this_sendResponse_call_state_counter_game_0'length);
                end if;
              when 1 =>
                this_input_port_sendResponse_code_field_wdata_writer_game_method_state <= conv_std_logic_vector(conv_integer(code_game_0), this_input_port_sendResponse_code_field_wdata'length);
                this_sendResponse_method_request_field_wdata_writer_game_method_state <= '0';
                  this_sendResponse_call_state_counter_game_0 <= conv_std_logic_vector(2, this_sendResponse_call_state_counter_game_0'length);
              when 2 =>
                if (this_sendResponse_method_request_field_wdata = '0' and this_sendResponse_method_busy = '0') then
                  this_sendResponse_call_state_counter_game_0 <= (others => '0');
                  game_method_state <= game_method_state + 1;
                end if;
              when others => this_sendResponse_call_state_counter_game_0 <= (others => '0');
            end case;
          when 8 => 
            case conv_integer(state_counter_game_game_1) is
              when 0 => state_counter_game_game_1 <= state_counter_game_game_1 + 1;
              when 1 =>
                if (conv_integer(turn_code_field_rdata) = 2) then
                  game_if_flag_game_2_game_0 <= '1';
                  state_counter_game_game_3 <= conv_std_logic_vector(1, state_counter_game_game_3'length);
                else
                  game_if_flag_game_2_game_0 <= '0';
                  state_counter_game_game_4 <= conv_std_logic_vector(1, state_counter_game_game_4'length);
                end if;
                state_counter_game_game_1 <= state_counter_game_game_1 + 1;
              when 2 =>
                if (game_if_flag_game_2_game_0 = '1') then
                  case conv_integer(state_counter_game_game_3) is
                    when 0 => state_counter_game_game_3 <= state_counter_game_game_3 + 1;
                    when 1 =>
                      case conv_integer(this_waitResponseCode_call_state_counter_game_3) is
                        when 0 =>
                          if (this_waitResponseCode_method_busy = '0') then
                            this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_3 <= '1';
                            this_waitResponseCode_call_state_counter_game_3 <= conv_std_logic_vector(1, this_waitResponseCode_call_state_counter_game_3'length);
                          end if;
                        when 1 =>
                          this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_3 <= conv_std_logic_vector(52, this_input_port_waitResponseCode_expected_field_wdata'length);
                          this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_3 <= conv_std_logic_vector(8, this_input_port_waitResponseCode_args_field_wdata'length);
                          this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_3 <= '0';
                            this_waitResponseCode_call_state_counter_game_3 <= conv_std_logic_vector(2, this_waitResponseCode_call_state_counter_game_3'length);
                        when 2 =>
                          if (this_waitResponseCode_method_request_field_wdata = '0' and this_waitResponseCode_method_busy = '0') then
                            this_waitResponseCode_call_state_counter_game_3 <= (others => '0');
                            state_counter_game_game_3 <= state_counter_game_game_3 + 1;
                          end if;
                        when others => this_waitResponseCode_call_state_counter_game_3 <= (others => '0');
                      end case;
                    when 2 =>
                      flag_game_0 <= this_output_port_waitResponseCode;
                      state_counter_game_game_3 <= state_counter_game_game_3 + 1;
                    when 3 =>
                      case conv_integer(this_parseAndApply_call_state_counter_game_3) is
                        when 0 =>
                          if (this_parseAndApply_method_busy = '0') then
                            this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_3 <= '1';
                            this_parseAndApply_call_state_counter_game_3 <= conv_std_logic_vector(1, this_parseAndApply_call_state_counter_game_3'length);
                          end if;
                        when 1 =>
                          this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_3 <= conv_std_logic_vector(0, this_input_port_parseAndApply_offset_field_wdata'length);
                          this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_3 <= '0';
                            this_parseAndApply_call_state_counter_game_3 <= conv_std_logic_vector(2, this_parseAndApply_call_state_counter_game_3'length);
                        when 2 =>
                          if (this_parseAndApply_method_request_field_wdata = '0' and this_parseAndApply_method_busy = '0') then
                            this_parseAndApply_call_state_counter_game_3 <= (others => '0');
                            state_counter_game_game_3 <= state_counter_game_game_3 + 1;
                          end if;
                        when others => this_parseAndApply_call_state_counter_game_3 <= (others => '0');
                      end case;
                    when 4 =>
                      case conv_integer(this_parseAndApply_call_state_counter_game_3) is
                        when 0 =>
                          if (this_parseAndApply_method_busy = '0') then
                            this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_3 <= '1';
                            this_parseAndApply_call_state_counter_game_3 <= conv_std_logic_vector(1, this_parseAndApply_call_state_counter_game_3'length);
                          end if;
                        when 1 =>
                          this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_3 <= conv_std_logic_vector(4, this_input_port_parseAndApply_offset_field_wdata'length);
                          this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_3 <= '0';
                            this_parseAndApply_call_state_counter_game_3 <= conv_std_logic_vector(2, this_parseAndApply_call_state_counter_game_3'length);
                        when 2 =>
                          if (this_parseAndApply_method_request_field_wdata = '0' and this_parseAndApply_method_busy = '0') then
                            this_parseAndApply_call_state_counter_game_3 <= (others => '0');
                            state_counter_game_game_3 <= state_counter_game_game_3 + 1;
                          end if;
                        when others => this_parseAndApply_call_state_counter_game_3 <= (others => '0');
                      end case;
                    when 5 =>
                      state_counter_game_game_1 <= state_counter_game_game_1 + 1;
                      state_counter_game_game_3 <= (others => '0');
                    when others => state_counter_game_game_3 <= (others => '0');
                  end case;
                else
                  case conv_integer(state_counter_game_game_4) is
                    when 0 => state_counter_game_game_4 <= state_counter_game_game_4 + 1;
                    when 1 =>
                      case conv_integer(this_waitResponseCode_call_state_counter_game_4) is
                        when 0 =>
                          if (this_waitResponseCode_method_busy = '0') then
                            this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_4 <= '1';
                            this_waitResponseCode_call_state_counter_game_4 <= conv_std_logic_vector(1, this_waitResponseCode_call_state_counter_game_4'length);
                          end if;
                        when 1 =>
                          this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_4 <= conv_std_logic_vector(51, this_input_port_waitResponseCode_expected_field_wdata'length);
                          this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_4 <= conv_std_logic_vector(4, this_input_port_waitResponseCode_args_field_wdata'length);
                          this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_4 <= '0';
                            this_waitResponseCode_call_state_counter_game_4 <= conv_std_logic_vector(2, this_waitResponseCode_call_state_counter_game_4'length);
                        when 2 =>
                          if (this_waitResponseCode_method_request_field_wdata = '0' and this_waitResponseCode_method_busy = '0') then
                            this_waitResponseCode_call_state_counter_game_4 <= (others => '0');
                            state_counter_game_game_4 <= state_counter_game_game_4 + 1;
                          end if;
                        when others => this_waitResponseCode_call_state_counter_game_4 <= (others => '0');
                      end case;
                    when 2 =>
                      flag_game_0 <= this_output_port_waitResponseCode;
                      state_counter_game_game_4 <= state_counter_game_game_4 + 1;
                    when 3 =>
                      case conv_integer(this_parseAndApply_call_state_counter_game_4) is
                        when 0 =>
                          if (this_parseAndApply_method_busy = '0') then
                            this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_4 <= '1';
                            this_parseAndApply_call_state_counter_game_4 <= conv_std_logic_vector(1, this_parseAndApply_call_state_counter_game_4'length);
                          end if;
                        when 1 =>
                          this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_4 <= conv_std_logic_vector(0, this_input_port_parseAndApply_offset_field_wdata'length);
                          this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_4 <= '0';
                            this_parseAndApply_call_state_counter_game_4 <= conv_std_logic_vector(2, this_parseAndApply_call_state_counter_game_4'length);
                        when 2 =>
                          if (this_parseAndApply_method_request_field_wdata = '0' and this_parseAndApply_method_busy = '0') then
                            this_parseAndApply_call_state_counter_game_4 <= (others => '0');
                            state_counter_game_game_4 <= state_counter_game_game_4 + 1;
                          end if;
                        when others => this_parseAndApply_call_state_counter_game_4 <= (others => '0');
                      end case;
                    when 4 =>
                      state_counter_game_game_1 <= state_counter_game_game_1 + 1;
                      state_counter_game_game_4 <= (others => '0');
                    when others => state_counter_game_game_4 <= (others => '0');
                  end case;
                end if;
              when 3 =>
                state_counter_game_game_1 <= (others => '0');
                game_method_state <= game_method_state + 1;
              when others =>
                state_counter_game_game_1 <= (others => '0');
            end case;
          when 9 => 
            case conv_integer(state_counter_game_game_5) is
              when 0 => state_counter_game_game_5 <= state_counter_game_game_5 + 1;
              when 1 =>
                if (flag_game_0 = '1') then
                  state_counter_game_game_5 <= state_counter_game_game_5 + 1;
                  state_counter_game_game_6 <= conv_std_logic_vector(1, state_counter_game_game_6'length);
                else
                  game_method_state <= game_method_state + 1;
                  state_counter_game_game_5 <= (others => '0');
                end if;
              when 2 =>
                case conv_integer(state_counter_game_game_6) is
                  when 0 => state_counter_game_game_6 <= state_counter_game_game_6 + 1;
                  when 1 =>
                    case conv_integer(player_getNextMove_call_state_counter_game_6) is
                      when 0 =>
                        if (player_getNextMove_method_busy_field_wdata = '0') then
                          player_getNextMove_method_request_field_wdata_writer_state_counter_game_game_6 <= '1';
                          player_getNextMove_call_state_counter_game_6 <= conv_std_logic_vector(1, player_getNextMove_call_state_counter_game_6'length);
                        end if;
                      when 1 =>
                        player_getNextMove_method_request_field_wdata_writer_state_counter_game_game_6 <= '0';
                          player_getNextMove_call_state_counter_game_6 <= conv_std_logic_vector(2, player_getNextMove_call_state_counter_game_6'length);
                      when 2 =>
                        if (player_getNextMove_method_request_field_wdata = '0' and player_getNextMove_method_busy_field_wdata = '0') then
                          player_getNextMove_call_state_counter_game_6 <= (others => '0');
                          state_counter_game_game_6 <= state_counter_game_game_6 + 1;
                        end if;
                      when others => player_getNextMove_call_state_counter_game_6 <= (others => '0');
                    end case;
                  when 2 =>
                    code_game_0 <= conv_std_logic_vector(conv_integer(player_output_port_getNextMove_field_rdata), code_game_0'length);
                    state_counter_game_game_6 <= state_counter_game_game_6 + 1;
                  when 3 =>
                    case conv_integer(this_sendResponse_call_state_counter_game_6) is
                      when 0 =>
                        if (this_sendResponse_method_busy = '0') then
                          this_sendResponse_method_request_field_wdata_writer_state_counter_game_game_6 <= '1';
                          this_sendResponse_call_state_counter_game_6 <= conv_std_logic_vector(1, this_sendResponse_call_state_counter_game_6'length);
                        end if;
                      when 1 =>
                        this_input_port_sendResponse_code_field_wdata_writer_state_counter_game_game_6 <= conv_std_logic_vector(conv_integer(code_game_0), this_input_port_sendResponse_code_field_wdata'length);
                        this_sendResponse_method_request_field_wdata_writer_state_counter_game_game_6 <= '0';
                          this_sendResponse_call_state_counter_game_6 <= conv_std_logic_vector(2, this_sendResponse_call_state_counter_game_6'length);
                      when 2 =>
                        if (this_sendResponse_method_request_field_wdata = '0' and this_sendResponse_method_busy = '0') then
                          this_sendResponse_call_state_counter_game_6 <= (others => '0');
                          state_counter_game_game_6 <= state_counter_game_game_6 + 1;
                        end if;
                      when others => this_sendResponse_call_state_counter_game_6 <= (others => '0');
                    end case;
                  when 4 =>
                    case conv_integer(this_waitResponseCode_call_state_counter_game_6) is
                      when 0 =>
                        if (this_waitResponseCode_method_busy = '0') then
                          this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_6 <= '1';
                          this_waitResponseCode_call_state_counter_game_6 <= conv_std_logic_vector(1, this_waitResponseCode_call_state_counter_game_6'length);
                        end if;
                      when 1 =>
                        this_input_port_waitResponseCode_expected_field_wdata_writer_state_counter_game_game_6 <= conv_std_logic_vector(51, this_input_port_waitResponseCode_expected_field_wdata'length);
                        this_input_port_waitResponseCode_args_field_wdata_writer_state_counter_game_game_6 <= conv_std_logic_vector(4, this_input_port_waitResponseCode_args_field_wdata'length);
                        this_waitResponseCode_method_request_field_wdata_writer_state_counter_game_game_6 <= '0';
                          this_waitResponseCode_call_state_counter_game_6 <= conv_std_logic_vector(2, this_waitResponseCode_call_state_counter_game_6'length);
                      when 2 =>
                        if (this_waitResponseCode_method_request_field_wdata = '0' and this_waitResponseCode_method_busy = '0') then
                          this_waitResponseCode_call_state_counter_game_6 <= (others => '0');
                          state_counter_game_game_6 <= state_counter_game_game_6 + 1;
                        end if;
                      when others => this_waitResponseCode_call_state_counter_game_6 <= (others => '0');
                    end case;
                  when 5 =>
                    flag_game_0 <= this_output_port_waitResponseCode;
                    state_counter_game_game_6 <= state_counter_game_game_6 + 1;
                  when 6 =>
                    case conv_integer(this_parseAndApply_call_state_counter_game_6) is
                      when 0 =>
                        if (this_parseAndApply_method_busy = '0') then
                          this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_6 <= '1';
                          this_parseAndApply_call_state_counter_game_6 <= conv_std_logic_vector(1, this_parseAndApply_call_state_counter_game_6'length);
                        end if;
                      when 1 =>
                        this_input_port_parseAndApply_offset_field_wdata_writer_state_counter_game_game_6 <= conv_std_logic_vector(0, this_input_port_parseAndApply_offset_field_wdata'length);
                        this_parseAndApply_method_request_field_wdata_writer_state_counter_game_game_6 <= '0';
                          this_parseAndApply_call_state_counter_game_6 <= conv_std_logic_vector(2, this_parseAndApply_call_state_counter_game_6'length);
                      when 2 =>
                        if (this_parseAndApply_method_request_field_wdata = '0' and this_parseAndApply_method_busy = '0') then
                          this_parseAndApply_call_state_counter_game_6 <= (others => '0');
                          state_counter_game_game_6 <= state_counter_game_game_6 + 1;
                        end if;
                      when others => this_parseAndApply_call_state_counter_game_6 <= (others => '0');
                    end case;
                  when 7 =>
                    state_counter_game_game_5 <= state_counter_game_game_5 + 1;
                    state_counter_game_game_6 <= (others => '0');
                  when others => state_counter_game_game_6 <= (others => '0');
                end case;
              when 3 =>
                state_counter_game_game_5 <= (others => '0');
              when others => state_counter_game_game_5 <= (others => '0');
            end case;
          when 10 => 
            game_method_state <= (others => '0');
          when 11 =>
            this_game_method_busy <= '0';
            game_method_state <= (others => '0');
          when others => game_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --game
  process(clk) --notify
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        notify_flag <= '0';
        this_notify_method_busy <= '0';
        notify_method_state <= (others => '0');
        state_counter_notify_notify_0 <= (others => '0');
      else
        case conv_integer(notify_method_state) is
          when 0 =>
            if(this_notify_method_request = '1') then
              this_notify_method_busy <= '1';
              notify_method_state <= notify_method_state + 1;
            else
              this_notify_method_busy <= '0';
            end if;
          when 1 =>
            if(this_notify_method_request = '0') then
              notify_method_state <= notify_method_state + 1;
            end if;
          when 2 => 
            notify_flag <= '1';
            notify_method_state <= notify_method_state + 1;
          when 3 => 
            notify_flag <= '0';
            notify_method_state <= notify_method_state + 1;
          when 4 =>
            this_notify_method_busy <= '0';
            notify_method_state <= (others => '0');
          when others => notify_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --notify
  process(clk) --parseAndApply
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_parseAndApply_parseAndApply_0 <= (others => '0');
        x_parseAndApply_0 <= (others => '0');
        y_parseAndApply_0 <= (others => '0');
        id_parseAndApply_0 <= (others => '0');
        rot_parseAndApply_0 <= (others => '0');
        array_index_operation_state_counter_parseAndApply_1 <= (others => '0');
        this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
        this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
        array_index_operation_state_counter_parseAndApply_2 <= (others => '0');
        this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
        this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
        array_index_operation_state_counter_parseAndApply_3 <= (others => '0');
        array_index_operation_state_counter_parseAndApply_4 <= (others => '0');
        this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
        this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
        state_counter_parseAndApply_parseAndApply_5 <= (others => '0');
        parseAndApply_if_flag_parseAndApply_6_parseAndApply_0 <= '0';
        state_counter_parseAndApply_parseAndApply_7 <= (others => '0');
        player_setOpponentMove_call_state_counter_parseAndApply_7 <= (others => '0');
        player_setOpponentMove_call_state_counter_parseAndApply_7 <= (others => '0');
        this_parseAndApply_method_busy <= '0';
        parseAndApply_method_state <= (others => '0');
        this_toInt_method_request_field_wdata_reset <= '0';
        this_toInt_method_request_field_wdata_reset <= '0';
        this_toInt_method_request_field_wdata_reset <= '0';
        player_setOpponentMove_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(parseAndApply_method_state) is
          when 0 =>
            if(this_parseAndApply_method_request_field_rdata = '1') then
              this_parseAndApply_method_busy <= '1';
              parseAndApply_method_state <= parseAndApply_method_state + 1;
            else
              this_parseAndApply_method_busy <= '0';
            end if;
          when 1 =>
            if(this_parseAndApply_method_request_field_rdata = '0') then
              parseAndApply_method_state <= parseAndApply_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(array_index_operation_state_counter_parseAndApply_1) is
              when 0 =>
                buffer_raddr_field_wdata_writer_parseAndApply_method_state <= conv_std_logic_vector(conv_integer(this_input_port_parseAndApply_offset_field_rdata) + 0, buffer_raddr_field_wdata'length);
                array_index_operation_state_counter_parseAndApply_1 <= array_index_operation_state_counter_parseAndApply_1 + 1;
              when 1 =>
                array_index_operation_state_counter_parseAndApply_1 <= (others => '0');
                parseAndApply_method_state <= parseAndApply_method_state + 1;
              when others => array_index_operation_state_counter_parseAndApply_1 <= (others => '0');
            end case;
          when 3 => 
            case conv_integer(this_toInt_call_state_counter_parseAndApply_0) is
              when 0 =>
                if (this_toInt_method_busy = '0') then
                  this_toInt_method_request_field_wdata_writer_parseAndApply_method_state <= '1';
                  this_toInt_call_state_counter_parseAndApply_0 <= conv_std_logic_vector(1, this_toInt_call_state_counter_parseAndApply_0'length);
                end if;
              when 1 =>
                this_input_port_toInt_x_field_wdata_writer_parseAndApply_method_state <= conv_std_logic_vector(conv_integer(buffer_rdata_field_rdata), this_input_port_toInt_x_field_wdata'length);
                this_toInt_method_request_field_wdata_writer_parseAndApply_method_state <= '0';
                  this_toInt_call_state_counter_parseAndApply_0 <= conv_std_logic_vector(2, this_toInt_call_state_counter_parseAndApply_0'length);
              when 2 =>
                if (this_toInt_method_request_field_wdata = '0' and this_toInt_method_busy = '0') then
                  this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
                  parseAndApply_method_state <= parseAndApply_method_state + 1;
                end if;
              when others => this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
            end case;
          when 4 => 
            x_parseAndApply_0 <= conv_std_logic_vector(conv_integer(this_output_port_toInt), x_parseAndApply_0'length);
            parseAndApply_method_state <= parseAndApply_method_state + 1;
          when 5 => 
            case conv_integer(array_index_operation_state_counter_parseAndApply_2) is
              when 0 =>
                buffer_raddr_field_wdata_writer_parseAndApply_method_state <= conv_std_logic_vector(conv_integer(this_input_port_parseAndApply_offset_field_rdata) + 1, buffer_raddr_field_wdata'length);
                array_index_operation_state_counter_parseAndApply_2 <= array_index_operation_state_counter_parseAndApply_2 + 1;
              when 1 =>
                array_index_operation_state_counter_parseAndApply_2 <= (others => '0');
                parseAndApply_method_state <= parseAndApply_method_state + 1;
              when others => array_index_operation_state_counter_parseAndApply_2 <= (others => '0');
            end case;
          when 6 => 
            case conv_integer(this_toInt_call_state_counter_parseAndApply_0) is
              when 0 =>
                if (this_toInt_method_busy = '0') then
                  this_toInt_method_request_field_wdata_writer_parseAndApply_method_state <= '1';
                  this_toInt_call_state_counter_parseAndApply_0 <= conv_std_logic_vector(1, this_toInt_call_state_counter_parseAndApply_0'length);
                end if;
              when 1 =>
                this_input_port_toInt_x_field_wdata_writer_parseAndApply_method_state <= conv_std_logic_vector(conv_integer(buffer_rdata_field_rdata), this_input_port_toInt_x_field_wdata'length);
                this_toInt_method_request_field_wdata_writer_parseAndApply_method_state <= '0';
                  this_toInt_call_state_counter_parseAndApply_0 <= conv_std_logic_vector(2, this_toInt_call_state_counter_parseAndApply_0'length);
              when 2 =>
                if (this_toInt_method_request_field_wdata = '0' and this_toInt_method_busy = '0') then
                  this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
                  parseAndApply_method_state <= parseAndApply_method_state + 1;
                end if;
              when others => this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
            end case;
          when 7 => 
            y_parseAndApply_0 <= conv_std_logic_vector(conv_integer(this_output_port_toInt), y_parseAndApply_0'length);
            parseAndApply_method_state <= parseAndApply_method_state + 1;
          when 8 => 
            case conv_integer(array_index_operation_state_counter_parseAndApply_3) is
              when 0 =>
                buffer_raddr_field_wdata_writer_parseAndApply_method_state <= conv_std_logic_vector(conv_integer(this_input_port_parseAndApply_offset_field_rdata) + 2, buffer_raddr_field_wdata'length);
                array_index_operation_state_counter_parseAndApply_3 <= array_index_operation_state_counter_parseAndApply_3 + 1;
              when 1 =>
                array_index_operation_state_counter_parseAndApply_3 <= (others => '0');
                parseAndApply_method_state <= parseAndApply_method_state + 1;
              when others => array_index_operation_state_counter_parseAndApply_3 <= (others => '0');
            end case;
          when 9 => 
            id_parseAndApply_0 <= conv_std_logic_vector(conv_integer(buffer_rdata_field_rdata) - 97, id_parseAndApply_0'length);
            parseAndApply_method_state <= parseAndApply_method_state + 1;
          when 10 => 
            case conv_integer(array_index_operation_state_counter_parseAndApply_4) is
              when 0 =>
                buffer_raddr_field_wdata_writer_parseAndApply_method_state <= conv_std_logic_vector(conv_integer(this_input_port_parseAndApply_offset_field_rdata) + 3, buffer_raddr_field_wdata'length);
                array_index_operation_state_counter_parseAndApply_4 <= array_index_operation_state_counter_parseAndApply_4 + 1;
              when 1 =>
                array_index_operation_state_counter_parseAndApply_4 <= (others => '0');
                parseAndApply_method_state <= parseAndApply_method_state + 1;
              when others => array_index_operation_state_counter_parseAndApply_4 <= (others => '0');
            end case;
          when 11 => 
            case conv_integer(this_toInt_call_state_counter_parseAndApply_0) is
              when 0 =>
                if (this_toInt_method_busy = '0') then
                  this_toInt_method_request_field_wdata_writer_parseAndApply_method_state <= '1';
                  this_toInt_call_state_counter_parseAndApply_0 <= conv_std_logic_vector(1, this_toInt_call_state_counter_parseAndApply_0'length);
                end if;
              when 1 =>
                this_input_port_toInt_x_field_wdata_writer_parseAndApply_method_state <= conv_std_logic_vector(conv_integer(buffer_rdata_field_rdata), this_input_port_toInt_x_field_wdata'length);
                this_toInt_method_request_field_wdata_writer_parseAndApply_method_state <= '0';
                  this_toInt_call_state_counter_parseAndApply_0 <= conv_std_logic_vector(2, this_toInt_call_state_counter_parseAndApply_0'length);
              when 2 =>
                if (this_toInt_method_request_field_wdata = '0' and this_toInt_method_busy = '0') then
                  this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
                  parseAndApply_method_state <= parseAndApply_method_state + 1;
                end if;
              when others => this_toInt_call_state_counter_parseAndApply_0 <= (others => '0');
            end case;
          when 12 => 
            rot_parseAndApply_0 <= conv_std_logic_vector(conv_integer(this_output_port_toInt), rot_parseAndApply_0'length);
            parseAndApply_method_state <= parseAndApply_method_state + 1;
          when 13 => 
            case conv_integer(state_counter_parseAndApply_parseAndApply_5) is
              when 0 => state_counter_parseAndApply_parseAndApply_5 <= state_counter_parseAndApply_parseAndApply_5 + 1;
              when 1 =>
                if (conv_integer(x_parseAndApply_0) > 0 and conv_integer(y_parseAndApply_0) > 0) then
                  parseAndApply_if_flag_parseAndApply_6_parseAndApply_0 <= '1';
                  state_counter_parseAndApply_parseAndApply_7 <= conv_std_logic_vector(1, state_counter_parseAndApply_parseAndApply_7'length);
                else
                  parseAndApply_if_flag_parseAndApply_6_parseAndApply_0 <= '0';
                end if;
                state_counter_parseAndApply_parseAndApply_5 <= state_counter_parseAndApply_parseAndApply_5 + 1;
              when 2 =>
                if (parseAndApply_if_flag_parseAndApply_6_parseAndApply_0 = '1') then
                  case conv_integer(state_counter_parseAndApply_parseAndApply_7) is
                    when 0 => state_counter_parseAndApply_parseAndApply_7 <= state_counter_parseAndApply_parseAndApply_7 + 1;
                    when 1 =>
                      case conv_integer(player_setOpponentMove_call_state_counter_parseAndApply_7) is
                        when 0 =>
                          if (player_setOpponentMove_method_busy_field_wdata = '0') then
                            player_setOpponentMove_method_request_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 <= '1';
                            player_setOpponentMove_call_state_counter_parseAndApply_7 <= conv_std_logic_vector(1, player_setOpponentMove_call_state_counter_parseAndApply_7'length);
                          end if;
                        when 1 =>
                          player_input_port_setOpponentMove_x_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 <= conv_std_logic_vector(conv_integer(x_parseAndApply_0) - 1, player_input_port_setOpponentMove_x_field_wdata'length);
                          player_input_port_setOpponentMove_y_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 <= conv_std_logic_vector(conv_integer(y_parseAndApply_0) - 1, player_input_port_setOpponentMove_y_field_wdata'length);
                          player_input_port_setOpponentMove_id_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 <= conv_std_logic_vector(conv_integer(id_parseAndApply_0), player_input_port_setOpponentMove_id_field_wdata'length);
                          player_input_port_setOpponentMove_rot_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 <= conv_std_logic_vector(conv_integer(rot_parseAndApply_0), player_input_port_setOpponentMove_rot_field_wdata'length);
                          player_setOpponentMove_method_request_field_wdata_writer_state_counter_parseAndApply_parseAndApply_7 <= '0';
                            player_setOpponentMove_call_state_counter_parseAndApply_7 <= conv_std_logic_vector(2, player_setOpponentMove_call_state_counter_parseAndApply_7'length);
                        when 2 =>
                          if (player_setOpponentMove_method_request_field_wdata = '0' and player_setOpponentMove_method_busy_field_wdata = '0') then
                            player_setOpponentMove_call_state_counter_parseAndApply_7 <= (others => '0');
                            state_counter_parseAndApply_parseAndApply_7 <= state_counter_parseAndApply_parseAndApply_7 + 1;
                          end if;
                        when others => player_setOpponentMove_call_state_counter_parseAndApply_7 <= (others => '0');
                      end case;
                    when 2 =>
                      state_counter_parseAndApply_parseAndApply_5 <= state_counter_parseAndApply_parseAndApply_5 + 1;
                      state_counter_parseAndApply_parseAndApply_7 <= (others => '0');
                    when others => state_counter_parseAndApply_parseAndApply_7 <= (others => '0');
                  end case;
                else
                  state_counter_parseAndApply_parseAndApply_5 <= state_counter_parseAndApply_parseAndApply_5 + 1;
                end if;
              when 3 =>
                state_counter_parseAndApply_parseAndApply_5 <= (others => '0');
                parseAndApply_method_state <= parseAndApply_method_state + 1;
              when others =>
                state_counter_parseAndApply_parseAndApply_5 <= (others => '0');
            end case;
          when 14 =>
            this_parseAndApply_method_busy <= '0';
            parseAndApply_method_state <= (others => '0');
          when others => parseAndApply_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --parseAndApply
  process(clk) --init
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_init_init_0 <= (others => '0');
        v_init_0 <= (others => '0');
        player_init_call_state_counter_init_0 <= (others => '0');
        player_init_call_state_counter_init_0 <= (others => '0');
        this_init_method_busy <= '0';
        init_method_state <= (others => '0');
        codeH_field_wdata_reset <= (others => '0');
        codeL_field_wdata_reset <= (others => '0');
        player_init_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(init_method_state) is
          when 0 =>
            if(this_init_method_request_field_rdata = '1') then
              this_init_method_busy <= '1';
              init_method_state <= init_method_state + 1;
            else
              this_init_method_busy <= '0';
            end if;
          when 1 =>
            if(this_init_method_request_field_rdata = '0') then
              init_method_state <= init_method_state + 1;
            end if;
          when 2 => 
            v_init_0 <= conv_std_logic_vector(conv_integer(player_code_value_field_rdata), v_init_0'length);
            init_method_state <= init_method_state + 1;
          when 3 => 
            codeH_field_wdata_writer_init_method_state <= conv_std_logic_vector((conv_integer(conv_std_logic_vector((conv_integer(conv_std_logic_vector(0, 8) & v_init_0(31 downto 8))), 32) and conv_std_logic_vector(255, 32))), codeH_field_wdata'length);
            codeL_field_wdata_writer_init_method_state <= conv_std_logic_vector((conv_integer(v_init_0 and conv_std_logic_vector(255, 32))), codeL_field_wdata'length);
            init_method_state <= init_method_state + 1;
          when 4 => 
            case conv_integer(player_init_call_state_counter_init_0) is
              when 0 =>
                if (player_init_method_busy_field_wdata = '0') then
                  player_init_method_request_field_wdata_writer_init_method_state <= '1';
                  player_init_call_state_counter_init_0 <= conv_std_logic_vector(1, player_init_call_state_counter_init_0'length);
                end if;
              when 1 =>
                player_init_method_request_field_wdata_writer_init_method_state <= '0';
                  player_init_call_state_counter_init_0 <= conv_std_logic_vector(2, player_init_call_state_counter_init_0'length);
              when 2 =>
                if (player_init_method_request_field_wdata = '0' and player_init_method_busy_field_wdata = '0') then
                  player_init_call_state_counter_init_0 <= (others => '0');
                  init_method_state <= init_method_state + 1;
                end if;
              when others => player_init_call_state_counter_init_0 <= (others => '0');
            end case;
          when 5 =>
            this_init_method_busy <= '0';
            init_method_state <= (others => '0');
          when others => init_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --init
end RTL;
